/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.finsubscribe;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.cim.common.enums.BonusWayEnum;
import kd.tmc.cim.common.enums.ExpireRedepositTypeEnum;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.enums.RedeemWayEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.FinSubscribeHelper;
import kd.tmc.cim.common.helper.RedeemBillHelper;
import kd.tmc.cim.common.helper.SuperMarketHelper;
import kd.tmc.cim.formplugin.resource.CimFormResourceEnum;
import kd.tmc.fbp.common.bean.BizBalanceModelBean;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.BizBalanceModelHelper;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinSubscribeEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        TextEdit finAccount = (TextEdit)this.getControl("finaccount");
        finAccount.addButtonClickListener((ClickListener)this);
        BasedataEdit productFactory = (BasedataEdit)this.getControl("productfactory");
        productFactory.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit settleAccount = (BasedataEdit)this.getControl("settleaccount");
        settleAccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit product = (BasedataEdit)this.getControl("product");
        product.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit currency = (BasedataEdit)this.getControl("currency");
        currency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map result = BaseDataServiceHelper.getBaseAccountingInfo((Long)RequestContext.get().getOrgId());
        Long baseCurrencyID = (Long)result.get("baseCurrencyID");
        this.getModel().setValue("currency", (Object)baseCurrencyID);
        this.setProduct();
        FinSubscribeHelper.productChgEvt((IDataModel)this.getModel());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setMustInput();
        this.changeRedeemWay();
        SuperMarketHelper.addAmountTips((IFormView)this.getView(), (IDataModel)this.getModel());
        this.resetExpireReDepositEnum();
        this.setTotalreveAmount();
        this.setValuationVisible();
    }

    private void setTotalreveAmount() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"totalreveamount", (Object)dataEntity.getBigDecimal("totalamount").add(dataEntity.getBigDecimal("futureamount")));
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().deleteEntryData("revenue_entry");
        this.getModel().deleteEntryData("rateadjust_entry");
        this.calExpireDate();
        FinSubscribeHelper.productChgEvt((IDataModel)this.getModel());
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "revenuetype": {
                this.setMustInput();
                break;
            }
            case "productfactory": {
                this.calExpireDate();
                this.setRedeemWay();
                break;
            }
            case "term": {
                ChangeData[] changeData = args.getChangeSet();
                String oldValue = (String)changeData[0].getOldValue();
                this.checkTermIsRight(oldValue);
                this.calExpireDate();
                this.setPurChaseDateRange();
                break;
            }
            case "valuedate": 
            case "workcalendar": {
                this.calExpireDate();
                this.setPurChaseDateRange();
                this.setIntDate();
                break;
            }
            case "expiredate": {
                this.checkExpireDate("expiredate");
                this.calTerm();
                this.setPurChaseDateRange();
                this.calPlanAmount();
                break;
            }
            case "buycopies": {
                this.calByFinCopies();
                this.calPlanAmount();
                break;
            }
            case "iopv": {
                this.calByFinIopv();
                this.calPlanAmount();
                break;
            }
            case "amount": {
                this.calByFinAmount();
                this.calPlanAmount();
                this.getModel().setValue("surplusamount", this.getModel().getValue("amount"));
                this.setValuationEntry("amount", null);
                break;
            }
            case "finaccount": {
                this.isClearFinAccountF7();
                break;
            }
            case "redeemway": {
                this.changeRedeemWay();
                this.resetExpireReDepositEnum();
                break;
            }
            case "investvarieties": {
                this.isClearProductFactory();
                break;
            }
            case "planrevenue": 
            case "basis": 
            case "intdate": {
                this.calPlanAmount();
                break;
            }
            case "tradechannel": {
                this.getModel().setValue("finaccount", null);
                this.getModel().setValue("finaccountf7", null);
                this.getModel().setValue("settleaccount", null);
                this.tradeChannelChgEvt();
                break;
            }
            case "product": {
                FinSubscribeHelper.productChgEvt((IDataModel)this.getModel());
                SuperMarketHelper.addAmountTips((IFormView)this.getView(), (IDataModel)this.getModel());
                break;
            }
            case "settleaccount": {
                this.setBalanceAmtChgEvt();
                break;
            }
            case "currency": {
                this.setBalanceAmtChgEvt();
                break;
            }
            case "finaccountf7": {
                DynamicObject finAcctF7 = (DynamicObject)this.getModel().getValue("finaccountf7");
                if (!EmptyUtil.isNoEmpty((DynamicObject)finAcctF7)) break;
                this.getModel().setValue("finorginfo", (Object)finAcctF7.getDynamicObject("bank"));
                break;
            }
            case "purchasedate": {
                this.setValuationEntry(null, "purchasedate");
                break;
            }
        }
    }

    private void setBalanceAmtChgEvt() {
        DynamicObject settleAcct = (DynamicObject)this.getModel().getValue("settleaccount");
        if (EmptyUtil.isEmpty((DynamicObject)settleAcct)) {
            return;
        }
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (EmptyUtil.isEmpty((DynamicObject)currency)) {
            return;
        }
        Long orgId = Optional.ofNullable((DynamicObject)this.getModel().getValue("org")).map(r -> r.getLong("id")).orElse(0L);
        String balanceType = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.CIM.getId(), (long)orgId, (String)"balancevalue");
        BizBalanceModelBean currBalance = BizBalanceModelHelper.getRunningBalance((String)balanceType, (long)settleAcct.getLong("id"), (long)currency.getLong("id"));
        if (currBalance == null || currBalance.getAmount() == null) {
            return;
        }
        this.getModel().setValue("balanceamt", (Object)currBalance.getAmount());
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        Boolean isCancel = Boolean.FALSE;
        String redeemWay = (String)sourceData.get("redeemway");
        String bonusWay = (String)sourceData.get("bonusway");
        if (redeemWay.equals(RedeemWayEnum.amount_redeem.getValue()) && bonusWay.equals(BonusWayEnum.copies_bonus.getValue()) || redeemWay.equals(RedeemWayEnum.copies_redeem.getValue()) && bonusWay.equals(BonusWayEnum.amount_bonus.getValue())) {
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), CimFormResourceEnum.FinSubscribeEdit_2.loadKDString());
            isCancel = Boolean.TRUE;
        }
        e.setCancel(isCancel.booleanValue());
    }

    public void afterImportData(ImportDataEventArgs e) {
        Date expireDate = (Date)this.getModel().getValue("expiredate");
        Date startDate = (Date)this.getModel().getValue("valuedate");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{startDate, expireDate})) {
            this.getModel().setValue("term", (Object)TermHelper.callTermLargeEqualZore((Date)startDate, (Date)expireDate));
        }
    }

    private void setIntDate() {
        String redeemWay = (String)this.getModel().getValue("redeemway");
        if (RedeemWayEnum.amount_redeem.getValue().equals(redeemWay)) {
            this.getModel().setValue("intdate", this.getModel().getValue("valuedate"));
        }
    }

    private void isClearProductFactory() {
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"productfactory", null);
    }

    private void setPurChaseDateRange() {
        DateEdit intEdit = (DateEdit)this.getControl("intdate");
        Date expireDate = (Date)this.getModel().getValue("expiredate");
        if (expireDate != null) {
            intEdit.setMaxDate(expireDate);
        } else {
            intEdit.setMaxDate(DateUtils.stringToDate((String)"2999-12-31", (String)"yyyy-MM-dd"));
        }
        Date intDate = (Date)this.getModel().getValue("intdate");
        if (intDate != null && expireDate != null && expireDate.before(intDate)) {
            this.getModel().setValue("intdate", null);
        }
    }

    private void checkExpireDate(String propName) {
        Date expireDate = (Date)this.getModel().getValue("expiredate");
        Date valueDate = (Date)this.getModel().getValue("valuedate");
        if (EmptyUtil.isNoEmpty((Object)expireDate) && EmptyUtil.isNoEmpty((Object)valueDate) && !expireDate.after(valueDate)) {
            this.getView().showTipNotification(CimFormResourceEnum.FinSubscribeEdit_0.loadKDString());
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)propName, null);
        }
    }

    private void checkTermIsRight(Object oldValue) {
        String term = (String)this.getModel().getValue("term");
        boolean rightFormat = TermHelper.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)term);
        if (!rightFormat) {
            this.getModel().setValue("term", oldValue);
        }
    }

    private void setMustInput() {
        String redeemWay = (String)this.getModel().getValue("redeemway");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)RedeemWayEnum.amount_redeem.getValue().equals(redeemWay), (String[])new String[]{"planrevenue", "intdate"});
    }

    private void setRedeemWay() {
        DynamicObject productFactory = (DynamicObject)this.getModel().getValue("productfactory");
        if (EmptyUtil.isNoEmpty((DynamicObject)productFactory)) {
            String redeeWay;
            String profitType = productFactory.getString("profittype");
            if ("cash".equals(profitType)) {
                redeeWay = RedeemWayEnum.amount_redeem.getValue();
                this.getModel().setValue("revenuetype", (Object)productFactory.getString("ratetype"));
            } else {
                redeeWay = RedeemWayEnum.copies_redeem.getValue();
            }
            this.getModel().setValue("basis", productFactory.get("basis"));
            this.getModel().setValue("redeemway", (Object)redeeWay);
        }
    }

    private void calExpireDate() {
        Date valueDate = (Date)this.getModel().getValue("valuedate");
        String term = (String)this.getModel().getValue("term");
        DynamicObject productFactory = (DynamicObject)this.getModel().getValue("productfactory");
        if (EmptyUtil.isNoEmpty((Object)valueDate) && !"".equals(term)) {
            Date calDate;
            if (EmptyUtil.isNoEmpty((DynamicObject)productFactory)) {
                String adjustRule = productFactory.getString("graceadjustrule");
                if (EmptyUtil.isEmpty((String)adjustRule)) {
                    adjustRule = AdjustMethodEnum.no_adjust.getValue();
                }
                DynamicObjectCollection workCalendars = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
                calDate = TermHelper.callAdjustSettleDate((DynamicObjectCollection)workCalendars, (Date)TermHelper.getDateByBaseDate4ymd((String)term, (Date)valueDate), (AdjustMethodEnum)AdjustMethodEnum.valueOf((String)adjustRule));
            } else {
                calDate = TermHelper.getDateByBaseDate4ymd((String)term, (Date)valueDate);
            }
            this.getModel().setValue("expiredate", (Object)calDate);
        }
    }

    private void calTerm() {
        Date valueDate = (Date)this.getModel().getValue("valuedate");
        Date expireDate = (Date)this.getModel().getValue("expiredate");
        if (EmptyUtil.isNoEmpty((Object)valueDate) && EmptyUtil.isNoEmpty((Object)expireDate)) {
            DynamicObject productFactory = (DynamicObject)this.getModel().getValue("productfactory");
            if (EmptyUtil.isNoEmpty((DynamicObject)productFactory)) {
                String adjustRule = productFactory.getString("graceadjustrule");
                List<String> ruleList = Arrays.asList("forward", "ad_forward", "backward", "ad_backward", "no_adjust");
                if (StringUtils.isEmpty((CharSequence)adjustRule) || !ruleList.contains(adjustRule)) {
                    return;
                }
                DynamicObjectCollection workCalendars = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
                expireDate = TermHelper.callAdjustSettleDate((DynamicObjectCollection)workCalendars, (Date)expireDate, (AdjustMethodEnum)AdjustMethodEnum.valueOf((String)adjustRule));
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", (Object)TermHelper.callTermLargeEqualZore((Date)valueDate, (Date)expireDate));
        }
    }

    private void calPlanAmount() {
        BigDecimal calAmount = RedeemBillHelper.calPlanAmount((ModelAgent)new ModelAgent((Object)this.getModel().getDataEntity()));
        this.getModel().setValue("planamount", (Object)calAmount);
    }

    private void tradeChannelChgEvt() {
        String tradeChannel = (String)this.getModel().getValue("tradechannel");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)TradeChannelEnum.ONLINE.getValue().equals(tradeChannel), (String[])new String[]{"settleaccount"});
        String redeemWay = (String)this.getModel().getValue("redeemway");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)RedeemWayEnum.copies_redeem.getValue().equals(redeemWay), (String[])new String[]{"buycopies", "iopv"});
    }

    private void isClearFinAccountF7() {
        if (!this.getPageCache().getAll().containsKey("finclick")) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"finaccountf7", null);
        } else {
            this.getPageCache().remove("finclick");
        }
    }

    public void click(EventObject evt) {
        String key;
        if (evt.getSource() instanceof Control && "finaccount".equals(key = ((Control)evt.getSource()).getKey())) {
            this.showF7AccountBank(key);
        }
    }

    private void showF7AccountBank(String key) {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"bd_accountbanks", (boolean)false);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        QFilter qFilter = TmcAccountHelper.getAccountBankFilterByOrg((Long)org.getLong("id"));
        qFilter.and("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue());
        if (this.isOnline()) {
            qFilter.and("issetbankinterface", "=", (Object)"1");
        }
        showParameter.getListFilterParameter().setFilter(qFilter);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private boolean isOnline() {
        String tradeChannel = (String)this.getModel().getValue("tradechannel");
        return TradeChannelEnum.ONLINE.getValue().equals(tradeChannel);
    }

    private void changeRedeemWay() {
        String redeemWay = (String)this.getModel().getValue("redeemway");
        if (RedeemWayEnum.amount_redeem.getValue().equals(redeemWay)) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"bonusway", (Object)BonusWayEnum.amount_bonus.getValue());
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"revenuetype", "revenueproject"});
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buycopies", (Object)0);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"surpluscopies", (Object)0);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"iopv", (Object)BigDecimal.ZERO);
        }
        if (RedeemWayEnum.copies_redeem.getValue().equals(redeemWay)) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"bonusway", (Object)BonusWayEnum.copies_bonus.getValue());
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"intdate", null);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"revenuetype", null);
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"revenueproject", "planrevenue", "revenuetype"});
        }
        this.tradeChannelChgEvt();
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        ListSelectedRowCollection rows;
        super.closedCallBack(e);
        if (StringUtils.equals((CharSequence)"finaccount", (CharSequence)e.getActionId())) {
            ListSelectedRowCollection rows2 = (ListSelectedRowCollection)e.getReturnData();
            if (EmptyUtil.isNoEmpty((Object)rows2)) {
                ListSelectedRow selectedRow = rows2.get(0);
                String number = selectedRow.getNumber();
                this.getModel().setValue(e.getActionId(), (Object)number);
                this.getModel().setValue("finaccountf7", selectedRow.getPrimaryKeyValue());
                this.getPageCache().put("finclick", "true");
                DynamicObject finAccount = TmcDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,currency", (QFilter[])new QFilter("id", "=", selectedRow.getPrimaryKeyValue()).toArray());
                DynamicObjectCollection currencys = finAccount.getDynamicObjectCollection("currency");
                if (currencys.size() == 1 && !"cim_finapply".equals(this.getModel().getValue("sourcebilltype"))) {
                    Object currency = ((DynamicObject)currencys.get(0)).getDynamicObject("fbasedataid").getPkValue();
                    this.getModel().setValue("currency", currency);
                }
                if (this.isOnline()) {
                    this.getModel().setValue("settleaccount", selectedRow.getPrimaryKeyValue());
                }
            }
        } else if (StringUtils.equals((CharSequence)"productfactory", (CharSequence)e.getActionId()) && EmptyUtil.isNoEmpty((Object)(rows = (ListSelectedRowCollection)e.getReturnData()))) {
            ListSelectedRow row = rows.get(0);
            this.getModel().setValue("productfactory", row.getPrimaryKeyValue());
            DynamicObject productFactory = (DynamicObject)this.getModel().getValue("productfactory");
            DynamicObject investVarieties = (DynamicObject)productFactory.get("investvarieties");
            if (EmptyUtil.isNoEmpty((DynamicObject)investVarieties)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"investvarieties", (Object)investVarieties);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        switch (operateKey) {
            case "save": 
            case "submit": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "updaterevenueplan": {
                this.showUpdateRevenuePlan();
                break;
            }
        }
    }

    private void showUpdateRevenuePlan() {
        BillShowParameter param = new BillShowParameter();
        param.setPkId(this.getModel().getDataEntity().getPkValue());
        param.setFormId("cim_finsubscribe_revplan");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setStatus(OperationStatus.EDIT);
        param.setBillStatus(BillOperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)param);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        if ("productfactory".equals(key)) {
            DynamicObject investVarieties = (DynamicObject)this.getModel().getValue("investvarieties");
            if (EmptyUtil.isNoEmpty((DynamicObject)investVarieties)) {
                QFilter filter = new QFilter("investvarieties", "=", investVarieties.getPkValue());
                qFilters.add(filter);
                return;
            }
            QFilter filter = new QFilter("investvarieties.isleaf", "=", (Object)"1");
            qFilters.add(filter);
            if ("cim_finsubscribe".equals(this.getModel().getDataEntityType().getName())) {
                filter = new QFilter("investvarieties.investtype", "=", (Object)InvestTypeEnum.finance.getValue());
                qFilters.add(filter);
            }
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "productfactory"));
        } else if ("settleaccount".equals(key) && this.isOnline()) {
            QFilter filter = new QFilter("issetbankinterface", "=", (Object)"1");
            qFilters.add(filter);
        } else if ("product".equals(key)) {
            DynamicObject finOrg = (DynamicObject)this.getModel().getValue("finorginfo");
            FinSubscribeHelper.setProductFilter((BeforeF7SelectEvent)evt, (DynamicObject)finOrg);
        } else if ("currency".equals(key)) {
            DynamicObject settleAccount = (DynamicObject)this.getModel().getValue("settleaccount");
            if (EmptyUtil.isEmpty((DynamicObject)settleAccount)) {
                return;
            }
            DynamicObjectCollection currencyCols = settleAccount.getDynamicObjectCollection("currency");
            List currencyList = currencyCols.stream().map(r -> r.getDynamicObject("fbasedataid")).map(r -> r.getLong("id")).collect(Collectors.toList());
            qFilters.add(new QFilter("id", "in", currencyList));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        DynamicObject finSubBill = this.getModel().getDataEntity();
        switch (operateKey) {
            case "submit": {
                Date expireDate = finSubBill.getDate("expiredate");
                if (EmptyUtil.isEmpty((Object)expireDate) && !this.getPageCache().getAll().containsKey("passSubmit")) {
                    this.showOperationConfirm(args);
                }
                this.getPageCache().remove("passSubmit");
                break;
            }
            case "updaterevenueplan": {
                if (FinServiceStatusEnum.isSubscribeEnd((String)finSubBill.getString("finservicestatus"))) {
                    this.getView().showTipNotification(CimFormResourceEnum.FinSubscribeList_8.loadKDString());
                    args.setCancel(true);
                    return;
                }
                if (!RedeemWayEnum.isCopiesRedeem((String)finSubBill.getString("redeemway"))) break;
                this.getView().showTipNotification(CimFormResourceEnum.FinSubscribeList_10.loadKDString());
                args.setCancel(true);
                break;
            }
            case "checkinterest": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("revenue_entry");
                boolean isInit = (Boolean)this.getModel().getValue("isinit");
                if (!isInit || rowIndex != 0 || !EmptyUtil.isNoEmpty((BigDecimal)((BigDecimal)this.getModel().getValue("handrevenueamt"))) || BillStatusEnum.isAudit((String)((String)this.getModel().getValue("billstatus")))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6570\u636e\uff0c\u4e0d\u80fd\u67e5\u770b\u6d4b\u7b97\u8be6\u60c5\u3002", (String)"DepositInitEdit_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    private void showOperationConfirm(BeforeDoOperationEventArgs args) {
        this.getView().showConfirm(CimFormResourceEnum.FinSubscribeEdit_1.loadKDString(), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("sumbitConfig", (IFormPlugin)this));
        args.setCancel(true);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (StringUtils.equals((CharSequence)"sumbitConfig", (CharSequence)evt.getCallBackId()) && evt.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put("passSubmit", "true");
            this.getView().invokeOperation("submit");
        }
    }

    private void setProduct() {
        Map paraMap = this.getView().getFormShowParameter().getCustomParams();
        Object supermarketId = paraMap.get("supermarketid");
        if (EmptyUtil.isEmpty(supermarketId)) {
            return;
        }
        this.getModel().setValue("product", supermarketId);
    }

    private void calByFinAmount() {
        String redeemWay = (String)this.getModel().getValue("redeemway");
        if (RedeemWayEnum.copies_redeem.getValue().equals(redeemWay)) {
            BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
            BigDecimal buyCopies = (BigDecimal)this.getModel().getValue("buycopies");
            BigDecimal iopv = (BigDecimal)this.getModel().getValue("iopv");
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{amount, buyCopies})) {
                iopv = amount.divide(buyCopies, 10, RoundingMode.HALF_UP);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"iopv", (Object)iopv);
            } else if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{amount, iopv})) {
                buyCopies = amount.divide(iopv, 10, RoundingMode.HALF_UP);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buycopies", (Object)buyCopies);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"surpluscopies", (Object)buyCopies);
            }
        }
    }

    private void calByFinCopies() {
        String redeemWay = (String)this.getModel().getValue("redeemway");
        if (RedeemWayEnum.copies_redeem.getValue().equals(redeemWay)) {
            BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
            BigDecimal buyCopies = (BigDecimal)this.getModel().getValue("buycopies");
            BigDecimal iopv = (BigDecimal)this.getModel().getValue("iopv");
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{amount, buyCopies})) {
                iopv = amount.divide(buyCopies, 10, RoundingMode.HALF_UP);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"iopv", (Object)iopv);
            } else if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{buyCopies, iopv})) {
                amount = iopv.multiply(buyCopies);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount", (Object)amount);
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"surpluscopies", (Object)buyCopies);
        }
    }

    private void calByFinIopv() {
        String redeemWay = (String)this.getModel().getValue("redeemway");
        if (RedeemWayEnum.copies_redeem.getValue().equals(redeemWay)) {
            BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
            BigDecimal buyCopies = (BigDecimal)this.getModel().getValue("buycopies");
            BigDecimal iopv = (BigDecimal)this.getModel().getValue("iopv");
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{amount, iopv})) {
                buyCopies = amount.divide(iopv, 10, RoundingMode.HALF_UP);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buycopies", (Object)buyCopies);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"surpluscopies", (Object)buyCopies);
            } else if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{buyCopies, iopv})) {
                amount = iopv.multiply(buyCopies);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount", (Object)amount);
            }
        }
    }

    private void resetExpireReDepositEnum() {
        ComboItem item1;
        String redeemWay = (String)this.getModel().getValue("redeemway");
        ArrayList<ComboItem> comboList = new ArrayList<ComboItem>(8);
        if (StringUtils.equals((CharSequence)RedeemWayEnum.copies_redeem.getValue(), (CharSequence)redeemWay)) {
            item1 = new ComboItem(new LocaleString(ExpireRedepositTypeEnum.NOREDEPOSIT.getName()), ExpireRedepositTypeEnum.NOREDEPOSIT.getValue());
            comboList.add(item1);
            ComboItem item2 = new ComboItem(new LocaleString(ExpireRedepositTypeEnum.PRINCIPALREDEPOSIT.getName()), ExpireRedepositTypeEnum.PRINCIPALREDEPOSIT.getValue());
            comboList.add(item2);
        } else {
            item1 = new ComboItem(new LocaleString(ExpireRedepositTypeEnum.NOREDEPOSIT.getName()), ExpireRedepositTypeEnum.NOREDEPOSIT.getValue());
            comboList.add(item1);
            ComboItem item2 = new ComboItem(new LocaleString(ExpireRedepositTypeEnum.PRINCIPALREDEPOSIT.getName()), ExpireRedepositTypeEnum.PRINCIPALREDEPOSIT.getValue());
            comboList.add(item2);
            ComboItem item3 = new ComboItem(new LocaleString(ExpireRedepositTypeEnum.PRINCIPALINTREDEPOSIT.getName()), ExpireRedepositTypeEnum.PRINCIPALINTREDEPOSIT.getValue());
            comboList.add(item3);
        }
        ComboEdit expireCombo = (ComboEdit)this.getControl("expireredeposit");
        expireCombo.setComboItems(comboList);
    }

    private void setValuationVisible() {
        DynamicObjectCollection entry = (DynamicObjectCollection)this.getModel().getValue("valuationentry");
        this.getView().setVisible(Boolean.valueOf(EmptyUtil.isNoEmpty((DynamicObjectCollection)entry)), new String[]{"valuationflex"});
    }

    private void setValuationEntry(String amtProp, String dateProp) {
        DynamicObjectCollection valueEntry = this.getModel().getEntryEntity("valuationentry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)valueEntry)) {
            return;
        }
        DynamicObject firstRow = (DynamicObject)valueEntry.get(0);
        if (null != amtProp) {
            firstRow.set("e_valuation", this.getModel().getValue("amount"));
        }
        if (null != dateProp) {
            firstRow.set("e_valuationdate", this.getModel().getValue("purchasedate"));
        }
        this.getView().updateView("valuationentry");
    }
}

