/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.finsubscribe;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextAreaProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cim.common.enums.RevenueStatEnum;
import kd.tmc.cim.formplugin.finsubscribe.FinSubscribeFormHelper;
import kd.tmc.cim.formplugin.resource.CimFormResourceEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinSubscribeImportPlugin
extends AbstractBasePlugIn {
    private static final String CIM_ENTRYIMPORT = "cim_entryimport";
    private static Log logger = LogFactory.getLog(FinSubscribeImportPlugin.class);

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "intplanentryimport": {
                this.showImportForm();
                break;
            }
        }
    }

    private void showImportForm() {
        FormShowParameter showForm = new FormShowParameter();
        showForm.setFormId(CIM_ENTRYIMPORT);
        showForm.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("BillFormId", this.getModel().getDataEntityType().getName());
        params.put("BillEntryId", "revenue_entry");
        showForm.setCustomParams(params);
        showForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CIM_ENTRYIMPORT));
        this.getView().showForm(showForm);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (CIM_ENTRYIMPORT.equals(e.getActionId())) {
            Map data = (Map)e.getReturnData();
            if (data == null) {
                return;
            }
            this.entryImportDataHandler(data);
        }
    }

    private void entryImportDataHandler(Map<String, Object> importReturnData) {
        String entryProp = "revenue_entry";
        Object imptMethod = importReturnData.get("imptmethod");
        HashSet<Date> dateSet = new HashSet<Date>(16);
        if ("cover".equals(imptMethod)) {
            this.getModel().deleteEntryData(entryProp);
        } else if ("append".equals(imptMethod)) {
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity(entryProp);
            for (int i = entryentity.size() - 1; i >= 0; --i) {
                DynamicObject entry = (DynamicObject)entryentity.get(i);
                if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{entry.get("revenuedate"), entry.get("revenuecalamount")})) {
                    this.getModel().deleteEntryRow(entryProp, i);
                    this.getView().updateView(entryProp);
                    continue;
                }
                dateSet.add((Date)entry.get("revenuedate"));
            }
        }
        List rowDatas = (List)importReturnData.get("rowDatas");
        Set billnos = rowDatas.stream().map(o -> (String)o.get("billno")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
        if (EmptyUtil.isNoEmpty(billnos) && billnos.size() > 1) {
            this.getView().showMessage(CimFormResourceEnum.FinSubscribeImportPlugin_10.loadKDString());
            return;
        }
        if (EmptyUtil.isNoEmpty(billnos) && billnos.size() == 1 && !billnos.toArray()[0].equals(this.getModel().getValue("billno"))) {
            this.getView().showMessage(CimFormResourceEnum.FinSubscribeImportPlugin_11.loadKDString());
            return;
        }
        this.getModel().beginInit();
        StringBuilder errorInfo = new StringBuilder();
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(entryProp);
        int seq = entryentity.size();
        for (Map row : rowDatas) {
            String tips;
            int rowIndex = this.getModel().createNewEntryRow(entryProp);
            boolean isBreak = false;
            String revenueStat = (String)row.get("revenuestate");
            try {
                for (Map.Entry r : row.entrySet()) {
                    String error;
                    String key = (String)r.getKey();
                    String value = (String)r.getValue();
                    IDataEntityProperty property = this.getModel().getProperty(key);
                    if ("revenueremark".equals(key) && (isBreak = this.appendErrorInfo(error = this.checkRemark(row, rowIndex, key, value, property), errorInfo, entryProp, rowIndex)) || property instanceof DecimalProp && (isBreak = this.appendErrorInfo(error = this.checkAmount(row, rowIndex, key, value), errorInfo, entryProp, rowIndex))) break;
                    if ("revenuestate".equals(key)) {
                        String stat = RevenueStatEnum.DONE.getName().equals(revenueStat) ? "1" : "0";
                        this.getModel().setValue(key, (Object)stat, rowIndex);
                    }
                    if (!"revenuedate".equals(key) || !(isBreak = this.appendErrorInfo(error = this.checkRevenueDate(dateSet, row, rowIndex, value, property, revenueStat), errorInfo, entryProp, rowIndex))) continue;
                    break;
                }
                if (isBreak) continue;
                this.getModel().setValue("revenueseq", (Object)(++seq), rowIndex);
            }
            catch (KDBizException bizExp) {
                this.getModel().deleteEntryRow(entryProp, rowIndex);
                tips = CimFormResourceEnum.FinSubscribeImportPlugin_5.loadKDString(row.get("excelrow"), bizExp.getMessage());
                errorInfo.append(tips).append("\n");
                logger.info("EntryImport >> data >> " + (Object)((Object)bizExp));
            }
            catch (Exception e) {
                this.getModel().deleteEntryRow(entryProp, rowIndex);
                tips = CimFormResourceEnum.FinSubscribeImportPlugin_5.loadKDString(row.get("excelrow"), e.getMessage());
                errorInfo.append(tips).append("\n");
                logger.info("EntryImport >> data >> " + e.getMessage());
            }
        }
        if (EmptyUtil.isNoEmpty((String)errorInfo.toString())) {
            this.getView().showMessage(CimFormResourceEnum.FinSubscribeImportPlugin_6.loadKDString(), errorInfo.toString(), MessageTypes.Default);
        }
        this.getModel().endInit();
        this.getView().updateView(entryProp);
    }

    private boolean appendErrorInfo(String error, StringBuilder errorInfo, String entryProp, int rowIndex) {
        if (EmptyUtil.isNoEmpty((String)error)) {
            errorInfo.append(error).append("\n");
            this.getModel().deleteEntryRow(entryProp, rowIndex);
            return true;
        }
        return false;
    }

    private String checkRemark(Map<String, String> row, int rowIndex, String key, String value, IDataEntityProperty property) {
        StringBuilder errorInfo = new StringBuilder();
        TextAreaProp text = new TextAreaProp();
        if (property instanceof TextAreaProp) {
            text = (TextAreaProp)property;
        }
        if (text.getMaxLenth() > 0 && EmptyUtil.isNoEmpty((String)value) && value.length() > text.getMaxLenth()) {
            value = value.substring(0, text.getMaxLenth());
            String maxTip = CimFormResourceEnum.FinSubscribeImportPlugin_2.loadKDString(row.get("excelrow"), property.getDisplayName().getLocaleValue());
            errorInfo.append(maxTip).append("\n");
        }
        this.getModel().setValue(key, (Object)value, rowIndex);
        return errorInfo.toString();
    }

    private String checkAmount(Map<String, String> row, int rowIndex, String key, String value) {
        StringBuilder errorInfo = new StringBuilder();
        try {
            BigDecimal amount = new BigDecimal(value);
            if (amount.compareTo(BigDecimal.ZERO) <= 0) {
                throw new KDBizException(CimFormResourceEnum.FinSubscribeImportPlugin_3.loadKDString());
            }
            if (amount.compareTo(new BigDecimal("9999999999.99")) > 0) {
                throw new KDBizException(CimFormResourceEnum.FinSubscribeImportPlugin_8.loadKDString());
            }
            this.getModel().setValue(key, (Object)amount, rowIndex);
        }
        catch (Exception e) {
            String tips = CimFormResourceEnum.FinSubscribeImportPlugin_5.loadKDString(row.get("excelrow"), e.getMessage());
            errorInfo.append(tips).append("\n");
        }
        return errorInfo.toString();
    }

    private String checkRevenueDate(Set<Date> dateSet, Map<String, String> row, int rowIndex, String value, IDataEntityProperty property, String revenueStat) {
        StringBuilder errorInfo = new StringBuilder();
        try {
            String error;
            if (EmptyUtil.isEmpty((String)value)) {
                throw new KDBizException(CimFormResourceEnum.FinSubscribeImportPlugin_9.loadKDString());
            }
            String dateFormat = "yyyy-MM-dd";
            SimpleDateFormat sf = new SimpleDateFormat(dateFormat);
            Date revenueDate = sf.parse(value);
            if (!dateSet.add(revenueDate)) {
                throw new KDBizException(CimFormResourceEnum.FinSubscribeImportPlugin_7.loadKDString());
            }
            if (RevenueStatEnum.NOTDO.getName().equals(revenueStat) && EmptyUtil.isNoEmpty((String)(error = FinSubscribeFormHelper.checkRevePlanRevenueDate(this.getModel(), revenueDate, dateFormat)))) {
                throw new KDBizException(error);
            }
            this.getModel().setValue("revenuedate", (Object)revenueDate, rowIndex);
        }
        catch (KDBizException bizExp) {
            String tips = CimFormResourceEnum.FinSubscribeImportPlugin_5.loadKDString(row.get("excelrow"), bizExp.getMessage());
            errorInfo.append(tips).append("\n");
        }
        catch (Exception e) {
            String importTip = CimFormResourceEnum.FinSubscribeImportPlugin_4.loadKDString(row.get("excelrow"), property.getDisplayName().getLocaleValue());
            errorInfo.append(importTip).append("\n");
        }
        return errorInfo.toString();
    }
}

