/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.finsubscribe;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.BebankStatusEnum;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.enums.RedeemWayEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.RedeemBillHelper;
import kd.tmc.cim.common.helper.RevenuePlanCalHelper;
import kd.tmc.cim.formplugin.resource.CimFormResourceEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;

public class FinSubscribeList
extends AbstractTmcListPlugin {
    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        BillList billList = (BillList)this.getControl("billlistap");
        if (billList.getBillFormId().equals("cim_finsubscribe_init")) {
            QFilter qFilter = new QFilter("isinit", "=", (Object)Boolean.TRUE);
            qFilters.add(qFilter);
        } else {
            QFilter qFilter = new QFilter("isinit", "=", (Object)Boolean.TRUE);
            QFilter initQfilter = qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            QFilter unionFilter = initQfilter.or(new QFilter("isinit", "=", (Object)Boolean.FALSE));
            qFilters.add(unionFilter);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection rows = super.getData(arg0, arg1);
                if (rows.isEmpty()) {
                    return rows;
                }
                DataEntityPropertyCollection properties = ((DynamicObject)rows.get(0)).getDataEntityType().getProperties();
                if (properties.containsKey((Object)"redeempattern") && properties.containsKey((Object)"redeempatternstr")) {
                    for (DynamicObject row : rows) {
                        int redeemPattern = row.getInt("redeempattern");
                        row.set("redeempatternstr", (Object)("T + " + redeemPattern));
                    }
                }
                return rows;
            }
        });
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.removeSpareFilter(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilter.getFieldName();
            if (!"org.name".equals(fieldName)) continue;
            commonFilter.setDefaultValue("");
            break;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (op.getOperateKey()) {
            case "pushredeem": {
                if (this.checkCanPushRedeemBill()) break;
                args.setCancel(true);
                break;
            }
            case "pushrevenue": {
                if (this.checkCanPushRevenueBill()) break;
                args.setCancel(true);
                break;
            }
            case "submit": {
                this.beforeSubmit(args);
                break;
            }
            case "updaterevenueplan": {
                this.beforeUpdateRevenuePlanOp(args);
                break;
            }
            case "pushtopay": {
                this.beforePush2PayBill(args);
                break;
            }
        }
    }

    private void beforePush2PayBill(BeforeDoOperationEventArgs args) {
        Long billPkId = this.getSelectedId();
        if (EmptyUtil.isEmpty((Long)billPkId)) {
            args.setCancel(true);
            return;
        }
    }

    private void beforeSubmit(BeforeDoOperationEventArgs args) {
        Long id = super.getSelectedId();
        if (EmptyUtil.isEmpty((Long)id)) {
            args.setCancel(true);
        } else {
            DynamicObject selBill = TmcDataServiceHelper.loadSingle((Object)id, (String)CimEntityEnum.cim_finsubscribe.getValue(), (String)"expiredate,id");
            Date expireDate = selBill.getDate("expiredate");
            if (EmptyUtil.isEmpty((Object)expireDate) && !this.getPageCache().getAll().containsKey("passSubmit")) {
                this.showOperationConfirm(args);
            }
            this.getPageCache().remove("passSubmit");
        }
    }

    private void beforeUpdateRevenuePlanOp(BeforeDoOperationEventArgs args) {
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(CimFormResourceEnum.FinSubscribeList_7.loadKDString());
            args.setCancel(true);
        } else {
            DynamicObject finBill = TmcDataServiceHelper.loadSingle((Object)selectedRows.get(0).getPrimaryKeyValue(), (String)"cim_finsubscribe", (String)"finservicestatus,redeemway");
            if (FinServiceStatusEnum.isSubscribeEnd((String)finBill.getString("finservicestatus"))) {
                this.getView().showTipNotification(CimFormResourceEnum.FinSubscribeList_8.loadKDString());
                args.setCancel(true);
                return;
            }
            if (RedeemWayEnum.isCopiesRedeem((String)finBill.getString("redeemway"))) {
                this.getView().showTipNotification(CimFormResourceEnum.FinSubscribeList_10.loadKDString());
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        switch (operateKey) {
            case "premodifyrate": {
                this.showModifyRateForm();
                break;
            }
            case "updaterevenueplan": {
                this.showRevenuePlanForm();
                break;
            }
            case "valuateupdate": {
                this.showValuationUpdate();
                break;
            }
        }
    }

    private void showValuationUpdate() {
        List selectedIdList = this.getSelectedIdList();
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cim_finsubscribe", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", selectedIdList.get(0))});
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cim_valuation_update");
        showParameter.getOpenStyle().setShowType(ShowType.NonModal);
        showParameter.getCustomParams().put("currency", dynamicObject.getLong("currency"));
        showParameter.getCustomParams().put("ids", selectedIdList);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "valuateupdate"));
        this.getView().showForm(showParameter);
    }

    private void showRevenuePlanForm() {
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        BillShowParameter param = new BillShowParameter();
        param.setPkId(selectedRows.get(0).getPrimaryKeyValue());
        param.setFormId("cim_finsubscribe_revplan");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setStatus(OperationStatus.EDIT);
        param.setBillStatus(BillOperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)param);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map returnData;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (StringUtils.equals((CharSequence)"modifyrate_action", (CharSequence)actionId)) {
            this.modifyPlanRevenue((Map)evt.getReturnData());
        } else if (StringUtils.equals((CharSequence)"valuateupdate", (CharSequence)actionId) && EmptyUtil.isNoEmpty((Object)(returnData = (Map)evt.getReturnData())) && ((Boolean)returnData.get("success")).booleanValue()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u4f30\u503c\u6210\u529f\u3002", (String)"FinSubscribeList_12", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        BillList billlistap = (BillList)this.getView().getControl("billlistap");
        if (StringUtils.equals((CharSequence)"sourbillno", (CharSequence)args.getFieldName())) {
            args.setCancel(true);
            this.doHyperLinkForSourBillNo(billlistap);
        }
    }

    private void doHyperLinkForSourBillNo(BillList billlistap) {
        ListSelectedRow currentSelectedRowInfo = billlistap.getCurrentSelectedRowInfo();
        Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
        DynamicObject currentFinSubBill = QueryServiceHelper.queryOne((String)"cim_finsubscribe", (String)"sourbillno", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValue)});
        List srcFinSubBillIds = QueryServiceHelper.queryPrimaryKeys((String)"cim_finsubscribe", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)currentFinSubBill.getString("sourbillno"))}, (String)"", (int)-1);
        if (EmptyUtil.isEmpty((Collection)srcFinSubBillIds)) {
            this.getView().showTipNotification(CimFormResourceEnum.DepositDealList_3.loadKDString());
            return;
        }
        BillShowParameter parameter = new BillShowParameter();
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setFormId("cim_finsubscribe");
        parameter.setPkId(srcFinSubBillIds.get(0));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private boolean checkCanPushRedeemBill() {
        Long id = super.getSelectedId();
        if (EmptyUtil.isEmpty((Long)id)) {
            return false;
        }
        DynamicObject finSubscribe = TmcDataServiceHelper.loadSingle((Object)id, (String)CimEntityEnum.cim_finsubscribe.getValue(), (String)"bebankstatus,billstatus,finservicestatus,tradechannel,buycopies,settleaccount");
        if (!BillStatusEnum.isAudit((String)finSubscribe.getString("billstatus"))) {
            this.getView().showTipNotification(CimFormResourceEnum.FinSubscribeList_0.loadKDString());
            return false;
        }
        String bizStatus = finSubscribe.getString("finservicestatus");
        if (!FinServiceStatusEnum.isSubscribeDone((String)bizStatus) && !FinServiceStatusEnum.isSubscribePart((String)bizStatus)) {
            this.getView().showTipNotification(CimFormResourceEnum.FinSubscribeList_5.loadKDString());
            return false;
        }
        String tradeChannel = finSubscribe.getString("tradechannel");
        if (TradeChannelEnum.ONLINE.getValue().equals(tradeChannel)) {
            QFilter idFilter = new QFilter("finbillno", "=", finSubscribe.getPkValue());
            QFilter auditFilter = idFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()));
            QFilter beBankFilter = new QFilter("finbillno", "=", finSubscribe.getPkValue()).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("tradechannel", "=", (Object)TradeChannelEnum.ONLINE.getValue()).and("bebankstatus", "not in", (Object)new String[]{BebankStatusEnum.TF.getValue(), BebankStatusEnum.TS.getValue()});
            QFilter qFilter = auditFilter.or(beBankFilter);
            boolean existsRed = TmcDataServiceHelper.exists((String)CimEntityEnum.cim_redeem.getValue(), (QFilter[])qFilter.toArray());
            if (existsRed) {
                this.getView().showTipNotification(CimFormResourceEnum.FinSubscribeList_9.loadKDString());
                return false;
            }
        }
        return true;
    }

    private boolean checkCanPushRevenueBill() {
        Long id = super.getSelectedId();
        if (EmptyUtil.isEmpty((Long)id)) {
            return false;
        }
        DynamicObject finSubscribe = TmcDataServiceHelper.loadSingle((Object)id, (String)CimEntityEnum.cim_finsubscribe.getValue(), (String)"billstatus,finservicestatus,redeemway,tradechannel");
        if (!BillStatusEnum.AUDIT.getValue().equals(finSubscribe.getString("billstatus")) || FinServiceStatusEnum.subscribe_end.getValue().equals(finSubscribe.getString("finservicestatus"))) {
            this.getView().showTipNotification(CimFormResourceEnum.FinSubscribeList_3.loadKDString());
            return false;
        }
        String redeemWay = finSubscribe.getString("redeemway");
        if (RedeemWayEnum.copies_redeem.getValue().equals(redeemWay)) {
            this.getView().showTipNotification(CimFormResourceEnum.FinSubscribeList_4.loadKDString());
            return false;
        }
        String tradeChannel = finSubscribe.getString("tradechannel");
        if (TradeChannelEnum.ONLINE.getValue().equals(tradeChannel) && !FinServiceStatusEnum.subscribe_done.getValue().equals(finSubscribe.getString("finservicestatus"))) {
            this.getView().showTipNotification(CimFormResourceEnum.FinSubscribeList_6.loadKDString());
            return false;
        }
        return true;
    }

    private void showOperationConfirm(BeforeDoOperationEventArgs args) {
        this.getView().showConfirm(CimFormResourceEnum.FinSubscribeEdit_1.loadKDString(), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("sumbitConfig", (IFormPlugin)this));
        args.setCancel(true);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (StringUtils.equals((CharSequence)"sumbitConfig", (CharSequence)evt.getCallBackId()) && evt.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put("passSubmit", "true");
            this.getView().invokeOperation("submit");
        }
    }

    protected List<QFilter> addCustomFilterForFilterCol(String fieldName) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
        if (StringUtils.equals((CharSequence)"investvarieties.name", (CharSequence)fieldName)) {
            filters.add(new QFilter("investtype", "=", (Object)InvestTypeEnum.finance));
        }
        return filters;
    }

    private void removeSpareFilter(FilterContainerInitArgs args) {
        List commonFilterColumns = args.getCommonFilterColumns();
        commonFilterColumns.removeIf(v -> kd.tmc.cim.common.util.StringUtils.equalsAny((String)v.getFieldName(), (String[])new String[]{"finorginfo.name", "bebankstatus", "submittime"}));
        args.getFastFilterColumns().removeIf(v -> kd.tmc.cim.common.util.StringUtils.equalsAny((String)v.getFieldName(), (String[])new String[]{"finorginfo.name"}));
    }

    private void modifyPlanRevenue(Map returnData) {
        if (EmptyUtil.isEmpty((Object)returnData)) {
            return;
        }
        this.getView().invokeOperation("modifyrate");
        List finsubbillids = (List)returnData.get("finsubbillids");
        DynamicObject[] finSubBills = TmcDataServiceHelper.load((Object[])finsubbillids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cim_finsubscribe"));
        List<String> bizStatusList = Arrays.asList(FinServiceStatusEnum.subscribe_done.getValue(), FinServiceStatusEnum.subscribe_part.getValue());
        List<DynamicObject> filteredFinBills = Arrays.stream(finSubBills).filter(r -> BillStatusEnum.AUDIT.getValue().equals(r.getString("billstatus")) && bizStatusList.contains(r.getString("finservicestatus"))).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(filteredFinBills)) {
            return;
        }
        ArrayList<Long> realNeedUpdateIds = new ArrayList<Long>(filteredFinBills.size());
        BigDecimal newPlanRate = (BigDecimal)returnData.get("planrevenue");
        for (DynamicObject finSubBill : filteredFinBills) {
            finSubBill.set("planrevenue", (Object)newPlanRate);
            BigDecimal calAmount = RedeemBillHelper.calPlanAmount((ModelAgent)new ModelAgent((Object)finSubBill));
            finSubBill.set("planamount", (Object)calAmount);
            finSubBill.set("modifier", (Object)RequestContext.get().getCurrUserId());
            finSubBill.set("modifytime", (Object)new Date());
            realNeedUpdateIds.add(finSubBill.getLong("id"));
        }
        SaveServiceHelper.update((DynamicObject[])filteredFinBills.toArray(new DynamicObject[0]));
        HashMap operationVariable = new HashMap(2);
        for (int i = 0; i < realNeedUpdateIds.size(); ++i) {
            RevenuePlanCalHelper.calRevenuePlan((Long)((Long)finsubbillids.get(i)), (String)CimEntityEnum.cim_finsubscribe.getValue(), operationVariable);
        }
        this.getView().invokeOperation("refresh");
    }

    private void showModifyRateForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cim_modifyplanrate");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        List selectedIdList = this.getSelectedIdList();
        showParameter.setCustomParam("finsubbillids", (Object)selectedIdList);
        if (selectedIdList.size() == 1) {
            DynamicObject finSubBill = QueryServiceHelper.queryOne((String)CimEntityEnum.cim_finsubscribe.getValue(), (String)"planrevenue", (QFilter[])new QFilter[]{new QFilter("id", "=", selectedIdList.get(0))});
            showParameter.setCustomParam("ori_planrevenue", (Object)finSubBill.getBigDecimal("planrevenue"));
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "modifyrate_action"));
        this.getView().showForm(showParameter);
    }
}

