/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.home;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractExpireWarnPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String appId = this.getView().getFormShowParameter().getAppId();
        long orgId = RequestContext.get().getOrgId();
        boolean hasPermision = TmcOrgDataHelper.hasPermission((String)appId, (long)RequestContext.get().getCurrUserId(), (long)orgId, (String)this.getEntityName(), (String)"47150e89000000ac");
        if (hasPermision) {
            DataSet dataSet = this.loanData();
            this.renderView(dataSet);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"refresh_btn"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("refresh_btn".equals(key)) {
            Integer day;
            if ("customrange".equals(this.getModel().getValue("expireday"))) {
                Date endDate = (Date)this.getModel().getValue("custexpireenddate");
                if (endDate == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f\u5fc5\u586b\u3002", (String)"AbstractExpireWarnPlugin_0", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                    return;
                }
                Date startDate = (Date)this.getModel().getValue("custexpirestartdate");
                if (startDate != null && startDate.after(endDate)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d77\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u622a\u6b62\u65e5\u671f\u3002", (String)"AbstractExpireWarnPlugin_3", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            if ("customday".equals(this.getModel().getValue("expireday")) && ((day = (Integer)this.getModel().getValue("day")) == null || day <= 0 || day > 365)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u63d0\u524d\u9884\u8b66\u5929\u6570\uff0c\u8303\u56f4\u4e3a1~365\u5929", (String)"AbstractExpireWarnPlugin_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                return;
            }
            DataSet dataSet = this.loanData();
            boolean result = this.renderView(dataSet);
            if (result) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f\u3002", (String)"AbstractExpireWarnPlugin_2", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "expireday": {
                if ("customrange".equals(this.getModel().getValue("expireday"))) {
                    TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"day"});
                    break;
                }
                if ("customday".equals(this.getModel().getValue("expireday"))) {
                    TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"day"});
                    break;
                }
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"day"});
            }
        }
    }

    private DataSet loanData() {
        String formId = this.getView().getFormShowParameter().getFormId();
        DataSet groupBillDs = QueryServiceHelper.queryDataSet((String)formId, (String)this.getEntityName(), (String)this.getSelectedField(), (QFilter[])this.getFilter(), null);
        return groupBillDs;
    }

    public boolean renderView(DataSet dataSet) {
        IDataModel model = this.getModel();
        AbstractFormDataModel dataModel = (AbstractFormDataModel)model;
        dataModel.deleteEntryData("entryentity");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        Arrays.stream(this.getSelectedField().split(",")).forEach(field -> vs.addField(field, new Object[0]));
        for (Row row : dataSet) {
            List collect = Arrays.stream(this.getSelectedField().split(",")).map(s -> row.get(s)).collect(Collectors.toList());
            vs.addRow(collect.toArray());
        }
        dataModel.beginInit();
        dataModel.batchCreateNewEntryRow("entryentity", vs);
        dataModel.endInit();
        this.getView().updateView("entryentity");
        return true;
    }

    public QFilter getDateFilter() {
        Pair<Date, Date> dateDatePair = this.transDate();
        Date startDate = (Date)dateDatePair.getLeft();
        Date endDate = (Date)dateDatePair.getRight();
        QFilter dateFilter = new QFilter(this.getExpireDateFieldName(), "<=", (Object)endDate);
        if (startDate != null) {
            dateFilter.and(new QFilter(this.getExpireDateFieldName(), ">=", (Object)startDate));
        }
        return dateFilter;
    }

    public QFilter getCustomFilter() {
        return null;
    }

    public QFilter[] getFilter() {
        QFilter dateFilter = this.getDateFilter();
        QFilter customFilter = this.getCustomFilter();
        return new QFilter[]{dateFilter, customFilter};
    }

    public abstract String getExpireDateFieldName();

    private Pair<Date, Date> transDate() {
        Date startDate = DateUtils.getCurrentDate();
        Date endDate = DateUtils.getCurrentDate();
        String expireday = (String)this.getModel().getValue("expireday");
        if ("thisweek".equals(expireday)) {
            startDate = DateUtils.getFirstDayOfWeek((Date)startDate);
            endDate = DateUtils.getMaxWeekDate((Date)endDate);
        } else if ("thismonth".equals(expireday)) {
            startDate = DateUtils.getFirstDayOfMonth((Date)startDate);
            endDate = DateUtils.getMaxMonthDate((Date)endDate);
        } else if ("nextweek".equals(expireday)) {
            startDate = DateUtils.getNextWeekMonday((Date)startDate);
            endDate = DateUtils.getMaxWeekDate((Date)startDate);
        } else if ("nextmonth".equals(expireday)) {
            startDate = DateUtils.getFirstDateOfNextMonth((Date)startDate);
            endDate = DateUtils.getMaxMonthDate((Date)startDate);
        } else if ("customrange".equals(expireday)) {
            startDate = (Date)this.getModel().getValue("custexpirestartdate");
            endDate = (Date)this.getModel().getValue("custexpireenddate");
            endDate = DateUtils.getDataFormat((Date)endDate, (boolean)false);
        } else if ("customday".equals(expireday)) {
            endDate = DateUtils.getNextDay((Date)endDate, (int)((Integer)this.getModel().getValue("day")));
            endDate = DateUtils.getDataFormat((Date)endDate, (boolean)false);
        }
        return Pair.of((Object)startDate, (Object)endDate);
    }

    public abstract String getSelectedField();

    public abstract String getEntityName();

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        Object id = entryRowEntity.get("id");
        BillShowParameter param = new BillShowParameter();
        param.setFormId(this.getHyperLinkFormId());
        param.setPkId(id);
        param.setStatus(OperationStatus.VIEW);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)param);
    }

    public String getHyperLinkFormId() {
        return this.getEntityName();
    }
}

