/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.home;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.ChartType;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinRevenueAnalysisHistogramChartPlugin
extends AbstractFormPlugin {
    private static final String CHART_PROP = "pointlinechartap";
    private static final String FIN_SUBSCRIBE_PROPS = "valuedate,planrevenue";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshChart();
    }

    private void refreshChart() {
        Map<String, BigDecimal> map = this.selectData();
        if (map == null || map.isEmpty()) {
            return;
        }
        PointLineChart chart = (PointLineChart)this.getControl(CHART_PROP);
        this.setStyle(chart);
        chart.clearData();
        this.createYAxis(chart);
        this.createXAxis(chart, map.keySet());
        this.setData(chart, map);
    }

    private void setStyle(PointLineChart chart) {
        chart.setMargin(Position.left, "15px");
        chart.setMargin(Position.right, "45px");
        chart.setMargin(Position.top, "30px");
        chart.setMargin(Position.bottom, "15px");
        chart.setShowLegend(true);
        chart.setLegendPropValue("itemWidth", (Object)10);
        chart.setLegendPropValue("itemHeight", (Object)10);
        chart.setLegendVertical(true);
        chart.setLegendAlign(XAlign.right, YAlign.top);
        chart.setShowTooltip(true);
    }

    private void createYAxis(PointLineChart chart) {
        Axis yAxis = chart.createYAxis("", AxisType.value);
        yAxis.setPosition(Position.bottom);
        yAxis.setPropValue("nameGap", (Object)"5");
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        map.put("padding", new int[]{0, 55, 0, 0});
        yAxis.setPropValue("nameTextStyle", map);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.valueOf(false));
        yAxis.setPropValue("axisTick", axisTick);
        HashMap<String, Object> axisLabel = new HashMap<String, Object>();
        axisLabel.put("formatter", "{value}%");
        axisLabel.put("inside", false);
        yAxis.setPropValue("axisLabel", axisLabel);
        this.setLineColor(yAxis);
    }

    private void setLineColor(Axis axis) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", "#999999");
        axisLineMap.put("lineStyle", lineStyleMap);
        axis.setPropValue("axisLine", axisLineMap);
    }

    private void createXAxis(PointLineChart chart, Set<String> valueDate) {
        Axis xAxis = chart.createXAxis("", AxisType.category);
        xAxis.setCategorys(valueDate.toArray(new String[0]));
        xAxis.setPropValue("nameGap", (Object)"5");
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        map.put("padding", new int[]{0, 0, 5, -45});
        xAxis.setPropValue("nameTextStyle", map);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", false);
        xAxis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        xAxis.setPropValue("splitLine", splitLine);
        this.setLineColor(xAxis);
        HashMap<String, Object> axisLabel = new HashMap<String, Object>();
        axisLabel.put("rotate", "-15");
        axisLabel.put("inside", false);
        axisLabel.put("margin", "10");
        xAxis.setPropValue("axisLabel", axisLabel);
    }

    private void setData(PointLineChart chart, Map<String, BigDecimal> map) {
        LineSeries lineSeries = this.createPieSeries(chart, ResManager.loadKDString((String)"\u9884\u8ba1\u6536\u76ca\u7387", (String)"FinRevenueAnalysisHistogramChartPlugin_0", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
        lineSeries.setData((Number[])map.values().toArray(new BigDecimal[0]));
        chart.bindData(null);
    }

    private LineSeries createPieSeries(PointLineChart chart, String name) {
        LineSeries lineSeries = chart.createSeries(name);
        lineSeries.setType(ChartType.line);
        lineSeries.setAnimationDuration(1500);
        HashMap<String, Object> itemStyle = new HashMap<String, Object>();
        itemStyle.put("shadowBlur", 10);
        itemStyle.put("shadowOffsetX", 0);
        itemStyle.put("shadowColor", "rgba(0, 0, 0, 0.5)");
        lineSeries.setPropValue("itemStyle", itemStyle);
        ArrayList<String> list = new ArrayList<String>();
        list.add("itemStyle");
        list.add("normal");
        list.add("color");
        lineSeries.addFuncPath(list);
        Label label = new Label();
        label.setShow(false);
        lineSeries.setLabel(label);
        return lineSeries;
    }

    private Map<String, BigDecimal> selectData() {
        DataSet resultDS = this.selectFinRevenueBillList();
        resultDS = resultDS.copy().groupBy(new String[]{"valuedate"}).avg("planrevenue").finish();
        TreeMap<String, BigDecimal> map = new TreeMap<String, BigDecimal>();
        for (Row finRevenueDatum : resultDS.copy()) {
            BigDecimal ePlanRevenue = finRevenueDatum.getBigDecimal("planrevenue");
            map.put(DateUtils.formatString((Date)finRevenueDatum.getDate("valuedate"), (String)"yyyy-MM-dd"), EmptyUtil.isEmpty((BigDecimal)ePlanRevenue) ? BigDecimal.ZERO : ePlanRevenue.setScale(6, 4));
        }
        return map;
    }

    private DataSet selectFinRevenueBillList() {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cim_finsubscribe", (String)"47150e89000000ac");
        qFilter.and(new QFilter("org", "in", (Object)orgIds));
        return QueryServiceHelper.queryDataSet((String)"finRevenue", (String)"cim_finsubscribe", (String)FIN_SUBSCRIBE_PROPS, (QFilter[])qFilter.toArray(), (String)"valuedate asc");
    }
}

