/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.intbatch;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.common.enums.WriteOffStatusEnum;
import kd.tmc.cim.common.helper.IntBillBatchHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.fbp.service.entitymap.helper.EntityMapBizHelper;

public class IntBillBatchEdit
extends AbstractTmcBillEdit
implements HyperLinkClickListener,
RowClickEventListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entrysGrid = (EntryGrid)this.getControl("entry");
        entrysGrid.addHyperClickListener((HyperLinkClickListener)this);
        entrysGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((CharSequence)"entry", (CharSequence)entryGrid.getKey())) {
            int index = evt.getRow();
            if (index < 0) {
                return;
            }
            this.loanIntEntry(index);
        }
    }

    private void loanIntEntry(int index) {
        DynamicObject entry = this.getModel().getEntryRowEntity("entry", index);
        this.getModel().setValue("intnum", (Object)entry.getString("intdetailnum"));
        this.getModel().setValue("loannum", (Object)entry.getString("finbillno"));
        IntBillBatchHelper.loanIntDetailInfo((DynamicObject)entry, (AbstractFormPlugin)this, (IDataModel)this.getModel());
    }

    public void afterCreateNewData(EventObject e) {
        Map param = this.getView().getFormShowParameter().getCustomParams();
        if (param.containsKey("navparam")) {
            Map navParam = (Map)SerializationUtils.fromJsonString((String)param.get("navparam").toString(), Map.class);
            Date endIntDate = DateUtils.stringToDate((String)((String)navParam.get("endintdate")), (String)"yyyy-MM-dd");
            this.getModel().setValue("preintdate", (Object)endIntDate);
        }
        this.loadIntDetail();
        DynamicObject permOrg = TmcOrgDataHelper.getCurrentAuthPermOrg((String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getEntityId(), (String)"47150e89000000ac", (long)RequestContext.get().getOrgId());
        if (EmptyUtil.isNoEmpty((DynamicObject)permOrg)) {
            this.getModel().setValue("org", permOrg.getPkValue());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("deleteentryloans".equals(operateKey)) {
            String errMsg = this.checkLoansEntry();
            if (EmptyUtil.isNoEmpty((String)errMsg)) {
                args.setCancel(true);
                this.getView().showTipNotification(errMsg);
                return;
            }
            this.dealInterest();
        } else if ("addentryloans".equals(operateKey)) {
            args.setCancel(true);
            this.openAddNewNavigateForm(this.initParams());
        }
    }

    private FormShowParameter initParams() {
        HashMap<String, Object> initParams = new HashMap<String, Object>();
        FormShowParameter showParameter = new FormShowParameter();
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
        List loanIds = entrys.stream().map(dny -> dny.getLong("finbillid")).collect(Collectors.toList());
        showParameter.getCustomParams().put("loanIds", loanIds);
        initParams.put("endintdate", this.getModel().getValue("preintdate"));
        HashSet<String> orgIds = new HashSet<String>(entrys.size());
        HashSet<String> currenyIds = new HashSet<String>(entrys.size());
        for (DynamicObject dyn : entrys) {
            orgIds.add(dyn.getDynamicObject("company").getPkValue().toString());
            currenyIds.add(dyn.getDynamicObject("currency").getPkValue().toString());
        }
        initParams.put("orgs", orgIds);
        initParams.put("currencys", currenyIds);
        showParameter.getCustomParams().put("initParams", initParams);
        return showParameter;
    }

    private void openAddNewNavigateForm(FormShowParameter showParameter) {
        showParameter.setFormId("cim_navigate_addnew");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close_bake_key_filter"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (StringUtils.equals((CharSequence)"close_bake_key_filter", (CharSequence)evt.getActionId()) && null != evt.getReturnData()) {
            Map navParam = (Map)evt.getReturnData();
            List<Map<String, Object>> intDetail = this.genIntDetails(navParam.get("calcIntResult").toString());
            TmcViewInputHelper.batchFillEntity((String)"entry", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), intDetail, (boolean)false);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("submit".equals(operateKey)) {
            this.getView().updateView();
        } else if ("deleteentryloans".equals(operateKey)) {
            this.getView().invokeOperation("save");
        }
        this.loanIntEntry(0);
    }

    private void dealInterest() {
        DynamicObjectCollection cl = this.getModel().getEntryEntity("entry");
        int[] indexs = ((EntryGrid)this.getControl("entry")).getSelectRows();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("WF", "TRUE");
        for (int i = 0; i < indexs.length; ++i) {
            Long id = ((DynamicObject)cl.get(indexs[i])).getLong("intbillid");
            if (!EmptyUtil.isNoEmpty((Long)id) || !TmcDataServiceHelper.exists((Object)id, (String)"cim_intbill_revenue")) continue;
            TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)"cim_intbill_revenue", (Object[])new Object[]{id}, (OperateOption)operateOption, (boolean)true);
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"cim_intbill_revenue", (Object[])new Object[]{id}, (OperateOption)operateOption, (boolean)true);
        }
    }

    private String checkLoansEntry() {
        DynamicObjectCollection cl = this.getModel().getEntryEntity("entry");
        int[] indexs = ((EntryGrid)this.getControl("entry")).getSelectRows();
        if (cl.size() == indexs.length) {
            return ResManager.loadKDString((String)"\u81f3\u5c11\u6709\u4e00\u6761\u5206\u5f55", (String)"DptRevenueBatchEdit_3", (String)"tmc-cim-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadEntryTotalIntamt();
        this.loanIntEntry(0);
    }

    private void loadIntDetail() {
        this.getModel().deleteEntryData("entry");
        JSONObject navParam = (JSONObject)this.getView().getFormShowParameter().getCustomParams().get("navparam");
        List<Map<String, Object>> intDetail = this.genIntDetails(navParam.getString("calcIntResult"));
        TmcViewInputHelper.batchFillEntity((String)"entry", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), intDetail);
        this.dealNoBotpTake(intDetail);
    }

    private void dealNoBotpTake(List<Map<String, Object>> intDetail) {
        Set finsubIdSet = intDetail.stream().map(r -> r.get("finbillid")).collect(Collectors.toSet());
        EntityMapBizHelper.dealNoneBotpPush(finsubIdSet, (String)"cim_finsubscribe", (IDataModel)this.getModel());
    }

    public List<Map<String, Object>> genIntDetails(String calcIntResultStr) {
        Map calcIntResult = (Map)JSON.parseObject((String)calcIntResultStr, (TypeReference)new TypeReference<Map<String, IntBillInfo>>(){}, (Feature[])new Feature[0]);
        ArrayList<Map<String, Object>> intDetails = new ArrayList<Map<String, Object>>(calcIntResult.size());
        calcIntResult.forEach((entryJson, intBill) -> {
            Object[] finBill = DynamicObjectSerializeUtil.deserialize((String)entryJson, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)CimEntityEnum.cim_finsubscribe.getValue()));
            this.fillIntDetail((DynamicObject)finBill[0], (IntBillInfo)intBill, (List<Map<String, Object>>)intDetails);
        });
        return intDetails;
    }

    protected void fillIntDetail(DynamicObject finBill, IntBillInfo intBill, List<Map<String, Object>> dataMap) {
        if (EmptyUtil.isEmpty((Object)intBill)) {
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("company", finBill.getDynamicObject("org"));
        data.put("currency", finBill.getDynamicObject("currency"));
        data.put("finbillno", finBill.getString("billno"));
        data.put("finbillid", finBill.getLong("id"));
        data.put("startdate", intBill.getBeginDate());
        data.put("enddate", intBill.getEndDate());
        Integer difDays = intBill.getDetails().stream().map(r -> r.getDays()).reduce((a, b) -> a + b).orElse(0);
        data.put("intdays", difDays);
        data.put("interestamt", intBill.getAmount());
        data.put("actualinstamt", intBill.getAmount());
        data.put("iswriteoff", Boolean.FALSE);
        data.put("intdetail_tag", SerializationUtils.toJsonString((Object)intBill));
        dataMap.add(data);
    }

    private void loadEntryTotalIntamt() {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            Long finBillId = entry.getLong("finbillid");
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"totalintamt", (Object)this.getTotalPreIntAmt(finBillId), (int)i);
        }
    }

    private BigDecimal getTotalPreIntAmt(Long finBillId) {
        DynamicObject[] preIntBills = this.getSumPreIntBills(finBillId);
        return Arrays.stream(preIntBills).map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private DynamicObject[] getSumPreIntBills(Long finBillId) {
        QFilter filter = new QFilter("finbillno", "=", (Object)finBillId);
        filter.and("writeoffstatus", "=", (Object)WriteOffStatusEnum.NO_WRITEOFF.getValue());
        filter.and("datasource", "=", (Object)"interestrev");
        Date preIntDate = (Date)this.getModel().getValue("preintdate");
        filter.and("revenueenddate", "<", (Object)DateUtils.getLastDay((Date)preIntDate, (int)1));
        return TmcDataServiceHelper.load((String)"cim_intbill_revenue", (String)"finbillno,writeoffstatus,amount,datasource", (QFilter[])filter.toArray());
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName;
        switch (fieldName = evt.getFieldName()) {
            case "interestamt": {
                this.showIntDetailForm(evt.getRowIndex());
                break;
            }
            case "intdetailnum": {
                IntBillBatchHelper.showIntRevBillForm((Object)this.getModel().getValue("intbillid", evt.getRowIndex()), (IFormView)this.getView());
                break;
            }
            case "writeoffbillno": {
                IntBillBatchHelper.showIntRevBillForm((Object)this.getModel().getValue("writeoffbillid", evt.getRowIndex()), (IFormView)this.getView());
                break;
            }
            case "totalintamt": {
                this.showIntRevBillFormByTotalAmt(evt.getRowIndex());
            }
        }
    }

    private void showIntDetailForm(int index) {
        FormShowParameter parameter = new FormShowParameter();
        DynamicObject entry = this.getModel().getEntryRowEntity("entry", index);
        String callIntStr = entry.getString("intdetail_tag");
        parameter.getCustomParams().put("intdetail_tag", callIntStr);
        parameter.getCustomParams().put("currency", entry.getDynamicObject("currency").getPkValue());
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setFormId("cim_revcaldetailcard");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    private void showIntRevBillFormByTotalAmt(int index) {
        DynamicObject entry = this.getModel().getEntryRowEntity("entry", index);
        DynamicObject[] preIntBills = this.getSumPreIntBills(entry.getLong("finbillid"));
        if (preIntBills.length == 1) {
            IntBillBatchHelper.showIntRevBillForm((Object)preIntBills[0].getPkValue(), (IFormView)this.getView());
        } else {
            List collect = Arrays.stream(preIntBills).map(s -> s.getLong("id")).collect(Collectors.toList());
            IntBillBatchHelper.showIntRevBillListForm(collect, (IFormView)this.getView());
        }
    }
}

