/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.intbatch;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.tmc.cim.common.helper.IntBillBatchHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;

public class IntBillBatchList
extends AbstractTmcListPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        List<String> singleOps = Arrays.asList("submit", "unsubmit", "audit", "unaudit");
        if (singleOps.contains(operateKey) && args.getListSelectedData().getPrimaryKeyValues().length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\u3002", (String)"IntBillBatchList_0", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"new")) {
            args.setCancel(true);
            this.openAddNewNavigateForm();
        }
    }

    private void openAddNewNavigateForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cim_navigate_addnew");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close_bake_key_filter"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (StringUtils.equals((CharSequence)"close_bake_key_filter", (CharSequence)evt.getActionId()) && null != evt.getReturnData()) {
            BillShowParameter parameter = new BillShowParameter();
            parameter.setStatus(OperationStatus.ADDNEW);
            parameter.setFormId("cim_intbill_batch");
            parameter.setCustomParam("navparam", evt.getReturnData());
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CLOSE_BAKE_KEY_EXIST"));
            this.getView().showForm((FormShowParameter)parameter);
        } else if (StringUtils.equals((CharSequence)"CLOSE_BAKE_KEY_EXIST", (CharSequence)evt.getActionId())) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if ("bartrack".equals(evt.getItemKey())) {
            Long id = super.getSelectedId();
            if (EmptyUtil.isEmpty((Long)id)) {
                return;
            }
            this.trackClick(id);
        }
    }

    private void trackClick(Long id) {
        DynamicObject intBatchBill = TmcDataServiceHelper.loadSingle((Object)id, (String)"cim_intbill_batch");
        DynamicObjectCollection entrys = intBatchBill.getDynamicObjectCollection("entry");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) {
            List collect = entrys.stream().filter(s -> EmptyUtil.isNoEmpty((Long)s.getLong("intbillid"))).map(s -> s.getLong("intbillid")).collect(Collectors.toList());
            if (collect.size() == 1) {
                IntBillBatchHelper.showIntRevBillForm(collect.get(0), (IFormView)this.getView());
            } else if (collect.size() > 1) {
                IntBillBatchHelper.showIntRevBillListForm(collect, (IFormView)this.getView());
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"IntBillBatchList_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

