/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.profitscheme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.tmc.cim.common.enums.ProfitCycleEnum;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ProfitschemeEdit
extends AbstractBasePlugIn {
    private static final String TMC_CIM_FORMPLUGIN = "tmc-cim-formplugin";
    private static Map<String, String> ckMonthMap;
    private static Map<String, String> ckDayMap;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"month", "flexpmb", "flexpmlab", "day", "flexpdb", "flexpdlab", "offetday"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.resetInterest();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)ProfitCycleEnum.isDay((String)((String)this.getModel().getValue("period"))), (String[])new String[]{"days"});
        String period = (String)this.getModel().getValue("period");
        this.getView().setVisible(Boolean.valueOf(ProfitCycleEnum.isShowMonthDay((String)period)), new String[]{"flexpmonths", "flexpdays"});
        boolean isChanged = this.getModel().getDataChanged();
        this.setSelectCkMonth();
        this.setSelectCkDay();
        this.registerIntInfoMustInput();
        this.getModel().setDataChanged(isChanged);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        IDataModel model = this.getModel();
        if (propName.startsWith("ckmonth")) {
            model.setValue("month", (Object)this.getSelectMonth());
            this.getView().updateView("month");
        } else if (propName.startsWith("ckday")) {
            model.setValue("day", (Object)this.getSelectDay(propName));
            this.getView().updateView("day");
        }
        switch (propName) {
            case "month": {
                this.setSelectCkMonth();
                break;
            }
            case "day": {
                this.setSelectCkDay();
                break;
            }
            case "period": {
                this.resetInterest();
                break;
            }
        }
    }

    private String loadKDString(String desc, String resourceID) {
        return ResManager.loadKDString((String)desc, (String)resourceID, (String)TMC_CIM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private void setControlVisible(Boolean isVisible, String ... controls) {
        this.getView().setVisible(isVisible, controls);
    }

    private void updateView(String ... propNames) {
        IFormView view = this.getView();
        for (String propName : propNames) {
            view.updateView(propName);
        }
    }

    private void resetInterest() {
        IDataModel model = this.getModel();
        String profitCycle = (String)model.getValue("period");
        if (StringUtils.isBlank((CharSequence)profitCycle)) {
            return;
        }
        IFormView view = this.getView();
        TmcViewInputHelper.registerMustInput((IFormView)view, (boolean)ProfitCycleEnum.isDay((String)profitCycle), (String[])new String[]{"days"});
        if (ProfitCycleEnum.isDay((String)profitCycle)) {
            this.getModel().setValue("days", (Object)1);
            this.getView().updateView("days");
        } else {
            this.getModel().setValue("days", null);
        }
        boolean isCycle = ProfitCycleEnum.isCycle((String)profitCycle);
        TmcViewInputHelper.registerMustInput((IFormView)view, (boolean)isCycle, (String[])new String[]{"month", "day"});
        TmcViewInputHelper.registerVisibleStatus((IFormView)view, (String[])new String[]{"month", "day", "flexpmonths", "flexpdays"}, (boolean)isCycle);
        this.getModel().setValue("month", (Object)(isCycle ? ProfitCycleEnum.getDefValueByType((String)profitCycle) : null));
        this.getModel().setValue("day", (Object)(isCycle ? "20" : null));
        this.getModel().setValue("drawmonthsettle", (Object)(isCycle ? Boolean.FALSE : null));
        boolean isToCycle = ProfitCycleEnum.isToCycle((String)profitCycle);
        this.getModel().setValue("offetday", (Object)(isToCycle ? Integer.valueOf(1) : null));
        this.updateView("month", "day");
        this.setSelectCkMonth();
        this.setSelectCkDay();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String clickKey = ((Control)evt.getSource()).getKey();
        IFormView view = this.getView();
        switch (clickKey) {
            case "month": {
                if (EmptyUtil.isEmpty((Object)this.getModel().getValue("period"))) {
                    view.showTipNotification(this.loadKDString("\u8bf7\u5148\u9009\u62e9\u6536\u76ca\u5468\u671f\u3002", "ProfitschemeEdit_0"));
                    return;
                }
                this.setControlVisible(Boolean.TRUE, "flexpmonths");
                break;
            }
            case "flexpmb": 
            case "flexpmlab": {
                this.setControlVisible(Boolean.FALSE, "flexpmonths");
                break;
            }
            case "day": {
                if (EmptyUtil.isEmpty((Object)this.getModel().getValue("period"))) {
                    view.showTipNotification(this.loadKDString("\u8bf7\u5148\u9009\u62e9\u6536\u76ca\u5468\u671f\u3002", "ProfitschemeEdit_0"));
                    return;
                }
                this.setControlVisible(Boolean.TRUE, "flexpdays");
                break;
            }
            case "flexpdb": 
            case "flexpdlab": {
                this.setControlVisible(Boolean.FALSE, "flexpdays");
                break;
            }
        }
    }

    private String getSelectDay(String propName) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        boolean isSelect = (Boolean)model.getValue(propName);
        String ckDay = "";
        String selectDay = "";
        model.beginInit();
        for (Map.Entry<String, String> cbox : ckDayMap.entrySet()) {
            ckDay = cbox.getKey();
            if (isSelect && ckDay.equals(propName)) {
                selectDay = cbox.getValue();
            }
            if (!isSelect || !((Boolean)model.getValue(ckDay)).booleanValue() || ckDay.equals(propName)) continue;
            model.setValue(ckDay, (Object)false);
        }
        model.endInit();
        view.updateView("flexpmonths");
        return selectDay;
    }

    private String getSelectMonth() {
        IDataModel model = this.getView().getModel();
        StringJoiner monthsJoiner = new StringJoiner(",");
        ArrayList<String> selectKeys = new ArrayList<String>();
        for (Map.Entry<String, String> cbox : ckMonthMap.entrySet()) {
            if (!((Boolean)model.getValue(cbox.getKey())).booleanValue()) continue;
            selectKeys.add(cbox.getKey());
            monthsJoiner.add(cbox.getValue());
        }
        this.setCkMonthEnable(selectKeys);
        return monthsJoiner.toString();
    }

    private void setSelectCkMonth() {
        IDataModel model = this.getView().getModel();
        IFormView view = this.getView();
        String selectMonths = (String)model.getValue("month");
        String[] ckMonthKeys = null;
        if (StringUtils.isNotBlank((CharSequence)selectMonths)) {
            ckMonthKeys = selectMonths.split(",");
        }
        ArrayList<String> selectKeys = new ArrayList<String>(16);
        model.beginInit();
        for (Map.Entry<String, String> cbox : ckMonthMap.entrySet()) {
            if (StringUtils.equalsAny((String)cbox.getValue(), (String[])ckMonthKeys)) {
                model.setValue(cbox.getKey(), (Object)true);
                selectKeys.add(cbox.getKey());
                continue;
            }
            model.setValue(cbox.getKey(), (Object)false);
        }
        model.endInit();
        this.setCkMonthEnable(selectKeys);
        view.updateView("flexpmonths");
    }

    private void setCkMonthEnable(List<String> selectKeys) {
        String profitCycle = (String)this.getModel().getValue("period");
        int keySize = selectKeys.size();
        if (keySize > 11 && ProfitCycleEnum.isMonth((String)profitCycle)) {
            TmcViewInputHelper.registerDisableStatus((IFormView)this.getView(), (String[])selectKeys.toArray(new String[0]));
            return;
        }
        boolean cleDisEnable = true;
        if (keySize > 0 && ProfitCycleEnum.isYear((String)profitCycle) || keySize > 1 && ProfitCycleEnum.isHalfYear((String)profitCycle) || keySize > 3 && ProfitCycleEnum.isQuarter((String)profitCycle)) {
            cleDisEnable = false;
        }
        String[] keys = ckMonthMap.keySet().toArray(new String[0]);
        if (cleDisEnable) {
            this.getView().setEnable(Boolean.valueOf(true), keys);
        } else {
            List<String> unSelectKeys = Arrays.stream(keys).filter(v -> !selectKeys.contains(v)).collect(Collectors.toList());
            this.getView().setEnable(Boolean.valueOf(true), selectKeys.toArray(new String[0]));
            TmcViewInputHelper.registerDisableStatus((IFormView)this.getView(), (String[])unSelectKeys.toArray(new String[0]));
        }
    }

    private void setSelectCkDay() {
        IDataModel model = this.getView().getModel();
        String day = (String)model.getValue("day");
        model.beginInit();
        for (Map.Entry<String, String> cbox : ckDayMap.entrySet()) {
            model.setValue(cbox.getKey(), (Object)StringUtils.equals((CharSequence)day, (CharSequence)cbox.getValue()));
        }
        model.endInit();
        this.getView().updateView("flexpdays");
    }

    private void registerIntInfoMustInput() {
        IDataModel model = this.getModel();
        String profitCycle = (String)model.getValue("period");
        if (StringUtils.isBlank((CharSequence)profitCycle)) {
            return;
        }
        IFormView view = this.getView();
        model.beginInit();
        if (ProfitCycleEnum.isCycle((String)profitCycle)) {
            TmcViewInputHelper.registerShowingStatus((IFormView)view, (String[])new String[]{"month", "day"});
            TmcViewInputHelper.registerMustInput((IFormView)view, (String[])new String[]{"month", "day"});
            model.setValue("month", (Object)ProfitCycleEnum.getDefValueByType((String)profitCycle));
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)view, (boolean)false, (String[])new String[]{"month", "day"});
            TmcViewInputHelper.registerVisibleStatus((IFormView)view, (String[])new String[]{"month", "day", "flexpmonths", "flexpdays"}, (boolean)false);
        }
    }

    static {
        int i;
        ckMonthMap = new HashMap<String, String>();
        ckDayMap = new HashMap<String, String>();
        for (i = 1; i < 13; ++i) {
            ckMonthMap.put(String.format("%s%s", "ckmonth", i), String.valueOf(i));
        }
        for (i = 1; i < 32; ++i) {
            ckDayMap.put(String.format("%s%s", "ckday", i), String.valueOf(i));
        }
    }
}

