/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.scheme;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.DepositTermEnum;
import kd.tmc.cim.common.enums.InterestTypeEnum;
import kd.tmc.cim.common.enums.RateSignEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.SystemStatusCtrolHelper;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositSchemeInfoEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit depositApply = (BasedataEdit)this.getControl("depositapply");
        depositApply.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit referenceRate = (BasedataEdit)this.getControl("referencerate");
        referenceRate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit investVarieties = (BasedataEdit)this.getControl("investvarieties");
        investVarieties.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldName;
        switch (fieldName = evt.getProperty().getName()) {
            case "org": {
                this.setOrgFilter(evt);
                break;
            }
            case "depositapply": {
                this.setApplyOrgFilter(evt);
                break;
            }
            case "referencerate": {
                this.setReferenceRateFilter(evt);
                break;
            }
            case "investvarieties": {
                this.setInvestVarietiesFilter(evt);
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setDepositNumber();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DepositHelper.initInterestTypeEnum((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"investvarieties", (String)"interesttype");
        this.setInterestTypeParameter();
        this.tradeChannelChgEvt(true);
        this.getModel().setDataChanged(false);
    }

    private void setDepositNumber() {
        String number = (String)this.getModel().getValue("number");
        if (StringUtils.isEmpty((CharSequence)number)) {
            return;
        }
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        DynamicObject dynamicObject = TmcDataServiceHelper.loadSingleFromCache((String)"cim_depositscheme", (QFilter[])qFilter.toArray());
        if (dynamicObject != null) {
            this.getModel().setValue("status", dynamicObject.get("status"));
            this.getModel().setDataChanged(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName;
        super.propertyChanged(e);
        switch (fieldName = e.getProperty().getName()) {
            case "interesttype": {
                this.setInterestTypeParameter();
                this.interestTypeChgEvt();
                break;
            }
            case "intdate": 
            case "term": 
            case "deadline": {
                this.calExpireDate((String)this.getModel().getValue("tradechannel"));
                break;
            }
            case "expiredate": {
                this.calTermOrIntDate((String)this.getModel().getValue("tradechannel"));
                break;
            }
            case "tradechannel": {
                this.tradeChannelChgEvt(false);
                break;
            }
            case "investvarieties": {
                DepositHelper.initInterestTypeEnum((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"investvarieties", (String)"interesttype");
                this.investVarietiesChgEvt();
                break;
            }
            case "finorginfo": {
                this.finOrgInfoChgEvt();
                break;
            }
            case "depositapply": {
                this.depositApplyChgEvt();
                break;
            }
            case "org": {
                this.orgChgEvt();
                break;
            }
            case "rangemax": 
            case "rangemin": {
                this.setDefaultRate();
                break;
            }
        }
    }

    private void orgChgEvt() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isNoEmpty((DynamicObject)org)) {
            this.getModel().setValue("currency", (Object)SystemStatusCtrolHelper.getStandardCurrency((long)org.getLong("id")));
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        this.verifyInput(key, value, e);
    }

    private void setInterestTypeParameter() {
        String interestType = (String)this.getModel().getValue("interesttype");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)InterestTypeEnum.FLOAT.getValue().equals(interestType), (String[])new String[]{"referencerate"});
        DynamicObject investVarieties = (DynamicObject)this.getModel().getValue("investvarieties");
        if (EmptyUtil.isNoEmpty((DynamicObject)investVarieties)) {
            String investType = investVarieties.getString("investtype");
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)InvestTypeEnum.isNotice((String)investType), (String[])new String[]{"prenoticeday"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)InvestTypeEnum.isFixed((String)investType), (String[])new String[]{"expireredeposit"});
        }
    }

    private void interestTypeChgEvt() {
        String interestType = (String)this.getModel().getValue("interesttype");
        if (InterestTypeEnum.FLOAT.getValue().equals(interestType)) {
            this.getModel().setValue("interestrate", null);
            this.getModel().setValue("ratesign", (Object)RateSignEnum.ADD.getValue());
        } else if (InterestTypeEnum.FIXED.getValue().equals(interestType)) {
            this.getModel().setValue("referencerate", null);
            this.getModel().setValue("ratesign", null);
            this.getModel().setValue("ratefloatpoint", null);
        }
    }

    protected void verifyInput(String key, Object value, BeforeFieldPostBackEvent e) {
        switch (key) {
            case "term": {
                if (TermHelper.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)value.toString())) break;
                e.setCancel(true);
                this.getView().updateView(key);
                return;
            }
            case "expiredate": {
                if (!EmptyUtil.isNoEmpty((Object)value)) break;
                this.validateExpireDate(e, value, key);
            }
        }
    }

    private void calTermOrIntDate(String tradeChannel) {
        Date expireDate = (Date)this.getModel().getValue("expiredate");
        if (!StringUtils.equals((CharSequence)TradeChannelEnum.ONLINE.getValue(), (CharSequence)tradeChannel)) {
            Date intDate = (Date)this.getModel().getValue("intdate");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{intDate, expireDate})) {
                return;
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", (Object)TermHelper.callTermLargeEqualZore((Date)intDate, (Date)expireDate));
        } else {
            String deadLine = (String)this.getModel().getValue("deadline");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{deadLine, expireDate})) {
                return;
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"intdate", (Object)DepositHelper.calStartDate((Date)expireDate, (String)deadLine));
        }
    }

    private void calExpireDate(String tradeChannel) {
        Date expireDate;
        Date intDate = (Date)this.getModel().getValue("intdate");
        if (!StringUtils.equals((CharSequence)TradeChannelEnum.ONLINE.getValue(), (CharSequence)tradeChannel)) {
            String term = (String)this.getModel().getValue("term");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{intDate, term})) {
                return;
            }
            expireDate = TermHelper.getDateByBaseDate4ymd((String)term, (Date)intDate);
        } else {
            String deadLine = (String)this.getModel().getValue("deadline");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{intDate, deadLine})) {
                return;
            }
            expireDate = DepositHelper.calEndDate((Date)intDate, (String)deadLine);
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"expiredate", (Object)expireDate);
    }

    private void setApplyOrgFilter(BeforeF7SelectEvent e) {
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgIdCollection = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        QFilter qFilter = new QFilter("applyorg", "in", (Object)orgIdCollection.toArray());
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter);
    }

    private void setOrgFilter(BeforeF7SelectEvent e) {
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgIdCollection = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        QFilter qFilter = new QFilter("id", "in", (Object)orgIdCollection.toArray());
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter);
    }

    private void setReferenceRateFilter(BeforeF7SelectEvent e) {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            QFilter qFilter = new QFilter("currency", "=", currency.getPkValue());
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    private void tradeChannelChgEvt(boolean isInit) {
        boolean isAddNew;
        String tradeChannel = (String)this.getModel().getValue("tradechannel");
        boolean isOnline = StringUtils.equals((CharSequence)tradeChannel, (CharSequence)TradeChannelEnum.ONLINE.getValue());
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        OperationStatus opStatus = billShowParameter.getStatus();
        boolean bl = isAddNew = opStatus == OperationStatus.ADDNEW;
        if ((isAddNew || !isInit) && isOnline) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", null);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"deadline", (Object)DepositTermEnum.SIXMONTH.getValue());
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"interesttype", (Object)InterestTypeEnum.FIXED.getValue());
        }
        this.getView().setEnable(Boolean.valueOf(!isOnline), new String[]{"interesttype"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"intdate", "expiredate"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isOnline, (String[])new String[]{"deadline"});
    }

    private void validateExpireDate(BeforeFieldPostBackEvent e, Object value, String fieldName) {
        if (StringUtils.equals((CharSequence)TradeChannelEnum.ONLINE.getValue(), (CharSequence)((String)this.getModel().getValue("tradechannel")))) {
            return;
        }
        Date expireDate = DateUtils.stringToDate((String)value.toString(), (String)"yyyy-MM-dd");
        Date intDate = (Date)this.getModel().getValue("intdate");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{intDate, expireDate})) {
            return;
        }
        if (expireDate.compareTo(intDate) <= 0) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5230\u671f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5b58\u6b3e\u8d77\u606f\u65e5\u3002", (String)"DepositDealEdit_4", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            this.getView().updateView(fieldName);
        }
    }

    private void investVarietiesChgEvt() {
        boolean flag;
        IDataModel model = this.getModel();
        DynamicObject investVarieties = (DynamicObject)model.getValue("investvarieties");
        boolean bl = flag = EmptyUtil.isNoEmpty((DynamicObject)investVarieties) && investVarieties.getBoolean("isproduct");
        if (flag) {
            String number = investVarieties.getString("number");
            String selectProperties = "center,currency,ratetype,productprice,referrate,ratesignbp,ratefloatpoints";
            DynamicObject product = TmcDataServiceHelper.loadSingleFromCache((String)"ifm_ldproduct", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
            boolean enable = true;
            if (EmptyUtil.isNoEmpty((DynamicObject)product)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"finorginfo", (Object)product.getDynamicObject("center"));
                model.setValue("currency", (Object)product.getDynamicObject("currency"));
                model.setValue("interesttype", (Object)product.getString("ratetype"));
                model.setValue("interestrate", (Object)product.getBigDecimal("productprice"));
                model.setValue("referencerate", (Object)product.getDynamicObject("referrate"));
                model.setValue("ratesign", (Object)product.getString("ratesignbp"));
                model.setValue("ratefloatpoint", (Object)product.getBigDecimal("ratefloatpoints"));
                enable = false;
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"tradechannel", (Object)TradeChannelEnum.OFFLINE.getValue());
            }
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{"tradechannel"});
        }
        this.getView().setEnable(Boolean.valueOf(!flag), new String[]{"finorginfo", "currency", "interesttype", "referencerate"});
        if (EmptyUtil.isNoEmpty((DynamicObject)investVarieties)) {
            String investType = investVarieties.getString("investtype");
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)InvestTypeEnum.isNotice((String)investType), (String[])new String[]{"prenoticeday"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)InvestTypeEnum.isFixed((String)investType), (String[])new String[]{"expireredeposit"});
        }
    }

    private void finOrgInfoChgEvt() {
        boolean settleCenterBill = DepositHelper.isSettleCenterBill((DynamicObject)this.getModel().getDataEntity());
        if (settleCenterBill) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"investvarieties", null);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"tradechannel", (Object)TradeChannelEnum.OFFLINE.getValue());
        }
        this.getView().setEnable(Boolean.valueOf(!settleCenterBill), new String[]{"tradechannel"});
    }

    private void depositApplyChgEvt() {
        DynamicObject depositApply = (DynamicObject)this.getModel().getValue("depositapply");
        if (EmptyUtil.isEmpty((DynamicObject)depositApply)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"currency", (Object)0);
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"org", (Object)depositApply.getDynamicObject("applyorg").getPkValue());
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"applydate", (Object)depositApply.get("applydate"));
            if (depositApply.getDynamicObject("currency") != null) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"currency", (Object)depositApply.getDynamicObject("currency").getPkValue());
            } else {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"currency", (Object)SystemStatusCtrolHelper.getStandardCurrency((long)((Long)depositApply.getDynamicObject("applyorg").getPkValue())));
            }
        }
    }

    private void setInvestVarietiesFilter(BeforeF7SelectEvent e) {
        DynamicObject depositOrg = (DynamicObject)this.getModel().getValue("finorginfo");
        if (EmptyUtil.isEmpty((DynamicObject)depositOrg)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5b58\u6b3e\u673a\u6784\u201d\u3002", (String)"DepositApplyEdit_6", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        boolean settleCenterBill = DepositHelper.isSettleCenterBill((DynamicObject)this.getModel().getDataEntity());
        if (settleCenterBill) {
            ListShowParameter f7ShowParam = (ListShowParameter)e.getFormShowParameter();
            f7ShowParam.setCaption(ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u5b58\u6b3e\u4ea7\u54c1", (String)"DepositApplyEdit_7", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            Map productMap = TmcDataServiceHelper.loadFromCache((String)"ifm_ldproduct", (String)"number", (QFilter[])new QFilter[]{new QFilter("center", "=", depositOrg.getPkValue())});
            if (EmptyUtil.isEmpty((Object)productMap) || productMap.size() == 0) {
                f7ShowParam.getListFilterParameter().getQFilters().add(new QFilter("id", "=", (Object)0L));
                return;
            }
            List numberList = productMap.values().stream().map(r -> r.getString("number")).collect(Collectors.toList());
            List investIds = QueryServiceHelper.queryPrimaryKeys((String)"cim_investvarieties", (QFilter[])new QFilter[]{new QFilter("number", "in", numberList)}, null, (int)-1);
            if (EmptyUtil.isNoEmpty((Object)investIds)) {
                f7ShowParam.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)investIds));
            }
        }
    }

    private void setDefaultRate() {
        BigDecimal rangeMin = (BigDecimal)this.getModel().getValue("rangemin");
        BigDecimal rangeMax = (BigDecimal)this.getModel().getValue("rangemax");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{rangeMin, rangeMax})) {
            return;
        }
        BigDecimal halfValue = rangeMin.add(rangeMax).divide(new BigDecimal("2"));
        this.getModel().setValue("interestrate", (Object)halfValue);
    }
}

