/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.scheme;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.common.enums.BonusWayEnum;
import kd.tmc.cim.common.enums.FinApplyTypeEnum;
import kd.tmc.cim.common.enums.RedeemWayEnum;
import kd.tmc.cim.common.helper.FinSubscribeHelper;
import kd.tmc.cim.common.helper.RedeemBillHelper;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinSchemeInfoEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit productFactoryEdit = (BasedataEdit)this.getControl("productfactory");
        productFactoryEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit accountEdit = (BasedataEdit)this.getControl("finaccountf7");
        accountEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit settleAccount = (BasedataEdit)this.getControl("settleaccount");
        settleAccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"finaccount", "s_entry"});
        BasedataEdit product = (BasedataEdit)this.getControl("product");
        product.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.redeemWayChgEvt();
        this.getModel().setDataChanged(false);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"finaccount")) {
            BasedataEdit finAccountF7 = (BasedataEdit)this.getControl("finaccountf7");
            finAccountF7.click();
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "redeemway": {
                this.redeemWayChgEvt();
                this.callPlanAmount();
                break;
            }
            case "expiredate": {
                this.expireDateChgEvt();
                break;
            }
            case "valuedate": {
                this.valueDateChgEvt((Date)args.getChangeSet()[0].getOldValue());
                break;
            }
            case "term": {
                this.termChgEvt((String)args.getChangeSet()[0].getOldValue());
                break;
            }
            case "buycopies": {
                this.calByFinCopies();
                break;
            }
            case "iopv": {
                this.calByFinIopv();
                break;
            }
            case "productfactory": {
                this.productFactoryChgEvt();
                break;
            }
            case "amount": {
                this.calByFinAmount();
                this.callPlanAmount();
                break;
            }
            case "planrevenue": 
            case "basis": {
                this.callPlanAmount();
                break;
            }
            case "intdate": {
                this.intDateChgEvt((Date)args.getChangeSet()[0].getOldValue());
                break;
            }
            case "finapply": {
                this.finapplyChgEvt();
                break;
            }
            case "finaccountf7": {
                DynamicObject finAccount = (DynamicObject)this.getModel().getValue("finaccountf7");
                String finAccountStr = "";
                if (EmptyUtil.isNoEmpty((DynamicObject)finAccount)) {
                    finAccountStr = finAccount.getString("number");
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"finorginfo", (Object)finAccount.getDynamicObject("bank"));
                }
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"finaccount", (Object)finAccountStr);
                break;
            }
            case "finaccount": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"finaccountf7", null);
                break;
            }
            case "product": {
                this.setColumnValueByProduct();
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String propName = event.getProperty().getName();
        List qFilters = ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().getQFilters();
        switch (propName) {
            case "finaccountf7": 
            case "settleaccount": {
                this.setBankAccountF7Filter(event);
                break;
            }
            case "productfactory": {
                if (!TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"investvarieties")) {
                    event.setCancel(true);
                    return;
                }
                DynamicObject investVarieties = (DynamicObject)this.getModel().getValue("investvarieties");
                qFilters.add(new QFilter("investvarieties", "=", investVarieties.getPkValue()));
                break;
            }
            case "product": {
                DynamicObject finOrg = (DynamicObject)this.getModel().getValue("finorginfo");
                FinSubscribeHelper.setProductFilter((BeforeF7SelectEvent)event, (DynamicObject)finOrg);
                break;
            }
        }
    }

    private void setBankAccountF7Filter(BeforeF7SelectEvent event) {
        long orgId = 0L;
        if ("cim_finscheme".equals(this.getModel().getDataEntity().getDataEntityType().getName())) {
            DynamicObject finapply = (DynamicObject)this.getModel().getValue("finapply");
            if (EmptyUtil.isEmpty((DynamicObject)finapply)) {
                event.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7406\u8d22\u7533\u8bf7\u3002", (String)"FinSchemeInfoEdit_2", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                return;
            }
            orgId = finapply.getLong("org.id");
        } else {
            orgId = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
        }
        List qFilters = ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().getQFilters();
        qFilters.add(TmcAccountHelper.getAccountBankFilterByOrg((Long)orgId));
    }

    private void calcTerm() {
        DynamicObject scheme = this.getModel().getDataEntity();
        Date startDate = scheme.getDate("valuedate");
        Date expireDate = scheme.getDate("expiredate");
        if (EmptyUtil.isNoEmpty((Object)startDate) && EmptyUtil.isNoEmpty((Object)expireDate)) {
            String term = DateUtils.getDiff_ymd((Date)startDate, (Date)expireDate);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", (Object)term);
        }
    }

    private void redeemWayChgEvt() {
        String entityName = this.getModel().getDataEntity().getDynamicObjectType().getName();
        if (StringUtils.equals((CharSequence)entityName, (CharSequence)"cim_finapply") && ((Boolean)this.getModel().getValue("inquiry")).booleanValue()) {
            return;
        }
        String redeemWay = (String)this.getModel().getValue("redeemway");
        String bonusWay = StringUtils.equals((CharSequence)redeemWay, (CharSequence)RedeemWayEnum.amount_redeem.getValue()) ? BonusWayEnum.amount_bonus.getValue() : BonusWayEnum.copies_bonus.getValue();
        this.getModel().setValue("bonusway", (Object)bonusWay);
        if (StringUtils.equals((CharSequence)redeemWay, (CharSequence)RedeemWayEnum.amount_redeem.getValue())) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"buycopies", "iopv"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"planrevenue", "intdate"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"amount"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"buycopies", "iopv"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"intdate"});
            this.getModel().setValue("buycopies", (Object)0);
            this.getModel().setValue("iopv", (Object)0);
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"planrevenue", "intdate"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"buycopies", "iopv"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"intdate"});
            this.getModel().setValue("revenueproject", null);
            this.getModel().setValue("intdate", null);
        }
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"intdate", (Object)this.getModel().getValue("valuedate"));
        }
        this.initRevenueView();
    }

    private boolean checkExpireDate() {
        Date expireDate = (Date)this.getModel().getValue("expiredate");
        Date valueDate = (Date)this.getModel().getValue("valuedate");
        if (EmptyUtil.isNoEmpty((Object)expireDate) && EmptyUtil.isNoEmpty((Object)valueDate) && valueDate.after(expireDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7406\u8d22\u5230\u671f\u65e5\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u7406\u8d22\u5f00\u59cb\u65e5\u3002", (String)"FinApplySchemeBillEdit_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"expiredate", null);
            return false;
        }
        return true;
    }

    private void checkTermIsRight(String oldValue) {
        String term = (String)this.getModel().getValue("term");
        boolean rightFormat = TermHelper.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)term);
        if (!rightFormat) {
            this.getModel().setValue("term", (Object)oldValue);
        }
    }

    private void calExpireDate() {
        DynamicObject scheme = this.getModel().getDataEntity();
        Date startDate = scheme.getDate("valuedate");
        String termStr = scheme.getString("term");
        if (EmptyUtil.isNoEmpty((Object)startDate) && EmptyUtil.isNoEmpty((String)termStr)) {
            Date endDate = TermHelper.getDateByTerm((String)termStr, (Date)startDate);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"expiredate", (Object)endDate);
        }
    }

    private void calByFinAmount() {
        String redeemWay = (String)this.getModel().getValue("redeemway");
        if (RedeemWayEnum.copies_redeem.getValue().equals(redeemWay)) {
            BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
            BigDecimal buyCopies = (BigDecimal)this.getModel().getValue("buycopies");
            BigDecimal iopv = (BigDecimal)this.getModel().getValue("iopv");
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{amount, buyCopies})) {
                iopv = amount.divide(buyCopies, 10, RoundingMode.HALF_UP);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"iopv", (Object)iopv);
            } else if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{amount, iopv})) {
                buyCopies = amount.divide(iopv, 10, RoundingMode.HALF_UP);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buycopies", (Object)buyCopies);
            }
        }
    }

    private void calByFinCopies() {
        String redeemWay = (String)this.getModel().getValue("redeemway");
        if (RedeemWayEnum.copies_redeem.getValue().equals(redeemWay)) {
            BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
            BigDecimal buyCopies = (BigDecimal)this.getModel().getValue("buycopies");
            BigDecimal iopv = (BigDecimal)this.getModel().getValue("iopv");
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{amount, buyCopies})) {
                iopv = amount.divide(buyCopies, 10, RoundingMode.HALF_UP);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"iopv", (Object)iopv);
            } else if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{buyCopies, iopv})) {
                amount = iopv.multiply(buyCopies);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount", (Object)amount);
            }
        }
    }

    private void calByFinIopv() {
        String redeemWay = (String)this.getModel().getValue("redeemway");
        if (RedeemWayEnum.copies_redeem.getValue().equals(redeemWay)) {
            BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
            BigDecimal buyCopies = (BigDecimal)this.getModel().getValue("buycopies");
            BigDecimal iopv = (BigDecimal)this.getModel().getValue("iopv");
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{amount, iopv})) {
                buyCopies = amount.divide(iopv, 10, RoundingMode.HALF_UP);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buycopies", (Object)buyCopies);
            } else if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{buyCopies, iopv})) {
                amount = iopv.multiply(buyCopies);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount", (Object)amount);
            }
        }
    }

    private void expireDateChgEvt() {
        Date intDate;
        if (this.checkExpireDate()) {
            this.calcTerm();
        }
        Date expireDate = (Date)this.getModel().getValue("expiredate");
        if (StringUtils.equals((CharSequence)RedeemWayEnum.amount_redeem.getValue(), (CharSequence)((String)this.getModel().getValue("redeemway"))) && !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{intDate = (Date)this.getModel().getValue("intdate"), expireDate}) && intDate.after(expireDate)) {
            this.getModel().setValue("intdate", this.getModel().getValue("valuedate"));
        }
        this.callPlanAmount();
    }

    private void valueDateChgEvt(Date oldValue) {
        Date intDate;
        Date valueDate = (Date)this.getModel().getValue("valuedate");
        if (EmptyUtil.isEmpty((Object)valueDate)) {
            return;
        }
        Date expireDate = (Date)this.getModel().getValue("expiredate");
        if (EmptyUtil.isNoEmpty((Object)expireDate) && expireDate.before(valueDate)) {
            valueDate = oldValue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7406\u8d22\u5f00\u59cb\u65e5\u4e0d\u80fd\u5927\u4e8e\u7406\u8d22\u5230\u671f\u65e5\u3002", (String)"FinSchemeInfoEdit_3", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"valuedate", (Object)valueDate);
        }
        if (StringUtils.equals((CharSequence)RedeemWayEnum.amount_redeem.getValue(), (CharSequence)((String)this.getModel().getValue("redeemway"))) && (EmptyUtil.isEmpty((Object)(intDate = (Date)this.getModel().getValue("intdate"))) || intDate.before(valueDate))) {
            this.getModel().setValue("intdate", (Object)valueDate);
        }
        this.calcTerm();
        this.callPlanAmount();
    }

    private void initRevenueView() {
        String redeemWay = (String)this.getModel().getValue("redeemway");
        boolean isShow = StringUtils.equals((CharSequence)redeemWay, (CharSequence)RedeemWayEnum.amount_redeem.getValue());
        this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"revenueproject"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isShow, (String[])new String[]{"revenueproject"});
    }

    private void productFactoryChgEvt() {
        this.initRevenueView();
        DynamicObject productFactory = (DynamicObject)this.getModel().getValue("productfactory");
        if (EmptyUtil.isEmpty((DynamicObject)productFactory)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"basis"});
            return;
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"basis"});
        String basis = EmptyUtil.isNoEmpty((String)productFactory.getString("basis")) ? productFactory.getString("basis") : BasisEnum.Actual_360.getValue();
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"basis", (Object)basis);
        String profitType = productFactory.getString("profittype");
        if (!EmptyUtil.isNoEmpty((Object)this.getModel().getProperty("applytype")) || !FinApplyTypeEnum.REDEEM.getValue().equals(this.getModel().getValue("applytype"))) {
            String redeemWay = StringUtils.equals((CharSequence)profitType, (CharSequence)"cash") ? "amount_redeem" : "copies_redeem";
            this.getModel().setValue("redeemway", (Object)redeemWay);
        }
    }

    private void termChgEvt(String oldValue) {
        this.checkTermIsRight(oldValue);
        this.calExpireDate();
        this.callPlanAmount();
    }

    private void finapplyChgEvt() {
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"finaccountf7", (Object)0);
        DynamicObject finapply = (DynamicObject)this.getModel().getValue("finapply");
        if (EmptyUtil.isEmpty((DynamicObject)finapply)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"currency", (Object)0);
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"currency", (Object)finapply.getDynamicObject("currency").getPkValue());
        }
        this.getModel().setValue("finaccountf7", null);
        this.getModel().setValue("settleaccount", null);
    }

    private void callPlanAmount() {
        BigDecimal planAmount = RedeemBillHelper.calPlanAmount((ModelAgent)new ModelAgent((Object)this.getModel()));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"planamount", (Object)planAmount);
    }

    private void intDateChgEvt(Date oldValue) {
        Date expireDate;
        Date intDate = (Date)this.getModel().getValue("intdate");
        if (EmptyUtil.isEmpty((Object)intDate)) {
            return;
        }
        Date valueDate = (Date)this.getModel().getValue("valuedate");
        if (EmptyUtil.isNoEmpty((Object)valueDate) && intDate.before(valueDate)) {
            intDate = oldValue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d77\u606f\u65e5\u4e0d\u80fd\u5c0f\u4e8e\u7406\u8d22\u5f00\u59cb\u65e5\u3002", (String)"FinSchemeInfoEdit_0", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"intdate", (Object)intDate);
        }
        if (EmptyUtil.isNoEmpty((Object)(expireDate = (Date)this.getModel().getValue("expiredate"))) && intDate.after(expireDate)) {
            intDate = oldValue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d77\u606f\u65e5\u4e0d\u80fd\u5927\u4e8e\u7406\u8d22\u5230\u671f\u65e5\u3002", (String)"FinSchemeInfoEdit_4", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"intdate", (Object)intDate);
        }
        this.callPlanAmount();
    }

    private void setColumnValueByProduct() {
        DynamicObject product = (DynamicObject)this.getModel().getValue("product");
        if (EmptyUtil.isEmpty((DynamicObject)product)) {
            this.setColumnEnableWhenProductNull(Arrays.asList("revenuetype", "planrevenue", "floatplanrevenue", "redeemway"));
            return;
        }
        this.getModel().setValue("productno", (Object)product.getString("number"));
        String entityName = this.getModel().getDataEntityType().getName();
        if ("cim_finscheme".equals(entityName)) {
            this.getModel().setValue("name", (Object)product.getString("name"));
        } else {
            this.getModel().setValue("productname", (Object)product.getString("name"));
        }
        this.getModel().setValue("currency", (Object)product.getDynamicObject("currency"));
        this.getModel().setValue("revenuetype", (Object)product.getString("revenuetype"));
        this.setColumnEnableByProduct(product, "revenuetype", "revenuetype");
        this.getModel().setValue("planrevenue", (Object)FinSubscribeHelper.dealPlanRevenue((String)product.getString("planrevenue")));
        this.setColumnEnableByProduct(product, "planrevenue", "planrevenue");
        this.getModel().setValue("floatplanrevenue", (Object)product.getBigDecimal("floatplanrevenue"));
        this.setColumnEnableByProduct(product, "floatplanrevenue", "floatplanrevenue");
        String buyway = product.getString("buyway");
        if (StringUtils.equals((CharSequence)RedeemWayEnum.amount_redeem.getValue(), (CharSequence)buyway) || StringUtils.equals((CharSequence)RedeemWayEnum.copies_redeem.getValue(), (CharSequence)buyway)) {
            this.getModel().setValue("redeemway", (Object)buyway);
        }
        this.setColumnEnableByProduct(product, "buyway", "redeemway");
    }

    private void setColumnEnableWhenProductNull(List<String> feilds) {
        feilds.stream().forEach(r -> this.getView().setEnable(Boolean.TRUE, new String[]{r}));
    }

    private void setColumnEnableByProduct(DynamicObject product, String productField, String applyField) {
        if (EmptyUtil.isEmpty((DynamicObject)product)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{applyField});
            return;
        }
        this.getView().setEnable(Boolean.valueOf(EmptyUtil.isEmpty((Object)product.get(productField))), new String[]{applyField});
    }
}

