/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.supermark;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tmc.cim.bussiness.opservice.ebservice.api.EBServiceFacadeImpl;
import kd.tmc.cim.common.helper.SuperMarketHelper;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.data.EBGetLoginListResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;

public class InterfaceSetPlugin
extends AbstractFormPlugin {
    private static final String INTERFACE = "interface";
    private static final String OP_BTNOK = "btnok";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{OP_BTNOK});
    }

    public void beforeBindData(EventObject e) {
        Map paraMap = this.getView().getFormShowParameter().getCustomParams();
        Object bankCateId = paraMap.get("bankCateId");
        if (EmptyUtil.isNoEmpty(bankCateId)) {
            this.getModel().setValue("bankcate", bankCateId);
            this.setInterfaceColumn((DynamicObject)this.getModel().getValue("bankcate"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String field = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"bankcate", (CharSequence)field)) {
            this.setInterfaceColumn((DynamicObject)this.getModel().getValue("bankcate"));
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)OP_BTNOK, (CharSequence)source.getKey())) {
            Object interfaceCol;
            Object bankCate = this.getModel().getValue("bankcate");
            if (EmptyUtil.isEmpty((Object)bankCate)) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u94f6\u884c\u7c7b\u522b\u201d\u3002", (String)"InterfaceSetPlugin_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((Object)(interfaceCol = this.getModel().getValue(INTERFACE)))) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u94f6\u4f01\u63a5\u53e3\u201d\u3002", (String)"InterfaceSetPlugin_2", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void setInterfaceColumn(DynamicObject bankCate) {
        Map<String, String> bankVersions = this.getBankVersions(bankCate);
        this.setInterfaceColEnum(bankVersions);
        this.setInterfaceValue(bankCate);
    }

    private Map<String, String> getBankVersions(DynamicObject bankCate) {
        if (EmptyUtil.isEmpty((DynamicObject)bankCate)) {
            return null;
        }
        EBGetLoginListResult result = new EBServiceFacadeImpl().queryBankLoginList("cim_interfaceset", bankCate);
        if (EmptyUtil.isNoEmpty((Object)result) && result.getStatusCode() == EBResultStatusCode.SUCCESS) {
            return result.getLoginMap();
        }
        return null;
    }

    private void setInterfaceColEnum(Map<String, String> bankVersions) {
        ComboEdit bankVersion = (ComboEdit)this.getControl(INTERFACE);
        if (bankVersions == null || bankVersions.size() == 0) {
            bankVersion.setComboItems(null);
            return;
        }
        ArrayList<ComboItem> bankVersionItems = new ArrayList<ComboItem>(bankVersions.size());
        for (Map.Entry<String, String> entry : bankVersions.entrySet()) {
            ComboItem item = new ComboItem(new LocaleString(entry.getValue() + "  " + entry.getKey()), entry.getKey());
            bankVersionItems.add(item);
        }
        bankVersion.setComboItems(bankVersionItems);
    }

    private void setInterfaceValue(DynamicObject bankCate) {
        if (EmptyUtil.isEmpty((DynamicObject)bankCate)) {
            return;
        }
        long bankCateId = bankCate.getLong("id");
        String bankLogin = SuperMarketHelper.getBankLoginFromDB((Long)bankCateId);
        this.getModel().setValue(INTERFACE, (Object)bankLogin);
    }
}

