/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.supermark;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.cim.common.enums.SupermarketCardEnum;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuperMarketEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit bankCate = (BasedataEdit)this.getControl("bankcate");
        bankCate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String field = event.getProperty().getName();
        if (StringUtils.equals((CharSequence)"bankcate", (CharSequence)field)) {
            String sourceMethod = event.getSourceMethod();
            if ("getLookUpList".equals(sourceMethod)) {
                event.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6253\u5f00\u5217\u8868\u9009\u62e9\u3002", (String)"SuperMarketEdit_2", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                return;
            }
            if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("bankcate"))) {
                event.setCancel(true);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u94f6\u884c\u7c7b\u522b\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5355\u636e\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"SuperMarketEdit_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("BANK_CATE_CHANGE", (IFormPlugin)this));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (StringUtils.equals((CharSequence)"BANK_CATE_CHANGE", (CharSequence)callBackId) && MessageBoxResult.Yes.equals((Object)event.getResult())) {
            BasedataEdit bankCate = (BasedataEdit)this.getControl("bankcate");
            bankCate.click();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object cardId = this.getModel().getValue("prdcardid");
        if (EmptyUtil.isNoEmpty((Object)cardId)) {
            String bankCateNo = Optional.ofNullable((DynamicObject)this.getModel().getValue("bankcate")).map(r -> r.getString("number")).orElse("");
            SupermarketCardEnum cardEnum = SupermarketCardEnum.getEnumByBankCateNo((String)bankCateNo);
            this.showBankCard(cardEnum.getCardEntity(), cardId, null);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String field;
        switch (field = e.getProperty().getName()) {
            case "bankcate": {
                this.showBankCard();
                break;
            }
            case "currency": {
                this.updateBankCardCurrency();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("save".equals(operateKey)) {
            this.saveBankCard(args);
        }
    }

    private void updateBankCardCurrency() {
        String childPageId = this.getPageCache().get("childPageId");
        if (EmptyUtil.isNoEmpty((String)childPageId)) {
            Object currency = this.getModel().getValue("currency");
            if (EmptyUtil.isEmpty((Object)currency)) {
                return;
            }
            IFormView childView = this.getView().getView(childPageId);
            if (EmptyUtil.isEmpty((Object)childView)) {
                return;
            }
            IDataModel childModel = childView.getModel();
            childModel.setValue("currency", currency);
            String childFormId = childView.getFormShowParameter().getFormId();
            DataEntityPropertyCollection properties = MetadataServiceHelper.getDataEntityType((String)childFormId).getProperties();
            Map<String, Object> childMap = properties.stream().map(r -> r.getName()).filter(r -> r.startsWith("icbc_") || r.startsWith("cmb_") || r.startsWith("abc_")).filter(r -> EmptyUtil.isNoEmpty((Object)childModel.getValue(r))).collect(Collectors.toMap(r -> r, r -> childModel.getValue(r)));
            childMap.put("currency", ((DynamicObject)currency).getPkValue());
            this.showBankCard(childFormId, null, childMap);
        }
    }

    private void showBankCard() {
        DynamicObject bankCate = (DynamicObject)this.getModel().getValue("bankcate");
        if (EmptyUtil.isEmpty((DynamicObject)bankCate)) {
            return;
        }
        String number = bankCate.getString("number");
        SupermarketCardEnum cardEnum = SupermarketCardEnum.getEnumByBankCateNo((String)number);
        if (EmptyUtil.isNoEmpty((Object)cardEnum)) {
            this.showBankCard(cardEnum.getCardEntity(), null, null);
        } else {
            this.showBankCard("", null, null);
        }
    }

    private void saveBankCard(BeforeDoOperationEventArgs args) {
        IFormView childView = this.getView().getView(this.getPageCache().get("childPageId"));
        if (EmptyUtil.isEmpty((Object)childView)) {
            return;
        }
        childView.getModel().setValue("number", this.getModel().getValue("number"));
        childView.getModel().setValue("currency", this.getModel().getValue("currency"));
        OperationResult opResult = childView.invokeOperation("save");
        if (!opResult.isSuccess()) {
            args.setCancel(true);
            List validateErrors = opResult.getValidateResult().getValidateErrors();
            for (ValidateResult validateResult : validateErrors) {
                List allErrorInfo = validateResult.getAllErrorInfo();
                allErrorInfo.stream().forEach(r -> this.getView().showTipNotification(r.getMessage()));
            }
        }
    }

    private void showBankCard(String bankCardEntity, Object cardId, Map<String, Object> paraMap) {
        Container control = (Container)this.getControl("flexpanelap");
        control.deleteControls(new String[]{"flexpanelaptemp"});
        if (EmptyUtil.isEmpty((String)bankCardEntity)) {
            return;
        }
        FlexPanelAp flex = new FlexPanelAp();
        flex.setKey("flexpanelaptemp");
        control.addControls(Collections.singletonList(flex.createControl()));
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId(bankCardEntity);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("flexpanelaptemp");
        if (EmptyUtil.isNoEmpty((Object)cardId)) {
            showParameter.setPkId(cardId);
        }
        showParameter.setStatus(OperationStatus.EDIT);
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            showParameter.setCustomParam("currency", currency.getPkValue());
        }
        if (EmptyUtil.isNoEmpty(paraMap)) {
            showParameter.setCustomParams(paraMap);
        }
        this.getPageCache().put("childPageId", showParameter.getPageId());
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

