/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.supermark;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextProp;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListColumn;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.bussiness.opservice.ebservice.api.EBServiceFacadeImpl;
import kd.tmc.cim.common.enums.SupermarketCardEnum;
import kd.tmc.cim.common.helper.SuperMarketHelper;
import kd.tmc.cim.common.property.SuperMarketProp;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.PageQueryEBResult;

public class SuperMarketList
extends AbstractTmcListPlugin
implements CreateListColumnsListener {
    public void initialize() {
        super.initialize();
        BillList list = (BillList)this.getControl("billlistap");
        list.addCreateListColumnsListener((CreateListColumnsListener)this);
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        CommonFilterColumn filterCol = (CommonFilterColumn)args.getSource();
        if (StringUtils.startsWith((CharSequence)filterCol.getFieldName(), (CharSequence)"bankcate.")) {
            List bankCateList = SuperMarketHelper.getBankCate();
            List signedBankCateIds = Arrays.stream(SupermarketCardEnum.values()).map(r -> r.getBankCateId()).collect(Collectors.toList());
            bankCateList.addAll(signedBankCateIds);
            args.getQFilters().add(new QFilter("id", "in", (Object)bankCateList));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List filterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumns) {
            String fieldName = filterColumn.getFieldName();
            if (!StringUtils.equals((CharSequence)"bankcate.name", (CharSequence)fieldName)) continue;
            List bankCateList = SuperMarketHelper.getBankCate();
            filterColumn.setDefaultValue(EmptyUtil.isNoEmpty((Object)bankCateList) ? bankCateList.get(0).toString() : "0");
            break;
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Object bankCateId;
        String filterName;
        super.filterContainerSearchClick(args);
        Map commonFilter = args.getCurrentCommonFilter();
        if (EmptyUtil.isEmpty((Object)commonFilter) || commonFilter.isEmpty()) {
            return;
        }
        List fieldNames = (List)commonFilter.get("FieldName");
        List values = (List)commonFilter.get("Value");
        if (EmptyUtil.isNoEmpty((Object)fieldNames) && EmptyUtil.isNoEmpty((String)(filterName = (String)fieldNames.get(0))) && filterName.startsWith("bankcate.") && EmptyUtil.isNoEmpty(bankCateId = values.get(0))) {
            String bankCateNo = SuperMarketHelper.getBankCateNo((Long)Long.valueOf(bankCateId.toString()));
            this.getView().getPageCache().put("bankCateId", bankCateNo);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        String bankCateId = this.getView().getPageCache().get("bankCateId");
        if (EmptyUtil.isEmpty((String)bankCateId)) {
            return;
        }
        args.setListDataProvider((IListDataProvider)new SuperMarketListDataProvider());
    }

    public void createListColumns(BeforeCreateListColumnsArgs args) {
        List listColumns = args.getListColumns();
        String bankCateNo = this.getView().getPageCache().get("bankCateId");
        if (EmptyUtil.isNoEmpty((String)bankCateNo)) {
            DataEntityPropertyCollection properties = SuperMarketHelper.getBankCardProperty((String)bankCateNo);
            if (EmptyUtil.isEmpty((Collection)properties)) {
                return;
            }
            for (int i = 0; i < properties.size(); ++i) {
                IDataEntityProperty property = (IDataEntityProperty)properties.get(i);
                ListColumn listColumn = new ListColumn();
                String columnKey = property.getName();
                if (!columnKey.startsWith("icbc_") && !columnKey.startsWith("cmb_")) continue;
                listColumn.setListFieldKey(columnKey);
                listColumn.setKey(columnKey);
                listColumn.setFieldName(columnKey);
                LocaleString displayName = property.getDisplayName();
                listColumn.setCaption(displayName);
                listColumn.setBlankFieldCanOrderAndFilter(true);
                listColumn.setColumnFilter(true);
                listColumn.setColumnOrder(true);
                listColumn.setVisible(1);
                listColumns.add(listColumn);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if (EmptyUtil.isNoEmpty((Object)opResult) && opResult.isSuccess()) {
            switch (operateKey) {
                case "addbuylist": 
                case "removebuylist": {
                    BillList billList = (BillList)this.getControl("billlistap");
                    billList.refresh();
                    break;
                }
                case "gotoapply": {
                    this.showForm("cim_finapply");
                    break;
                }
                case "gotosub": {
                    this.showForm("cim_finsubscribe");
                    break;
                }
                case "onlinequery": {
                    this.showPullProductForm();
                    break;
                }
                case "pagesizeset": {
                    this.showPageInquirySetForm();
                    break;
                }
                case "interfaceset": {
                    this.showBeiInterfaceSetForm();
                    break;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (StringUtils.equals((CharSequence)"CLOSECALL_PULL_PRODUCT", (CharSequence)actionId)) {
            this.pullProductByBei(evt);
        }
    }

    private void pullProductByBei(ClosedCallBackEvent evt) {
        Map returnData = (Map)evt.getReturnData();
        if (EmptyUtil.isEmpty((Object)returnData)) {
            return;
        }
        Integer pageSize = SuperMarketHelper.getPageSizeFromDB();
        returnData.put("pageSize", EmptyUtil.isEmpty((Integer)pageSize) ? SuperMarketProp.CONST_PAGESIZE : pageSize);
        String productNo = (String)returnData.get("productno");
        if (EmptyUtil.isEmpty((String)productNo)) {
            this.pullAllProduct(returnData);
        } else {
            String[] productNoArr;
            for (String prdNum : productNoArr = productNo.split(",")) {
                returnData.put("productno", prdNum);
                returnData.put("pageNum", 1);
                PageQueryEBResult pageQueryEBResult = new EBServiceFacadeImpl().queryBankInfos("cim_supermarket", returnData);
            }
        }
        this.getView().invokeOperation("refresh");
    }

    private void pullAllProduct(Map returnData) {
        int pageNum = 1;
        while (true) {
            boolean isLastPage = true;
            returnData.put("pageNum", pageNum);
            PageQueryEBResult ebResult = new EBServiceFacadeImpl().queryBankInfos("cim_supermarket", returnData);
            if (ebResult != null && ebResult.getStatusCode() == EBResultStatusCode.SUCCESS) {
                isLastPage = ebResult.getLastPage();
            }
            if (isLastPage) break;
            ++pageNum;
        }
    }

    private void showForm(String formId) {
        Long selectedId = this.getSelectedId();
        if (EmptyUtil.isEmpty((Long)selectedId)) {
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setFormId(formId);
        showParameter.setCustomParam("supermarketid", (Object)selectedId);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showPullProductForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("cim_pullproduct");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CLOSECALL_PULL_PRODUCT"));
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows != null && selectedRows.size() > 0) {
            List selectedIdList = selectedRows.stream().map(r -> (Long)r.getPrimaryKeyValue()).collect(Collectors.toList());
            showParameter.setCustomParam("selectIdList", selectedIdList);
        }
        this.getView().showForm(showParameter);
    }

    private void showPageInquirySetForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("cim_pageinquiryset");
        this.getView().showForm(showParameter);
    }

    private void showBeiInterfaceSetForm() {
        Object pkId;
        DynamicObject bankCate;
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("cim_interfaceset");
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows != null && selectedRows.size() > 0 && EmptyUtil.isNoEmpty((DynamicObject)(bankCate = QueryServiceHelper.queryOne((String)"cim_supermarket", (String)"bankcate", (QFilter[])new QFilter[]{new QFilter("id", "=", pkId = selectedRows.get(0).getPrimaryKeyValue())})))) {
            showParameter.setCustomParam("bankCateId", (Object)bankCate.getLong("bankcate"));
        }
        this.getView().showForm(showParameter);
    }

    class SuperMarketListDataProvider
    extends ListDataProvider {
        SuperMarketListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection marketCols = super.getData(start, limit);
            if (EmptyUtil.isEmpty((DynamicObjectCollection)marketCols)) {
                return marketCols;
            }
            String bankCate = SuperMarketList.this.getView().getPageCache().get("bankCateId");
            if (EmptyUtil.isEmpty((String)bankCate)) {
                return marketCols;
            }
            DynamicObjectCollection prdCols = SuperMarketHelper.getPrdCardCollection((String)bankCate);
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)prdCols)) {
                DataEntityPropertyCollection properties = prdCols.getDynamicObjectType().getProperties();
                ArrayList<String> propList = new ArrayList<String>();
                for (int i = 0; i < properties.size(); ++i) {
                    IDataEntityProperty property = (IDataEntityProperty)properties.get(i);
                    String columnKey = property.getName();
                    if (!columnKey.startsWith("icbc_") && !columnKey.startsWith("cmb_")) continue;
                    propList.add(columnKey);
                    Object addProp = property instanceof DateProp ? new DateProp() : (property instanceof DecimalProp ? new DecimalProp() : (property instanceof TextProp ? new TextProp() : new DynamicSimpleProperty()));
                    addProp.setName(columnKey);
                    marketCols.getDynamicObjectType().addProperty((DynamicProperty)addProp);
                }
                for (DynamicObject row : marketCols) {
                    for (String key : propList) {
                        row.set(key, ((DynamicObject)prdCols.get(0)).get(key));
                    }
                }
            }
            return marketCols;
        }

        public void setListFields(List<ListField> listFields) {
            super.setListFields(listFields);
            String bankCateNo = SuperMarketList.this.getView().getPageCache().get("bankCateId");
            if (EmptyUtil.isNoEmpty((String)bankCateNo)) {
                DataEntityPropertyCollection properties = SuperMarketHelper.getBankCardProperty((String)bankCateNo);
                for (int i = 0; i < properties.size(); ++i) {
                    IDataEntityProperty property = (IDataEntityProperty)properties.get(i);
                    String columnKey = property.getName();
                    if (!columnKey.startsWith("icbc_") && !columnKey.startsWith("cmb_")) continue;
                    ListField listField = new ListField();
                    listField.setListFieldKey(columnKey);
                    listField.setFieldName(columnKey);
                    listField.setKey(columnKey);
                    listField.setFieldProp(property);
                    listFields.add(listField);
                }
            }
        }
    }
}

