/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.report.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.report.helper.BalanceReportHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import org.apache.commons.lang3.tuple.Pair;

public class BalanceReportDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final String[] AMTSUM_FIELDS = new String[]{"accfinamount", "accsurplusamount", "accredamount", "accbuycopies", "accsurpluscopies", "accredcopies", "accplanamount", "accrealamount"};
    private static final String[] AMTOTAL_FIELDS = new String[]{"accfinamount", "accamount", "accsurplusamount", "accredamount", "accbuycopies", "accsurpluscopies", "accredcopies", "accplanamount", "accrealamount"};
    private static final String[] BASE_FIELDS = new String[]{"acccurrencyname", "accamount", "accfinamount", "accsurplusamount", "accredamount", "accbuycopies", "accsurpluscopies", "accredcopies", "accplanamount", "accrealamount"};
    private static final String DETAILSFIELDS = "id,finaccount,finaccountf7.id as finaccountid,currency,currency.name currname,finorginfo,case when finorginfo.bank_cate.name is null then finorginfo.name else finorginfo.bank_cate.name end as finorginfomain,org,org.name orgname,investvarieties,investvarieties.name investname,productno,productname,billno as finsubscribeno,amount,amount as bizamount,surplusamount,buycopies,iopv,surpluscopies,purchasedate,redeemway,futureamount as accplanamount";
    private static final String DETAILSFIELDS_RATE = "id,finaccount,finaccountid,currency,currname,finorginfo,org,orgname,investvarieties,productno,productname,finsubscribeno,amount,bizamount,surplusamount,buycopies,iopv,surpluscopies,purchasedate,finorginfomain,investname,redeemway,accplanamount";
    private static final String LAST_SELECTfIELD = "acccurrency,accamount,acccurrencyname,accfinamount,accsurplusamount,accredamount,accbuycopies,accsurpluscopies,accredcopies,accplanamount,accrealamount,finorginfo,org,currency,investvarieties,productno,productname,finsubscribeno,amount,bizamount,surplusamount,buycopies,iopv,surpluscopies,purchasedate,totalamount,totalcopies,avgiopv,totalplanamount,realamount,redeemway,sumlevel";
    private Map<String, Object> params;
    private Pair<String[], String> allTotalByStatDim;
    private String statDim;
    private String unit;
    private String orderStr;
    private boolean isShowDetail;
    private QFilter filter;
    private DataSet redeemSet;
    private DataSet revenueSet;

    public DataSet queryDataSet(ReportQueryParam param) {
        this.initParams(param);
        DataSet finsubDateSet = BalanceReportDataListPlugin.getFinsubDateSet(param, this.filter);
        this.redeemSet = BalanceReportDataListPlugin.getRedeemSetByfin(finsubDateSet.copy(), this.params);
        DataSet revenSet = BalanceReportDataListPlugin.getRevenSet(finsubDateSet.copy());
        DataSet planAmtSet = revenSet.copy().groupBy(new String[]{"finbillno"}).sum("totalplanamount").finish().select(new String[]{"finbillno", "totalplanamount as planamt"});
        finsubDateSet = finsubDateSet.leftJoin(planAmtSet).on("id", "finbillno").select(finsubDateSet.getRowMeta().getFieldNames(), new String[]{"planamt"}).finish().updateField("accplanamount", "accplanamount+planamt");
        this.revenueSet = BalanceReportDataListPlugin.getRevenueSet(finsubDateSet.copy(), this.redeemSet.copy(), revenSet.copy(), this.params);
        finsubDateSet = BalanceReportDataListPlugin.getTotalPlanRev(finsubDateSet.copy(), this.redeemSet.copy(), this.revenueSet.copy());
        String[] statDimGroup = BalanceReportHelper.getStatDim(param);
        DataSet groupDataSet = BalanceReportHelper.groupByAndSum(finsubDateSet, statDimGroup, AMTSUM_FIELDS, new String[0]);
        DataSet finaccountAmt = this.getFinaccountAmt(groupDataSet.copy(), this.statDim);
        DataSet baseDateSet = null;
        baseDateSet = groupDataSet.copy();
        String selFields = String.join((CharSequence)",", BASE_FIELDS) + ",acccurrency";
        if (!"currency".equals(this.statDim) && !"finaccount".equals(this.statDim)) {
            selFields = selFields + ",finaccount,finaccountid," + this.orderStr;
        }
        if ("finaccount".equals(this.statDim)) {
            selFields = selFields + ",finaccountid," + this.orderStr;
        }
        String joinStr = "finaccountid";
        if ("currency".equals(this.statDim)) {
            joinStr = "acccurrency";
        }
        baseDateSet = baseDateSet.join(finaccountAmt, JoinType.LEFT).on(joinStr, joinStr).on("acccurrency", "acccurrency").select(selFields.split(",")).finish();
        return baseDateSet;
    }

    private void initParams(ReportQueryParam param) {
        this.params = this.transQueryParam(param);
        this.allTotalByStatDim = BalanceReportHelper.getAllTotalByStatDim(param);
        this.statDim = (String)param.getCustomParam().get("filter_statdim");
        this.unit = (String)param.getCustomParam().get("filter_currencyunit");
        this.orderStr = "finorginfomain";
        if ("finaccount".equals(this.statDim)) {
            this.orderStr = "finaccount";
        } else if ("currency".equals(this.statDim)) {
            this.orderStr = "acccurrency";
        }
        this.isShowDetail = (Boolean)param.getCustomParam().get("filter_isshowdetail");
        this.filter = BalanceReportHelper.initBalanceQfilter(this.params, this.getQueryOrgIds(param));
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        if (dataSet == null || dataSet.isEmpty()) {
            return dataSet;
        }
        Long accCurrency = (Long)((DynamicObject)this.params.get("filter_currency")).getPkValue();
        dataSet = dataSet.updateField("acccurrency", "case when sumlevel!=0 then " + accCurrency + " else acccurrency end");
        if (this.isShowDetail) {
            DataSet finsubDateSetDetails = QueryServiceHelper.queryDataSet((String)"BalanceReportDataListPlugindetail", (String)"cim_finsubscribe", (String)DETAILSFIELDS, (QFilter[])new QFilter[]{this.filter}, (String)"purchasedate");
            if (finsubDateSetDetails.isEmpty()) {
                return dataSet;
            }
            dataSet = dataSet.addField("case when sumlevel!=2 then 0 else 1 end", "totallevel");
            DataSet redeemAmtSet = BalanceReportDataListPlugin.getRedeemSet(finsubDateSetDetails, this.redeemSet, this.revenueSet, this.params);
            DataSet finsubAndRedeem = finsubDateSetDetails.join(redeemAmtSet, JoinType.LEFT).on("id", "id").select("id,finaccount,finaccountid,currency,currname,finorginfo,org,orgname,investvarieties,productno,productname,finsubscribeno,amount,bizamount,surplusamount,buycopies,iopv,surpluscopies,purchasedate,finorginfomain,investname,redeemway,accplanamount,totalplanamount,totalamount,totalcopies,avgiopv,realamount".split(",")).finish().updateField("totalamount", "case when totalamount = null then 0 else totalamount end").updateField("totalcopies", "case when totalcopies = null then 0 else totalcopies end").updateField("surplusamount", "case when redeemway ='copies_redeem' then 0 else amount-totalamount end").updateField("totalamount", "case when redeemway ='copies_redeem' then totalcopies*avgiopv else totalamount end").updateField("surpluscopies", "buycopies-totalcopies");
            DataSet detailSet = this.converAmtByUnitRate(finsubAndRedeem, this.unit).removeFields(new String[]{"accplanamount"});
            String groupField = LAST_SELECTfIELD;
            if (((Boolean)this.params.get("filter_isshowtotal")).booleanValue()) {
                groupField = groupField + ",totallevel";
            }
            if (!"currency".equals(this.statDim) && !"finaccount".equals(this.statDim)) {
                groupField = groupField + ",finorginfomain,finaccount,finaccountid";
            }
            if ("finaccount".equals(this.statDim)) {
                groupField = groupField + ",finaccount,finaccountid";
            }
            if ("currency".equals(this.statDim)) {
                dataSet = dataSet.join(detailSet, JoinType.LEFT).on("acccurrencyname", "currname").select(groupField.split(",")).finish();
            } else if ("finaccount".equals(this.statDim)) {
                dataSet = dataSet.join(detailSet, JoinType.LEFT).on("finaccountid", "finaccountid").on("acccurrency", "currency").select(groupField.split(",")).finish();
            } else {
                String joinName = "finorginfomain";
                if ("org".equals(this.statDim)) {
                    joinName = "orgname";
                } else if ("investvarieties".equals(this.statDim)) {
                    joinName = "investname";
                }
                dataSet = dataSet.join(detailSet, JoinType.LEFT).on("finorginfomain", joinName).on("finaccountid", "finaccountid").on("acccurrency", "currency").select(groupField.split(",")).finish();
            }
            String[] orders = new String[]{this.orderStr, "sumlevel"};
            if (((Boolean)this.params.get("filter_isshowtotal")).booleanValue()) {
                orders = new String[]{"totallevel", this.orderStr, "sumlevel"};
            }
            dataSet = dataSet.orderBy(orders);
        }
        return dataSet;
    }

    protected boolean isNeedDimCurrency() {
        return false;
    }

    protected List<String> orinalAmountField() {
        return Arrays.asList("accamount", "accfinamount", "accsurplusamount", "accredamount", "accplanamount", "accrealamount");
    }

    public String subNameField() {
        return (String)this.allTotalByStatDim.getRight();
    }

    public String sumNameField() {
        String totalField = ((String[])this.allTotalByStatDim.getLeft())[0];
        if ("currency".equals(this.statDim)) {
            totalField = "acccurrencyname";
        }
        return totalField;
    }

    public List<String> groupFields() {
        return new ArrayList<Object>(Arrays.asList((Object[])this.allTotalByStatDim.getLeft()));
    }

    public List<String> sumAmountFields() {
        return Arrays.asList(AMTOTAL_FIELDS);
    }

    private static List<Long> getFinSubscribeIds(DataSet finSubscribeDS) {
        DataSet fsDS = finSubscribeDS.copy();
        ArrayList<Long> ids = new ArrayList<Long>(16);
        for (Row row : fsDS) {
            ids.add(row.getLong("id"));
        }
        return ids;
    }

    private static DataSet getTotalPlanRev(DataSet finsubDateSetDetails, DataSet redeemSet, DataSet revSet) {
        DataSet finsubAndRedeem = finsubDateSetDetails.join(redeemSet, JoinType.LEFT).on("id", "finbillno").select("id,finbillno,redeemway,realrevenue,iopv,totalamount,totalcopies,avgiopv".split(",")).finish();
        DataSet finsubAndRedeemAndRevAmt = finsubAndRedeem.copy().filter("redeemway='amount_redeem'").addField("totalamount", "revamount").addField("totalcopies", "totalcopies").groupBy(new String[]{"finbillno"}).sum("revamount").sum("totalcopies").finish().select(new String[]{"finbillno", "revamount", "totalcopies"});
        DataSet finsubAndRedeemAndRevCop = finsubAndRedeem.copy().filter("redeemway='copies_redeem'").addField("totalamount", "revamount").addField("totalcopies", "totalcopies").groupBy(new String[]{"finbillno"}).sum("revamount").sum("totalcopies").finish().select(new String[]{"finbillno", "revamount", "totalcopies"});
        DataSet redeemRec = finsubAndRedeemAndRevAmt.union(finsubAndRedeemAndRevCop);
        DataSet revenueGroups = BalanceReportHelper.groupByAndSum(revSet, new String[]{"finbillno"}, new String[]{"realamount", "totalplanamount"}, new String[0]);
        DataSet finsubAndRedeemAndRev = redeemRec.leftJoin(revenueGroups).on("finbillno", "finbillno").select(new String[]{"finbillno", "realamount", "revamount", "totalcopies", "totalplanamount"}).finish();
        String[] fieldNames = finsubDateSetDetails.getRowMeta().getFieldNames();
        DataSet details = finsubDateSetDetails.leftJoin(finsubAndRedeemAndRev).on("id", "finbillno").select(fieldNames, new String[]{"realamount", "revamount", "totalcopies", "totalplanamount"}).finish();
        details = details.updateField("accredamount", "revamount").updateField("realamount", "case when realamount = null then 0 else realamount end").updateField("revamount", "case when revamount = null then 0 else revamount end").updateField("totalcopies", "case when totalcopies = null then 0 else totalcopies end").updateField("accsurplusamount", "accfinamount-revamount").updateField("accredcopies", "totalcopies").updateField("accsurpluscopies", "accbuycopies-totalcopies").updateField("accplanamount", "case when redeemway='copies_redeem' then realamount else accplanamount end").updateField("accrealamount", "realamount");
        return details;
    }

    private static DataSet getRedeemSetByfin(DataSet finsubDateSetDetails, Map<String, Object> params) {
        List<Long> finSubscribeIds = BalanceReportDataListPlugin.getFinSubscribeIds(finsubDateSetDetails.copy());
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and(new QFilter("finbillno.id", "in", finSubscribeIds));
        Pair<Date, Date> dateSearchRanges = BalanceReportHelper.getDateSearchRanges("fredranges", params);
        if (dateSearchRanges != null && dateSearchRanges.getRight() != null) {
            filter.and(new QFilter("expiredate", "<", (Object)DateUtils.getNextDay((Date)((Date)dateSearchRanges.getRight()), (int)1)));
        }
        DataSet redeemSet = QueryServiceHelper.queryDataSet((String)"BalanceReportDataListPlugindetailGetRedeemSet", (String)"cim_redeem", (String)"finbillno,expiredate,redeemway,amount as totalamount,copies as totalcopies,iopv as avgiopv,realrevenue", (QFilter[])new QFilter[]{filter}, null);
        return redeemSet;
    }

    private static DataSet getRedeemSet(DataSet finsubDateSetDetails, DataSet redeemSet, DataSet revSet, Map<String, Object> params) {
        Pair<Date, Date> dateSearchRev;
        Pair<Date, Date> dateSearchRed = BalanceReportHelper.getDateSearchRanges("fredranges", params);
        if (dateSearchRed != null && dateSearchRed.getLeft() != null) {
            redeemSet = redeemSet.filter("to_char(expiredate, 'yyyyMMdd')>" + DateUtils.formatString((Date)DateUtils.getLastDay((Date)((Date)dateSearchRed.getLeft()), (int)1), (String)"yyyyMMdd"));
        }
        if ((dateSearchRev = BalanceReportHelper.getDateSearchRanges("frevranges", params)) != null && dateSearchRev.getLeft() != null) {
            revSet = revSet.filter("to_char(expiredate, 'yyyyMMdd')>" + DateUtils.formatString((Date)DateUtils.getLastDay((Date)((Date)dateSearchRev.getLeft()), (int)1), (String)"yyyyMMdd"));
        }
        DataSet finsubAndRedeem = finsubDateSetDetails.copy().join(redeemSet, JoinType.LEFT).on("id", "finbillno").select("id,finbillno,redeemway,iopv,totalamount,totalcopies,avgiopv".split(",")).finish();
        DataSet revenueGroups = BalanceReportHelper.groupByAndSum(revSet, new String[]{"finbillno"}, new String[]{"realamount", "totalplanamount"}, new String[0]);
        DataSet redeemGroups = BalanceReportHelper.groupByAndSum(finsubAndRedeem, new String[]{"id"}, new String[]{"iopv", "totalamount", "totalcopies", "avgiopv"}, new String[]{"avgiopv"});
        DataSet finsubAndRedeemAndRev = redeemGroups.join(revenueGroups, JoinType.LEFT).on("id", "finbillno").select("id,iopv,totalamount,totalcopies,avgiopv,totalplanamount,realamount".split(",")).finish();
        return finsubAndRedeemAndRev;
    }

    private static DataSet getRevenueSet(DataSet finsubDateSetDetails, DataSet redeemSet, DataSet revenSet, Map<String, Object> params) {
        redeemSet = redeemSet.filter("redeemway='copies_redeem'");
        Pair<Date, Date> dateSearchRanges = BalanceReportHelper.getDateSearchRanges("frevranges", params);
        if (dateSearchRanges != null && dateSearchRanges.getRight() != null) {
            redeemSet = redeemSet.filter("to_char(expiredate, 'yyyyMMdd')<" + DateUtils.formatString((Date)DateUtils.getNextDay((Date)((Date)dateSearchRanges.getRight()), (int)1), (String)"yyyyMMdd"));
            revenSet = revenSet.filter("to_char(expiredate, 'yyyyMMdd')<" + DateUtils.formatString((Date)DateUtils.getNextDay((Date)((Date)dateSearchRanges.getRight()), (int)1), (String)"yyyyMMdd"));
        }
        DataSet reveCop = finsubDateSetDetails.filter("redeemway='copies_redeem'").leftJoin(redeemSet).on("id", "finbillno").select(new String[]{"finbillno", "expiredate", "totalcopies", "avgiopv", "iopv"}).finish().addField("totalcopies*(avgiopv-iopv)", "realamount").addField("totalcopies*(avgiopv-iopv)", "totalplanamount").select("finbillno,expiredate,realamount,totalplanamount");
        return revenSet.union(reveCop);
    }

    private static DataSet getRevenSet(DataSet finsubDateSetDetails) {
        List<Long> finSubscribeIds = BalanceReportDataListPlugin.getFinSubscribeIds(finsubDateSetDetails.copy());
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and(new QFilter("finbillno.id", "in", finSubscribeIds));
        DataSet revenueSet = QueryServiceHelper.queryDataSet((String)"BalanceReportDataListPlugindetailGetRedeemSet", (String)"cim_revenue", (String)"finbillno,expiredate,amount as realamount,revenueamount as totalplanamount", (QFilter[])new QFilter[]{filter}, null);
        return revenueSet;
    }

    private DataSet converAmtByUnitRate(DataSet detail, String currencyUnit) {
        return detail.updateField("amount", String.format("amount/%s", currencyUnit)).updateField("surplusamount", String.format("surplusamount/%s", currencyUnit)).updateField("totalamount", String.format("totalamount/%s", currencyUnit)).updateField("totalplanamount", String.format("totalplanamount/%s", currencyUnit)).updateField("iopv", String.format("iopv/%s", currencyUnit)).updateField("avgiopv", String.format("avgiopv/%s", currencyUnit)).updateField("realamount", String.format("realamount/%s", currencyUnit));
    }

    private static DataSet getFinsubDateSet(ReportQueryParam param, QFilter filter) {
        Pair<String, String> selectFieldAndOrder = BalanceReportHelper.getSelectFieldAndOrder(param);
        DataSet finsubDateSet = QueryServiceHelper.queryDataSet((String)"BalanceReportDataListPlugin", (String)"cim_finsubscribe", (String)((String)selectFieldAndOrder.getLeft() + "id,finaccount,redeemway,iopv,finaccountf7 as finaccountid,currency as acccurrency,currency.name as acccurrencyname,amount as accfinamount,surplusamount as accsurplusamount, redeemamount as accredamount, buycopies as accbuycopies,surpluscopies as accsurpluscopies,redeemcopies as accredcopies,futureamount as accplanamount,totalamount as accrealamount"), (QFilter[])new QFilter[]{filter}, (String)((String)selectFieldAndOrder.getRight()));
        return finsubDateSet;
    }

    protected DataSet getFinaccountAmt(DataSet sourceDataSet, String statDim) {
        ArrayList<Field> fields = new ArrayList<Field>();
        String field = "currency".equals(statDim) ? "acccurrency" : "finaccountid";
        fields.add(new Field(field, (DataType)DataType.LongType));
        fields.add(new Field("acccurrency", (DataType)DataType.LongType));
        fields.add(new Field("accamount", (DataType)DataType.BigDecimalType));
        RowMeta rowMeta = new RowMeta(fields.toArray(new Field[0]));
        Algo algo = Algo.create((String)"");
        DataSetBuilder dsBuilder = algo.createDataSetBuilder(rowMeta);
        Iterator it = sourceDataSet.copy().iterator();
        HashMap<String, BigDecimal> balanceMap = new HashMap<String, BigDecimal>(16);
        while (it.hasNext()) {
            Row data = (Row)it.next();
            Object finAccountId = data.get(field);
            Object currencyId = data.get("acccurrency");
            String key = String.valueOf(finAccountId) + currencyId;
            BigDecimal amount = BigDecimal.ZERO;
            if (balanceMap.containsKey(key)) continue;
            amount = BalanceReportHelper.getBankAccoutBalance(finAccountId, currencyId);
            balanceMap.put(key, amount);
            Object[] rows = new Object[]{(Long)finAccountId, (Long)currencyId, amount};
            dsBuilder.append(rows);
        }
        return dsBuilder.build();
    }
}

