/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.report.helper.ReportHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;

public class RevDetailReportDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final String FINSUBSCRIBE_HEAD_PROPS = "id as finid, case when finorginfo.bank_cate.name is null then finorginfo.name else finorginfo.bank_cate.name end as finorginfomain,finorginfo.name as finorgname,org.id as orgid, org.name as orgname, finaccount,investvarieties.name as investvarietyname, currency.id as currencyid, currency.name as currencyname, productno,productname, billno as finsubscribeno,amount,surplusamount,buycopies,iopv,surpluscopies,purchasedate,expiredate,term,creator,redeemway";
    private static final String REDEEM_PROPS = "'redeem' as revsrctype, id, finbillno.id as finbillid, '' as basis, '' as revenuetype, null as revenuedays,  expiredate as revexpiredate, copies as  revcopies, iopv as reviopv ";
    private static final String REVENUE_RPOPS = "'rev' as revsrctype, id, finbillno.id as finbillid, basis, revenuetype, revenuedays, expiredate as revexpiredate, copies as revcopies, iopv as reviopv, revenueamount as planamount, amount as realamount";
    private static final String REPORT_COLUM_SHENGOU_PROPS = "finid,finorginfomain,finorgname,orgid, orgname, finaccount,investvarietyname,currencyid, currencyname, productno,productname, finsubscribeno,amount,surplusamount,buycopies,iopv,surpluscopies,purchasedate,expiredate,term,creator,redeemway";
    private static final String REPORT_COLUM_REV_PROPS = "revsrctype, id, basis, revenuetype, revenuedays, revexpiredate, revcopies, reviopv, planamount, realamount";
    private static final String REPORT_COLUM_REDEAM_REV_PROPS = "revsrctype, id, basis, revenuetype, revenuedays, revexpiredate, revcopies, reviopv, (reviopv-iopv)*revcopies as planamount, (reviopv-iopv)*revcopies as realamount";
    private static final String[] ORDERBY_DIM_FINORG = new String[]{"finorginfomain", "sumlevel", "finorgname", "orgname"};
    private static final String[] ORDERBY_DIM_ORG = new String[]{"orgname", "sumlevel", "finorginfomain", "finorgname"};
    private static final String[] ORDERBY_DIM_INVESTVARIETIE = new String[]{"investvarietyname", "sumlevel", "finorginfomain", "finorgname", "orgname"};
    private static final String[] ORDERBY_DIM_FINACCT = new String[]{"finaccount", "sumlevel", "finorginfomain", "finorgname", "orgname"};
    private static final String[] ORDERBY_DIM_CURRENCY = new String[]{"currencyname", "sumlevel", "finorginfomain", "finorgname", "orgname"};
    private String statDim;

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        paramMap.remove("filter_currency");
        QFilter finSubFilter = ReportHelper.initReportFilter(paramMap, this.getQueryOrgIds(queryParam));
        this.statDim = (String)paramMap.get("filter_statdim");
        DataSet finSubscribeDS = QueryServiceHelper.queryDataSet((String)"finsubscribe", (String)"cim_finsubscribe", (String)FINSUBSCRIBE_HEAD_PROPS, (QFilter[])finSubFilter.toArray(), null);
        if (finSubscribeDS.isEmpty()) {
            return this.createEmptyDS();
        }
        List<Long> fsRevIds = this.getFinSubscribeIds(finSubscribeDS, "amount_redeem");
        QFilter revQF = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        revQF.and(new QFilter("finbillno.id", "in", fsRevIds));
        String revexpireRanges = (String)paramMap.get("frevranges");
        ReportHelper.buildDateSearchRanges(revQF, "frevranges", revexpireRanges, "expiredate", paramMap);
        DataSet revenueDS = QueryServiceHelper.queryDataSet((String)"finsubscribe", (String)"cim_revenue", (String)REVENUE_RPOPS, (QFilter[])revQF.toArray(), null);
        fsRevIds = this.getFinSubscribeIds(finSubscribeDS, "copies_redeem");
        QFilter revRedeemQF = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        revQF.and(new QFilter("finbillno.id", "in", fsRevIds));
        ReportHelper.buildDateSearchRanges(revRedeemQF, "frevranges", revexpireRanges, "expiredate", paramMap);
        DataSet revRedeemDS = QueryServiceHelper.queryDataSet((String)"finsubscribe", (String)"cim_redeem", (String)REDEEM_PROPS, (QFilter[])revRedeemQF.toArray(), null);
        DataSet amountJoinedDS = finSubscribeDS.filter("redeemway='amount_redeem'").join(revenueDS).on("finid", "finbillid").select(REPORT_COLUM_SHENGOU_PROPS.split(","), REPORT_COLUM_REV_PROPS.split(",")).finish();
        DataSet copiesJoinedDS = finSubscribeDS.filter("redeemway='copies_redeem'").join(revRedeemDS).on("finid", "finbillid").select(REPORT_COLUM_SHENGOU_PROPS.split(","), REPORT_COLUM_REDEAM_REV_PROPS.split(",")).finish();
        return amountJoinedDS.union(copiesJoinedDS);
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        if (dataSet.isEmpty()) {
            return dataSet;
        }
        String lvalue = ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"DepositSumRptDataListPlugin_1", (String)"tmc-cim-report", (Object[])new Object[0]);
        dataSet = dataSet.addFields(new String[]{"case when sumlevel = 0 then '" + lvalue + "' else '' end as detail", "rate"}, new String[]{"opercol", "exchrate"});
        dataSet = dataSet.updateFields(new String[]{"amount", "surplusamount", "iopv", "planamount", "realamount", "reviopv"}, new String[]{"amount_report", "surplusamount_report", "iopv_report", "planamount_report", "realamount_report", "reviopv_report"});
        return dataSet;
    }

    protected DataSet addSubRowDataSet(DataSet bizDs, Map<String, Object> paramMap) {
        Boolean isShowSubTotal = (Boolean)paramMap.get("filter_isshowsubtotal");
        if (isShowSubTotal.booleanValue()) {
            String subNameField = this.subNameField();
            List<String> groupFields = this.groupFields();
            ArrayList<String> sumFields = new ArrayList<String>(5);
            sumFields.add("planamount_report");
            sumFields.add("realamount_report");
            DataSet subTotalDS = this.addSubTotalDataSet(bizDs.copy().filter("pid = '0'"), groupFields, sumFields, subNameField, this.subDisplayName());
            List<String> fieldNames = this.getFieldNamesFromRowMeta(bizDs.getRowMeta());
            String joinField = this.getJoinFieldByDim(this.statDim);
            DataSet finsubDS = bizDs.copy().select("finid,amount,amount_report,surplusamount,surplusamount_report, statcurrency, sumlevel, '' as hej," + joinField).distinct();
            ArrayList<String> finsubSumFields = new ArrayList<String>(5);
            finsubSumFields.add("amount_report");
            finsubSumFields.add("surplusamount_report");
            DataSet finsubSubTotalDS = this.addSubTotalDataSet(finsubDS, groupFields, finsubSumFields, "hej");
            subTotalDS = subTotalDS.removeFields(new String[]{"amount_report", "surplusamount_report"});
            subTotalDS = subTotalDS.join(finsubSubTotalDS).on(joinField, joinField).on("sumlevel", "sumlevel").select(fieldNames.toArray(new String[0])).finish().updateFields(new String[]{"rowid", "pid"}, new String[]{"cast(rowid as String)", "cast(pid as String)"}).updateFields(new String[]{"rowid", "pid", "isgroupnode"}, new String[]{this.uniqueRow, "'0'", "'0'"});
            bizDs = bizDs.union(subTotalDS).orderBy(this.orderByFields().toArray(new String[0]));
        } else {
            bizDs = bizDs.orderBy(this.orderByFields().toArray(new String[0]));
        }
        return bizDs;
    }

    protected DataSet addSumRowDataSet(DataSet bizDs, Map<String, Object> paramMap) {
        Boolean isShowTotal = (Boolean)paramMap.get("filter_isshowtotal");
        if (isShowTotal.booleanValue()) {
            DataSet ds = bizDs.copy();
            String sumNameField = this.getTotalFieldByDim(this.statDim);
            ArrayList<String> sumFields = new ArrayList<String>(5);
            sumFields.add("planamount_report");
            sumFields.add("realamount_report");
            DataSet totalDS = this.addAllTotalDataSet(ds.filter("level=1"), sumFields, sumNameField).updateFields(new String[]{"rowid", "pid", "isgroupnode"}, new String[]{this.uniqueRow + "+" + sumNameField, "0", "'0'"});
            List<String> fieldNames = this.getFieldNamesFromRowMeta(ds.getRowMeta());
            String joinField = this.getJoinFieldByDim(this.statDim);
            DataSet finsubDS = ds.select("finid,amount,amount_report,surplusamount,surplusamount_report, statcurrency, sumlevel, '' as hej," + joinField).distinct();
            ArrayList<String> finsubSumFields = new ArrayList<String>(5);
            finsubSumFields.add("amount_report");
            finsubSumFields.add("surplusamount_report");
            DataSet finsubTotalDS = this.addAllTotalDataSet(finsubDS, finsubSumFields, sumNameField);
            totalDS = totalDS.removeFields(new String[]{"amount_report", "surplusamount_report"});
            totalDS = totalDS.join(finsubTotalDS).on("sumlevel", "sumlevel").select(fieldNames.toArray(new String[0])).finish();
            bizDs = ds.union(totalDS.updateFields(new String[]{"rowid", "pid"}, new String[]{"cast(rowid as String)", "cast(pid as String)"}));
        }
        return bizDs;
    }

    protected List<String> orinalAmountField() {
        return Arrays.asList("amount", "surplusamount", "planamount", "realamount", "iopv", "reviopv");
    }

    protected String getCurrencyField() {
        return "currencyid";
    }

    public String subNameField() {
        return this.getSumFieldNameByDim(this.statDim);
    }

    public String sumNameField() {
        return this.getTotalFieldByDim(this.statDim);
    }

    public List<String> groupFields() {
        return this.getGroupFieldsByDim(this.statDim);
    }

    public List<String> sumAmountFields() {
        ArrayList<String> sumFields = new ArrayList<String>(5);
        sumFields.add("planamount");
        sumFields.add("realamount");
        sumFields.add("amount");
        sumFields.add("surplusamount");
        return sumFields;
    }

    public List<String> orderByFields() {
        return Arrays.asList(this.getOrderbyByDim(this.statDim));
    }

    private List<String> getGroupFieldsByDim(String statdim) {
        ArrayList<String> groupFields = new ArrayList<String>(3);
        switch (statdim) {
            case "finorginfo": {
                groupFields.add("finorginfomain");
                break;
            }
            case "org": {
                groupFields.add("orgname");
                break;
            }
            case "investvarieties": {
                groupFields.add("investvarietyname");
                break;
            }
            case "finaccount": {
                groupFields.add("finaccount");
                break;
            }
            case "currency": {
                groupFields.add("currencyname");
                break;
            }
            default: {
                groupFields.add("finorginfomain");
            }
        }
        groupFields.add("statcurrency");
        return groupFields;
    }

    private String getSumFieldNameByDim(String statdim) {
        if ("finorginfo".equals(statdim)) {
            return "finorgname";
        }
        return "finorginfomain";
    }

    private String[] getOrderbyByDim(String statdim) {
        String[] ret = ORDERBY_DIM_FINORG;
        switch (statdim) {
            case "org": {
                ret = ORDERBY_DIM_ORG;
                break;
            }
            case "investvarieties": {
                ret = ORDERBY_DIM_INVESTVARIETIE;
                break;
            }
            case "finaccount": {
                ret = ORDERBY_DIM_FINACCT;
                break;
            }
            case "currency": {
                ret = ORDERBY_DIM_CURRENCY;
                break;
            }
        }
        return ret;
    }

    private String getTotalFieldByDim(String statdim) {
        String field = "finorginfomain";
        switch (statdim) {
            case "finorginfo": {
                field = "finorginfomain";
                break;
            }
            case "org": {
                field = "orgname";
                break;
            }
            case "investvarieties": {
                field = "investvarietyname";
                break;
            }
            case "finaccount": {
                field = "finaccount";
                break;
            }
            case "currency": {
                field = "currencyname";
                break;
            }
        }
        return field;
    }

    private String getJoinFieldByDim(String statdim) {
        String field = "finorginfomain";
        switch (statdim) {
            case "finorginfo": {
                field = "finorginfomain";
                break;
            }
            case "org": {
                field = "orgname";
                break;
            }
            case "investvarieties": {
                field = "investvarietyname";
                break;
            }
            case "finaccount": {
                field = "finaccount";
                break;
            }
            case "currency": {
                field = "currencyname";
                break;
            }
        }
        return field;
    }

    private List<String> getFieldNamesFromRowMeta(RowMeta rowMeta) {
        Field[] fields = rowMeta.getFields();
        ArrayList<String> fieldNames = new ArrayList<String>(fields.length);
        for (Field f : fields) {
            fieldNames.add(f.getName());
        }
        return fieldNames;
    }

    private DataSet createEmptyDS() {
        RowMeta rowMeta = new RowMeta(new String[]{"empty"}, new DataType[]{DataType.StringType});
        DataSet emptyDataSet = Algo.create((String)"EmptyDataSet").createDataSetBuilder(rowMeta).build();
        return emptyDataSet;
    }

    private List<Long> getFinSubscribeIds(DataSet finSubscribeDS, String redeemway) {
        DataSet fsDS = finSubscribeDS.copy();
        ArrayList<Long> ids = new ArrayList<Long>(10);
        for (Row row : fsDS) {
            if (!redeemway.equals(row.getString("redeemway"))) continue;
            ids.add(row.getLong("finid"));
        }
        return ids;
    }
}

