/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.report.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.RedeemWayEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.cim.mservice.api.BatchCalcBillIntReq;
import kd.tmc.cim.mservice.api.CalcBillIntReq;
import kd.tmc.cim.mservice.interest.CalcDepositIntServiceImpl;
import kd.tmc.cim.mservice.interest.CalcFinsubIntServiceImpl;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;

public class RevEstimateReportDataPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final String DEPOSIT_SELECT = "id, org, billno, finorginfo, investvarieties, currency as oricurrency, org.name as orgname, finorginfo.name as finorginfoname, investvarieties.name as investvarietyname,investvarieties.investtype as busitype, currency.name as currencyname, interestrate as revrate, intdate, expiredate, org.id as orgid, currency.id as currencyid";
    private static final String FINSUBSCRIBE_SELECT = "id, org, billno, finorginfo, investvarieties, currency as oricurrency, org.name as orgname, finorginfo.name as finorginfoname, investvarieties.name as investvarietyname,investvarieties.investtype as busitype, currency.name as currencyname, planrevenue as revrate, (case when intdate is null then valuedate else intdate end) as intdate, expiredate, org.id as orgid, currency.id as currencyid";
    private String statDim;

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        paramMap.putAll(queryParam.getCustomParam());
        DataSet resultDataSet = this.queryWithBusiType(paramMap, this.getQueryOrgIds(queryParam));
        if (resultDataSet.isEmpty()) {
            return this.createEmptyDS();
        }
        Boolean isShowZeroInt = (Boolean)paramMap.get("filter_showzeroint");
        if (!isShowZeroInt.booleanValue()) {
            resultDataSet = this.filterZeroIntData(resultDataSet);
        }
        this.statDim = (String)paramMap.get("filter_statdim");
        return resultDataSet;
    }

    protected String getCurrencyField() {
        return "currencyid";
    }

    protected List<String> orinalAmountField() {
        return Arrays.asList("oriestimateint", "startdayamount");
    }

    protected String getReportField(String field) {
        if ("startdayamount".equals(field)) {
            return super.getReportField(field);
        }
        return field.replace("ori", "stat");
    }

    public String sumNameField() {
        return this.getSumFieldNameByDim(this.statDim);
    }

    public List<String> groupFields() {
        return this.getGroupFieldsByDim(this.statDim);
    }

    public List<String> sumAmountFields() {
        ArrayList<String> sumFields = new ArrayList<String>(8);
        sumFields.add("statestimateint");
        return sumFields;
    }

    private DataSet queryWithBusiType(Map<String, Object> paramMap, List<Long> orgIds) {
        DataSet finsubscribeDataSet;
        DataSet noticeDepositDataSet;
        List<QFilter> commonFilterList = this.buildCommonFilter(paramMap, orgIds);
        String busitypeFilterStr = (String)paramMap.get("filter_busitype");
        List<Object> busitypeFilterList = new ArrayList();
        ArrayList<String> investList = new ArrayList<String>(8);
        if (EmptyUtil.isNotEmpty((CharSequence)busitypeFilterStr)) {
            busitypeFilterList = Arrays.asList(busitypeFilterStr.split(","));
            if (busitypeFilterList.contains("noticedeposit")) {
                investList.add(InvestTypeEnum.notice.getValue());
            }
            if (busitypeFilterList.contains("deposit")) {
                investList.add(InvestTypeEnum.fixed.getValue());
            }
            if (busitypeFilterList.contains("structuredeposit")) {
                investList.add(InvestTypeEnum.structure.getValue());
            }
            if (busitypeFilterList.contains("hugedeposit")) {
                investList.add(InvestTypeEnum.huge.getValue());
            }
        } else {
            investList = Arrays.asList(InvestTypeEnum.notice.getValue(), InvestTypeEnum.fixed.getValue(), InvestTypeEnum.structure.getValue(), InvestTypeEnum.huge.getValue());
        }
        DataSet resultDataSet = this.createEmptyDS();
        if (EmptyUtil.isNoEmpty(investList) && !(noticeDepositDataSet = this.queryDeposit(paramMap, new ArrayList<QFilter>(commonFilterList), investList)).isEmpty()) {
            resultDataSet = resultDataSet.isEmpty() ? noticeDepositDataSet : resultDataSet.union(noticeDepositDataSet);
        }
        if ((busitypeFilterList.isEmpty() || busitypeFilterList.contains("finsubscribe")) && !(finsubscribeDataSet = this.queryFinSubscribe(paramMap, new ArrayList<QFilter>(commonFilterList))).isEmpty()) {
            resultDataSet = resultDataSet.isEmpty() ? finsubscribeDataSet : resultDataSet.union(finsubscribeDataSet);
        }
        return resultDataSet;
    }

    private DataSet queryDeposit(Map<String, Object> paramMap, List<QFilter> commonFilterList, List<String> investList) {
        List<QFilter> depositFilterList = this.buildDepositQueryFilter(commonFilterList, paramMap, investList);
        DataSet noticeDepositDataSet = this.queryDepositDataset(depositFilterList, paramMap);
        if (noticeDepositDataSet.isEmpty()) {
            return noticeDepositDataSet;
        }
        ArrayList<CalcBillIntReq> reqList = new ArrayList<CalcBillIntReq>(10);
        for (Row row : noticeDepositDataSet.copy()) {
            reqList.add(CalcBillIntReq.build((Long)row.getLong("id"), (Date)row.getDate("revstartdate"), (Date)row.getDate("revenddate")));
        }
        BatchCalcBillIntReq batchIntReq = new BatchCalcBillIntReq(reqList);
        CalcDepositIntServiceImpl intService = new CalcDepositIntServiceImpl();
        Map intBillInfoMap = intService.batchCalcDepositInt(batchIntReq);
        DataSet intBillDataSet = this.getIntBillDataSet(intBillInfoMap);
        noticeDepositDataSet = noticeDepositDataSet.leftJoin(intBillDataSet).on("id", "id").select(noticeDepositDataSet.getRowMeta().getFieldNames(), (String[])Arrays.stream(intBillDataSet.getRowMeta().getFieldNames()).filter(item -> !StringUtils.equals((CharSequence)"id", (CharSequence)item)).toArray(String[]::new)).finish();
        return noticeDepositDataSet;
    }

    private DataSet getIntBillDataSet(Map<Long, IntBillInfo> intBillInfoMap) {
        ArrayList<Field> field = new ArrayList<Field>();
        field.add(new Field("id", (DataType)DataType.LongType));
        field.add(new Field("startdayamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("oriestimateint", (DataType)DataType.BigDecimalType));
        field.add(new Field("revdays", (DataType)DataType.IntegerType));
        RowMeta rowMeta = new RowMeta(field.toArray(new Field[0]));
        Algo algo = Algo.create((String)"");
        DataSetBuilder dsBuilder = algo.createDataSetBuilder(rowMeta);
        for (Map.Entry<Long, IntBillInfo> entry : intBillInfoMap.entrySet()) {
            List details;
            Long depositId = entry.getKey();
            IntBillInfo intBillInfo = entry.getValue();
            if (null == intBillInfo || !EmptyUtil.isNoEmpty((Object)(details = intBillInfo.getDetails()))) continue;
            BigDecimal startdayamount = ((IntBillDetailInfo)details.get(0)).getPrinciple();
            BigDecimal revenueamount = intBillInfo.getAmount() != null ? intBillInfo.getAmount() : new BigDecimal(0);
            Integer reventrydays = 0;
            for (IntBillDetailInfo billDetailInfo : details) {
                reventrydays = reventrydays + billDetailInfo.getDays();
            }
            Object[] obj = new Object[]{depositId, startdayamount, revenueamount, reventrydays};
            dsBuilder.append(obj);
        }
        return dsBuilder.build();
    }

    private DataSet createEmptyDS() {
        RowMeta rowMeta = new RowMeta(new String[]{"empty"}, new DataType[]{DataType.StringType});
        return Algo.create((String)"EmptyDataSet").createDataSetBuilder(rowMeta).build();
    }

    private DataSet queryDepositDataset(List<QFilter> filterList, Map<String, Object> paraMap) {
        String entityname = "cim_deposit";
        DataSet finSubDs = QueryServiceHelper.queryDataSet((String)"RevEstimateReportDataPlugin_QueryDeposit", (String)entityname, (String)DEPOSIT_SELECT, (QFilter[])filterList.toArray(new QFilter[0]), (String)"");
        if (paraMap.get("filter_revstartdate") != null) {
            String filterRevStartDateString = DateUtils.formatString((Date)((Date)paraMap.get("filter_revstartdate")), (String)"yyyy-MM-dd");
            finSubDs = finSubDs.addField("cast('" + filterRevStartDateString + "' as Timestamp)", "filter_revstartdate").addField("(case when filter_revstartdate > intdate then filter_revstartdate else intdate end)", "revstartdate");
        } else {
            finSubDs = finSubDs.addField("intdate", "revstartdate");
        }
        String filterRevEndDateString = DateUtils.formatString((Date)((Date)paraMap.get("filter_revenddate")), (String)"yyyy-MM-dd");
        finSubDs = finSubDs.addField("cast('" + filterRevEndDateString + "' as Timestamp)", "filter_revenddate").addField("(case when expiredate is null then filter_revenddate when filter_revenddate < expiredate then filter_revenddate else expiredate end)", "revenddate");
        finSubDs = finSubDs.filter("revstartdate <= revenddate");
        return finSubDs;
    }

    private DataSet queryFinSubscribe(Map<String, Object> paramMap, List<QFilter> commonFilterList) {
        List<QFilter> finsubscribeFilterList = this.buildFinSubscribeQueryFilter(commonFilterList, paramMap);
        DataSet finsubscribeDataSet = this.queryFinSubscribeDataset(finsubscribeFilterList, paramMap);
        if (finsubscribeDataSet.isEmpty()) {
            return finsubscribeDataSet;
        }
        ArrayList<CalcBillIntReq> reqList = new ArrayList<CalcBillIntReq>(10);
        for (Row row : finsubscribeDataSet.copy()) {
            reqList.add(CalcBillIntReq.build((Long)row.getLong("id"), (Date)row.getDate("revstartdate"), (Date)row.getDate("revenddate")));
        }
        BatchCalcBillIntReq batchIntReq = new BatchCalcBillIntReq(reqList);
        CalcFinsubIntServiceImpl service = new CalcFinsubIntServiceImpl();
        Map intBillInfoMap = service.batchCalcFinsubInt(batchIntReq);
        DataSet intBillDataSet = this.getIntBillDataSet(intBillInfoMap);
        finsubscribeDataSet = finsubscribeDataSet.leftJoin(intBillDataSet).on("id", "id").select(finsubscribeDataSet.getRowMeta().getFieldNames(), (String[])Arrays.stream(intBillDataSet.getRowMeta().getFieldNames()).filter(item -> !StringUtils.equals((CharSequence)"id", (CharSequence)item)).toArray(String[]::new)).finish();
        return finsubscribeDataSet;
    }

    private DataSet queryFinSubscribeDataset(List<QFilter> filterList, Map<String, Object> paraMap) {
        DataSet finSubDs = QueryServiceHelper.queryDataSet((String)"RevEstimateReportDataPlugin_QueryFinSubscribe", (String)"cim_finsubscribe", (String)FINSUBSCRIBE_SELECT, (QFilter[])filterList.toArray(new QFilter[0]), (String)"");
        if (paraMap.get("filter_revstartdate") != null) {
            String filterRevStartDateString = DateUtils.formatString((Date)((Date)paraMap.get("filter_revstartdate")), (String)"yyyy-MM-dd");
            finSubDs = finSubDs.addField("cast('" + filterRevStartDateString + "' as Timestamp)", "filter_revstartdate").addField("(case when filter_revstartdate > intdate then filter_revstartdate else intdate end)", "revstartdate");
        } else {
            finSubDs = finSubDs.addField("intdate", "revstartdate");
        }
        String filterRevEndDateString = DateUtils.formatString((Date)((Date)paraMap.get("filter_revenddate")), (String)"yyyy-MM-dd");
        finSubDs = finSubDs.addField("cast('" + filterRevEndDateString + "' as Timestamp)", "filter_revenddate").addField("(case when expiredate is null then filter_revenddate when filter_revenddate < expiredate then filter_revenddate else expiredate end)", "revenddate");
        finSubDs = finSubDs.filter("revstartdate <= revenddate");
        return finSubDs;
    }

    private List<QFilter> buildCommonFilter(Map<String, Object> paraMap, List<Long> orgIds) {
        ArrayList<QFilter> filtersList = new ArrayList<QFilter>(8);
        filtersList.add(new QFilter("org", "in", orgIds));
        filtersList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        this.addFilter(filtersList, paraMap, "finorginfo", "filter_finorginfo_multi");
        this.addFilter(filtersList, paraMap, "currency", "filter_currency");
        this.addFilter(filtersList, paraMap, "investvarieties", "filter_invvarieties_multi");
        return filtersList;
    }

    private void addFilter(List<QFilter> filtersList, Map<String, Object> paraMap, String field, String filterName) {
        DynamicObjectCollection dynCols = (DynamicObjectCollection)paraMap.get(filterName);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)dynCols)) {
            List ids = dynCols.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
            filtersList.add(new QFilter(field, "in", ids));
        }
    }

    private List<QFilter> buildDepositQueryFilter(List<QFilter> commonList, Map<String, Object> paraMap, List<String> investList) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(commonList);
        QFilter onlineTradeChannelFilter = new QFilter("tradechannel", "=", (Object)TradeChannelEnum.ONLINE.getValue());
        QFilter beBankStatusFilter = new QFilter("bebankstatus", "=", (Object)BeBillStatusEnum.TS.getValue());
        onlineTradeChannelFilter = onlineTradeChannelFilter.and(beBankStatusFilter);
        QFilter offlineTradeChannelFilter = new QFilter("tradechannel", "=", (Object)TradeChannelEnum.OFFLINE.getValue());
        QFilter tradeChannelFilter = onlineTradeChannelFilter.or(offlineTradeChannelFilter);
        filterList.add(tradeChannelFilter);
        if (paraMap.get("filter_revstartdate") != null) {
            // empty if block
        }
        if (paraMap.get("filter_revenddate") != null) {
            QFilter intDateFilter = new QFilter("intdate", "<=", paraMap.get("filter_revenddate"));
            filterList.add(intDateFilter);
        }
        filterList.add(new QFilter("investvarieties.investtype", "in", investList));
        return filterList;
    }

    private List<QFilter> buildFinSubscribeQueryFilter(List<QFilter> commonList, Map<String, Object> paraMap) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(commonList);
        QFilter onlineTradeChannelFilter = new QFilter("tradechannel", "=", (Object)TradeChannelEnum.ONLINE.getValue());
        QFilter beBankStatusFilter = new QFilter("bebankstatus", "=", (Object)BeBillStatusEnum.TS.getValue()).or(new QFilter("isrenewal", "=", (Object)Boolean.TRUE));
        onlineTradeChannelFilter = onlineTradeChannelFilter.and(beBankStatusFilter);
        QFilter offlineTradeChannelFilter = new QFilter("tradechannel", "=", (Object)TradeChannelEnum.OFFLINE.getValue());
        QFilter tradeChannelFilter = onlineTradeChannelFilter.or(offlineTradeChannelFilter);
        filterList.add(tradeChannelFilter);
        if (paraMap.get("filter_revstartdate") != null) {
            // empty if block
        }
        if (paraMap.get("filter_revenddate") != null) {
            QFilter intDateFilter = new QFilter("valuedate", "<=", paraMap.get("filter_revenddate"));
            filterList.add(intDateFilter);
        }
        QFilter redeemWayFilter = new QFilter("redeemway", "=", (Object)RedeemWayEnum.amount_redeem.getValue());
        filterList.add(redeemWayFilter);
        return filterList;
    }

    private List<String> getGroupFieldsByDim(String statdim) {
        ArrayList<String> groupFields = new ArrayList<String>(4);
        groupFields.add(this.getSumFieldNameByDim(statdim));
        return groupFields;
    }

    private String getSumFieldNameByDim(String statdim) {
        String sumFieldName = "";
        switch (statdim) {
            case "org": {
                sumFieldName = "orgname";
                break;
            }
            case "busitype": {
                sumFieldName = "busitype";
                break;
            }
            case "finorginfo": {
                sumFieldName = "finorginfoname";
                break;
            }
            case "investvarieties": {
                sumFieldName = "investvarietyname";
                break;
            }
            case "currency": {
                sumFieldName = "currencyname";
                break;
            }
        }
        return sumFieldName;
    }

    private DataSet filterZeroIntData(DataSet dataSet) {
        return dataSet.filter("oriestimateint is not null and oriestimateint <> 0");
    }
}

