/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.report.form;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.cim.common.errorcode.ReportErrorCode;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.RptDateRangeEnum;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public abstract class AbstractCimBaseReportFormPlugin
extends AbstractReportFormPlugin {
    public void registerListener(EventObject e) {
        TextEdit finAccount = (TextEdit)this.getControl("filter_finaccount");
        finAccount.addButtonClickListener((ClickListener)this);
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        this.getModel().beginInit();
        this.getModel().endInit();
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_org"))) {
            this.getModel().setItemValueByID("filter_org", (Object)RequestContext.get().getOrgId());
        }
        this.defaultCurrency();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "filter_org": 
            case "filter_orgview": {
                this.defaultCurrency();
                this.getModel().setValue("filter_finaccount", null);
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        if (evt.getSource() instanceof Control && "filter_finaccount".equals(key = ((Control)evt.getSource()).getKey())) {
            this.showF7AccountBank(key);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        this.verifyQueryParam(this.transQueryParam(queryParam));
        return true;
    }

    private void showF7AccountBank(String key) {
        DynamicObject orgView;
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"bd_accountbanks", (boolean)Boolean.FALSE);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        DynamicObjectCollection companyList = (DynamicObjectCollection)this.getModel().getValue("filter_org");
        List orgIds = companyList.stream().map(s -> (Long)s.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
        if (companyList.isEmpty() && EmptyUtil.isNoEmpty((DynamicObject)(orgView = (DynamicObject)this.getModel().getValue("filter_orgview")))) {
            String companyViewNum = orgView.getString("number");
            orgIds = OrgUnitServiceHelper.getAllOrg((String)companyViewNum);
        }
        QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", orgIds, (boolean)true);
        QFilter acctStatusFilter = new QFilter("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue());
        qFilter = acctStatusFilter.and(qFilter);
        RequestContext context = RequestContext.get();
        String appId = this.getView().getFormShowParameter().getAppId();
        List permorgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)context.getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        qFilter.and(new QFilter("company", "in", (Object)permorgIds));
        showParameter.getListFilterParameter().setFilter(qFilter);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        ListSelectedRowCollection rows;
        super.closedCallBack(e);
        if (StringUtils.equals((CharSequence)"filter_finaccount", (CharSequence)e.getActionId()) && EmptyUtil.isNoEmpty((Object)(rows = (ListSelectedRowCollection)e.getReturnData()))) {
            ListSelectedRow selectedRow = rows.get(0);
            String number = selectedRow.getNumber();
            this.getModel().setValue(e.getActionId(), (Object)number);
        }
    }

    private void defaultCurrency() {
        DynamicObjectCollection companyList = (DynamicObjectCollection)this.getModel().getValue("filter_org");
        if (companyList != null && companyList.size() > 0) {
            DynamicObject currency = TmcBusinessBaseHelper.getBaseCurrency((long)((DynamicObject)((DynamicObject)companyList.get(0)).get("fbasedataid")).getLong("id"));
            if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
                this.getModel().setValue("filter_currency", (Object)currency);
            }
        } else {
            String companyViewNum;
            List allOrgIds;
            DynamicObject currency;
            DynamicObject orgView = (DynamicObject)this.getModel().getValue("filter_orgview");
            if (EmptyUtil.isNoEmpty((DynamicObject)orgView) && EmptyUtil.isNoEmpty((DynamicObject)(currency = TmcBusinessBaseHelper.getBaseCurrency((long)((Long)(allOrgIds = OrgUnitServiceHelper.getAllOrg((String)(companyViewNum = orgView.getString("number")))).get(0)))))) {
                this.getModel().setValue("filter_currency", (Object)currency);
            }
        }
    }

    protected Map<String, Object> transQueryParam(ReportQueryParam param) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(param.getFilter().getFilterItems().size());
        for (FilterItemInfo filterItem : param.getFilter().getFilterItems()) {
            paramMap.put(filterItem.getPropName(), filterItem.getValue());
        }
        return paramMap;
    }

    protected void verifyQueryParam(Map<String, Object> paramMap) {
        ReportErrorCode reportErrorCode = new ReportErrorCode();
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!key.endsWith("ranges") || !RptDateRangeEnum.CUSTOM.getValue().equals(value) || !EmptyUtil.isEmpty((Object)paramMap.get(key + "_startdate")) && !EmptyUtil.isEmpty((Object)paramMap.get(key + "_enddate"))) continue;
            throw new TmcBizException(reportErrorCode.DEFINEDATE_NULL());
        }
    }
}

