/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.report.form;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.report.helper.ReportHelper;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositDetailFormPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        MulBasedataEdit mulOrg = (MulBasedataEdit)this.getControl("filter_org");
        mulOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit finorginfo = (MulBasedataEdit)this.getControl("filter_finorginfo");
        finorginfo.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit investvarieties = (MulBasedataEdit)this.getControl("filter_investvarieties");
        investvarieties.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        String appId = this.getView().getFormShowParameter().getAppId();
        DynamicObjectCollection finOrgCols = ReportHelper.getFinOrgDefaultValue(appId, this.getModel().getDataEntityType().getName());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)finOrgCols)) {
            this.getModel().setValue("filter_finorginfo", (Object)finOrgCols);
        }
        this.setIntStartDefVal();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initSkipQueryParam();
        String queryCutOffDate = (String)this.getModel().getValue("filter_querycutoffdate");
        if (!"custom".equals(queryCutOffDate)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"filter_enddate"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"filter_enddate"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String field = evt.getProperty().getName();
        String appId = this.getView().getFormShowParameter().getAppId();
        String entityName = this.getModel().getDataEntityType().getName();
        long currUserId = RequestContext.get().getCurrUserId();
        List f7Filter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
        if (StringUtils.equals((CharSequence)"filter_finorginfo", (CharSequence)field)) {
            if (this.isIfmApp(entityName)) {
                List orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)currUserId, (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
                f7Filter.add(new QFilter("org", "in", (Object)orgIds));
                List<Object> finOrgTypeIds = this.getFinOrgIds();
                f7Filter.add(new QFilter("finorgtype", "in", finOrgTypeIds));
            }
        } else if (StringUtils.equals((CharSequence)"filter_investvarieties", (CharSequence)field) && this.isIfmApp(entityName)) {
            Set<String> ldPrdNumbers = this.getInvestVarisNumbers();
            f7Filter.add(new QFilter("number", "in", ldPrdNumbers));
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        Date intEndDate;
        Date intStartDate;
        DynamicObjectCollection finorginfo;
        FilterInfo filter = queryParam.getFilter();
        String entityName = this.getModel().getDataEntityType().getName();
        String queryCutOffDate = (String)filter.getFilterItem("filter_querycutoffdate").getValue();
        if (EmptyUtil.isEmpty((String)queryCutOffDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DepositDetailFormPlugin_16", (String)"tmc-cim-report", (Object[])new Object[0]));
            return false;
        }
        Date filterEndDate = filter.getDate("filter_enddate");
        if (EmptyUtil.isEmpty((Object)filterEndDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u67e5\u8be2\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DepositDetailFormPlugin_1", (String)"tmc-cim-report", (Object[])new Object[0]));
            return false;
        }
        if (this.isIfmApp(entityName) && EmptyUtil.isEmpty((DynamicObjectCollection)(finorginfo = filter.getDynamicObjectCollection("filter_finorginfo")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u6b3e\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DepositDetailFormPlugin_13", (String)"tmc-cim-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject statCurrency = (DynamicObject)this.getModel().getValue("filter_statcurrency");
        if (EmptyUtil.isEmpty((DynamicObject)statCurrency)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edf\u8ba1\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DepositDetailFormPlugin_15", (String)"tmc-cim-report", (Object[])new Object[0]));
            return false;
        }
        String intStart = (String)this.getModel().getValue("filter_intstart");
        if ("custom".equals(intStart) && EmptyUtil.isAnyoneEmpty((Object[])new Object[]{intStartDate = (Date)this.getModel().getValue("selfdefine_startdate"), intEndDate = (Date)this.getModel().getValue("selfdefine_enddate")})) {
            this.getView().showTipNotification(ReportHelper.loadKDString("\u5f53\u5b58\u6b3e\u8d77\u606f\u65e5\u4e3a\u81ea\u5b9a\u4e49\u65f6\uff0c\u81ea\u5b9a\u4e49\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", "DepositSumRptFormListPlugin_4", new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        filter.addFilterItem("filter_statdim", this.getModel().getValue("filter_statdim"));
        filter.addFilterItem("filter_statcurrency", this.getModel().getValue("filter_statcurrency"));
        filter.addFilterItem("filter_currencyunit", this.getModel().getValue("filter_currencyunit"));
        filter.addFilterItem("filter_islinetotal", this.getModel().getValue("filter_islinetotal"));
        filter.addFilterItem("filter_appid", (Object)this.getView().getFormShowParameter().getAppId());
        this.SetInvesFilterWhenNullAndIfm(filter);
        this.SetFinOrgFilterWhenNullAndIfm(filter, RequestContext.get().getCurrUserId(), this.getView().getFormShowParameter().getAppId());
        this.addReportColumn(filter);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (StringUtils.equals((CharSequence)"billno", (CharSequence)evt.getFieldName())) {
            ReportList reportList = (ReportList)evt.getSource();
            IReportListModel reportModel = reportList.getReportModel();
            DynamicObject rowData = reportModel.getRowData(evt.getRowIndex());
            this.showDepositBill(rowData);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (fieldName) {
            case "filter_statdim": 
            case "filter_islinetotal": {
                this.autoSearch();
                break;
            }
            case "filter_querycutoffdate": {
                if (!"custom".equals(newValue)) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"filter_enddate"});
                    break;
                }
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"filter_enddate"});
                break;
            }
        }
    }

    private void autoSearch() {
        ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
        if (!EmptyUtil.isEmpty((Object)rptFilter)) {
            try {
                rptFilter.search();
            }
            catch (KDBizException bizEx) {
                this.getView().showErrorNotification(bizEx.getMessage());
            }
        }
    }

    private void showDepositBill(DynamicObject rowData) {
        String billno = rowData.getString("billno");
        if (EmptyUtil.isEmpty((String)billno)) {
            return;
        }
        DynamicObject oriBill = TmcDataServiceHelper.loadSingle((String)"cim_deposit", (String)"id,investvarieties", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)});
        if (EmptyUtil.isEmpty((DynamicObject)oriBill)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"DepositDetailFormPlugin_12", (String)"tmc-cim-report", (Object[])new Object[0]));
            return;
        }
        String investType = Optional.ofNullable(oriBill.getDynamicObject("investvarieties")).map(r -> r.getString("investtype")).orElse("");
        String entityName = "cim_deposit";
        String curEntityName = this.getModel().getDataEntityType().getName();
        if (this.isIfmApp(curEntityName) && InvestTypeEnum.isFixed((String)investType)) {
            entityName = "ifm_deposit";
        } else if (this.isCimApp(curEntityName) && InvestTypeEnum.isNotice((String)investType)) {
            entityName = "cim_noticedeposit";
        } else if (this.isIfmApp(curEntityName) && InvestTypeEnum.isNotice((String)investType)) {
            entityName = "ifm_notice_deposit";
        }
        IReportView view = this.getView();
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setPkId(oriBill.getPkValue());
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setFormId(entityName);
        view.showForm((FormShowParameter)parameter);
    }

    private void addReportColumn(FilterInfo filter) {
        ReportList listTab = (ReportList)this.getControl("reportlistap");
        List columns = listTab.getColumns();
        String statdim = filter.getString("filter_statdim");
        String columnStr = "";
        switch (statdim) {
            case "f": {
                columnStr = "finorginfo,org,investvarieties,currencyname";
                break;
            }
            case "o": {
                columnStr = "org,finorginfo,investvarieties,currencyname";
                break;
            }
            case "v": {
                columnStr = "investvarieties,finorginfo,org,currencyname";
                break;
            }
            case "c": {
                columnStr = "currencyname,finorginfo,org,investvarieties";
                break;
            }
            default: {
                columnStr = "finorginfo,org,investvarieties,currencyname";
            }
        }
        String[] colArr = columnStr.split(",");
        for (int i = 0; i < colArr.length; ++i) {
            ReportColumn reportColumn = new ReportColumn();
            reportColumn.setFieldType("text");
            reportColumn.setFieldKey(colArr[i]);
            reportColumn.setCaption(new LocaleString(this.getColumnName(colArr[i])));
            columns.add(i, reportColumn);
        }
    }

    private String getColumnName(String field) {
        String name = "";
        switch (field) {
            case "finorginfo": {
                name = ResManager.loadKDString((String)"\u5b58\u6b3e\u673a\u6784", (String)"DepositDetailFormPlugin_8", (String)"tmc-cim-report", (Object[])new Object[0]);
                break;
            }
            case "org": {
                name = ResManager.loadKDString((String)"\u5b58\u6b3e\u7ec4\u7ec7", (String)"DepositDetailFormPlugin_9", (String)"tmc-cim-report", (Object[])new Object[0]);
                break;
            }
            case "investvarieties": {
                name = ResManager.loadKDString((String)"\u5b58\u6b3e\u54c1\u79cd", (String)"DepositDetailFormPlugin_10", (String)"tmc-cim-report", (Object[])new Object[0]);
                String entityName = this.getModel().getDataEntityType().getName();
                if (!this.isIfmApp(entityName)) break;
                name = ResManager.loadKDString((String)"\u5b58\u6b3e\u4ea7\u54c1", (String)"DepositDetailFormPlugin_14", (String)"tmc-cim-report", (Object[])new Object[0]);
                break;
            }
            case "currencyname": {
                name = ResManager.loadKDString((String)"\u5e01\u79cd", (String)"DepositDetailFormPlugin_11", (String)"tmc-cim-report", (Object[])new Object[0]);
                break;
            }
        }
        return name;
    }

    private Set<String> getInvestVarisNumbers() {
        QFilter ldPrdFilter = new QFilter("servicecategory", "in", (Object)new String[]{"A", "C"});
        DynamicObjectCollection ldPrdCols = QueryServiceHelper.query((String)"ifm_ldproduct", (String)"number", (QFilter[])ldPrdFilter.toArray());
        Set<String> ldPrdNumbers = ldPrdCols.stream().map(r -> r.getString("number")).collect(Collectors.toSet());
        return ldPrdNumbers;
    }

    private List<Object> getFinOrgIds() {
        QFilter finOrgFilter = new QFilter("type", "=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue());
        finOrgFilter.and("enable", "=", (Object)"1");
        List finOrgTypeIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_finorgtype", (QFilter[])finOrgFilter.toArray(), (String)"", (int)-1);
        return finOrgTypeIds;
    }

    private void SetFinOrgFilterWhenNullAndIfm(FilterInfo filter, long currUserId, String appId) {
        DynamicObjectCollection finorginfoCols = filter.getDynamicObjectCollection("filter_finorginfo");
        String entityName = this.getModel().getDataEntityType().getName();
        if (EmptyUtil.isEmpty((DynamicObjectCollection)finorginfoCols) && this.isIfmApp(entityName)) {
            List orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)currUserId, (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
            QFilter finOrgFilter = new QFilter("org", "in", (Object)orgIds);
            List<Object> finOrgTypeIds = this.getFinOrgIds();
            finOrgFilter.and(new QFilter("finorgtype", "in", finOrgTypeIds));
            List finOrgIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_finorginfo", (QFilter[])new QFilter[]{finOrgFilter}, (String)"", (int)-1);
            filter.addFilterItem("filter_finorginfo_ifm", (Object)finOrgIds);
        }
    }

    private void SetInvesFilterWhenNullAndIfm(FilterInfo filter) {
        DynamicObjectCollection filterInvCols = filter.getDynamicObjectCollection("filter_investvarieties");
        String entityName = this.getModel().getDataEntityType().getName();
        if (EmptyUtil.isEmpty((DynamicObjectCollection)filterInvCols) && this.isIfmApp(entityName)) {
            Set<String> ldPrdNumbers = this.getInvestVarisNumbers();
            List investVarIds = QueryServiceHelper.queryPrimaryKeys((String)"cim_investvarieties", (QFilter[])new QFilter[]{new QFilter("number", "in", ldPrdNumbers)}, (String)"", (int)-1);
            filter.addFilterItem("filter_investvarieties_ifm", (Object)investVarIds);
        }
    }

    private void initSkipQueryParam() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (EmptyUtil.isNoEmpty(customParams.get("skipfromsumrpt"))) {
            String endDateStr;
            List investVarieties;
            List currencys;
            List finOrgInfos;
            IDataModel model = this.getModel();
            IReportView view = this.getView();
            model.setValue("filter_queryway", (Object)"org");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)"filter_queryway", (Object)"org");
            List orgIds = (List)customParams.get("filter_org");
            if (EmptyUtil.isNoEmpty((Object)orgIds)) {
                this.setMutiPropValue("bos_org", "filter_org", orgIds.toArray());
            }
            if (EmptyUtil.isNoEmpty((Object)(finOrgInfos = (List)customParams.get("filter_finorginfo")))) {
                this.setMutiPropValue("bd_finorginfo", "filter_finorginfo", finOrgInfos.toArray());
            }
            if (EmptyUtil.isNoEmpty((Object)(currencys = (List)customParams.get("filter_currency")))) {
                this.setMutiPropValue("bd_currency", "filter_currency", currencys.toArray());
            }
            if (EmptyUtil.isNoEmpty((Object)(investVarieties = (List)customParams.get("filter_investvarieties")))) {
                this.setMutiPropValue("cim_investvarieties", "filter_investvarieties", investVarieties.toArray());
            } else {
                DynamicObjectCollection products;
                List productIds = (List)customParams.get("filter_product");
                if (EmptyUtil.isNoEmpty((Object)productIds) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(products = QueryServiceHelper.query((String)"ifm_ldproduct", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)productIds)})))) {
                    List numbers = products.stream().map(v -> v.getString("number")).collect(Collectors.toList());
                    DynamicObjectCollection invests = QueryServiceHelper.query((String)"cim_investvarieties", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", numbers)});
                    Object[] inverstIds = invests.stream().map(d -> d.get("id")).toArray();
                    this.setMutiPropValue("cim_investvarieties", "filter_investvarieties", inverstIds);
                }
            }
            String queryCutOffDate = (String)customParams.get("filter_querycutoffdate");
            if (EmptyUtil.isNoEmpty((String)queryCutOffDate)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"filter_querycutoffdate", (Object)queryCutOffDate);
            }
            if (EmptyUtil.isNoEmpty((String)(endDateStr = (String)customParams.get("filter_enddate")))) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"filter_enddate", (Object)DateUtils.stringToDate((String)endDateStr, (String)"yyyy-MM-dd"));
            }
            boolean isInclude = (Boolean)customParams.get("filter_isinclude");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"filter_isinclude", (Object)isInclude);
            this.autoSearch();
        }
    }

    private void setMutiPropValue(String entityName, String propName, Object[] ids) {
        if (EmptyUtil.isEmpty((Object[])ids)) {
            return;
        }
        DynamicObject[] objs = TmcDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        DynamicObjectCollection objList = new DynamicObjectCollection();
        Arrays.stream(objs).forEach(v -> objList.add(v));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)propName, (Object)objList);
    }

    private boolean isCimApp(String entityName) {
        return StringUtils.equals((CharSequence)"cim_deposit_dtlrpt", (CharSequence)entityName);
    }

    private boolean isIfmApp(String entityName) {
        return StringUtils.equals((CharSequence)"ifm_deposit_dtlrpt", (CharSequence)entityName);
    }

    private void setIntStartDefVal() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (EmptyUtil.isEmpty(customParams.get("skipfromsumrpt"))) {
            return;
        }
        String intStart = (String)customParams.get("filter_intstart");
        this.getModel().setValue("filter_intstart", (Object)intStart);
        if ("custom".equals(intStart)) {
            this.getModel().setValue("selfdefine_startdate", customParams.get("selfdefine_startdate"));
            this.getModel().setValue("selfdefine_enddate", customParams.get("selfdefine_enddate"));
        }
    }
}

