/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.report.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.report.ReportList;
import kd.bos.report.filter.ReportFilter;
import kd.tmc.cim.report.form.AbstractCimBaseReportFormPlugin;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RevDetailReportFormListPlugin
extends AbstractCimBaseReportFormPlugin
implements HyperLinkClickListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportListAp = (ReportList)this.getView().getControl("reportlistap");
        reportListAp.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeQuery(ReportQueryParam param) {
        String statdim = (String)this.getModel().getValue("filter_statdim");
        param.getFilter().addFilterItem("filter_statdim", (Object)statdim);
        DynamicObject currency = (DynamicObject)this.getModel().getValue("filter_statcurrency");
        param.getFilter().addFilterItem("filter_statcurrency", (Object)currency);
        Boolean isLineTotal = (Boolean)this.getModel().getValue("filter_islinetotal");
        param.getFilter().addFilterItem("filter_islinetotal", (Object)isLineTotal);
        String currencyUnit = (String)this.getModel().getValue("filter_currencyunit");
        param.getFilter().addFilterItem("filter_currencyunit", (Object)currencyUnit);
        this.initQueryColumn(statdim, param);
        super.beforeQuery(param);
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("filter_statcurrency");
        if (EmptyUtil.isEmpty((DynamicObject)currency)) {
            this.showStatCurencyTipNoti();
            return false;
        }
        return true;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        ReportFilter rptFilter;
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if ((propName.equals("filter_statdim") || propName.equals("filter_currencyunit") || propName.equals("filter_islinetotal")) && !EmptyUtil.isEmpty((Object)(rptFilter = (ReportFilter)this.getControl("reportfilterap")))) {
            rptFilter.search();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName;
        switch (fieldName = evt.getFieldName()) {
            case "opercol": {
                ReportList reportList = (ReportList)this.getControl("reportlistap");
                IReportListModel reportModel = reportList.getReportModel();
                int rowIdx = this.getView().getModel().getEntryCurrentRowIndex("reportlistap");
                DynamicObject rowData = reportModel.getRowData(rowIdx);
                BillShowParameter param = new BillShowParameter();
                Object id = rowData.get("id");
                param.setPkId(id);
                param.setStatus(OperationStatus.VIEW);
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                param.setFormId("redeem".equals(rowData.get("revsrctype")) ? "cim_redeem" : "cim_revenue");
                this.getView().showForm((FormShowParameter)param);
                break;
            }
        }
    }

    private void initQueryColumn(String statdim, ReportQueryParam param) {
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        List columns = listTable.getColumns();
        for (AbstractReportColumn column : columns) {
            ReportColumnGroup group;
            if (!(column instanceof ReportColumnGroup) || !"finsubscribe".equals((group = (ReportColumnGroup)column).getFieldKey())) continue;
            this.reOrderColumn(statdim, group);
        }
    }

    private void reOrderColumn(String statdim, ReportColumnGroup group) {
        ReportColumn statColumn = null;
        String statColumKey = "finorginfomain";
        switch (statdim) {
            case "finorginfo": {
                statColumKey = "finorginfomain";
                break;
            }
            case "org": {
                statColumKey = "orgname";
                break;
            }
            case "finaccount": {
                statColumKey = "finaccount";
                break;
            }
            case "investvarieties": {
                statColumKey = "investvarietyname";
                break;
            }
            case "currency": {
                statColumKey = "currencyname";
                break;
            }
        }
        List children = group.getChildren();
        ArrayList<Object> rebuildColumns = new ArrayList<Object>(children.size());
        for (AbstractReportColumn column : children) {
            ReportColumn reportColumn;
            if (!(column instanceof ReportColumn) || !(reportColumn = (ReportColumn)column).getFieldKey().equals(statColumKey)) continue;
            statColumn = reportColumn;
        }
        rebuildColumns.add(statColumn);
        for (AbstractReportColumn column : children) {
            if (rebuildColumns.contains(column)) continue;
            rebuildColumns.add(column);
        }
        children.clear();
        children.addAll(rebuildColumns);
    }

    private void showStatCurencyTipNoti() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7edf\u8ba1\u5e01\u79cd\u3002", (String)"RevDetailReportFormListPlugin_0", (String)"tmc-cim-report", (Object[])new Object[0]));
    }

    private void showNoOrgPermTipNoti() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u76f8\u5173\u8d44\u91d1\u7ec4\u7ec7\u67e5\u8be2\u6743\u9650\u3002", (String)"RevDetailReportFormListPlugin_1", (String)"tmc-cim-report", (Object[])new Object[0]));
    }
}

