/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.report.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.cim.report.helper.ReportHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SumReportFormPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final String HIDE_GROUP_COLS = "applyamtgroup,redeemamtgroup,surpamtgroup,futureamtgroup,realamtgroup";
    private static final String HIDE_COLS = "amount,redeemamount,surplusamount,futureamount,realrevenue";
    private static final String HIDE_COPY_COLS = "buycopies,copies,surpluscopies";
    private static Log logger = LogFactory.getLog(SumReportFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportListAp = (ReportList)this.getView().getControl("reportlistap");
        reportListAp.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        event.setTreeReportList(true);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String queryCutOffDate = (String)this.getModel().getValue("filter_querycutoffdate");
        if (!"custom".equals(queryCutOffDate)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"filter_enddate"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"filter_enddate"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject currency;
        String fieldName = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (fieldName.equals("filter_statcurrency") && EmptyUtil.isEmpty((DynamicObject)(currency = (DynamicObject)this.getModel().getValue("filter_statcurrency")))) {
            return;
        }
        switch (fieldName) {
            case "filter_islinetotal": 
            case "filter_banklevel": 
            case "filter_statdim": {
                this.autoSearch();
                break;
            }
            case "filter_querycutoffdate": {
                if (!"custom".equals(newValue)) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"filter_enddate"});
                    break;
                }
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"filter_enddate"});
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        String queryWay;
        FilterInfo filter = queryParam.getFilter();
        String filterQueryCutOffDate = filter.getString("filter_querycutoffdate");
        Date filterEndDate = filter.getDate("filter_enddate");
        if (EmptyUtil.isEmpty((String)filterQueryCutOffDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DepositDetailFormPlugin_16", (String)"tmc-cim-report", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((Object)filterEndDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u67e5\u8be2\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DepositDetailFormPlugin_1", (String)"tmc-cim-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject statCurrency = (DynamicObject)this.getModel().getValue("filter_statcurrency");
        if (EmptyUtil.isEmpty((DynamicObject)statCurrency)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edf\u8ba1\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DepositDetailFormPlugin_15", (String)"tmc-cim-report", (Object[])new Object[0]));
            return false;
        }
        String intStart = (String)this.getModel().getValue("filter_intstart");
        if ("custom".equals(intStart)) {
            Date intStartDate = (Date)this.getModel().getValue("selfdefine_startdate");
            Date intEndDate = (Date)this.getModel().getValue("selfdefine_enddate");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{intStartDate, intEndDate})) {
                this.getView().showTipNotification(ReportHelper.loadKDString("\u5f53\u7406\u8d22\u8d77\u59cb\u65e5\u4e3a\u81ea\u5b9a\u4e49\u65f6\uff0c\u81ea\u5b9a\u4e49\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", "SumReportFormPlugin_4", new Object[0]));
                return false;
            }
        }
        if ("orgview".equals(queryWay = (String)this.getModel().getValue("filter_queryway"))) {
            DynamicObject orgView = (DynamicObject)queryParam.getFilter().getFilterItem("filter_orgview").getValue();
            queryParam.getFilter().addFilterItem("filter_useorg", (Object)TmcOrgDataHelper.getOrgRootId((Long)orgView.getLong("id")));
        } else {
            queryParam.getFilter().addFilterItem("filter_useorg", (Object)RequestContext.get().getOrgId());
        }
        return super.verifyQuery(queryParam);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        filter.addFilterItem("filter_statdim", this.getModel().getValue("filter_statdim"));
        filter.addFilterItem("filter_banklevel", this.getModel().getValue("filter_banklevel"));
        filter.addFilterItem("filter_islinetotal", this.getModel().getValue("filter_islinetotal"));
        filter.addFilterItem("filter_isshowtotal", this.getModel().getValue("filter_islinetotal"));
        this.addReportColumn(filter);
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"detail")) {
            ReportList reportList = (ReportList)event.getSource();
            ReportShowParameter param = new ReportShowParameter();
            String formId = "cim_detailrpt";
            param.setFormId(formId);
            param.setCustomParams(this.getHyperLinkParam(this.getHyperLinkData(reportList, event.getRowIndex())));
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    private void addReportColumn(FilterInfo filter) {
        List<String> redeemWayList;
        int i;
        ReportList listTab = (ReportList)this.getControl("reportlistap");
        List columns = listTab.getColumns();
        String statdim = filter.getString("filter_statdim");
        String hidCol = "";
        String sumNameField = "";
        String orderByField = "";
        String statDimField = "";
        switch (statdim) {
            case "ofc": {
                statDimField = "org+finorginfo+currency";
                sumNameField = "currencyname,finorginfoname";
                orderByField = "orgname,secondlevel,finorginfoname,sumlevel,currencyname";
                hidCol = HIDE_COLS;
                break;
            }
            case "foc": {
                statDimField = "finorginfo+org+currency";
                sumNameField = "currencyname,orgname";
                orderByField = "finorginfoname,secondlevel,orgname,sumlevel,currencyname";
                hidCol = HIDE_COLS;
                break;
            }
            case "oc": {
                statDimField = "org+currency";
                sumNameField = "currencyname";
                orderByField = "orgname,sumlevel,currencyname";
                hidCol = HIDE_COLS;
                break;
            }
            case "fc": {
                statDimField = "finorginfo+currency";
                sumNameField = "currencyname";
                orderByField = "finorginfoname,sumlevel,currencyname";
                hidCol = HIDE_COLS;
                break;
            }
            case "ic": {
                statDimField = "invest+currency";
                sumNameField = "currencyname";
                orderByField = "investname,sumlevel,currencyname";
                hidCol = HIDE_COLS;
                break;
            }
            case "o": {
                statDimField = "org";
                sumNameField = "";
                orderByField = "orgname";
                hidCol = HIDE_GROUP_COLS;
                break;
            }
            case "f": {
                statDimField = "finorginfo";
                sumNameField = "";
                orderByField = "finorginfoname";
                hidCol = HIDE_GROUP_COLS;
                break;
            }
            case "c": {
                statDimField = "currency";
                sumNameField = "";
                orderByField = "currencyname";
                hidCol = HIDE_COLS;
                break;
            }
        }
        String[] colArr = statDimField.split("\\+");
        for (i = 0; i < colArr.length; ++i) {
            ReportColumn reportColumn = this.createReportColumn(colArr[i] + "name");
            columns.add(i, reportColumn);
        }
        for (i = 0; i < colArr.length; ++i) {
            ReportColumn srcReportColumn = null;
            srcReportColumn = "finorginfo".equals(colArr[i]) ? this.createReportColumn(colArr[i] + "id") : this.createReportColumn(colArr[i]);
            columns.add(i, srcReportColumn);
            srcReportColumn.setHide(true);
        }
        String redeemWay = filter.getString("filter_redeemway");
        boolean isHideCopyCol = false;
        if (EmptyUtil.isNoEmpty((String)redeemWay) && (redeemWayList = Arrays.asList(redeemWay.split(","))).contains("amount_redeem") && !redeemWayList.contains("copies_redeem")) {
            isHideCopyCol = true;
        }
        List<String> hideCopyColList = Arrays.asList(HIDE_COPY_COLS.split(","));
        List<String> hideColList = Arrays.asList(hidCol.split(","));
        for (AbstractReportColumn column : columns) {
            ReportColumn col;
            if (column instanceof ReportColumn) {
                col = (ReportColumn)column;
                logger.info("ReportColumn: fieldKey:{}, dataIndex:{}", (Object)col.getFieldKey(), (Object)col.getDateIndex());
                if (col.isHide()) continue;
                col.setHide(hideColList.contains(col.getFieldKey()));
                if (col.isHide() || !isHideCopyCol) continue;
                col.setHide(hideCopyColList.contains(col.getFieldKey()));
                continue;
            }
            if (!(column instanceof ReportColumnGroup) || !hideColList.contains((col = (ReportColumnGroup)column).getFieldKey())) continue;
            col.getChildren().forEach(r -> {
                ((ReportColumn)r).setHide(true);
                logger.info("ReportColumnGroup: fieldKey:{}, dataIndex:{}", (Object)((ReportColumn)r).getFieldKey(), (Object)((ReportColumn)r).getDateIndex());
            });
        }
        List<AbstractReportColumn> tmpColumns = this.removeDuplicatedColumnDataIndex(columns);
        columns.clear();
        columns.addAll(tmpColumns);
        for (AbstractReportColumn column : columns) {
            ReportColumn col;
            if (column instanceof ReportColumn) {
                col = (ReportColumn)column;
                logger.info("newReportColumn: fieldKey:{}, dataIndex:{}", (Object)col.getFieldKey(), (Object)col.getDateIndex());
                continue;
            }
            if (!(column instanceof ReportColumnGroup) || !hideColList.contains((col = (ReportColumnGroup)column).getFieldKey())) continue;
            col.getChildren().forEach(r -> logger.info("newReportColumnGroup: fieldKey:{}, dataIndex:{}", (Object)((ReportColumn)r).getFieldKey(), (Object)((ReportColumn)r).getDateIndex()));
        }
        filter.addFilterItem("stat_dimfield", (Object)statDimField);
        filter.addFilterItem("stat_sumfield", (Object)sumNameField);
        filter.addFilterItem("stat_orderfield", (Object)orderByField);
    }

    private String getColumnName(String field) {
        String name = "";
        switch (field) {
            case "orgname": {
                name = ResManager.loadKDString((String)"\u7533\u8d2d\u7ec4\u7ec7", (String)"SumReportFormPlugin_1", (String)"tmc-cim-report", (Object[])new Object[0]);
                break;
            }
            case "finorginfoname": {
                name = ResManager.loadKDString((String)"\u53d1\u884c\u673a\u6784", (String)"SumReportFormPlugin_2", (String)"tmc-cim-report", (Object[])new Object[0]);
                break;
            }
            case "investname": {
                name = ResManager.loadKDString((String)"\u6295\u8d44\u54c1\u79cd", (String)"SumReportFormPlugin_3", (String)"tmc-cim-report", (Object[])new Object[0]);
                break;
            }
            case "currencyname": {
                name = ResManager.loadKDString((String)"\u5e01\u79cd", (String)"DepositDetailFormPlugin_11", (String)"tmc-cim-report", (Object[])new Object[0]);
                break;
            }
        }
        return name;
    }

    private void autoSearch() {
        ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
        if (!EmptyUtil.isEmpty((Object)rptFilter)) {
            try {
                rptFilter.search();
            }
            catch (KDBizException bizEx) {
                this.getView().showErrorNotification(bizEx.getMessage());
            }
        }
    }

    private List<AbstractReportColumn> removeDuplicatedColumnDataIndex(List<AbstractReportColumn> columns) {
        ArrayList<AbstractReportColumn> tmpColumns = new ArrayList<AbstractReportColumn>();
        HashSet<String> columnFieldKeySet = new HashSet<String>();
        for (AbstractReportColumn column : columns) {
            ReportColumn col;
            if (column instanceof ReportColumn) {
                col = (ReportColumn)column;
                logger.info("remove ReportColumn: fieldKey:{}, dataIndex:{}", (Object)col.getFieldKey(), (Object)col.getDateIndex());
                if (!StringUtils.isNotEmpty((CharSequence)col.getFieldKey()) || columnFieldKeySet.contains(col.getFieldKey())) continue;
                tmpColumns.add((AbstractReportColumn)col);
                columnFieldKeySet.add(col.getFieldKey());
                continue;
            }
            if (!(column instanceof ReportColumnGroup)) continue;
            col = (ReportColumnGroup)column;
            tmpColumns.add((AbstractReportColumn)col);
        }
        return tmpColumns;
    }

    private Map<String, Object> getHyperLinkParam(List<DynamicObject> curRowDatas) {
        HashMap<String, Object> hyperLinkParam = new HashMap<String, Object>(16);
        hyperLinkParam.put("skipfromsumrpt", "true");
        ArrayList<Object> orgIds = new ArrayList<Object>();
        ArrayList<Object> finOrgInfos = new ArrayList<Object>();
        ArrayList<Object> investVarieties = new ArrayList<Object>();
        ArrayList<Object> currencyIds = new ArrayList<Object>();
        for (DynamicObject curRowData : curRowDatas) {
            this.addOrgIds(orgIds, curRowData);
            this.addFinOrgIds(finOrgInfos, curRowData);
            this.addInvestIds(investVarieties, curRowData);
            this.addCurrencyIds(currencyIds, curRowData);
        }
        String queryCutOffDate = (String)this.getModel().getValue("filter_querycutoffdate");
        hyperLinkParam.put("filter_querycutoffdate", queryCutOffDate);
        Date endDate = (Date)this.getModel().getValue("filter_enddate");
        hyperLinkParam.put("filter_enddate", endDate);
        hyperLinkParam.put("filter_org", orgIds);
        hyperLinkParam.put("filter_lfinorginfo", finOrgInfos);
        hyperLinkParam.put("filter_linvestvarieties", investVarieties);
        hyperLinkParam.put("filter_lcurrency", currencyIds);
        boolean isInclude = (Boolean)this.getModel().getValue("filter_isinclude");
        hyperLinkParam.put("filter_isinclude", isInclude);
        hyperLinkParam.put("filter_intstart", this.getModel().getValue("filter_intstart"));
        hyperLinkParam.put("selfdefine_startdate", this.getModel().getValue("selfdefine_startdate"));
        hyperLinkParam.put("selfdefine_enddate", this.getModel().getValue("selfdefine_enddate"));
        hyperLinkParam.put("filter_redeemway1", this.getModel().getValue("filter_redeemway"));
        return hyperLinkParam;
    }

    private void addOrgIds(List<Object> orgIds, DynamicObject curRowData) {
        long orgId = curRowData.getLong("org");
        if (EmptyUtil.isNoEmpty((Long)orgId)) {
            orgIds.add(orgId);
        } else if (orgIds.isEmpty()) {
            String orgWay = (String)this.getModel().getValue("filter_queryway");
            DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("filter_org");
            if (StringUtils.equals((CharSequence)orgWay, (CharSequence)"org")) {
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)orgs)) {
                    orgIds.addAll(orgs.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList()));
                }
            } else {
                DynamicObject orgView = (DynamicObject)this.getModel().getValue("filter_orgview");
                if (EmptyUtil.isNoEmpty((DynamicObject)orgView)) {
                    orgIds.addAll(TmcOrgDataHelper.getOrgIds((Long)orgView.getLong("id")));
                }
            }
        }
    }

    private void addFinOrgIds(List<Object> finOrgIds, DynamicObject curRowData) {
        IDataModel model = this.getModel();
        DynamicObjectCollection finOrgInfoCol = (DynamicObjectCollection)model.getValue("filter_finorginfo");
        List finOrgIdList = finOrgInfoCol.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty((Object)curRowData.getDynamicObjectType().getProperty("finorginfo")) && EmptyUtil.isNoEmpty((Long)curRowData.getLong("finorginfo"))) {
            Long finOrgInfo = curRowData.getLong("finorginfo");
            String level = (String)model.getValue("filter_banklevel");
            if (StringUtils.equals((CharSequence)level, (CharSequence)"1")) {
                QFilter qfilter = new QFilter("finorginfo.bank_cate", "=", (Object)finOrgInfo);
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)"addFinOrgIds.query", (String)"cim_finsubscribe", (String)"finorginfo", (QFilter[])new QFilter[]{qfilter}, null);
                HashSet<Object> finSet = new HashSet<Object>();
                for (Row row : dataSet) {
                    Object id = row.get("finorginfo");
                    if (!EmptyUtil.isEmpty(finOrgIdList) && (!EmptyUtil.isNoEmpty(finOrgIdList) || !finOrgIdList.contains(id))) continue;
                    finSet.add(id);
                }
                if (finSet.size() > 0) {
                    finOrgIds.addAll(finSet);
                } else {
                    finOrgIds.add(finOrgInfo);
                }
                dataSet.close();
            } else {
                finOrgIds.add(finOrgInfo);
            }
        } else if (finOrgIds.isEmpty() && EmptyUtil.isNoEmpty((DynamicObjectCollection)finOrgInfoCol)) {
            finOrgIds.addAll(finOrgIdList);
        }
    }

    private void addInvestIds(List<Object> InvestIds, DynamicObject curRowData) {
        DynamicObjectCollection investCol;
        if (EmptyUtil.isNoEmpty((Object)curRowData.getDynamicObjectType().getProperty("investvarieties"))) {
            long investId = curRowData.getLong("investvarieties");
            if (EmptyUtil.isNoEmpty((Long)investId)) {
                InvestIds.add(investId);
            }
        } else if (InvestIds.isEmpty() && EmptyUtil.isNoEmpty((DynamicObjectCollection)(investCol = (DynamicObjectCollection)this.getModel().getValue("filter_investvarieties")))) {
            InvestIds.addAll(investCol.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList()));
        }
    }

    private void addCurrencyIds(List<Object> currencyIds, DynamicObject curRowData) {
        DynamicObjectCollection currencyCol;
        if (EmptyUtil.isNoEmpty((Object)curRowData.getDynamicObjectType().getProperty("currency"))) {
            DynamicObject currency = curRowData.getDynamicObject("currency");
            if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
                currencyIds.add(currency.getPkValue().toString());
            }
        } else if (currencyIds.isEmpty() && EmptyUtil.isNoEmpty((DynamicObjectCollection)(currencyCol = (DynamicObjectCollection)this.getModel().getValue("filter_currency")))) {
            currencyIds.addAll(currencyCol.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList()));
        }
    }

    private List<DynamicObject> getHyperLinkData(ReportList reportList, int rowIndex) {
        ArrayList<DynamicObject> hyperLinkData = new ArrayList<DynamicObject>(16);
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject firstData = reportModel.getRowData(rowIndex);
        ArrayList<Object> rowIds = new ArrayList<Object>(16);
        rowIds.add(firstData.get("rowid"));
        if (!firstData.getBoolean("isgroupnode")) {
            hyperLinkData.add(firstData);
            return hyperLinkData;
        }
        int totalRecords = reportList.getTotalRecords();
        for (int i = rowIndex + 1; i <= totalRecords; ++i) {
            DynamicObject data = reportModel.getRowData(i);
            Object pId = data.get("pid");
            boolean isGroupNode = data.getBoolean("isgroupnode");
            if (!data.getString("sumlevel").equals("0") || isGroupNode && !rowIds.contains(pId)) break;
            if (!isGroupNode) {
                hyperLinkData.add(data);
                continue;
            }
            rowIds.add(data.get("rowid"));
        }
        return hyperLinkData;
    }

    private ReportColumn createReportColumn(String colArr) {
        ReportColumn reportColumn = new ReportColumn();
        reportColumn.setFieldType("text");
        reportColumn.setFieldKey(colArr);
        reportColumn.setCaption(new LocaleString(this.getColumnName(colArr)));
        return reportColumn;
    }
}

