/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.mservice.consistency.helper;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.DTX;
import kd.bos.kdtx.sdk.session.DTXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cim.mservice.consistency.bean.CimConsistencyInfo;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.TmcAppEnum;

public class CimConsistencyServiceHelper {
    private static final Log logger = LogFactory.getLog(CimConsistencyServiceHelper.class);

    public static void asyncPush(CimConsistencyInfo info) {
        String businessType = info.getBusinessType();
        logger.info("asyncPush dtx start, param:{}", (Object)businessType, (Object)info.toString());
        try (DTXHandle dtx = DTX.requiresNew((String)businessType, (DBRoute)DBRouteConst.TMC, (boolean)false);){
            try {
                List<String> ids = info.getIdStr();
                CommonParam param = new CommonParam();
                param.put((Object)"consistencyInfo", (Object)info);
                param.put((Object)"currUserId", (Object)RequestContext.get().getCurrUserId());
                dtx.setBusinessType(businessType);
                dtx.setBusinessInfo(ids);
                dtx.register(TmcAppEnum.TMC.getValue(), TmcAppEnum.CIM.getValue(), info.getServiceName(), (Param)param);
                if (info.needCallback()) {
                    dtx.setCallback(TmcAppEnum.CIM.getValue(), info.getCallback());
                }
            }
            catch (Exception e) {
                dtx.markRollback();
                logger.error("asyncPush dtx error,{}", (Object)e.getMessage());
                throw e;
            }
        }
    }
}

