/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.mservice.interest;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.service.deposit.DepositCalcIntService;
import kd.tmc.cim.mservice.api.BatchCalcBillIntReq;
import kd.tmc.cim.mservice.api.CalcBillIntReq;
import kd.tmc.cim.mservice.api.CalcDepositIntService;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CalcDepositIntServiceImpl
implements CalcDepositIntService {
    private static final DepositCalcIntService depositCalcIntService = new DepositCalcIntService();

    public IntBillInfo calcDepositInt(Long depositId, Date beginDate, Date endDate) {
        return depositCalcIntService.calcDepositBillInt(depositId, beginDate, endDate);
    }

    public Map<Long, IntBillInfo> batchCalcDepositInt(List<Long> depositIds, Date beginDate, Date endDate) {
        return depositCalcIntService.calcDepositBillInt(depositIds, beginDate, endDate);
    }

    public Map<Long, IntBillInfo> batchCalcDepositInt(BatchCalcBillIntReq request) {
        HashMap<Long, IntBillInfo> intBillMap = new HashMap<Long, IntBillInfo>(8);
        List requests = request.getRequests();
        if (EmptyUtil.isEmpty((Collection)requests)) {
            return intBillMap;
        }
        Map<Long, CalcBillIntReq> requestMap = requests.stream().collect(Collectors.toMap(CalcBillIntReq::getBillId, r -> r, (r1, r2) -> r2));
        ArrayList<Long> depositIds = new ArrayList<Long>(requestMap.keySet());
        Map depositMap = TmcDataServiceHelper.loadFromCache((Object[])depositIds.toArray(), (String)"cim_deposit");
        Map<Long, List<PlanCallResult>> repayMap = this.buildPlanCallResultList(requests);
        for (CalcBillIntReq intReq : requests) {
            Long depositId = intReq.getBillId();
            DynamicObject depositBill = (DynamicObject)depositMap.get(depositId);
            if (depositBill == null) {
                intBillMap.put(depositId, this.buildEmptyIntBill());
                continue;
            }
            List<PlanCallResult> repayList = repayMap.get(depositId);
            IntBillInfo billInfo = depositCalcIntService.calcDepositBillIntForReport(depositBill, intReq.getBeginDate(), intReq.getEndDate(), repayList);
            if (billInfo == null) {
                billInfo = new IntBillInfo();
                billInfo.setAmount(BigDecimal.ZERO);
                IntBillDetailInfo detailInfo = new IntBillDetailInfo();
                BigDecimal principle = depositBill.getBigDecimal("amount");
                if (EmptyUtil.isNoEmpty(repayList)) {
                    BigDecimal releaseAmount = repayList.stream().filter(r -> r.getBizDate().compareTo(intReq.getEndDate()) <= 0).map(PlanCallResult::getPrinciple).reduce(BigDecimal.ZERO, BigDecimal::add);
                    principle = principle.subtract(releaseAmount);
                }
                detailInfo.setPrinciple(principle);
                billInfo.setDetails(Collections.singletonList(detailInfo));
            }
            intBillMap.put(depositId, billInfo);
        }
        return intBillMap;
    }

    private IntBillInfo buildEmptyIntBill() {
        IntBillInfo intBillInfo = new IntBillInfo();
        intBillInfo.setAmount(BigDecimal.ZERO);
        return intBillInfo;
    }

    private Map<Long, List<PlanCallResult>> buildPlanCallResultList(List<CalcBillIntReq> requests) {
        HashMap<Long, List<PlanCallResult>> planMap = new HashMap<Long, List<PlanCallResult>>(requests.size());
        Map<Long, Date> depositIdMap = requests.stream().collect(Collectors.toMap(r -> r.getBillId(), r -> r.getEndDate()));
        QFilter filter = new QFilter("finbillno", "in", depositIdMap.keySet()).and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        QFilter online = new QFilter("tradechannel", "=", (Object)TradeChannelEnum.ONLINE.getValue());
        online.and(new QFilter("bebankstatus", "=", (Object)BeBillStatusEnum.TS.getValue()));
        QFilter tradeChannel = online.or(new QFilter("tradechannel", "!=", (Object)TradeChannelEnum.ONLINE.getValue()));
        filter.and(tradeChannel);
        DynamicObjectCollection releaseCols = QueryServiceHelper.query((String)"cim_release", (String)"finbillno,isrevenue,redeemdate,amount", (QFilter[])filter.toArray());
        Map<Long, List<DynamicObject>> releaseMap = releaseCols.stream().filter(r -> r.getDate("redeemdate").compareTo((Date)depositIdMap.get(r.getLong("finbillno"))) <= 0).collect(Collectors.groupingBy(r -> r.getLong("finbillno")));
        for (Long depositId : depositIdMap.keySet()) {
            List repayPlanList;
            List<DynamicObject> releaseBills = releaseMap.get(depositId);
            if (releaseBills != null) {
                repayPlanList = new ArrayList(releaseBills.size());
                for (DynamicObject releaseBill : releaseBills) {
                    PlanCallResult info = new PlanCallResult();
                    info.setBizDate(releaseBill.getDate("redeemdate"));
                    info.setPrinciple(releaseBill.getBigDecimal("amount"));
                    info.setPayInt(false);
                    repayPlanList.add(info);
                }
            } else {
                repayPlanList = Collections.emptyList();
            }
            planMap.put(depositId, repayPlanList);
        }
        return planMap;
    }
}

