/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.mservice.paybill;

import java.math.BigDecimal;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.common.helper.PushPayBillVerifyHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.inst.helper.BizBill2PayBillWriteBackHelper;
import kd.tmc.fbp.service.paywriteback.AbstractPayBillWriteBackService;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackParam;

public class Finsub2PayBillWriteBackService
extends AbstractPayBillWriteBackService {
    private static final String selectProps = "id,billno,currency,paybill,lockpayamt,amount,tradechannel,isinit,isrenewal,eassrcid,bebankstatus,ispushpay,billstatus,finservicestatus";

    protected void doSaveExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.updateBizBill(sourceBill, param.getPayBill().getPayBillId(), param.getPayBill().getAmount(), Boolean.TRUE);
    }

    protected void doSubmitExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.updateBizBill(sourceBill, param.getPayBill().getPayBillId(), param.getPayBill().getAmount(), Boolean.TRUE);
    }

    protected void doDeleteExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.updateBizBill(sourceBill, null, BigDecimal.ZERO, Boolean.FALSE);
    }

    protected void doChargebackExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.updateBizBill(sourceBill, null, BigDecimal.ZERO, Boolean.FALSE);
    }

    protected void doRenoteExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.updateBizBill(sourceBill, null, BigDecimal.ZERO, Boolean.FALSE);
    }

    protected void doSaveValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSaveValidateExecute(param, sourceBill);
        this.validateBizCore(sourceBill);
        BizBill2PayBillWriteBackHelper.checkPayTypeWhenOnline((PayBillWriteBackParam)param, (DynamicObject)sourceBill);
    }

    protected void doSubmitValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSubmitValidateExecute(param, sourceBill);
        this.validateBizCore(sourceBill);
        BizBill2PayBillWriteBackHelper.checkPayTypeWhenOnline((PayBillWriteBackParam)param, (DynamicObject)sourceBill);
    }

    protected void doPayValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        super.doPayValidateExecute(param, sourceBill);
        this.validateBizCore(sourceBill);
        BizBill2PayBillWriteBackHelper.checkPayTypeWhenOnline((PayBillWriteBackParam)param, (DynamicObject)sourceBill);
    }

    protected DynamicObject getSourceBill(PayBillWriteBackParam.PayBillInfo payBillInfo) {
        return TmcDataServiceHelper.loadSingle((String)"cim_finsubscribe", (String)selectProps, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)payBillInfo.getSourceBillId())});
    }

    protected Long getSourceBillCurrencyId(DynamicObject sourceBill) {
        return Optional.ofNullable(sourceBill).map(r -> r.getDynamicObject("currency")).map(r -> r.getLong("id")).orElse(0L);
    }

    protected BigDecimal getSourceBillPayAmount(DynamicObject sourceBill) {
        return Optional.ofNullable(sourceBill.getBigDecimal("amount")).orElse(BigDecimal.ZERO);
    }

    private void updateBizBill(DynamicObject sourceBill, Long payBillId, BigDecimal lockPayAmt, boolean isPushPay) {
        sourceBill.set("paybill", (Object)payBillId);
        sourceBill.set("lockpayamt", (Object)lockPayAmt);
        sourceBill.set("ispushpay", (Object)isPushPay);
        this.DBTxBizUpdate(sourceBill);
    }

    private void validateBizCore(DynamicObject sourceBill) {
        String msg = PushPayBillVerifyHelper.verifyFinsubBill((DynamicObject)sourceBill);
        if (EmptyUtil.isNoEmpty((String)msg)) {
            throw new KDBizException(msg);
        }
    }
}

