/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.mservice.recwriteback;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.common.enums.RevenueSortEnum;
import kd.tmc.cim.common.helper.PushRecBillVerifyHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.recwriteback.AbstractRecBillWriteBackService;
import kd.tmc.fbp.service.recwriteback.RecBillWriteBackParam;

public class DptRevenueRecBillWriteBackService
extends AbstractRecBillWriteBackService {
    private static final String SELECT_PROP = "id,billno,billstatus,currency.id,actpreinstamt,recbillno,recaccount,isinit,ishistorybuild,combineinst,revenuesort,srcreleaseid";

    protected void doSaveExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSaveExecute(param, sourceBill);
        sourceBill.set("recbillno", (Object)param.getRecBill().getRecBillNo());
        this.DBTxBizUpdate(sourceBill);
    }

    protected void doSubmitExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSubmitExecute(param, sourceBill);
        this.doSaveExecute(param, sourceBill);
    }

    protected void doDeleteExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doDeleteExecute(param, sourceBill);
        sourceBill.set("recbillno", null);
        this.DBTxBizUpdate(sourceBill);
    }

    protected void doSaveValidateExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSaveValidateExecute(param, sourceBill);
        this.validateBizCore(sourceBill);
    }

    protected void doSubmitValidateExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSubmitValidateExecute(param, sourceBill);
        this.validateBizCore(sourceBill);
    }

    protected DynamicObject getSourceBill(RecBillWriteBackParam param) {
        return TmcDataServiceHelper.loadSingle((Object)param.getRecBill().getSourceBillId(), (String)"cim_dptrevenue", (String)SELECT_PROP);
    }

    protected Long getSourceBillCurrencyId(RecBillWriteBackParam param, DynamicObject sourceBill) {
        return sourceBill.getLong("currency.id");
    }

    protected BigDecimal getSourceBillRecAmount(RecBillWriteBackParam param, DynamicObject sourceBill) {
        return sourceBill.getBigDecimal("actpreinstamt");
    }

    private void validateBizCore(DynamicObject sourceBill) {
        String msg;
        Set<Object> releaseSet = new HashSet(8);
        if (RevenueSortEnum.redeem_revenue.getValue().equals(sourceBill.getString("revenuesort")) && EmptyUtil.isNoEmpty((Long)sourceBill.getLong("srcreleaseid"))) {
            long srcReleaseId = sourceBill.getLong("srcreleaseid");
            QFilter qFilter = new QFilter("id", "=", (Object)srcReleaseId);
            qFilter.and(new QFilter("accepttransfer", "=", (Object)Boolean.TRUE));
            Object[] releaseBills = TmcDataServiceHelper.load((String)"cim_release", (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)"", (int)-1);
            if (EmptyUtil.isNoEmpty((Object[])releaseBills)) {
                releaseSet = Arrays.stream(releaseBills).map(r -> r.getLong("id")).collect(Collectors.toSet());
            }
        }
        if (EmptyUtil.isNoEmpty((String)(msg = PushRecBillVerifyHelper.verifyDptRevenueBill((DynamicObject)sourceBill, (String)"", releaseSet)))) {
            throw new KDBizException(msg);
        }
    }
}

