/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.mservice.recwriteback;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.tmc.cim.common.helper.PushRecBillVerifyHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.recwriteback.AbstractRecBillWriteBackService;
import kd.tmc.fbp.service.recwriteback.RecBillWriteBackParam;

public class RevenueRecBillWriteBackService
extends AbstractRecBillWriteBackService {
    private static final String SELECT_PROP = "id,billno,billstatus,currency.id,amount,recbillno,ispushrec,revenuesort,combineinst,isinit,redeemid";

    protected void doSaveExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSaveExecute(param, sourceBill);
        sourceBill.set("recbillno", (Object)param.getRecBill().getRecBillNo());
        sourceBill.set("ispushrec", (Object)Boolean.TRUE);
        this.DBTxBizUpdate(sourceBill);
    }

    protected void doSubmitExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSubmitExecute(param, sourceBill);
        this.doSaveExecute(param, sourceBill);
    }

    protected void doDeleteExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doDeleteExecute(param, sourceBill);
        sourceBill.set("recbillno", null);
        sourceBill.set("ispushrec", (Object)Boolean.FALSE);
        this.DBTxBizUpdate(sourceBill);
    }

    protected void doSaveValidateExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSaveValidateExecute(param, sourceBill);
        this.validateBizCore(sourceBill);
    }

    protected void doSubmitValidateExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSubmitValidateExecute(param, sourceBill);
        this.validateBizCore(sourceBill);
    }

    protected DynamicObject getSourceBill(RecBillWriteBackParam param) {
        return TmcDataServiceHelper.loadSingle((Object)param.getRecBill().getSourceBillId(), (String)"cim_revenue", (String)SELECT_PROP);
    }

    protected Long getSourceBillCurrencyId(RecBillWriteBackParam param, DynamicObject sourceBill) {
        return sourceBill.getLong("currency.id");
    }

    protected BigDecimal getSourceBillRecAmount(RecBillWriteBackParam param, DynamicObject sourceBill) {
        return sourceBill.getBigDecimal("amount");
    }

    private void validateBizCore(DynamicObject sourceBill) {
        String msg = PushRecBillVerifyHelper.verifyRevenueBill((DynamicObject)sourceBill);
        if (EmptyUtil.isNoEmpty((String)msg)) {
            throw new KDBizException(msg);
        }
    }
}

