/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.feedetailbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FeeDetailSrcBillStatusEnum;
import kd.tmc.fbp.common.enums.FeeSourceEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FeeDetailBillList
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(FeeDetailBillList.class);

    public void setFilter(SetFilterEvent e) {
        QFilter dataIsoRateFilter = new QFilter("feesource", "in", Arrays.asList(FeeSourceEnum.HAND.getValue(), FeeSourceEnum.BIZPATCH.getValue(), FeeSourceEnum.BATCHINPUT.getValue())).or(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and(new QFilter("feesource", "=", (Object)FeeSourceEnum.LINKGEN.getValue())));
        String billFormId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        String appSource = TmcBusinessBaseHelper.getDefaultBizType((String)billFormId);
        dataIsoRateFilter.and(new QFilter("appsource", "=", (Object)appSource));
        if ("gm".equals(appSource) && billFormId != null && billFormId.endsWith("_feebill")) {
            dataIsoRateFilter.and(new QFilter("entry.producttype", "=", (Object)Long.valueOf(ProductTypeEnum.GM_LETTEROFGUARANTEE.getId())).or("entry", "is null", null));
        } else if ("gm".equals(appSource) && billFormId != null && billFormId.endsWith("_pledgefeebill")) {
            dataIsoRateFilter.and(new QFilter("entry.producttype", "=", (Object)Long.valueOf(ProductTypeEnum.GM_PLEDGEBILL.getId())).or("entry", "is null", null));
        } else if ("gm".equals(appSource) && billFormId != null && billFormId.endsWith("_contractfeebill")) {
            dataIsoRateFilter.and(new QFilter("entry.producttype", "=", (Object)Long.valueOf(ProductTypeEnum.GM_GUARANTEECONTRACT.getId())).or("entry", "is null", null));
        }
        e.getQFilters().add(dataIsoRateFilter);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection dataList = super.getData(arg0, arg1);
                if (dataList.isEmpty()) {
                    return dataList;
                }
                if (!((DynamicObject)dataList.get(0)).containsProperty("entry.id")) {
                    return dataList;
                }
                Map<Object, List<DynamicObject>> groups = dataList.stream().collect(Collectors.groupingBy(d -> d.get("id")));
                logger.info("\u5904\u7406\u524d\u7684\u5206\u7ec4\uff1a---" + SerializationUtils.toJsonString(groups));
                DynamicObject[] feeBill = TmcDataServiceHelper.load((String)"cfm_feebill", (String)"id,entry.id,entry.srcstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", groups.keySet())});
                ArrayList<Long> needChangeEntryId = new ArrayList<Long>();
                HashSet needDeleteEntrys = new HashSet();
                for (DynamicObject fee : feeBill) {
                    boolean existCanShowBill;
                    DynamicObjectCollection entry = fee.getDynamicObjectCollection("entry");
                    boolean bl = existCanShowBill = entry.size() == 0 || entry.stream().anyMatch(row -> !FeeDetailSrcBillStatusEnum.NOAUDIT.getValue().equals(row.getString("srcstatus")));
                    if (!existCanShowBill) {
                        needChangeEntryId.add(fee.getLong("id"));
                    }
                    needDeleteEntrys.addAll(entry.stream().filter(row -> FeeDetailSrcBillStatusEnum.NOAUDIT.getValue().equals(row.getString("srcstatus"))).map(row -> row.getLong("id")).collect(Collectors.toList()));
                }
                if (EmptyUtil.isNoEmpty(needChangeEntryId)) {
                    needChangeEntryId.forEach(id -> {
                        DynamicObject row = (DynamicObject)((List)groups.get(id)).get(0);
                        if (row.containsProperty("entry.seq")) {
                            row.set("entry.seq", null);
                        }
                        if (row.containsProperty("entry.producttype")) {
                            row.set("entry.producttype", null);
                        }
                        if (row.containsProperty("entry.srcbillno")) {
                            row.set("entry.srcbillno", null);
                        }
                        if (row.containsProperty("entry.feeratio")) {
                            row.set("entry.feeratio", null);
                        }
                        if (row.containsProperty("entry.feedetailamt")) {
                            row.set("entry.feedetailamt", null);
                        }
                        if (row.containsProperty("entry.remark")) {
                            row.set("entry.remark", null);
                        }
                    });
                }
                logger.info("\u5904\u7406\u540e\u7684\u5206\u7ec4\uff1a---" + SerializationUtils.toJsonString(groups));
                dataList.removeIf(row -> needDeleteEntrys.contains(row.getLong("entry.id")) && EmptyUtil.isNoEmpty((String)row.getString("entry.srcbillno")));
                return dataList;
            }
        });
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("settle".equals(operateKey) || "unsettle".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }
}

