/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.attachment;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.ExpressionFromHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.ExpressionType;

public class AttachmentTypeEdit
extends AbstractFormPlugin {
    private static final String FORM_PLUGIN_MODULE = "tmc-fbd-formplugin";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"condition", "atcondition", "hide"});
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.showNotifyIfExistBillEntity();
        this.initAttachOperateNodeMulCombo();
        this.getModel().setValue("savecondition", null);
        this.getModel().setValue("savecondition_tag", null);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.showNotifyIfExistBillEntity();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getModel().getDataEntity().getDataEntityState().getFromDatabase()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"notifyflexpanel"});
        }
        this.initAttachOperateNodeMulCombo();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData changedata = e.getChangeSet()[0];
        Object newValue = changedata.getNewValue();
        int rowIndex = changedata.getRowIndex();
        IDataModel model = this.getModel();
        switch (propName) {
            case "billentity": {
                if (newValue == null) {
                    return;
                }
                model.setValue("condition", null);
                model.setValue("savecondition", null);
                model.setValue("savecondition_tag", null);
                model.deleteEntryData("entryentity");
                this.initAttachOperateNodeMulCombo();
                this.showNotifyIfExistBillEntity();
                break;
            }
            case "number": {
                if (EmptyUtil.isEmpty((Object)newValue)) {
                    return;
                }
                boolean existNumber = this.validatedNumber();
                if (!existNumber) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d \u503c \u201c{0}\u201d \u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"AttachmentTypeEdit_1", (String)FORM_PLUGIN_MODULE, (Object[])new Object[]{newValue}), Integer.valueOf(2000));
                return;
            }
            case "condition": {
                if (!EmptyUtil.isEmpty((Object)newValue)) break;
                model.setValue("savecondition", null);
                model.setValue("savecondition_tag", null);
                return;
            }
            case "atcondition": {
                if (!EmptyUtil.isEmpty((Object)newValue)) break;
                model.setValue("atsavecondition", null);
                model.setValue("atsavecondition_tag", null);
                return;
            }
            case "atoperatenode": {
                if (newValue == null) {
                    return;
                }
                if (((String)newValue).length() <= 500) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u9644\u4ef6\u5206\u7c7b\u4fe1\u606f\u201d\u5206\u5f55\u7b2c{0}\u884c\uff1a\u201c\u5fc5\u4f20\u6821\u9a8c\u8282\u70b9\u201d\u540e\u53f0\u6570\u636e\u5e93\u5b57\u6bb5\u8d85\u957f\uff0c\u8bf7\u51cf\u5c11\u8282\u70b9\u3002", (String)"AttachmentTypeEdit_2", (String)FORM_PLUGIN_MODULE, (Object[])new Object[]{rowIndex + 1}));
                model.setValue("atoperatenode", null);
                return;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control ctr = (Control)evt.getSource();
        switch (key = ctr.getKey()) {
            case "condition": {
                this.openExpressionForm(key, "savecondition_tag", "savecondition_tag");
                break;
            }
            case "atcondition": {
                this.openExpressionForm(key, "atsavecondition_tag", "atsavecondition_tag");
                break;
            }
            case "hide": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"notifyflexpanel"});
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "savecondition_tag": {
                ExpressionFromHelper.dealCallbackOfCloseForm((ClosedCallBackEvent)evt, (String)"condition", (String)"savecondition_tag", (AbstractFormPlugin)this);
                break;
            }
            case "atsavecondition_tag": {
                ExpressionFromHelper.dealCallbackOfCloseForm((ClosedCallBackEvent)evt, (String)"atcondition", (String)"atsavecondition_tag", (AbstractFormPlugin)this);
                break;
            }
        }
    }

    private void initAttachOperateNodeMulCombo() {
        DynamicObject sourceEntityType = (DynamicObject)this.getModel().getValue("billentity");
        if (EmptyUtil.isEmpty((DynamicObject)sourceEntityType)) {
            return;
        }
        ArrayList comboItems = new ArrayList(10);
        MulComboEdit comboEdit = (MulComboEdit)this.getControl("atoperatenode");
        List opList = EntityMetadataCache.getDataEntityOperate((String)sourceEntityType.getString("number"));
        opList.forEach(op -> {
            ComboItem comboItem = new ComboItem();
            Map name = (Map)op.get("name");
            comboItem.setCaption(new LocaleString((String)name.get(Lang.get().toString())));
            comboItem.setValue((String)op.get("key"));
            comboItems.add(comboItem);
        });
        comboEdit.setComboItems(comboItems);
    }

    private void showNotifyIfExistBillEntity() {
        DynamicObject sourceEntityType = (DynamicObject)this.getModel().getValue("billentity");
        boolean exist = false;
        if (EmptyUtil.isNoEmpty((DynamicObject)sourceEntityType)) {
            exist = TmcDataServiceHelper.exists((String)"fbd_attachmenttype", (QFilter[])new QFilter[]{new QFilter("billentity", "=", sourceEntityType.getPkValue()), new QFilter("enable", "=", (Object)"1")});
        }
        this.getView().setVisible(Boolean.valueOf(exist), new String[]{"notifyflexpanel"});
    }

    private boolean validatedNumber() {
        String number = (String)this.getModel().getValue("number");
        return TmcDataServiceHelper.exists((String)"fbd_attachmenttype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter("id", "!=", this.getModel().getDataEntity().getPkValue())});
    }

    public void openExpressionForm(String clickKey, String fieldSign, String callbackId) {
        String conditionJson;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String sourceBillId = Optional.ofNullable(dataEntity.getDynamicObject("billentity")).map(o -> o.getString("number")).orElse(null);
        if (EmptyUtil.isEmpty((String)sourceBillId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u540d\u79f0\u3002", (String)"AttachmentTypeEdit_0", (String)FORM_PLUGIN_MODULE, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.equals((CharSequence)clickKey, (CharSequence)"atcondition")) {
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", index);
            conditionJson = rowEntity.getString(fieldSign);
        } else if (StringUtils.equals((CharSequence)clickKey, (CharSequence)"condition")) {
            conditionJson = dataEntity.getString(fieldSign);
        } else {
            return;
        }
        String fieldNode = ExpressionFromHelper.getSourceBillFieldNode((String)sourceBillId, (String)fieldSign, (ExpressionType)ExpressionType.Condition, (boolean)false, null, (AbstractFormPlugin)this);
        ExpressionFromHelper.openExpressionForm((String)"fbd_apply_condition", (String)sourceBillId, (String)conditionJson, (String)fieldNode, (String)callbackId, (AbstractFormPlugin)this);
    }
}

