/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.companyprop;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbd.common.enums.GroupInOutEnum;
import kd.tmc.fbd.common.helper.ComapnyManagePropHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CompanyManagePropEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final Pattern PATTERN = Pattern.compile("^([0-9]|[A-Z]){18}$");
    private static final String NOTIFYFLEXPANEL = "notifyflexpanel";
    private static final String CHECKFLEXPANEL = "checkflexpanel";
    private static final String UPDATENOW = "updatenow";
    private static final String UPDATENOW1 = "updatenow1";
    private static final String HIDE = "hide";
    private static final String HIDE1 = "hide1";
    private static final String SELECTORG = "selectorg";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{UPDATENOW, UPDATENOW1, HIDE, HIDE1, "stockright"});
        BasedataEdit org = (BasedataEdit)this.getControl(SELECTORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue(SELECTORG);
        this.showTips(org);
        this.setOrgPatternValue(org);
    }

    public void afterCreateNewData(EventObject e) {
        Long org;
        boolean exsit;
        String orgId;
        super.afterCreateNewData(e);
        if (null != this.getView().getParentView() && EmptyUtil.isNoEmpty((String)(orgId = this.getView().getParentView().getPageCache().get("orgid"))) && !(exsit = TmcDataServiceHelper.exists((String)"fbd_company_manageprop", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)(org = Long.valueOf(orgId)))}))) {
            this.getModel().setValue(SELECTORG, (Object)org);
            this.getModel().setValue("org", (Object)org);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String property = evt.getProperty().getName();
        if (SELECTORG.equals(property)) {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getCustomParams().put("orgFuncId", "08");
            String appId = EntityMetadataCache.getDataEntityType((String)"fbd_company_manageprop").getAppId();
            List permIds = ComapnyManagePropHelper.getAuthorizedBankOrgFromCache((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"fbd_company_manageprop", (String)"47150e89000000ac").stream().map(s -> s.getLong("id")).collect(Collectors.toList());
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("id", "in", permIds));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Long id;
        DynamicObject model;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("startchange".equals(operateKey) && (model = TmcDataServiceHelper.loadSingleFromCache((Object)(id = Long.valueOf(this.getModel().getDataEntity().getLong("id"))), (String)"fbd_company_manageprop", (String)"ischanging")).getBoolean("ischanging")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5df2\u5ba1\u6838\u201d\u4e14\u975e\u201c\u53d8\u66f4\u4e2d\u201d\u7684\u8d44\u91d1\u7ec4\u7ec7\u7ba1\u7406\u5c5e\u6027\uff0c\u624d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"CompanyManagePropEdit_5", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldName = e.getProperty().getName();
        int rowIdx = e.getChangeSet()[0].getRowIndex();
        switch (fieldName) {
            case "selectorg": {
                DynamicObject org = (DynamicObject)this.getModel().getValue(SELECTORG);
                this.getModel().setValue("org", (Object)org);
                this.showTips(org);
                this.setOrgPatternValue(org);
                break;
            }
            case "groupinout": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"stockright", null, (int)rowIdx);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"stockrightorgid", null, (int)rowIdx);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"proportion", null, (int)rowIdx);
                break;
            }
            case "proportion": {
                ChangeData changeData = e.getChangeSet()[0];
                BigDecimal newValue = (BigDecimal)changeData.getNewValue();
                if (!this.checkProportionSum(newValue)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u80a1\u6743\u5360\u6bd4\u4e4b\u548c\u5e94\u5c0f\u4e8e\u7b49\u4e8e100\u3002", (String)"CompanyManagePropEdit_2", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)fieldName, null, (int)rowIdx);
                break;
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        if (EmptyUtil.isNoEmpty((Object)value)) {
            int rowIdx = e.getRowIndex();
            String groupInOut = (String)this.getModel().getValue("groupinout", rowIdx);
            switch (key) {
                case "stockright": {
                    if (this.checkGroupInOut(e, key, rowIdx, groupInOut) || !GroupInOutEnum.INGROUP.getValue().equals(groupInOut)) break;
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u96c6\u56e2\u5185\u65f6\uff0c\u4e0d\u80fd\u76f4\u63a5\u8f93\u5165\uff0c\u8bf7\u901a\u8fc7\u70b9\u51fb\u9009\u62e9\u3002", (String)"CompanyManagePropEdit_1", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                    this.getView().updateView(key, rowIdx);
                    break;
                }
                case "proportion": {
                    BigDecimal decimalValue;
                    if (this.checkGroupInOut(e, key, rowIdx, groupInOut) || this.checkStockRight(e, key, rowIdx, groupInOut) || (decimalValue = new BigDecimal(String.valueOf(value))).compareTo(Constants.ZERO) >= 0) break;
                    e.setCancel(true);
                    this.getModel().setValue(key, null, rowIdx);
                    this.getView().updateView(key, rowIdx);
                    break;
                }
                case "logoutdate": {
                    if (!this.checkLogOutDate(value)) break;
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ce8\u9500\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u6210\u7acb\u65e5\u671f\u3002", (String)"CompanyManagePropEdit_3", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                    this.getView().updateView(key);
                    break;
                }
            }
        }
    }

    private boolean checkStockRight(BeforeFieldPostBackEvent e, String key, int rowIdx, String groupInOut) {
        String stockRight = (String)this.getModel().getValue("stockright", rowIdx);
        if (EmptyUtil.isEmpty((String)stockRight)) {
            e.setCancel(true);
            if (GroupInOutEnum.INGROUP.getValue().equals(groupInOut)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u80a1\u6743\u65b9\u3002", (String)"CompanyManagePropEdit_6", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u80a1\u6743\u65b9\u3002", (String)"CompanyManagePropEdit_7", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            }
            this.getView().updateView(key, rowIdx);
            return true;
        }
        return false;
    }

    private boolean checkGroupInOut(BeforeFieldPostBackEvent e, String key, int rowIdx, String groupInOut) {
        if (EmptyUtil.isEmpty((String)groupInOut)) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u96c6\u56e2\u5185/\u96c6\u56e2\u5916\u201d\u3002", (String)"CompanyManagePropEdit_4", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            this.getView().updateView(key, rowIdx);
            return true;
        }
        return false;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "updatenow": 
            case "updatenow1": {
                this.showOrgForm();
                break;
            }
            case "hide": {
                this.closeTips(NOTIFYFLEXPANEL);
                break;
            }
            case "hide1": {
                this.closeTips(CHECKFLEXPANEL);
                break;
            }
            case "stockright": {
                int row = this.getModel().getEntryCurrentRowIndex("stockentry");
                String groupInOut = (String)this.getModel().getValue("groupinout", row);
                if (EmptyUtil.isEmpty((String)groupInOut)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u96c6\u56e2\u5185/\u96c6\u56e2\u5916\u201d\u3002", (String)"CompanyManagePropEdit_4", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.showOrgF7(row);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (EmptyUtil.isEmpty((Object)returnData)) {
            return;
        }
        if ("stock_right_f7_callback".equals(actionId)) {
            ListSelectedRowCollection rowDataCol = (ListSelectedRowCollection)evt.getReturnData();
            ListSelectedRow selectedRow = rowDataCol.get(0);
            int row = this.getModel().getEntryCurrentRowIndex("stockentry");
            this.getModel().setValue("stockright", (Object)selectedRow.getName(), row);
            this.getModel().setValue("stockrightorgid", selectedRow.getPrimaryKeyValue(), row);
        }
    }

    private boolean checkProportionSum(BigDecimal decimalValue) {
        if (decimalValue.compareTo(Constants.ONE_HUNDRED) > 0) {
            return true;
        }
        DynamicObjectCollection stockEntry = this.getModel().getEntryEntity("stockentry");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)stockEntry)) {
            BigDecimal sum = stockEntry.stream().map(e -> e.getBigDecimal("proportion")).reduce(BigDecimal.ZERO, BigDecimal::add);
            return sum.compareTo(Constants.ONE_HUNDRED) > 0;
        }
        return false;
    }

    private boolean checkLogOutDate(Object value) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            return false;
        }
        Date establishMentDate = org.getDate("establishmentdate");
        if (EmptyUtil.isEmpty((Object)establishMentDate)) {
            return false;
        }
        Date logOutDate = DateUtils.stringToDate((String)((String)value), (String)"yyyy-MM-dd");
        return logOutDate.before(establishMentDate);
    }

    private void showOrgF7(int rowIndex) {
        String groupInOut = (String)this.getModel().getValue("groupinout", rowIndex);
        if (GroupInOutEnum.OUTGROUP.getValue().equals(groupInOut)) {
            return;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setLookUp(true);
        showParameter.setShowTitle(false);
        showParameter.setBillFormId("bos_org");
        showParameter.setFormId("bos_orgtreelistf7");
        showParameter.setMultiSelect(false);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "stock_right_f7_callback"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showOrgForm() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("bos_org");
        showParameter.setPkId(org.getPkValue());
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showTips(DynamicObject org) {
        this.getView().setVisible(Boolean.valueOf(EmptyUtil.isNoEmpty((DynamicObject)org)), new String[]{NOTIFYFLEXPANEL});
        if (EmptyUtil.isNoEmpty((DynamicObject)org)) {
            String uniformSocialCreditCode = org.getString("uniformsocialcreditcode");
            this.getView().setVisible(Boolean.valueOf(EmptyUtil.isNoEmpty((String)uniformSocialCreditCode) && !PATTERN.matcher(uniformSocialCreditCode).matches()), new String[]{CHECKFLEXPANEL});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CHECKFLEXPANEL});
        }
    }

    private void setOrgPatternValue(DynamicObject org) {
        if (EmptyUtil.isNoEmpty((DynamicObject)org)) {
            DynamicObject orgPattern = org.getDynamicObject("orgpattern");
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"orgpattern", (Object)orgPattern);
        }
    }

    private void closeTips(String panel) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{panel});
    }
}

