/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.companyprop;

import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;

public class CompanyManagePropPlugin
extends AbstractFormPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult != null && operationResult.isSuccess() && !operationResult.getSuccessPkIds().isEmpty()) {
            String operateKey = args.getOperateKey();
            long successId = (Long)operationResult.getSuccessPkIds().get(0);
            switch (operateKey) {
                case "startchange": {
                    this.openChangeBill(successId);
                    break;
                }
                case "viewchgrecord": {
                    this.openChgList(successId);
                    break;
                }
            }
        }
    }

    private void openChangeBill(Long selectedId) {
        BillShowParameter bsp = new BillShowParameter();
        bsp.setFormId("fbd_company_fillchg");
        bsp.setPkId((Object)selectedId);
        bsp.setBillStatus(BillOperationStatus.EDIT);
        bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        bsp.setCustomParam("source", (Object)"billchange");
        this.getView().showForm((FormShowParameter)bsp);
    }

    private void openChgList(Long selectedId) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("fbd_company_chg");
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        QFilter qFilter = new QFilter("srcbillpk", "=", (Object)String.valueOf(selectedId));
        qFilter.and("srcbilltype", "=", (Object)"fbd_company_manageprop");
        parameter.getListFilterParameter().setFilter(qFilter);
        parameter.getCustomParams().put("dataSource", "bizBill");
        this.getView().showForm((FormShowParameter)parameter);
    }
}

