/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.companysys;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeDragEvent;
import kd.bos.form.control.events.TreeNodeDragListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgApiResult;
import kd.bos.org.model.OrgParam;
import kd.bos.org.model.ViewSchemaParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbd.common.helper.CompanySysViewHelper;
import kd.tmc.fbd.common.util.BDUtil;
import kd.tmc.fbd.common.util.CompanySysUtil;
import kd.tmc.fbd.formplugin.companysys.CompanySysViewSaveTask;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CompanySysAuthScopeEnum;
import kd.tmc.fbp.common.enums.CompanySysAuthTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.collections.MapUtils;

public class CompanySysViewEdit
extends AbstractBasePlugIn
implements ClickListener,
TreeNodeCheckListener,
TreeNodeDragListener,
SearchEnterListener,
TreeNodeClickListener {
    private static final Log logger = LogFactory.getLog(CompanySysViewEdit.class);
    private static final String BIZUNITTREE = "bizunittree";
    private static final String BIZVIEWTREE = "bizviewtree";
    private static final String ISCHECKUNITCHILD = "ischeckunitchild";
    private static final String BTN_UNCHECKUNIT = "btn_uncheckunit";
    private static final String BTN_ADDNODE = "btn_addnode";
    private static final String BTN_DELETENODE = "btn_deletenode";
    private static final String BTN_SAVE = "bar_save";
    private static final String UNIT_ROOT = "unittreenode";
    private static final String VIEW_ROOT = "viewtreenode";
    private static final String ALL_NODE_CACHE = "allNodeCache";
    private static final String VIEW_NODE_CACHE = "viewNodeCache";
    private TreeView bizunittree;
    private TreeView bizviewtree;
    private static final int SAVE_SYNC = 50;

    public void initialize() {
        super.initialize();
        this.bizunittree = (TreeView)this.getView().getControl(BIZUNITTREE);
        this.bizviewtree = (TreeView)this.getView().getControl(BIZVIEWTREE);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ISCHECKUNITCHILD, BTN_UNCHECKUNIT, BTN_ADDNODE, BTN_DELETENODE});
        this.bizunittree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        this.bizviewtree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        this.bizunittree.addTreeNodeDragListener((TreeNodeDragListener)this);
        this.bizviewtree.addTreeNodeDragListener((TreeNodeDragListener)this);
        Search orgsearchap = (Search)this.getView().getControl("orgsearchap");
        orgsearchap.addEnterListener((SearchEnterListener)this);
        Search viewsearchap = (Search)this.getView().getControl("viewsearchap");
        viewsearchap.addEnterListener((SearchEnterListener)this);
    }

    public void click(EventObject e) {
        String key;
        switch (key = ((Control)e.getSource()).getKey()) {
            case "btn_addnode": {
                this.addNode();
                break;
            }
            case "btn_deletenode": {
                this.deleteNode();
                break;
            }
            case "clear": {
                TreeNode bizTree = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(BIZUNITTREE), TreeNode.class);
                this.bizviewtree.deleteAllNodes();
                this.bizviewtree.addNode(new TreeNode(bizTree.getParentid(), bizTree.getId(), bizTree.getText()));
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("orgproperty".equals(name)) {
            ChangeData changeData = e.getChangeSet()[0];
            DynamicObject newValue = (DynamicObject)changeData.getNewValue();
            this.filterProperty(newValue);
        } else if ("scope".equals(name)) {
            ChangeData changeData = e.getChangeSet()[0];
            String scopeVal = (String)changeData.getNewValue();
            if (CompanySysAuthScopeEnum.AUTH.getValue().equals(scopeVal)) {
                this.setCreatorAuth();
            }
        }
    }

    private void filterProperty(DynamicObject newValue) {
        this.bizunittree.deleteAllNodes();
        QFilter qf = null;
        if (newValue != null) {
            qf = new QFilter("org.orgpattern.name", "=", (Object)newValue.getString("name"));
        }
        String def = this.getPageCache().get("mainViewId");
        Map unitTreeMap = CompanySysUtil.getAllOrgByViewId((Long)Long.parseLong(def), (QFilter)qf);
        Map allTreeMap = CompanySysUtil.getAllOrgByViewId((Long)Long.parseLong(def));
        Map flatOrgTreeMap = CompanySysUtil.getOrgTreeMap((Map)unitTreeMap);
        TreeNode unitRoot = CompanySysUtil.createTreeNode((Map)unitTreeMap);
        if (unitRoot == null) {
            this.getInfo(unitTreeMap, allTreeMap);
            TreeNode tree = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(UNIT_ROOT), TreeNode.class);
            if (unitTreeMap.get(tree.getId()) == null) {
                unitTreeMap.put(tree.getId(), allTreeMap.get(tree.getId()));
            }
            unitRoot = CompanySysUtil.createTreeNode((Map)unitTreeMap);
            flatOrgTreeMap = CompanySysUtil.getOrgTreeMap((Map)unitTreeMap);
        }
        CompanySysUtil.createChildNodes((Map)flatOrgTreeMap, (String)unitRoot.getId(), (TreeNode)unitRoot);
        this.bizunittree.addNode(unitRoot);
    }

    private void setCreatorAuth() {
        Object userEntity = this.getModel().getEntryEntity("userentity");
        if (CollectionUtils.isNotEmpty((Collection)userEntity)) {
            userEntity = userEntity.stream().filter(t -> Objects.nonNull(t.get("user"))).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)userEntity)) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            Long creatorId = ((DynamicObject)this.getModel().getValue("creator")).getLong("id");
            model.beginInit();
            List<Map<String, Object>> mapList = this.loadUserByIds(Collections.singletonList(creatorId), creatorId);
            TmcViewInputHelper.batchFillEntity((String)"userentity", (AbstractFormDataModel)model, mapList);
            model.endInit();
            this.getView().updateView("userentity");
        }
    }

    private void getInfo(Map<String, Map<String, String>> unitTreeMap, Map<String, Map<String, String>> allTreeMap) {
        Map parentMap = null;
        Optional<Map> opt = allTreeMap.values().stream().filter(item -> "0".equals(item.get("parentid"))).findFirst();
        if (opt.isPresent()) {
            parentMap = opt.get();
        }
        for (Map.Entry<String, Map<String, String>> unitTree : unitTreeMap.entrySet()) {
            Map<String, String> map = allTreeMap.get(unitTree.getKey());
            unitTreeMap.get(unitTree.getKey()).put("parentid", this.getParent(map.get("id"), allTreeMap, unitTreeMap, parentMap));
        }
    }

    private String getParent(String key, Map<String, Map<String, String>> allTreeMap, Map<String, Map<String, String>> unitTreeMap, Map<String, String> parentMap) {
        String parent = "";
        while (StringUtils.isBlank((CharSequence)parent)) {
            if (allTreeMap.containsKey(key)) {
                Map<String, String> map = allTreeMap.get(key);
                if (unitTreeMap.containsKey(key = map.get("parentid"))) {
                    parent = key;
                    continue;
                }
                if (!"0".equals(key)) continue;
                parent = map.get("id");
                continue;
            }
            if (null != parentMap) {
                parent = parentMap.get("id");
                continue;
            }
            Set parentids = allTreeMap.values().stream().map(item -> (String)item.get("parentid")).collect(Collectors.toSet());
            Set orgids = allTreeMap.values().stream().map(item -> (String)item.get("id")).collect(Collectors.toSet());
            parentids.removeAll(orgids);
            Optional<Map> first = allTreeMap.values().stream().filter(item -> parentids.contains(item.get("parentid")) && allTreeMap.containsKey(item.get("id"))).findFirst();
            if (!first.isPresent()) break;
            parent = (String)first.get().get("id");
            break;
        }
        return parent;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String opKey;
        super.beforeDoOperation(e);
        AbstractOperate operate = (AbstractOperate)e.getSource();
        switch (opKey = operate.getOperateKey()) {
            case "bizsave": {
                TreeNode viewTreeNode = this.getCachedRoot(VIEW_ROOT);
                if (viewTreeNode != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"CompanySysViewEdit_0", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
            case "deleteentry": {
                Object entryId = operate.getParameter().get("entryId");
                if (!"userentity".equals(entryId)) break;
                this.checkDeleteUser(e);
            }
        }
    }

    private void checkDeleteUser(BeforeDoOperationEventArgs e) {
        int[] select = ((EntryGrid)this.getControl("userentity")).getSelectRows();
        DynamicObjectCollection userEntity = this.getModel().getEntryEntity("userentity");
        for (int idx : select) {
            String defaultUser = ((DynamicObject)userEntity.get(idx)).getString("defaultuser");
            if (!"D".equals(defaultUser)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u4e3a\u89c6\u56fe\u521b\u5efa\u7528\u6237\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"CompanySysViewEdit_10", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        boolean isBizSave;
        boolean bl = isBizSave = Objects.nonNull(e.getOperationResult()) && e.getOperationResult().isSuccess() && e.getOperateKey().equals("bizsave");
        if (isBizSave) {
            String msg;
            Long id = (Long)this.getModel().getValue("id");
            Long pkId = this.saveModelValue();
            this.addViewAuth(pkId, EmptyUtil.isEmpty((Long)id));
            if (CompanySysViewHelper.idDefaultViewId((Long)id)) {
                this.getModel().setDataChanged(false);
                this.getView().returnDataToParent((Object)true);
                this.getView().close();
                return;
            }
            logger.info("\u8d44\u91d1\u89c6\u56fe\u6570\u636e\u4fdd\u5b58\u5f00\u59cb---");
            boolean isAddViewSchema = false;
            try (TXHandle h = TX.requiresNew();){
                try {
                    TreeNode viewRootNode = this.getViewRootNodes();
                    msg = this.addViewSchema(pkId);
                    if (EmptyUtil.isEmpty((String)msg)) {
                        isAddViewSchema = true;
                        List<OrgParam> orgParams = this.compareTreeNodeSave(viewRootNode);
                        msg = this.checkOrgParams(orgParams);
                    }
                }
                catch (Throwable e1) {
                    logger.error(e1);
                    h.markRollback();
                    msg = e1.getMessage();
                }
            }
            logger.info("\u8d44\u91d1\u89c6\u56fe\u6570\u636e\u4fdd\u5b58\u7ed3\u675f---");
            if (EmptyUtil.isNoEmpty((String)msg)) {
                this.getView().showTipNotification(msg, Integer.valueOf(6000));
                if (EmptyUtil.isEmpty((Long)id) && !isAddViewSchema) {
                    DeleteServiceHelper.delete((String)"fbd_companysysviewsch", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkId)});
                    DeleteServiceHelper.delete((String)"fbd_companysysauth", (QFilter[])new QFilter[]{new QFilter("companysysview", "=", (Object)pkId)});
                }
            } else if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get("bizsave"))) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u63d0\u4ea4\u540e\u53f0\u4efb\u52a1\u4fdd\u5b58\u3002", (String)"CompanySysViewEdit_12", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            } else {
                this.getModel().setDataChanged(false);
                this.getView().returnDataToParent((Object)true);
                this.getView().close();
            }
        }
    }

    private List<OrgParam> compareTreeNodeSave(TreeNode viewRootNode) {
        String cache = this.getPageCache().get(VIEW_NODE_CACHE);
        TreeNode viewCache = null;
        if (StringUtils.isNotEmpty((CharSequence)cache)) {
            viewCache = (TreeNode)SerializationUtils.fromJsonString((String)cache, TreeNode.class);
        }
        ArrayList<OrgParam> delParams = new ArrayList<OrgParam>(16);
        ArrayList<Tuple<Integer, OrgParam>> addParams = new ArrayList<Tuple<Integer, OrgParam>>(16);
        this.compareTree(delParams, addParams, viewRootNode, viewCache, 0);
        this.getPageCache().remove("bizsave");
        if (delParams.size() + addParams.size() > 50) {
            this.getPageCache().put("bizsave", "start");
            Object value = this.getModel().getValue("number");
            CompanySysViewSaveTask saveTask = new CompanySysViewSaveTask(RequestContext.get(), this.getView().getPageId(), value.toString(), addParams, delParams);
            ThreadPools.executeOnce((String)CompanySysViewSaveTask.class.getName(), (Runnable)saveTask);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_SAVE, BTN_ADDNODE, BTN_DELETENODE});
            this.getView().addClientCallBack("bizsave", Integer.valueOf(500));
        } else {
            CompanySysViewHelper.syncOrgUnitDuty(delParams, addParams);
        }
        return delParams;
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        if ("bizsave".equals(e.getName())) {
            String res = this.getPageCache().get("bizsave");
            if ("success".equals(res)) {
                this.getView().returnDataToParent((Object)true);
                this.getView().close();
            } else if ("fail".equals(res)) {
                this.getView().returnDataToParent((Object)false);
                this.getView().close();
            } else {
                this.getView().addClientCallBack("bizsave", Integer.valueOf(500));
            }
        }
    }

    private void compareTree(List<OrgParam> delParams, List<Tuple<Integer, OrgParam>> addParams, TreeNode node, TreeNode cache, int level) {
        if (Objects.isNull(node)) {
            if (Objects.nonNull(cache)) {
                delParams.addAll(this.getRevertNodeAndChildParam(cache));
            }
            return;
        }
        if (Objects.isNull(cache)) {
            addParams.add((Tuple<Integer, OrgParam>)Tuple.create((Object)level, (Object)this.buildParam(node)));
            this.compareChild(delParams, addParams, node, null, level + 1);
        } else if (this.isTreeNodeEqual(node, cache)) {
            this.compareChild(delParams, addParams, node, cache, level + 1);
        } else {
            addParams.add((Tuple<Integer, OrgParam>)Tuple.create((Object)level, (Object)this.buildParam(node)));
            this.compareChild(delParams, addParams, node, null, level + 1);
            delParams.addAll(this.getRevertNodeAndChildParam(cache));
        }
    }

    private void compareChild(List<OrgParam> delParams, List<Tuple<Integer, OrgParam>> addParams, TreeNode node, TreeNode cache, int level) {
        List cacheChi;
        List children = node.getChildren();
        List list = cacheChi = Objects.nonNull(cache) ? cache.getChildren() : null;
        if (CollectionUtils.isEmpty((Collection)children)) {
            Optional.ofNullable(cacheChi).orElseGet(Collections::emptyList).stream().flatMap(t -> this.getRevertNodeAndChildParam((TreeNode)t).stream()).filter(Objects::nonNull).forEach(delParams::add);
            return;
        }
        for (TreeNode child : children) {
            TreeNode findCache = this.findNode(child, cacheChi);
            this.compareTree(delParams, addParams, child, findCache, level);
            if (null == findCache || null == cacheChi) continue;
            cacheChi.remove(findCache);
        }
        Optional.ofNullable(cacheChi).orElseGet(Collections::emptyList).stream().flatMap(t -> this.getRevertNodeAndChildParam((TreeNode)t).stream()).filter(Objects::nonNull).forEach(delParams::add);
    }

    private List<OrgParam> getRevertNodeAndChildParam(TreeNode treeNode) {
        List<TreeNode> list = this.bsf(treeNode);
        List<OrgParam> params = list.stream().map(this::buildParam).collect(Collectors.toList());
        Collections.reverse(params);
        return params;
    }

    private List<TreeNode> bsf(TreeNode treeNode) {
        LinkedList<TreeNode> queue = new LinkedList<TreeNode>();
        ArrayList<TreeNode> list = new ArrayList<TreeNode>(16);
        if (Objects.isNull(treeNode)) {
            return list;
        }
        queue.add(treeNode);
        while (!queue.isEmpty()) {
            TreeNode cur = (TreeNode)queue.remove();
            if (CollectionUtils.isNotEmpty((Collection)cur.getChildren())) {
                queue.addAll(cur.getChildren());
            }
            list.add(cur);
        }
        return list;
    }

    private TreeNode findNode(TreeNode node, List<TreeNode> cacheList) {
        if (CollectionUtils.isEmpty(cacheList)) {
            return null;
        }
        for (TreeNode cache : cacheList) {
            if (!this.isTreeNodeEqual(node, cache)) continue;
            return cache;
        }
        return null;
    }

    private boolean isTreeNodeEqual(TreeNode node, TreeNode cache) {
        return Objects.equals(node.getId(), cache.getId()) && Objects.equals(node.getParentid(), cache.getParentid());
    }

    private OrgParam buildParam(TreeNode node) {
        OrgParam param = new OrgParam();
        param.setId(Long.parseLong(node.getId()));
        String parentId = node.getParentid();
        param.setDuty(this.getViewSchemaNumber());
        param.setParentId(parentId.equals("") ? 0L : Long.parseLong(parentId));
        return param;
    }

    private String checkOrgParams(List<OrgParam> orgParams) {
        StringBuilder str = new StringBuilder();
        for (OrgParam orgParam : orgParams) {
            if (orgParam.isSuccess()) continue;
            str.append(orgParam.getMsg());
        }
        return str.toString();
    }

    private Long saveModelValue() {
        IDataModel model = this.getModel();
        Long id = (Long)model.getValue("id");
        DynamicObject fundOrg = null;
        if (EmptyUtil.isNoEmpty((Long)id)) {
            fundOrg = TmcDataServiceHelper.loadSingle((Object)id, (String)"fbd_companysysviewsch");
        } else {
            fundOrg = TmcDataServiceHelper.newDynamicObject((String)"fbd_companysysviewsch");
            fundOrg.set("creator", (Object)RequestContext.get().getCurrUserId());
            fundOrg.set("enable", (Object)BaseEnableEnum.ENABLE.getValue());
            fundOrg.set("status", (Object)BillStatusEnum.AUDIT.getValue());
            fundOrg.set("treetype", (Object)"08");
        }
        fundOrg.set("id", (Object)id);
        fundOrg.set("number", this.getModel().getValue("number"));
        fundOrg.set("name", this.getModel().getValue("name"));
        fundOrg.set("description", this.getModel().getValue("description"));
        fundOrg.set("scope", this.getModel().getValue("scope"));
        TmcOperateServiceHelper.execOperate((String)"save", (String)"fbd_companysysviewsch", (DynamicObject[])new DynamicObject[]{fundOrg}, (OperateOption)OperateOption.create());
        return fundOrg.getLong("id");
    }

    private String addViewSchema(Long pkId) {
        ViewSchemaParam view = new ViewSchemaParam();
        view.setNumber(this.getViewSchemaNumber());
        view.setName(this.getModel().getValue("name").toString());
        view.setViewType("08");
        Long id = 0L;
        Map vs = BusinessDataServiceHelper.loadFromCache((String)"bos_org_viewschema", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkId)}, null);
        Long newId = vs == null || vs.size() == 0 ? id : pkId;
        view.setCustomId(pkId.longValue());
        view.setId(newId.longValue());
        OrgApiResult result = OrgUnitServiceHelper.saveOrgViewSchema((ViewSchemaParam)view);
        if (!result.isSuccess()) {
            return result.getErrorMsg();
        }
        return "";
    }

    private void addViewAuth(Long pkId, boolean isNew) {
        String scope = (String)this.getModel().getValue("scope");
        if (CompanySysAuthScopeEnum.AUTH.getValue().equals(scope)) {
            DynamicObjectCollection userEntity = this.getModel().getEntryEntity("userentity");
            DynamicObjectCollection roleEntity = this.getModel().getEntryEntity("roleentity");
            List userIds = Optional.ofNullable(userEntity).orElseGet(Collections::emptyList).stream().filter(t -> Objects.nonNull(t.getDynamicObject("user"))).map(t -> t.getDynamicObject("user").getLong("id")).filter(t -> t > 0L).distinct().collect(Collectors.toList());
            List roleIds = Optional.ofNullable(roleEntity).orElseGet(Collections::emptyList).stream().filter(t -> Objects.nonNull(t.getDynamicObject("rolename"))).map(t -> t.getDynamicObject("rolename").getString("id")).distinct().collect(Collectors.toList());
            Long creatorId = ((DynamicObject)this.getModel().getValue("creator")).getLong("id");
            CompanySysViewHelper.mergeCompanySysViewAuth(Collections.singletonList(pkId), userIds, roleIds, (Long)creatorId);
        } else if (!isNew) {
            DeleteServiceHelper.delete((String)"fbd_companysysauth", (QFilter[])new QFilter[]{new QFilter("companysysview", "=", (Object)pkId)});
        }
    }

    private void deleteNode() {
        List checkedNodes = this.bizviewtree.getTreeState().getCheckedNodes();
        TreeNode viewRoot = this.getViewRootNodes();
        if (checkedNodes.size() == 0 || viewRoot == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u9664\u7684\u7ec4\u7ec7\u3002", (String)"CompanySysViewEdit_1", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return;
        }
        for (Map node : checkedNodes) {
            if (viewRoot == null) break;
            TreeNode checkNodeInfo = CompanySysUtil.getTreeNodeById((String)((String)node.get("id")), (TreeNode)viewRoot);
            if (checkNodeInfo == null) continue;
            String parentId = checkNodeInfo.getParentid();
            if (parentId.equals("")) {
                viewRoot = null;
                this.bizviewtree.deleteAllNodes();
                this.setCheckChildren(false);
                continue;
            }
            if (viewRoot != null) {
                viewRoot.deleteChildNode(checkNodeInfo.getId());
            }
            this.bizviewtree.deleteNode(checkNodeInfo.getId());
            TreeNode parentNode = CompanySysUtil.getTreeNodeById((String)parentId, (TreeNode)viewRoot);
            if (parentNode.getChildren() == null || parentNode.getChildren() != null && parentNode.getChildren().isEmpty()) {
                parentNode.setChildren(null);
            }
            this.bizviewtree.updateNode(parentNode);
            this.bizviewtree.expand(parentId);
        }
        this.getPageCache().put(VIEW_ROOT, SerializationUtils.toJsonString((Object)viewRoot));
    }

    public void treeNodeDragged(TreeNodeDragEvent evt) {
        TreeView source = (TreeView)evt.getSource();
        if (!BIZVIEWTREE.equalsIgnoreCase(source.getKey())) {
            return;
        }
        String sourceNodeId = (String)evt.getNodeId();
        if ("".equals(sourceNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u6e90\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CompanySysViewEdit_2", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return;
        }
        String targetNodeId = (String)evt.getToParentId();
        TreeNode unitRoot = this.getCachedRoot(UNIT_ROOT);
        TreeNode viewRoot = this.getCachedRoot(VIEW_ROOT);
        TreeNode sourceNode = CompanySysUtil.getTreeNodeById((String)sourceNodeId, (TreeNode)unitRoot);
        TreeNode targetNode = CompanySysUtil.getTreeNodeById((String)targetNodeId, (TreeNode)viewRoot);
        List<TreeNode> allAppendNodes = this.getAllChildrenAndSelf(sourceNode);
        List allAppendNodeIds = allAppendNodes.stream().map(TreeNode::getId).collect(Collectors.toList());
        List<TreeNode> allViewNodes = this.getAllChildrenAndSelf(viewRoot);
        List allViewNodeIds = allViewNodes.stream().map(TreeNode::getId).collect(Collectors.toList());
        List<String> dumpIds = allAppendNodeIds.stream().filter(allViewNodeIds::contains).collect(Collectors.toList());
        TreeNode finalAppendNode = this.getParentExcludeIds(viewRoot, targetNode, dumpIds);
        String finalAppendNodeId = finalAppendNode.getId();
        List<TreeNode> needUpdateNodes = this.getNeedUpdateNodes(viewRoot, dumpIds);
        needUpdateNodes.add(targetNode);
        this.removeNodes(viewRoot, dumpIds);
        if ("".equals(sourceNode.getParentid())) {
            List children = sourceNode.getChildren();
            for (TreeNode child : children) {
                child.setParentid(finalAppendNodeId);
                finalAppendNode.addChild(child);
            }
        } else {
            sourceNode.setParentid(finalAppendNodeId);
            finalAppendNode.addChild(sourceNode);
        }
        this.bizviewtree.updateNodes(needUpdateNodes);
        this.expandUp(this.bizviewtree, viewRoot, finalAppendNode);
        this.getPageCache().put(VIEW_ROOT, SerializationUtils.toJsonString((Object)viewRoot));
    }

    private TreeNode createRootNode(Map<String, Object> nodeMap) {
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId((String)nodeMap.get("id"));
        root.setText((String)nodeMap.get("text"));
        root.setIsOpened(true);
        root.setLongNumber((String)nodeMap.get("longnumber"));
        HashMap<String, String> dataMap = new HashMap<String, String>(16);
        dataMap.put("isleaf", "0");
        dataMap.put("level", "1");
        dataMap.put("fullname", (String)nodeMap.get("text"));
        root.setData(dataMap);
        return root;
    }

    private TreeNode getViewRootNodes() {
        String rootNodeStr = this.getPageCache().get(VIEW_ROOT);
        return EmptyUtil.isNoEmpty((String)rootNodeStr) ? (TreeNode)SerializationUtils.fromJsonString((String)rootNodeStr, TreeNode.class) : null;
    }

    private List<Map<String, Object>> getNodeMap(List<Map<String, Object>> mapList) {
        Map<String, Map<String, String>> allTreeNodeCache = this.getAllTreeNodeCache();
        for (Map<String, Object> map : mapList) {
            String nodeId = (String)map.get("id");
            String viewCheckedLongNum = allTreeNodeCache.get(nodeId).get("longnumber");
            map.put("longnumber", viewCheckedLongNum);
        }
        return mapList;
    }

    private void addNode() {
        Map<String, Map<String, String>> allTreeNodeCache = this.getAllTreeNodeCache();
        List checkedNodes = this.bizviewtree.getTreeState().getCheckedNodes();
        if (checkedNodes.size() == 0) {
            List leftNodes = this.bizunittree.getTreeState().getCheckedNodes();
            if (EmptyUtil.isEmpty((Collection)leftNodes)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"CompanySysViewEdit_3", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                return;
            }
            if (leftNodes.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u7ec4\u7ec7\u505a\u4e3a\u6839\u8282\u70b9\u3002", (String)"CompanySysViewEdit_4", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                return;
            }
            Map nodeMap = (Map)leftNodes.get(0);
            String nodeId = (String)nodeMap.get("id");
            String longNumber = CompanySysUtil.getLastLongNum((String)allTreeNodeCache.get(nodeId).get("longnumber"));
            nodeMap.put("longnumber", longNumber);
            TreeNode rootNodeCache = this.getViewRootNodes();
            if (rootNodeCache != null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u7ec4\u7ec7\u505a\u4e3a\u7236\u8282\u70b9\u3002", (String)"CompanySysViewEdit_5", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                return;
            }
            TreeNode rootNode = this.createRootNode(nodeMap);
            this.bizviewtree.addNode(rootNode);
            this.getPageCache().put(VIEW_ROOT, SerializationUtils.toJsonString((Object)rootNode));
            this.setCheckChildren(true);
            return;
        }
        if (checkedNodes.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u7ec4\u7ec7\u505a\u4e3a\u7236\u8282\u70b9\u3002", (String)"CompanySysViewEdit_6", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return;
        }
        List<Map<String, Object>> leftNodes = this.bizunittree.getTreeState().getCheckedNodes();
        if (leftNodes.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5c1a\u672a\u9009\u62e9\u9700\u8981\u6dfb\u52a0\u7684\u7ec4\u7ec7\u3002", (String)"CompanySysViewEdit_7", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return;
        }
        if (leftNodes.size() == 1 && EmptyUtil.isEmpty(((Map)leftNodes.get(0)).get("parentid"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u7ec4\u7ec7[%s]\u4e0d\u652f\u6301\u6dfb\u52a0\u3002", (String)"CompanySysViewEdit_9", (String)"tmc-fbd-formplugin", (Object[])new Object[]{((Map)leftNodes.get(0)).get("text")}));
            return;
        }
        Map viewCheckNode = (Map)checkedNodes.get(0);
        String viewCheckedId = (String)viewCheckNode.get("id");
        TreeNode viewRoot = this.getCachedRoot(VIEW_ROOT);
        List<TreeNode> viewNodeAll = this.getAllChildrenAndSelf(viewRoot);
        Set<String> viewIdAll = viewNodeAll.stream().map(TreeNode::getId).collect(Collectors.toSet());
        String checkMsg = this.checkOrgExist(viewIdAll, leftNodes);
        if (EmptyUtil.isNoEmpty((String)checkMsg)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7 [%s] \u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u3002", (String)"CompanySysViewEdit_8", (String)"tmc-fbd-formplugin", (Object[])new Object[]{checkMsg}));
            return;
        }
        TreeNode viewCheckedNode = CompanySysUtil.getTreeNodeById((String)viewCheckedId, (TreeNode)viewRoot);
        leftNodes = this.getNodeMap(leftNodes);
        List unitCheckedNodes = CompanySysUtil.buildTreeNodeByList((TreeNode)viewCheckedNode, leftNodes);
        unitCheckedNodes.removeIf(node -> node.getId().equals(viewRoot.getId()));
        List<String> dumpIds = unitCheckedNodes.stream().map(TreeNode::getId).filter(viewIdAll::contains).collect(Collectors.toList());
        TreeNode finalAppendNode = this.getAllNode();
        List<TreeNode> needUpdateNodes = this.getNeedUpdateNodes(viewRoot, dumpIds);
        needUpdateNodes.add(viewCheckedNode);
        this.removeNodes(viewRoot, dumpIds);
        this.bizviewtree.updateNodes(needUpdateNodes);
        if (finalAppendNode.getChildren() != null) {
            for (TreeNode tre : finalAppendNode.getChildren()) {
                this.clearSelectNode(tre);
                tre.setParentid(viewCheckedNode.getId());
                if (viewCheckedNode.getChildren() == null) {
                    viewCheckedNode.addChild(tre);
                    continue;
                }
                viewCheckedNode.getChildren().add(tre);
            }
        }
        CompanySysUtil.sortTreeNode((List)viewCheckedNode.getChildren());
        this.bizviewtree.checkNode(viewCheckedNode);
        this.getPageCache().put(VIEW_ROOT, SerializationUtils.toJsonString((Object)viewRoot));
    }

    private String checkOrgExist(Set<String> viewIds, List<Map<String, Object>> leftNodes) {
        StringBuilder str = new StringBuilder();
        for (Map<String, Object> leftNode : leftNodes) {
            if (!viewIds.contains(leftNode.get("id"))) continue;
            str.append(leftNode.get("text")).append(",");
        }
        return EmptyUtil.isEmpty((CharSequence)str) ? str.toString() : str.toString().substring(0, str.length() - 1);
    }

    private void clearSelectNode(TreeNode viewCheckedNode) {
        this.bizunittree.uncheckNode(viewCheckedNode.getId());
    }

    private TreeNode getAllNode() {
        List leftNodes = this.bizunittree.getTreeState().getCheckedNodes();
        Long mainViewId = Long.parseLong(this.getPageCache().get("mainViewId"));
        Map<String, Map<String, String>> unitTreeMap = this.getSelectInfo(CompanySysUtil.getAllOrgByViewId((Long)mainViewId), leftNodes);
        this.removeRepetion(unitTreeMap);
        Map allTreeMap = CompanySysUtil.getAllOrgByViewId((Long)mainViewId);
        Map flatOrgTreeMap = CompanySysUtil.getOrgTreeMap(unitTreeMap);
        TreeNode unitRoot = CompanySysUtil.createTreeNode(unitTreeMap);
        if (unitRoot == null) {
            this.getInfo(unitTreeMap, allTreeMap);
            TreeNode tree = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(UNIT_ROOT), TreeNode.class);
            if (unitTreeMap.get(tree.getId()) == null) {
                unitTreeMap.put(tree.getId(), (Map<String, String>)allTreeMap.get(tree.getId()));
            }
            unitRoot = CompanySysUtil.createTreeNode(unitTreeMap);
            flatOrgTreeMap = CompanySysUtil.getOrgTreeMap(unitTreeMap);
        }
        CompanySysUtil.createChildNodes((Map)flatOrgTreeMap, (String)unitRoot.getId(), (TreeNode)unitRoot);
        return unitRoot;
    }

    private void removeRepetion(Map<String, Map<String, String>> unitTreeMap) {
        TreeNode viewRootNodes = this.getViewRootNodes();
        List<TreeNode> allViewNodes = this.getAllChildrenAndSelf(viewRootNodes);
        Set<String> nodeIds = unitTreeMap.keySet();
        Iterator<TreeNode> iterator = allViewNodes.iterator();
        while (iterator.hasNext()) {
            TreeNode node = iterator.next();
            if (!nodeIds.contains(node.getId())) continue;
            iterator.remove();
            if (node.getChildren() == null) continue;
            for (TreeNode n : node.getChildren()) {
                n.setParentid(node.getParentid());
            }
        }
    }

    private Map<String, Map<String, String>> getSelectInfo(Map<String, Map<String, String>> unitTreeMap, List<Map<String, Object>> leftNodes) {
        ArrayList<Object> list = new ArrayList<Object>(leftNodes.size());
        for (Map<String, Object> leftNode : leftNodes) {
            list.add(leftNode.get("id"));
        }
        unitTreeMap.keySet().retainAll(list);
        return unitTreeMap;
    }

    private TreeNode getCachedRoot(String key) {
        return (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(key), TreeNode.class);
    }

    private String getViewSchemaNumber() {
        return this.getModel().getValue("number").toString();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        int mode = BDUtil.getRunModeCode();
        if (mode == 2) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"labelap", "orgproperty"});
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long id = (Long)dataEntity.getPkValue();
        Long orgDefaultViewSchemaId = CompanySysUtil.getDefaultViewSchemaInfoId();
        this.getPageCache().put("mainViewId", orgDefaultViewSchemaId + "");
        Map unitTreeMap = CompanySysUtil.getAllOrgByViewId((Long)orgDefaultViewSchemaId);
        this.getPageCache().put(ALL_NODE_CACHE, SerializationUtils.toJsonString((Object)unitTreeMap));
        Map flatOrgTreeMap = CompanySysUtil.getOrgTreeMap((Map)unitTreeMap);
        TreeNode unitRoot = CompanySysUtil.createTreeNode((Map)unitTreeMap);
        if (unitRoot == null) {
            return;
        }
        CompanySysUtil.createChildNodes((Map)flatOrgTreeMap, (String)unitRoot.getId(), (TreeNode)unitRoot);
        this.bizunittree.addNode(unitRoot);
        this.getPageCache().put(BIZUNITTREE, SerializationUtils.toJsonString((Object)unitRoot));
        Map viewTreeMap = CompanySysUtil.getAllOrgByViewId((Long)id);
        Map flatOrgTreeMap2 = CompanySysUtil.getOrgTreeMap((Map)viewTreeMap);
        TreeNode viewRoot = CompanySysUtil.createTreeNode((Map)viewTreeMap);
        if (this.getView().getFormShowParameter().getStatus() != OperationStatus.ADDNEW && viewRoot != null) {
            CompanySysUtil.createChildNodes((Map)flatOrgTreeMap2, (String)viewRoot.getId(), (TreeNode)viewRoot);
            this.setCheckChildren(true);
            this.getPageCache().put(VIEW_NODE_CACHE, SerializationUtils.toJsonString((Object)viewRoot));
        }
        this.bizviewtree.addNode(viewRoot);
        this.cacheTreeNode(unitRoot, viewRoot);
        String number = dataEntity.getString("number");
        if (StringUtils.isNotBlank((CharSequence)number)) {
            try (DLock lock = DLock.create((String)("tmc/fbd/view/" + number)).fastMode();){
                if (!lock.tryLock()) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_SAVE, BTN_ADDNODE, BTN_DELETENODE});
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8868\u5355\u8fd8\u5728\u7f16\u8f91\u4e2d\u3002", (String)"CompanySysViewEdit_13", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                }
            }
        }
        this.getView().setEnable(Boolean.valueOf(!CompanySysViewHelper.idDefaultViewId((Long)id)), new String[]{"tabview", "number", "name"});
    }

    private void cacheTreeNode(TreeNode unitTreeNode, TreeNode viewTreeNode) {
        IPageCache cache = this.getPageCache();
        cache.put(UNIT_ROOT, SerializationUtils.toJsonString((Object)unitTreeNode));
        cache.put(VIEW_ROOT, SerializationUtils.toJsonString((Object)viewTreeNode));
    }

    private Map<String, Map<String, String>> getAllTreeNodeCache() {
        String allNodeCache = this.getPageCache().get(ALL_NODE_CACHE);
        return (Map)SerializationUtils.fromJsonString((String)allNodeCache, Map.class);
    }

    public void treeNodeCheck(TreeNodeCheckEvent e) {
        TreeNode viewRootNodes;
        Control treeView = (Control)e.getSource();
        boolean isCheckChild = (Boolean)this.getModel().getValue(ISCHECKUNITCHILD);
        boolean toCancelCheck = false;
        String nodeId = (String)e.getNodeId();
        if (e.getChecked().booleanValue() && treeView.getKey().equals(BIZUNITTREE) && Objects.nonNull(viewRootNodes = this.getViewRootNodes())) {
            List<TreeNode> allChildrenAndSelf = this.getAllChildrenAndSelf(viewRootNodes);
            Set viewNodeIds = allChildrenAndSelf.stream().map(TreeNode::getId).distinct().collect(Collectors.toSet());
            toCancelCheck = viewNodeIds.contains(nodeId);
        }
        if (isCheckChild && treeView.getKey().equals(BIZUNITTREE)) {
            boolean containsAll;
            TreeNode unitTreeNode = this.getCachedRoot(UNIT_ROOT);
            TreeNode checkNodeInfo = CompanySysUtil.getTreeNodeById((String)nodeId, (TreeNode)unitTreeNode);
            List checkedNodeIds = this.bizunittree.getTreeState().getCheckedNodeIds();
            boolean empty = this.bizviewtree.getTreeState().getSelectedNodeId().isEmpty();
            boolean bl = containsAll = empty ? false : checkedNodeIds.containsAll(this.bizviewtree.getTreeState().getSelectedNodeId());
            if (containsAll && StringUtils.isNotBlank((Object)e.getParentNodeId())) {
                this.getView().setEnable(Boolean.FALSE, new String[]{BTN_ADDNODE, BTN_DELETENODE});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{BTN_ADDNODE, BTN_DELETENODE});
            }
            List<TreeNode> allChildren = this.getAllChildren(checkNodeInfo);
            if (checkedNodeIds.contains(nodeId)) {
                this.bizunittree.checkNodes(allChildren);
            } else {
                List allChildrenIds = allChildren.stream().map(TreeNode::getId).collect(Collectors.toList());
                this.bizunittree.unCheckNodesWithoutChild(allChildrenIds);
            }
        } else if (treeView.getKey().equals(BIZVIEWTREE)) {
            if (e.getChecked().booleanValue()) {
                if (StringUtils.isNotBlank((Object)e.getParentNodeId())) {
                    List list = this.bizunittree.getTreeState().getSelectedNodeId();
                    this.getView().setEnable(Boolean.valueOf(!list.contains(nodeId)), new String[]{BTN_ADDNODE, BTN_DELETENODE});
                }
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{BTN_ADDNODE, BTN_DELETENODE});
            }
        }
        if (toCancelCheck) {
            this.bizunittree.unCheckNodeWithoutChild(nodeId);
        }
    }

    private List<TreeNode> getAllChildren(TreeNode parentNode) {
        if (parentNode == null) {
            return new ArrayList<TreeNode>();
        }
        List children = parentNode.getChildren();
        if (children == null || children.size() == 0) {
            return new ArrayList<TreeNode>();
        }
        ArrayList<TreeNode> result = new ArrayList<TreeNode>(children);
        for (TreeNode child : children) {
            result.addAll(this.getAllChildren(child));
        }
        return result;
    }

    private List<TreeNode> getAllChildrenAndSelf(TreeNode parentNode) {
        List<TreeNode> allChildren = this.getAllChildren(parentNode);
        allChildren.add(parentNode);
        return allChildren;
    }

    private List<TreeNode> getNeedUpdateNodes(TreeNode viewRoot, List<String> dumpIds) {
        ArrayList<TreeNode> needUpdateNodes = new ArrayList<TreeNode>(dumpIds.size());
        for (String dumpId : dumpIds) {
            needUpdateNodes.add(this.getParentExcludeIds(viewRoot, CompanySysUtil.getTreeNodeById((String)dumpId, (TreeNode)viewRoot), dumpIds));
        }
        return needUpdateNodes;
    }

    private void expandUp(TreeView treeView, TreeNode treeRoot, TreeNode treeNode) {
        List<TreeNode> parentNodes = this.getParentNodesAndSelf(treeRoot, treeNode);
        parentNodes.forEach(x -> treeView.expand(x.getId()));
    }

    private List<TreeNode> getParentNodesAndSelf(TreeNode treeRoot, TreeNode treeNode) {
        List<TreeNode> parentNodes = this.getParentNodes(treeRoot, treeNode);
        parentNodes.add(treeNode);
        return parentNodes;
    }

    private List<TreeNode> getParentNodes(TreeNode treeRoot, TreeNode treeNode) {
        String parentId = treeNode.getParentid();
        if ("".equals(parentId)) {
            return new ArrayList<TreeNode>();
        }
        ArrayList<TreeNode> result = new ArrayList<TreeNode>();
        TreeNode parentNode = CompanySysUtil.getTreeNodeById((String)parentId, (TreeNode)treeRoot);
        result.add(parentNode);
        result.addAll(this.getParentNodesAndSelf(treeRoot, parentNode));
        return result;
    }

    private TreeNode getParentExcludeIds(TreeNode viewRoot, TreeNode targetNode, List<String> dumpIds) {
        if (!dumpIds.contains(targetNode.getId())) {
            return targetNode;
        }
        String parentId = targetNode.getParentid();
        if ("".equals(parentId)) {
            return targetNode;
        }
        TreeNode parentNode = CompanySysUtil.getTreeNodeById((String)parentId, (TreeNode)viewRoot);
        return this.getParentExcludeIds(viewRoot, parentNode, dumpIds);
    }

    private void removeNodes(TreeNode root, List<String> nodeIds) {
        for (String nodeId : nodeIds) {
            String parentId;
            TreeNode node = CompanySysUtil.getTreeNodeById((String)nodeId, (TreeNode)root);
            if (node == null || "".equals(parentId = node.getParentid())) continue;
            List childNodes = node.getChildren();
            TreeNode parentNode = CompanySysUtil.getTreeNodeById((String)parentId, (TreeNode)root);
            List parentChilds = parentNode.getChildren();
            parentChilds.removeIf(x -> x.getId().equals(nodeId));
            if (childNodes == null) continue;
            for (TreeNode childNode : childNodes) {
                parentChilds.add(childNode);
                childNode.setParentid(parentId);
            }
        }
    }

    public void search(SearchEnterEvent e) {
        String text = e.getText();
        Search search = (Search)e.getSource();
        if (StringUtils.isBlank((CharSequence)text)) {
            return;
        }
        QFilter[] qf = new QFilter[]{new QFilter("name", "like", (Object)("%" + text + "%"))};
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])qf, (String)"name");
        TreeView orgTree = "orgsearchap".equals(search.getKey()) ? (TreeView)this.getControl(BIZUNITTREE) : (TreeView)this.getControl(BIZVIEWTREE);
        this.unCheckNode(orgTree);
        if (!orgs.isEmpty()) {
            DynamicObject queryOne = (DynamicObject)orgs.get(0);
            boolean isFirstTime = true;
            for (DynamicObject org : orgs) {
                boolean containLeaf;
                if (queryOne == null) continue;
                boolean bl = containLeaf = "orgsearchap".equals(search.getKey()) ? (Boolean)this.getModel().getValue(ISCHECKUNITCHILD) : false;
                if (isFirstTime) {
                    boolean isFind = this.selectNode(orgTree, org, containLeaf, true);
                    if (!isFind) continue;
                    isFirstTime = false;
                    continue;
                }
                this.selectNode(orgTree, org, containLeaf, false);
            }
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        long pkId = (Long)this.getModel().getValue("id");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fbd_companysysauth", (String)"authtype,authuser.id,authrole.id", (QFilter[])new QFilter[]{new QFilter("companysysview", "=", (Object)pkId)}, null);
        DynamicObject[] vs = (DynamicObject[])query.toArray((Object[])new DynamicObject[0]);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        boolean dataChanged = this.getModel().getDataChanged();
        model.beginInit();
        DynamicObject creator = (DynamicObject)this.getModel().getValue("creator");
        long creatorId = Objects.nonNull(creator) ? creator.getLong("id") : 0L;
        List<Map<String, Object>> mapList = this.loadUserEntity(vs, creatorId);
        List<Map<String, Object>> roleList = this.loadRoleEntity(vs);
        TmcViewInputHelper.batchFillEntity((String)"userentity", (AbstractFormDataModel)model, mapList);
        TmcViewInputHelper.batchFillEntity((String)"roleentity", (AbstractFormDataModel)model, roleList);
        model.endInit();
        this.getView().updateView("userentity");
        this.getModel().setDataChanged(dataChanged);
    }

    private List<Map<String, Object>> loadUserEntity(DynamicObject[] vs, Long creatorId) {
        List dynamicObjectList = Arrays.stream(vs).filter(t -> CompanySysAuthTypeEnum.USER.getValue().equals(t.getString("authtype"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dynamicObjectList)) {
            return null;
        }
        List<Long> userIds = dynamicObjectList.stream().map(t -> t.getLong("authuser.id")).collect(Collectors.toList());
        return this.loadUserByIds(userIds, creatorId);
    }

    private List<Map<String, Object>> loadUserByIds(List<Long> userIds, Long creatorId) {
        if (CollectionUtils.isEmpty(userIds)) {
            return null;
        }
        List maps = UserServiceHelper.get(userIds, (String[])new String[]{"id", "picturefield", "number", "gender", "isforbidden", "islocked"}, null);
        if (CollectionUtils.isEmpty((Collection)maps)) {
            return null;
        }
        List orgId = UserServiceHelper.getUserMainOrgId(userIds);
        HashMap orgMap = new HashMap(orgId.size());
        for (Map map : orgId) {
            orgMap.putAll(map);
        }
        Map jobNameMap = UserServiceHelper.getUserMainJob(userIds);
        Map userMap = maps.stream().collect(Collectors.toMap(t -> Long.valueOf(t.get("id").toString()), Function.identity(), (p, q) -> p));
        ArrayList<Map<String, Object>> resList = new ArrayList<Map<String, Object>>(userIds.size());
        for (Long userId : userIds) {
            Map map = (Map)userMap.get(userId);
            if (MapUtils.isEmpty((Map)map)) continue;
            Long mainOrg = orgMap.getOrDefault(userId, 0L);
            String jobName = jobNameMap.getOrDefault(userId, "");
            String defaultUser = userId.equals(creatorId) ? "D" : "N";
            ImmutableMap dataMap = ImmutableMap.builder().put((Object)"headimg", map.get("picturefield")).put((Object)"user", map.get("id")).put((Object)"worknumber", map.get("number")).put((Object)"gender", map.get("gender")).put((Object)"position", (Object)jobName).put((Object)"mainorg", (Object)mainOrg).put((Object)"userforbidden", map.get("isforbidden")).put((Object)"lock", map.get("islocked")).put((Object)"defaultuser", (Object)defaultUser).build();
            resList.add((Map<String, Object>)dataMap);
        }
        return resList;
    }

    private List<Map<String, Object>> loadRoleEntity(DynamicObject[] vs) {
        List dynamicObjectList = Arrays.stream(vs).filter(t -> CompanySysAuthTypeEnum.ROLE.getValue().equals(t.getString("authtype"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dynamicObjectList)) {
            return null;
        }
        List roleIds = dynamicObjectList.stream().map(t -> t.getString("authrole.id")).collect(Collectors.toList());
        String selFields = "id,number,remark,createtime,disabledate";
        Map roleMap = BusinessDataServiceHelper.loadFromCache((String)"perm_role", (String)selFields, (QFilter[])new QFilter[]{new QFilter("id", "in", roleIds)});
        ArrayList<Map<String, Object>> resList = new ArrayList<Map<String, Object>>(vs.length);
        for (DynamicObject object : dynamicObjectList) {
            String roleId = object.getString("authrole.id");
            DynamicObject role = (DynamicObject)roleMap.get(roleId);
            if (Objects.isNull(role)) continue;
            ImmutableMap.Builder roleBuild = ImmutableMap.builder().put((Object)"rolename", (Object)object.getString("authrole.id")).put((Object)"rolecode", (Object)role.getString("number"));
            Optional.ofNullable(role.getDate("createtime")).ifPresent(tt -> roleBuild.put((Object)"effectdate", tt));
            Optional.ofNullable(role.getString("remark")).ifPresent(tt -> roleBuild.put((Object)"roledesc", tt));
            roleBuild.put((Object)"disabledate", role.getDate("disabledate") == null ? "" : role.getDate("disabledate"));
            resList.add((Map<String, Object>)roleBuild.build());
        }
        return resList;
    }

    private void unCheckNode(TreeView orgTree) {
        List selectedNodeId = orgTree.getTreeState().getSelectedNodeId();
        orgTree.uncheckNodes(selectedNodeId);
    }

    private boolean selectNode(TreeView orgTree, DynamicObject org, boolean containLeaf, boolean isFirstTime) {
        TreeNode bizTree = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(BIZUNITTREE), TreeNode.class);
        List childPathNodes = bizTree.getChildPathNodes(org.getString("id"));
        String rootOrgId = String.valueOf(OrgUnitServiceHelper.getRootOrgId());
        for (TreeNode child : childPathNodes) {
            if (!child.getText().equalsIgnoreCase(org.getString("name")) || rootOrgId.equals(child.getId())) continue;
            orgTree.showNode(child.getId());
            if (isFirstTime) {
                orgTree.focusNode(child);
            }
            orgTree.checkNode(child);
            if (containLeaf) {
                TreeNodeCheckEvent tnc = new TreeNodeCheckEvent((Object)orgTree, (Object)child.getParentid(), (Object)child.getId(), Boolean.valueOf(containLeaf));
                this.treeNodeCheck(tnc);
            }
            return true;
        }
        return false;
    }

    private void setCheckChildren(boolean isCheck) {
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)ISCHECKUNITCHILD, (Object)isCheck);
        this.getView().updateView(ISCHECKUNITCHILD);
    }
}

