/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.companysys;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.org.model.OrgParam;
import kd.tmc.fbd.common.helper.CompanySysViewHelper;

public class CompanySysViewSaveTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(CompanySysViewSaveTask.class);
    private RequestContext rc;
    private String pageId;
    private String viewNumber;
    private List<Tuple<Integer, OrgParam>> addParams;
    private List<OrgParam> delParams;
    private static final long LOCK_TRY_TIME = 5000L;

    public CompanySysViewSaveTask(RequestContext rc, String pageId, String viewNumber, List<Tuple<Integer, OrgParam>> addParams, List<OrgParam> delParams) {
        this.rc = rc;
        this.pageId = pageId;
        this.viewNumber = viewNumber;
        this.addParams = addParams;
        this.delParams = delParams;
    }

    @Override
    public void run() {
        logger.info("start CompanySysViewSaveTask pageId {}", (Object)this.pageId);
        RequestContext.copyAndSet((RequestContext)this.rc);
        PageCache pageCache = new PageCache(this.pageId);
        try (DLock lock = DLock.create((String)("tmc/fbd/view/" + this.viewNumber)).fastMode();){
            if (lock.tryLock(5000L)) {
                CompanySysViewHelper.syncOrgUnitDuty(this.delParams, this.addParams);
                logger.info("CompanySysViewSaveTask result success");
                pageCache.put("bizsave", "success");
            } else {
                logger.error("CompanySysViewSaveTask lock fail");
                pageCache.put("bizsave", "fail");
            }
        }
        catch (Exception e) {
            logger.error("execOperate fail", (Throwable)e);
            pageCache.put("bizsave", "fail");
        }
    }
}

