/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.compare;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.EntityOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.tmc.fbp.common.compare.api.bean.CompareRuleConfigBean;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.EntityFieldTreeOption;
import kd.tmc.fbp.common.util.EntityFieldTreeResult;
import kd.tmc.fbp.common.util.EntityTreeUtil;
import kd.tmc.fbp.common.util.ExpressionType;

public class CompareRuleEdit
extends AbstractBasePlugIn {
    private static final String ACTION_CONFIGFORM = "ACTION_CONFIGFORM";
    private static final String NON_FIELDS = "non_fields";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"ruleconfig", "e_detailcondition", "e_bizcondition"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key;
        super.beforeClick(evt);
        if (evt.getSource() instanceof Control && "addrow".equals(key = ((Control)evt.getSource()).getKey())) {
            Object srcType = this.getModel().getValue("entitytypesrc");
            Object tarType = this.getModel().getValue("entitytypetar");
            if (srcType == null || tarType == null) {
                evt.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e90\u5355\u4e0e\u76ee\u6807\u5355\u7c7b\u578b\u3002", (String)"CompareRuleEdit_2", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Control) {
            String key = ((Control)evt.getSource()).getKey();
            if ("ruleconfig".equals(key)) {
                int row = this.getModel().getEntryCurrentRowIndex("entryentity");
                String configVal = (String)this.getModel().getValue("ruleconfigval_TAG", row);
                this.showConfigForm(row, configVal);
            } else if ("e_detailcondition".equals(key) || "e_bizcondition".equals(key)) {
                DynamicObject dy;
                String fileName = "";
                String entity = "";
                if ("e_detailcondition".equals(key)) {
                    dy = (DynamicObject)this.getModel().getValue("entitytypesrc");
                    if (dy == null) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e90\u5355\u7c7b\u578b\u3002", (String)"CompareRuleEdit_0", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    fileName = "detailcondition_real_TAG";
                    entity = dy.getString("number");
                } else {
                    dy = (DynamicObject)this.getModel().getValue("entitytypetar");
                    if (dy == null) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u76ee\u6807\u5355\u7c7b\u578b\u3002", (String)"CompareRuleEdit_1", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    fileName = "bizcondition_real_TAG";
                    entity = dy.getString("number");
                }
                this.fillFields(key, ExpressionType.Condition, false, null, EntityMetadataCache.getDataEntityType((String)entity));
                int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                this.showConditionForm(entryCurrentRowIndex, fileName, this.getPageCache().get(key), entity);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String EntryEntityName = e.getEntryProp().getName();
        if ("entryentityorg".equals(EntryEntityName)) {
            this.onOrgEntryChanged();
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if ("entryentityorg".equals(e.getEntryProp().getName())) {
            this.onOrgEntryChanged();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if ("entitytypesrc".equals(propName) || "entitytypetar".equals(propName)) {
            this.getModel().deleteEntryData("entryentity");
        } else if ("ruleconfig".equals(propName) && EmptyUtil.isEmpty((Object)e.getChangeSet()[0].getNewValue())) {
            this.getModel().beginInit();
            this.getModel().setValue("ruleconfigval_TAG", null);
            this.getModel().endInit();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object operate = args.getSource();
        if (operate instanceof EntityOperate && "save".equals(((EntityOperate)operate).getOperateKey())) {
            this.onOrgEntryChanged();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (ACTION_CONFIGFORM.equals(actionId)) {
            Map returnDataMap = (Map)evt.getReturnData();
            if (returnDataMap != null) {
                this.handleConfigReturnData(returnDataMap);
            }
        } else {
            this.receiveExpressionSet(evt, "entryentity", actionId);
        }
    }

    private void showConfigForm(int row, String configVal) {
        FormShowParameter sp = new FormShowParameter();
        sp.setFormId("fbd_compareruleconfig");
        sp.getOpenStyle().setShowType(ShowType.Modal);
        sp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_CONFIGFORM));
        sp.setCustomParam("key_extradata", (Object)row);
        DynamicObject srcEntity = (DynamicObject)this.getModel().getValue("entitytypesrc");
        DynamicObject tarEntity = (DynamicObject)this.getModel().getValue("entitytypetar");
        if (EmptyUtil.isEmpty((DynamicObject)srcEntity) || EmptyUtil.isEmpty((DynamicObject)tarEntity)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e90\u5355\u4e0e\u76ee\u6807\u5355\u7c7b\u578b\u3002", (String)"CompareRuleEdit_2", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
            return;
        }
        sp.setCustomParam("key_entity_type_src", (Object)srcEntity.getString("number"));
        sp.setCustomParam("key_entity_type_tar", (Object)tarEntity.getString("number"));
        sp.setCustomParam("key_rule_config_val", (Object)configVal);
        this.getView().showForm(sp);
    }

    private void handleConfigReturnData(Map<String, Object> configDataMap) {
        int row = (Integer)configDataMap.get("key_extradata");
        List configList = (List)configDataMap.get("key_rule_config_val");
        this.getModel().setValue("ruleconfigval_TAG", (Object)JSON.toJSONString((Object)configList), row);
        String rulePrintVal = CompareRuleConfigBean.printList((List)configList);
        this.getModel().setValue("ruleconfig", (Object)rulePrintVal, row);
    }

    private void onOrgEntryChanged() {
        DynamicObjectCollection entryList = this.getModel().getEntryEntity("entryentityorg");
        this.getModel().beginInit();
        if (entryList.size() > 0) {
            this.getModel().setValue("forentireorg", (Object)"0");
        } else {
            this.getModel().setValue("forentireorg", (Object)"1");
        }
        this.getModel().endInit();
    }

    private void fillFields(String key, ExpressionType type, boolean readChildEntity, Class<?> cls, MainEntityType srcMainET) {
        if (srcMainET == null) {
            this.getPageCache().put(key, "");
        } else {
            EntityFieldTreeOption option = EntityFieldTreeOption.create();
            option.setEntityType((IDataEntityType)srcMainET);
            option.setReadEntryEntity(readChildEntity);
            option.setExprType(type);
            option.setFieldType(cls);
            EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes((EntityFieldTreeOption)option);
            TreeNode tree = EntityTreeUtil.buildBillTree((List)result.getNodes());
            String toJson = SerializationUtils.toJsonString((Object)tree);
            this.getPageCache().put(key, toJson);
            String nonFdStr = this.getPageCache().get(NON_FIELDS);
            if (nonFdStr != null) {
                Set nonSet = (Set)SerializationUtils.fromJsonString((String)nonFdStr, Set.class);
                nonSet.addAll(result.getNonFields());
                this.getPageCache().put(NON_FIELDS, SerializationUtils.toJsonString((Object)nonSet));
            } else {
                this.getPageCache().put(NON_FIELDS, SerializationUtils.toJsonString((Object)result.getNonFields()));
            }
        }
    }

    private void showConditionForm(int rowIndex, String sourceCtrlKey, String fieldNodes, String entity) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cas_condition");
        String conditionJson = (String)this.getModel().getValue(sourceCtrlKey + "_TAG", rowIndex);
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entity);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCustomParam(NON_FIELDS, (Object)this.getPageCache().get(NON_FIELDS));
        String funcsXML = this.getPageCache().get("functiontypes");
        if (StringUtils.isBlank((CharSequence)funcsXML)) {
            FunctionTypes functionTypes = FunctionTypes.get();
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put("functiontypes", funcsXML);
        }
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void receiveExpressionSet(ClosedCallBackEvent closedCallBackEvent, String entityKey, String expressionFldKey) {
        if (closedCallBackEvent.getReturnData() != null) {
            String descFldKey = "detailcondition_real_TAG".equals(expressionFldKey) ? "e_detailcondition" : "e_bizcondition";
            String str = (String)closedCallBackEvent.getReturnData();
            int row = this.getModel().getEntryCurrentRowIndex(entityKey);
            if (StringUtils.isBlank((CharSequence)str)) {
                this.getModel().setValue(descFldKey, (Object)"", row);
            } else {
                CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)str, CRCondition.class);
                this.getModel().setValue(expressionFldKey + "_TAG", (Object)str, row);
                String desp = "";
                if (StringUtils.isNotEmpty((CharSequence)filterObj.getExprTran().trim())) {
                    desp = filterObj.getExprTran();
                }
                if (desp.length() > 1024) {
                    desp = desp.substring(0, 1024);
                }
                this.getModel().setValue(descFldKey, (Object)desp, row);
            }
        }
    }
}

