/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.feescheme;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbd.common.enums.AmountBaseEnum;
import kd.tmc.fbd.common.enums.BusinessProcessEnum;
import kd.tmc.fbd.common.enums.TimeConventionEnum;
import kd.tmc.fbp.common.enums.FeeCalTypeEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FeeSchemeEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit market = (BasedataEdit)this.getView().getControl("market");
        BasedataEdit counterParty = (BasedataEdit)this.getView().getControl("counterparty");
        BasedataEdit tradeType = (BasedataEdit)this.getView().getControl("tradetype");
        market.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        counterParty.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        tradeType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"tradetype")) {
            sp.getListFilterParameter().setFilter(TmcBusinessBaseHelper.getTradeTypeFilter((IFormView)this.getView()));
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"market")) {
            this.initMarketFilterF7(sp);
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"counterparty")) {
            this.initCounterPartyFilterF7(sp);
        }
    }

    public void afterBindData(EventObject e) {
        boolean setAmountRate;
        super.afterBindData(e);
        this.setCurrencyEnable();
        this.setContractsizeEnable();
        this.initAllComboItems();
        String feeCalType = (String)this.getModel().getValue("feecaltype");
        if (FeeCalTypeEnum.fixed.getValue().equals(feeCalType)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"contractsize"});
        }
        if (!(setAmountRate = ((Boolean)this.getModel().getValue("setamountrate")).booleanValue())) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"amountrate"});
        }
    }

    private void initAllComboItems() {
        this.initFeeCalTypeComboItems();
        this.initAmountBaseComboItems();
        this.initBusinessProcessComboItems();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "market": {
                this.setCurrencyByMarket();
                this.setCurrencyEnable();
                break;
            }
            case "tradetype": {
                this.getModel().setValue("feecaltype", (Object)FeeCalTypeEnum.fixed.getValue());
                this.getModel().setValue("amountbase", (Object)AmountBaseEnum.principal.getValue());
                this.getModel().setValue("businessprocess", (Object)"");
                this.setContractsizeEnable();
                this.initFeeCalTypeComboItems();
                this.initAmountBaseComboItems();
                this.initBusinessProcessComboItems();
                break;
            }
            case "feecaltype": {
                String feeCalType = (String)this.getModel().getValue("feecaltype");
                if (FeeCalTypeEnum.fixed.getValue().equals(feeCalType)) {
                    TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"contractsize"});
                    break;
                }
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"contractsize"});
                break;
            }
            case "timeconvention": {
                this.getModel().setValue("businessprocess", (Object)"");
                this.initBusinessProcessComboItems();
                String timeConvention = (String)this.getModel().getValue("timeconvention");
                if (TimeConventionEnum.trade_business.getValue().equals(timeConvention)) {
                    TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"businessprocess"});
                    break;
                }
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"businessprocess"});
                break;
            }
            case "setamountrate": {
                boolean setAmountRate = (Boolean)this.getModel().getValue("setamountrate");
                if (setAmountRate) {
                    TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"amountrate"});
                    break;
                }
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"amountrate"});
            }
        }
    }

    private void setContractsizeEnable() {
        DynamicObject tradeType = (DynamicObject)this.getModel().getValue("tradetype");
        List<String> foreProduct = Arrays.asList(ProductTypeEnum.FOREXFORWARD.getId(), ProductTypeEnum.FOREXSWAPS.getId());
        if (EmptyUtil.isNoEmpty((DynamicObject)tradeType) && foreProduct.contains(String.valueOf(tradeType.getLong("id")))) {
            this.getModel().setValue("contractsize", (Object)BigDecimal.ZERO);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"contractsize"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"contractsize"});
        }
    }

    private void initMarketFilterF7(ListShowParameter sp) {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            QFilter qFilter = new QFilter("currency", "=", currency.getPkValue());
            sp.getListFilterParameter().setFilter(qFilter);
        } else {
            sp.setCustomParam("FBD_FEESCHEME_CURR_VALIDATE", (Object)"true");
        }
    }

    private void initCounterPartyFilterF7(ListShowParameter sp) {
        DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity("entity");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryEntitys)) {
            HashSet<Long> idSet = new HashSet<Long>(entryEntitys.size());
            for (DynamicObject entry : entryEntitys) {
                DynamicObject counterPDO = entry.getDynamicObject("counterparty");
                if (!EmptyUtil.isNoEmpty((DynamicObject)counterPDO)) continue;
                idSet.add(counterPDO.getLong("id"));
            }
            QFilter qFilter = new QFilter("id", "not in", idSet);
            sp.getListFilterParameter().setFilter(qFilter);
        }
    }

    private void setCurrencyEnable() {
        if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("market"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"currency"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"currency"});
        }
    }

    private void setCurrencyByMarket() {
        DynamicObject marketCurrency;
        DynamicObjectCollection markets = (DynamicObjectCollection)this.getModel().getValue("market");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)markets) && EmptyUtil.isNoEmpty((DynamicObject)(marketCurrency = ((DynamicObject)markets.get(0)).getDynamicObject("fbasedataid").getDynamicObject("currency")))) {
            this.getModel().setValue("currency", marketCurrency.getPkValue());
        }
    }

    private void initFeeCalTypeComboItems() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(2);
        items.add(new ComboItem(new LocaleString(FeeCalTypeEnum.fixed.getName()), FeeCalTypeEnum.fixed.getValue()));
        DynamicObject tradeType = (DynamicObject)this.getModel().getValue("tradetype");
        if (EmptyUtil.isEmpty((DynamicObject)tradeType)) {
            this.initComboItems("feecaltype", items);
        } else {
            String number = tradeType.getString("number");
            HashSet<String> ratioCaseProduceType = new HashSet<String>(16);
            ratioCaseProduceType.add(ProductTypeEnum.FOREXSPOT.getValue());
            ratioCaseProduceType.add(ProductTypeEnum.FOREXFORWARD.getValue());
            ratioCaseProduceType.add(ProductTypeEnum.FOREXSWAPS.getValue());
            ratioCaseProduceType.add(ProductTypeEnum.FOREXOPTION.getValue());
            ratioCaseProduceType.add(ProductTypeEnum.BONDOPTION.getValue());
            ratioCaseProduceType.add(ProductTypeEnum.RATEBOUND.getValue());
            if (!ratioCaseProduceType.contains(number)) {
                items.add(new ComboItem(new LocaleString(FeeCalTypeEnum.ratio.getName()), FeeCalTypeEnum.ratio.getValue()));
            }
            this.initComboItems("feecaltype", items);
        }
    }

    private void initAmountBaseComboItems() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(2);
        DynamicObject tradeType = (DynamicObject)this.getModel().getValue("tradetype");
        if (EmptyUtil.isEmpty((DynamicObject)tradeType)) {
            this.initComboItems("amountbase", items);
        } else {
            String number = tradeType.getString("number");
            items.add(new ComboItem(new LocaleString(AmountBaseEnum.principal.getName()), AmountBaseEnum.principal.getValue()));
            if (ProductTypeEnum.BONDFIX.getValue().equals(number) || ProductTypeEnum.BONDFLOAT.getValue().equals(number)) {
                items.add(new ComboItem(new LocaleString(AmountBaseEnum.fullprice.getName()), AmountBaseEnum.fullprice.getValue()));
            }
            this.initComboItems("amountbase", items);
        }
    }

    private void initBusinessProcessComboItems() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        String timeConvention = (String)this.getModel().getValue("timeconvention");
        if (TimeConventionEnum.trade_business.getValue().equals(timeConvention)) {
            DynamicObject tradeType = (DynamicObject)this.getModel().getValue("tradetype");
            if (EmptyUtil.isEmpty((DynamicObject)tradeType)) {
                this.initComboItems("businessprocess", items);
            } else {
                String number = tradeType.getString("number");
                ProductTypeEnum enumByValue = ProductTypeEnum.getEnumByValue((String)number);
                switch (enumByValue) {
                    case FOREXSPOT: {
                        items.add(new ComboItem(new LocaleString(BusinessProcessEnum.expiredey.getName()), BusinessProcessEnum.expiredey.getValue()));
                        break;
                    }
                    case FOREXFORWARD: {
                        items.add(new ComboItem(new LocaleString(BusinessProcessEnum.exratecfg.getName()), BusinessProcessEnum.exratecfg.getValue()));
                        items.add(new ComboItem(new LocaleString(BusinessProcessEnum.flat.getName()), BusinessProcessEnum.flat.getValue()));
                        items.add(new ComboItem(new LocaleString(BusinessProcessEnum.bdelivery.getName()), BusinessProcessEnum.bdelivery.getValue()));
                        items.add(new ComboItem(new LocaleString(BusinessProcessEnum.expiredey.getName()), BusinessProcessEnum.expiredey.getValue()));
                        items.add(new ComboItem(new LocaleString(BusinessProcessEnum.defer.getName()), BusinessProcessEnum.defer.getValue()));
                        break;
                    }
                    case FOREXSWAPS: {
                        items.add(new ComboItem(new LocaleString(BusinessProcessEnum.exratecfg.getName()), BusinessProcessEnum.exratecfg.getValue()));
                        items.add(new ComboItem(new LocaleString(BusinessProcessEnum.expiredey.getName()), BusinessProcessEnum.expiredey.getValue()));
                        break;
                    }
                    case BONDFIX: 
                    case BONDFLOAT: {
                        items.add(new ComboItem(new LocaleString(BusinessProcessEnum.ratecfg.getName()), BusinessProcessEnum.ratecfg.getValue()));
                        items.add(new ComboItem(new LocaleString(BusinessProcessEnum.exratecfg.getName()), BusinessProcessEnum.exratecfg.getValue()));
                        items.add(new ComboItem(new LocaleString(BusinessProcessEnum.pay.getName()), BusinessProcessEnum.pay.getValue()));
                        items.add(new ComboItem(new LocaleString(BusinessProcessEnum.redemption.getName()), BusinessProcessEnum.redemption.getValue()));
                        items.add(new ComboItem(new LocaleString(BusinessProcessEnum.sellback.getName()), BusinessProcessEnum.sellback.getValue()));
                        break;
                    }
                    case FORWRATEAGREE: 
                    case STRUCTDEPOSIT: {
                        items.add(new ComboItem(new LocaleString(BusinessProcessEnum.ratecfg.getName()), BusinessProcessEnum.ratecfg.getValue()));
                        items.add(new ComboItem(new LocaleString(BusinessProcessEnum.pay.getName()), BusinessProcessEnum.pay.getValue()));
                        break;
                    }
                    case SWAP: {
                        items.add(new ComboItem(new LocaleString(BusinessProcessEnum.ratecfg.getName()), BusinessProcessEnum.ratecfg.getValue()));
                        items.add(new ComboItem(new LocaleString(BusinessProcessEnum.exratecfg.getName()), BusinessProcessEnum.exratecfg.getValue()));
                        items.add(new ComboItem(new LocaleString(BusinessProcessEnum.pay.getName()), BusinessProcessEnum.pay.getValue()));
                        break;
                    }
                    case FOREXOPTION: 
                    case BONDOPTION: 
                    case RATEBOUND: {
                        items.add(new ComboItem(new LocaleString(BusinessProcessEnum.exercise.getName()), BusinessProcessEnum.exercise.getValue()));
                        items.add(new ComboItem(new LocaleString(BusinessProcessEnum.giveup.getName()), BusinessProcessEnum.giveup.getValue()));
                        items.add(new ComboItem(new LocaleString(BusinessProcessEnum.flat.getName()), BusinessProcessEnum.flat.getValue()));
                    }
                }
                this.initComboItems("businessprocess", items);
            }
        }
    }

    private void initComboItems(String propertyName, List<ComboItem> itemList) {
        ComboEdit property = (ComboEdit)this.getControl(propertyName);
        property.setComboItems(itemList);
    }
}

