/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.investvarieties;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.plugin.TemplateTreePlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class VarTreeList
extends TemplateTreePlugin {
    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        ITreeModel treeModel = this.getTreeListView().getTreeModel();
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("cim".equals(appId) && EmptyUtil.isNoEmpty((Object)this.getView().getParentView())) {
            List<String> investtypes;
            String sourceEntityId;
            switch (sourceEntityId = this.getView().getParentView().getEntityId()) {
                case "cim_deposit_apply": {
                    investtypes = Arrays.asList("fixed", "notice", "structure", "huge");
                    break;
                }
                case "cim_deposit": {
                    investtypes = Arrays.asList("fixed", "structure", "huge");
                    break;
                }
                case "cim_noticedeposit": {
                    investtypes = Collections.singletonList("notice");
                    break;
                }
                default: {
                    investtypes = Arrays.asList("finance", "fixed", "notice", "structure", "huge");
                }
            }
            treeModel.getTreeFilter().add(new QFilter("id", "in", this.getInvestvarietIds(investtypes)));
        }
    }

    private Set<Long> getInvestvarietIds(List investtypes) {
        QFilter qFilter = new QFilter("investtype", "in", (Object)investtypes);
        qFilter.and("enable", "=", (Object)"1");
        DynamicObjectCollection investvarieties = QueryServiceHelper.query((String)"cim_investvarieties", (String)"id", (QFilter[])qFilter.toArray());
        HashSet<Long> investvarietiesIds = new HashSet<Long>();
        investvarieties.stream().forEach(item -> investvarietiesIds.add(item.getLong("id")));
        investvarietiesIds.remove(0L);
        return investvarietiesIds;
    }
}

