/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.lendingmarketrate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbd.common.property.LendingMarketRateProp;

public class LendingMarketRateTreeList
extends AbstractListPlugin
implements TreeNodeClickListener {
    public static final String SEPARATOR = "&";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.equals("termcategory.id")) {
            QFilter qFilter = new QFilter("name", "not in", (Object)ResManager.loadKDString((String)"\u5373\u671f", (String)"LendingMarketRateTreeList_1", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
            qFilter.and(new QFilter("name", "not in", (Object)ResManager.loadKDString((String)"\u6d3b\u671f", (String)"LendingMarketRateTreeList_2", (String)"tmc-fbp-formplugin", (Object[])new Object[0])));
            args.getQfilters().add(qFilter);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            QFilter qFilter;
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilter.getFieldName();
            DynamicObject[] loanObjs = BusinessDataServiceHelper.load((String)"fbd_loanmarketrate", (String)"lendingmarket.id,termcategory.id,currency.id", (QFilter[])new QFilter[0]);
            ArrayList<Object> lendingmarketId = new ArrayList<Object>(10);
            ArrayList<Object> termcategoryId = new ArrayList<Object>(10);
            ArrayList<Object> currencyId = new ArrayList<Object>(10);
            for (DynamicObject loanObj : loanObjs) {
                lendingmarketId.add(loanObj.get("lendingmarket.id"));
                termcategoryId.add(loanObj.get("termcategory.id"));
                currencyId.add(loanObj.get("currency.id"));
            }
            if ("termcategory.name".equals(fieldName)) {
                qFilter = new QFilter("name", "not in", (Object)ResManager.loadKDString((String)"\u5373\u671f", (String)"LendingMarketRateTreeList_1", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
                qFilter.and(new QFilter("name", "not in", (Object)ResManager.loadKDString((String)"\u6d3b\u671f", (String)"LendingMarketRateTreeList_2", (String)"tmc-fbp-formplugin", (Object[])new Object[0])));
                qFilter.and(new QFilter("id", "in", termcategoryId));
                DynamicObject[] objs = BusinessDataServiceHelper.load((String)"fbd_termcategorycode", (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)"createtime");
                this.commonFilter(filterColumn, objs);
            }
            if ("lendingmarket.name".equals(fieldName)) {
                qFilter = new QFilter("id", "in", lendingmarketId);
                DynamicObject[] objs = BusinessDataServiceHelper.load((String)"fbd_lendingmarketcode", (String)"id", (QFilter[])new QFilter[]{qFilter});
                this.commonFilter(filterColumn, objs);
            }
            if (!"currency.name".equals(fieldName)) continue;
            qFilter = new QFilter("id", "in", currencyId);
            DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{qFilter});
            this.commonFilter(filterColumn, objs);
        }
    }

    private void commonFilter(FilterColumn filterColumn, DynamicObject[] objs) {
        CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
        ArrayList<ComboItem> ids = new ArrayList<ComboItem>(10);
        for (DynamicObject obj : objs) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(obj.getString("name")));
            item.setValue(obj.getString("id"));
            ids.add(item);
        }
        commonFilter.setComboItems(ids);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        switch (opKey) {
            case "refresh": 
            case "delete": {
                this.initTree(this.queryLoanMarketRateData(), treeView);
                treeView.expand(BigDecimal.ZERO.toString());
                break;
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        Control source = (Control)evt.getSource();
        String eventKey = source.getKey();
        if ("treeviewap".equals(eventKey)) {
            String clickNodeId = evt.getNodeId().toString();
            this.refreshBillList(clickNodeId);
            treeView.showNode(clickNodeId);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        this.initTree(this.queryLoanMarketRateData(), treeView);
        treeView.expand(BigDecimal.ZERO.toString());
    }

    private void refreshBillList(String clickNodeId) {
        BillList billList = (BillList)this.getControl("billlistap");
        FilterParameter fp = new FilterParameter();
        QFilter filter = this.assemblyFilterCondition(clickNodeId);
        fp.setFilter(filter);
        billList.setFilterParameter(fp);
        billList.addSetFilterListener(event -> event.getQFilters().add(filter));
        billList.refresh();
        billList.clearSelection();
    }

    private QFilter assemblyFilterCondition(String clickNodeId) {
        QFilter filter = null;
        String[] conditionIds = clickNodeId.split(SEPARATOR);
        if (null != conditionIds) {
            if (LendingMarketRateProp.ONE.compareTo(conditionIds.length) == 0 && 0 != BigDecimal.ZERO.compareTo(new BigDecimal(clickNodeId))) {
                filter = new QFilter("lendingmarket", "=", (Object)Long.valueOf(conditionIds[0]));
            } else if (LendingMarketRateProp.TWO == conditionIds.length) {
                filter = new QFilter("lendingmarket", "=", (Object)Long.valueOf(conditionIds[0]));
                filter.and("currency", "=", (Object)Long.valueOf(conditionIds[1]));
            }
        }
        return filter;
    }

    private void initTree(Map<Long, Map<Long, List<DynamicObject>>> loanMarketGroupColls, TreeView treeView) {
        TreeNode root = new TreeNode("", BigDecimal.ZERO.toString(), ResManager.loadKDString((String)"\u5168\u90e8", (String)"LendingMarketRateTreeList_0", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
        Iterator<Map.Entry<Long, Map<Long, List<DynamicObject>>>> loanMarketGroupNodeIt = loanMarketGroupColls.entrySet().iterator();
        ArrayList loanNodeLst = new ArrayList(loanMarketGroupColls.size());
        while (loanMarketGroupNodeIt.hasNext()) {
            DynamicObject loanMarketElem = null;
            Map.Entry<Long, Map<Long, List<DynamicObject>>> loanMarketGroupEntry = loanMarketGroupNodeIt.next();
            Long loanMarketNodeId = loanMarketGroupEntry.getKey();
            Map<Long, List<DynamicObject>> currencyGroupColls = loanMarketGroupEntry.getValue();
            ArrayList<TreeNode> leafNodeLst = new ArrayList<TreeNode>(currencyGroupColls.size());
            for (Map.Entry<Long, List<DynamicObject>> currencyGroupEntry : currencyGroupColls.entrySet()) {
                Long currencyNodeId = currencyGroupEntry.getKey();
                List<DynamicObject> elems = currencyGroupEntry.getValue();
                if (elems.isEmpty()) continue;
                TreeNode leafNode = new TreeNode(loanMarketNodeId.toString(), String.format("%s&%s", loanMarketNodeId.toString(), currencyNodeId.toString()), elems.get(0).getString("currency.name"));
                loanMarketElem = Optional.ofNullable(loanMarketElem).orElseGet(() -> (DynamicObject)elems.get(0));
                leafNodeLst.add(leafNode);
            }
            Optional.ofNullable(loanMarketElem).ifPresent(consumer -> {
                TreeNode loanNode = new TreeNode(root.getParentid(), loanMarketNodeId.toString(), consumer.getString("lendingmarket.number"));
                loanNodeLst.add(loanNode);
                if (!leafNodeLst.isEmpty()) {
                    loanNode.addChildren(leafNodeLst);
                }
            });
        }
        root.setChildren(loanNodeLst);
        treeView.addNode(root);
        treeView.updateNode(root);
    }

    private Map<Long, Map<Long, List<DynamicObject>>> queryLoanMarketRateData() {
        DynamicObjectCollection loanMarketRateColls = QueryServiceHelper.query((String)"fbd_loanmarketrate", (String)"id,currency,currency.name,status,lendingmarket,lendingmarket.name,lendingmarket.number,termcategory,termcategory.number,rate", (QFilter[])new QFilter[0]);
        return loanMarketRateColls.stream().collect(Collectors.groupingBy(loanMarkert -> loanMarkert.getLong("lendingmarket"), Collectors.groupingBy(currency -> currency.getLong("currency"))));
    }
}

