/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.pricerule;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.YieldTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PriceRuleYieldEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "markets": {
                this.changeByCurMkt();
                break;
            }
            case "yields": {
                int rowIndex = e.getChangeSet()[0].getRowIndex();
                if (!EmptyUtil.isNoEmpty((Object)e.getChangeSet()[0].getNewValue())) break;
                DynamicObject yield = (DynamicObject)e.getChangeSet()[0].getNewValue();
                this.getModel().setValue("bootstrap", yield.get("bootstrap"), rowIndex);
                this.getModel().setValue("interpolation", yield.get("interptype"), rowIndex);
                this.getModel().setValue("swpbndmethod", yield.get("bonddealtype"), rowIndex);
            }
        }
    }

    private void changeByCurMkt() {
        HashSet<Long> markIds = new HashSet<Long>();
        DynamicObjectCollection marketColl = (DynamicObjectCollection)this.getModel().getValue("markets");
        for (DynamicObject market : marketColl) {
            markIds.add(market.getDynamicObject("fbasedataid").getLong("id"));
        }
        HashSet<Long> existMarkIds = new HashSet<Long>();
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("yield");
        for (int index = entryColl.size() - 1; index >= 0; --index) {
            if (EmptyUtil.isNoEmpty((DynamicObject)((DynamicObject)entryColl.get(index)).getDynamicObject("market"))) {
                Long id = ((DynamicObject)entryColl.get(index)).getDynamicObject("market").getLong("id");
                if (!markIds.contains(id)) {
                    this.getModel().deleteEntryRow("yield", index);
                    continue;
                }
                existMarkIds.add(id);
                continue;
            }
            this.getModel().deleteEntryRow("yield", index);
        }
        for (DynamicObject market : marketColl) {
            DynamicObject curmktInfo = (DynamicObject)market.get("fbasedataid");
            if (existMarkIds.contains(curmktInfo.getLong("id"))) continue;
            int[] rowIndexs = this.getModel().batchCreateNewEntryRow("yield", 2);
            int firstIndex = rowIndexs[0];
            int secondIndex = rowIndexs[1];
            this.getModel().setValue("market", (Object)curmktInfo, firstIndex);
            this.getModel().setValue("type", (Object)YieldTypeEnum.disc.getValue(), firstIndex);
            this.getModel().setValue("market", (Object)curmktInfo, secondIndex);
            this.getModel().setValue("type", (Object)YieldTypeEnum.ref.getValue(), secondIndex);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"yields")) {
            DynamicObject market = (DynamicObject)this.getModel().getValue("market", evt.getRow());
            if (EmptyUtil.isEmpty((DynamicObject)market)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e02\u573a\u3002", (String)"PriceRuleYieldEdit_0", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            }
            DynamicObject currency = market.getDynamicObject("currency");
            QFilter qFilter = new QFilter("currency.id", "=", currency.getPkValue());
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid buyMarket = (EntryGrid)this.getView().getControl("yield");
        List controls = buyMarket.getControls();
        BasedataEdit control = (BasedataEdit)controls.get(3);
        control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit yieldCurve = (BasedataEdit)this.getView().getControl("yields");
        Optional.ofNullable(yieldCurve).ifPresent(c -> c.addBeforeF7ViewDetailListener(this::beforeF7ViewDetail));
    }

    private void beforeF7ViewDetail(BeforeF7ViewDetailEvent event) {
        Object pkId = event.getPkId();
        BasedataEdit source = (BasedataEdit)event.getSource();
        String key = source.getKey();
        if ("yields".equals(key)) {
            event.setCancel(true);
            BillShowParameter billShowParameter = new BillShowParameter();
            String formid = "md_yieldline";
            billShowParameter.setFormId(formid);
            billShowParameter.setPkId(pkId);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }
}

