/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.referrate;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tmc.fbp.common.enums.RateTermEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReferRateBatchEdit
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        Object currencyId;
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object marketId = customParams.getOrDefault("market", null);
        if (EmptyUtil.isNoEmpty(marketId)) {
            this.getModel().setValue("market", marketId);
        }
        if (EmptyUtil.isNoEmpty(currencyId = customParams.getOrDefault("currency", null))) {
            this.getModel().setValue("currency", currencyId);
        }
        this.setTermMustInput();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "currency": 
            case "market": {
                this.referRateNumberChgEvt();
                this.setTermMustInput();
                break;
            }
            case "term": {
                this.termChgEvt(e);
                break;
            }
        }
    }

    private void termChgEvt(PropertyChangedArgs e) {
        String trem = (String)e.getChangeSet()[0].getNewValue();
        if (EmptyUtil.isEmpty((String)trem)) {
            return;
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        int len = entrys.size();
        for (int i = 0; i < len; ++i) {
            if (rowIndex == i || !StringUtils.equals((CharSequence)((DynamicObject)entrys.get(i)).getString("term"), (CharSequence)trem)) continue;
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", null, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"number", null, (int)rowIndex);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53c2\u8003\u5229\u7387\u671f\u9650\u4e0d\u80fd\u91cd\u590d\u3002", (String)"ReferRateBatchEdit_0", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return;
        }
        this.genAndSetReferRateNumber(e.getChangeSet()[0].getRowIndex());
    }

    private void referRateNumberChgEvt() {
        int entryRowCount = this.getModel().getEntryRowCount("entry");
        for (int i = 0; i < entryRowCount; ++i) {
            this.genAndSetReferRateNumber(i);
        }
    }

    private void genAndSetReferRateNumber(int currEntry) {
        String term = this.getModel().getEntryRowEntity("entry", currEntry).getString("term");
        DynamicObject market = (DynamicObject)this.getModel().getValue("market");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{term, market, currency})) {
            this.getModel().setValue("number", null, currEntry);
        } else {
            String referRateNumber = market.getString("number") + currency.getString("number") + RateTermEnum.getName((String)term);
            int length = referRateNumber.length();
            if (length > 30) {
                referRateNumber = referRateNumber.substring(length - 30, length);
            }
            this.getModel().setValue("number", (Object)referRateNumber, currEntry);
        }
    }

    private boolean getTermIsMustInputOrNot() {
        DynamicObject market = (DynamicObject)this.getModel().getValue("market");
        HashSet<String> refSet = new HashSet<String>(2);
        refSet.add("tzck");
        refSet.add("rate");
        refSet.add("jgxck");
        boolean isNotMustInput = EmptyUtil.isNoEmpty((DynamicObject)market) && refSet.contains(market.getString("number"));
        return !isNotMustInput;
    }

    private void setTermMustInput() {
        boolean mustInput = this.getTermIsMustInputOrNot();
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)mustInput, (String[])new String[]{"term"});
    }
}

