/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.release;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildDrawFilterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbd.common.enums.SuretyStatusEnum;
import kd.tmc.fbd.common.helper.SuretyBillHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class SuretyReleaseBillConvertPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] extendedDataEntities;
        super.afterConvert(e);
        Map opMap = this.getOption().getVariables();
        String suretyReleaseDebtBillIdStr = (String)opMap.get("suretyReleaseDebtBillIdStr");
        ExtendedDataEntitySet targetExtDataEntitySet = e.getTargetExtDataEntitySet();
        String entityName = this.getTgtMainType().getName();
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities = targetExtDataEntitySet.FindByEntityKey(entityName)) {
            DynamicObject tagBill = extendedDataEntity.getDataEntity();
            DynamicObject srcBill = tagBill.getDynamicObject("suretybill");
            this.dealNoFinishBill(entityName, srcBill);
            this.validAndSetLoanRate(srcBill, tagBill);
            this.dealSettleEntryData(tagBill, srcBill, suretyReleaseDebtBillIdStr);
            this.setReleaseDate(tagBill, srcBill);
        }
    }

    private void setReleaseDate(DynamicObject tagBill, DynamicObject srcBill) {
        Date expireDate = srcBill.getDate("expiredate");
        if (EmptyUtil.isNoEmpty((Object)expireDate)) {
            tagBill.set("releasedate", (Object)expireDate);
        } else {
            tagBill.set("releasedate", (Object)DateUtils.getCurrentDate());
        }
    }

    private void dealNoFinishBill(String entityName, DynamicObject srcBill) {
        QFilter existFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()).and("sourcebillid", "=", (Object)srcBill.getLong("id"));
        if (TmcDataServiceHelper.exists((String)entityName, (QFilter[])existFilter.toArray())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u4e0b\u6e38\u672a\u5b8c\u6210\u7684\u5b58\u51fa\u5355\u3002", (String)"SuretyReleaseBillConvertPlugin_0", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
        }
    }

    private void dealSettleEntryData(DynamicObject tagBill, DynamicObject srcBill, String suretyReleaseDebtBillIdStr) {
        Map debtBillStatusMap = SuretyBillHelper.getAndSetDebtBillStatus((long)srcBill.getLong("id"), (String)"fbd_suretybill");
        DynamicObjectCollection entryCol = tagBill.getDynamicObjectCollection("entry");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryCol)) {
            ArrayList<DynamicObject> yetSettleDebtBillDos = new ArrayList<DynamicObject>(entryCol.size());
            for (DynamicObject entry : entryCol) {
                String debtStatus;
                long debtBillId = entry.getLong("debtbillid");
                String string = debtStatus = EmptyUtil.isEmpty((Object)debtBillStatusMap) || debtBillStatusMap.get(debtBillId) == null ? null : (String)((Pair)debtBillStatusMap.get(debtBillId)).getLeft();
                if (!SuretyStatusEnum.SETTLED.getValue().equals(debtStatus) && (!EmptyUtil.isNoEmpty((String)suretyReleaseDebtBillIdStr) || debtBillId == Long.parseLong(suretyReleaseDebtBillIdStr))) continue;
                yetSettleDebtBillDos.add(entry);
            }
            entryCol.removeAll(yetSettleDebtBillDos);
        }
    }

    private void validAndSetLoanRate(DynamicObject srcBill, DynamicObject tagBill) {
        Date expireDate = srcBill.getDate("expiredate");
        if (InterestTypeEnum.FLOAT.getValue().equals(srcBill.getString("interesttype")) && EmptyUtil.isNoEmpty((Object)expireDate)) {
            Date releaseDate = tagBill.getDate("releasedate");
            BigDecimal loanDateYearRate = SuretyBillHelper.getDateYearRate((DynamicObject)srcBill, (Date)releaseDate);
            if (EmptyUtil.isEmpty((BigDecimal)loanDateYearRate)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u57fa\u7840\u8d44\u6599\u5e94\u7528\u4e0b\u7684\u53c2\u8003\u5229\u7387\u6570\u636e\u3002", (String)"SuretyReleaseBillConvertPlugin_1", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            }
            tagBill.set("interestrate", (Object)loanDateYearRate);
        }
    }

    public void afterBuildDrawFilter(AfterBuildDrawFilterEventArgs e) {
        super.afterBuildDrawFilter(e);
        QFilter qFilter = new QFilter("entry_credit", "is null", null).or(new QFilter("entry_credit", "is not null", null).and(String.join((CharSequence)".", "entry_credit", "creditbillid", "isclose"), "=", (Object)true));
        e.setPlugFilter(qFilter);
    }
}

