/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.settleconfig;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SettleConfigEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgEdit = (BasedataEdit)this.getView().getControl("org");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bankAccountEdit = (BasedataEdit)this.getView().getControl("bankaccount");
        bankAccountEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit currencyEdit = (BasedataEdit)this.getView().getControl("currencycol");
        currencyEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "bankaccount": {
                DynamicObject bankAccount = (DynamicObject)this.getModel().getValue("bankaccount");
                if (EmptyUtil.isNoEmpty((DynamicObject)bankAccount)) {
                    DynamicObjectCollection currencyCol = bankAccount.getDynamicObjectCollection("currency");
                    if (currencyCol.size() == 1) {
                        this.getModel().setValue("currencycol", (Object)currencyCol);
                        break;
                    }
                    this.getModel().setValue("currencycol", null);
                    break;
                }
                this.getModel().setValue("currencycol", null);
                break;
            }
            case "org": 
            case "counterparty": 
            case "settletype": {
                this.getModel().setValue("bankaccount", null);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String flag = event.getProperty().getName();
        if (flag.equals("org")) {
            String appId = this.getView().getFormShowParameter().getAppId();
            List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
            QFilter filter = new QFilter("id", "in", (Object)comIdList);
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(filter);
        }
        if (flag.equals("bankaccount")) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            DynamicObject counterParty = (DynamicObject)this.getModel().getValue("counterparty");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{org, counterParty})) {
                event.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ea4\u6613\u4e3b\u4f53\u3001\u4ea4\u6613\u5bf9\u624b\u3002", (String)"SettleConfigEdit_0", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            } else {
                QFilter qFilter = TmcAccountHelper.getAccountBankFilterByOrg((Long)((DynamicObject)this.getModel().getValue("org")).getLong("id"));
                Iterator filter_status = new QFilter("acctstatus", "=", (Object)"normal");
                QFilter filter_type = new QFilter("finorgtype", "!=", (Object)"1");
                qFilter.and((QFilter)filter_status).and(filter_type);
                DynamicObject settleType = (DynamicObject)this.getModel().getValue("settletype");
                if (EmptyUtil.isNoEmpty((DynamicObject)settleType)) {
                    QFilter filter_settleType = new QFilter("settlementtype.fbasedataid", "in", (Object)settleType.getLong("id"));
                    filter_settleType = filter_settleType.or(QFilter.isNull((String)"settlementtype.fbasedataid"));
                    qFilter.and(filter_settleType);
                }
                ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
            }
        }
        if (flag.equals("currencycol")) {
            DynamicObject bankAccount = (DynamicObject)this.getModel().getValue("bankaccount");
            if (EmptyUtil.isEmpty((DynamicObject)bankAccount)) {
                event.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6211\u65b9\u94f6\u884c\u8d26\u53f7\u3002", (String)"SettleConfigEdit_1", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            } else {
                DynamicObjectCollection currencyCol = bankAccount.getDynamicObjectCollection("currency");
                HashSet<Long> ids = new HashSet<Long>(currencyCol.size());
                for (DynamicObject currency : currencyCol) {
                    ids.add(currency.getLong("fbasedataid_id"));
                }
                QFilter filter = new QFilter("id", "in", ids);
                ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
                showParameter.getListFilterParameter().getQFilters().add(filter);
            }
        }
    }
}

