/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.settleconfig;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SettleConfigImportPlugin
extends AbstractBillPlugIn {
    public void afterImportData(ImportDataEventArgs e) {
        DynamicObjectCollection currencyCollection;
        String diffCurrencyNumbers;
        DynamicObject bankAccount;
        DynamicObject settleType;
        DynamicObject counterParty;
        HasPermOrgResult result;
        ArrayList<String> errorMsgList = new ArrayList<String>();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            errorMsgList.add(ResManager.loadKDString((String)"\u4ea4\u6613\u4e3b\u4f53\u3010%s\u3011\u672a\u80fd\u5339\u914d\u5230\u8bb0\u5f55\u3002", (String)"SettleConfigImportPlugin_2", (String)"tmc-fbd-formplugin", (Object[])new Object[]{this.getValue(e, "org")}));
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)org) && (result = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"08", (String)this.getView().getFormShowParameter().getAppId(), (String)this.getModel().getDataEntityType().getName(), (String)"47156aff000000ac")) != null && !result.hasAllOrgPerm() && result.getHasPermOrgs() != null && !result.getHasPermOrgs().contains(org.getLong("id"))) {
            errorMsgList.add(ResManager.loadKDString((String)"\u3010%s\u3011\u65e0\u8be5\u4ea4\u6613\u4e3b\u4f53\u7684\u6743\u9650\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"SettleConfigImportPlugin_3", (String)"tmc-fbd-formplugin", (Object[])new Object[]{this.getValue(e, "org")}));
        }
        if (EmptyUtil.isEmpty((DynamicObject)(counterParty = (DynamicObject)this.getModel().getValue("counterparty")))) {
            errorMsgList.add(ResManager.loadResFormat((String)"\u4ea4\u6613\u5bf9\u624b\u3010%s\u3011\u672a\u80fd\u5339\u914d\u5230\u8bb0\u5f55\u3002", (String)"SettleConfigImportPlugin_4", (String)"tmc-fbd-formplugin", (Object[])new Object[]{this.getValue(e, "counterparty")}));
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(settleType = (DynamicObject)this.getModel().getValue("settletype"))) && "0".equals((settleType = this.queryWholeDynamicObject(settleType)).getString("settlementtype"))) {
            errorMsgList.add(ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u652f\u6301\u73b0\u91d1\u7c7b\u522b\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"SettleConfigImportPlugin_5", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty((DynamicObject)(bankAccount = (DynamicObject)this.getModel().getValue("bankaccount")))) {
            errorMsgList.add(ResManager.loadKDString((String)"\u6211\u65b9\u94f6\u884c\u8d26\u53f7\u3010%s\u3011\u672a\u80fd\u5339\u914d\u5230\u8bb0\u5f55\u3002", (String)"SettleConfigImportPlugin_6", (String)"tmc-fbd-formplugin", (Object[])new Object[]{this.getValue(e, "bankaccount")}));
        } else {
            DynamicObjectCollection settleTypeCollection;
            DynamicObject[] ids;
            bankAccount = this.queryWholeDynamicObject(bankAccount);
            long aLong = (Long)bankAccount.getPkValue();
            if (EmptyUtil.isNoEmpty((DynamicObject)org) && Arrays.stream(ids = TmcAccountHelper.getAccountBanksByOrg((Long)org.getLong("id"))).noneMatch(a -> (Long)a.getPkValue() == aLong)) {
                errorMsgList.add(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u4e0d\u5728\u4ea4\u6613\u4e3b\u4f53\u6709\u6743\u9650\u7684\u94f6\u884c\u8d26\u6237\u4e2d\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"SettleConfigImportPlugin_7", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            }
            if (!"normal".equals(bankAccount.getString("acctstatus"))) {
                errorMsgList.add(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u6216\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"SettleConfigImportPlugin_8", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            }
            if ("1".equals(bankAccount.getString("finorgtype"))) {
                errorMsgList.add(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u7684\u91d1\u878d\u673a\u6784\u7c7b\u522b\u4e0d\u80fd\u662f\u7ed3\u7b97\u4e2d\u5fc3\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"SettleConfigImportPlugin_9", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)settleType) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(settleTypeCollection = bankAccount.getDynamicObjectCollection("settlementtype"))) && !this.isContain(settleTypeCollection, settleType)) {
                errorMsgList.add(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u7684\u9650\u5b9a\u7ed3\u7b97\u65b9\u5f0f\u4e0e\u914d\u7f6e\u7684\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"SettleConfigImportPlugin_10", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            }
        }
        DynamicObjectCollection currencyCol = (DynamicObjectCollection)this.getModel().getValue("currencycol");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)currencyCol)) {
            errorMsgList.add(ResManager.loadKDString((String)"\u5e01\u79cd\u3010%s\u3011\u672a\u80fd\u5339\u914d\u5230\u8bb0\u5f55\u3002", (String)"SettleConfigImportPlugin_11", (String)"tmc-fbd-formplugin", (Object[])new Object[]{this.getValue(e, "currencycol")}));
        } else if (EmptyUtil.isNoEmpty((DynamicObject)bankAccount) && EmptyUtil.isNoEmpty((String)(diffCurrencyNumbers = this.getDiffCurrencyNumbers(currencyCollection = bankAccount.getDynamicObjectCollection("currency"), currencyCol)))) {
            errorMsgList.add(ResManager.loadKDString((String)"\u6211\u65b9\u94f6\u884c\u8d26\u53f7\u3010%1$s\u3011\u4e2d\u65e0\u5e01\u79cd\u3010%2$s\u3011\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"SettleConfigImportPlugin_12", (String)"tmc-fbd-formplugin", (Object[])new Object[]{this.getValue(e, "bankaccount"), diffCurrencyNumbers}));
        }
        this.dealErrorMsgList(errorMsgList);
    }

    private String getDiffCurrencyNumbers(DynamicObjectCollection collection1, DynamicObjectCollection collection2) {
        Set set1 = collection1.stream().map(obj -> ((DynamicObject)obj.get("fbasedataid")).getString("number")).collect(Collectors.toSet());
        Set set2 = collection2.stream().map(obj -> ((DynamicObject)obj.get("fbasedataid")).getString("number")).collect(Collectors.toSet());
        HashSet<String> set = new HashSet<String>();
        for (String s2 : set2) {
            if (set1.contains(s2)) continue;
            set.add(s2);
        }
        if (EmptyUtil.isNoEmpty(set)) {
            return String.join((CharSequence)",", set);
        }
        return null;
    }

    private boolean isContain(DynamicObjectCollection collection, DynamicObject dynamicObject) {
        for (DynamicObject obj : collection) {
            if (((DynamicObject)obj.get("fbasedataid")).getLong("id") != dynamicObject.getLong("id")) continue;
            return true;
        }
        return false;
    }

    private DynamicObject queryWholeDynamicObject(DynamicObject obj) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)obj.get("id"), (String)obj.getDynamicObjectType().getName());
    }

    private Object getValue(ImportDataEventArgs e, String key) {
        return ((JSONObject)e.getSourceData().get(key)).get(((JSONObject)e.getSourceData().get(key)).get((Object)"importprop"));
    }

    protected void dealErrorMsgList(List<String> errorMsgList) {
        if (EmptyUtil.isNoEmpty(errorMsgList)) {
            StringBuilder errorMsg = new StringBuilder();
            for (String msg : errorMsgList) {
                errorMsg.append(msg);
                errorMsg.append('\n');
            }
            throw new KDBizException(errorMsg.toString());
        }
    }
}

