/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.subscribe;

import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbd.common.helper.SubscribeHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SubscribeTemplateEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit tplscen = (BasedataEdit)this.getView().getControl("tplscen");
        tplscen.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        this.initFilterGrid();
        this.loadCondition();
        this.setOperateItems();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("datasource".equals(e.getProperty().getName())) {
            this.initFilterGrid();
            this.checkTplscen();
            this.getModel().setValue("subscribeop", null);
            this.setOperateItems();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if ("tplscen".equals(key)) {
            Object dataSource = this.getModel().getValue("datasource");
            if (EmptyUtil.isEmpty((Object)dataSource)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"SubscribeTemplateEdit_0", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Object dataSourceId = ((DynamicObject)dataSource).getPkValue();
            QFilter filter = new QFilter("entitynumber", "=", dataSourceId);
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            sp.getListFilterParameter().getQFilters().add(filter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate formOperate = (AbstractOperate)args.getSource();
        String operate = formOperate.getOperateKey();
        if ("save".equals(operate)) {
            FilterCondition condition = this.getCondition("filtergrid");
            this.getModel().setValue("filter_tag", (Object)SerializationUtils.toJsonString((Object)condition));
            condition = this.getCondition("filtergrfixid");
            this.getModel().setValue("fixfilter_tag", (Object)SerializationUtils.toJsonString((Object)condition));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("save".equals(args.getOperateKey())) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"status", (Object)BillStatusEnum.SAVE.getValue());
        }
    }

    private void initFilterGrid() {
        DynamicObject dataSource = (DynamicObject)this.getModel().getValue("datasource");
        if (EmptyUtil.isNoEmpty((DynamicObject)dataSource)) {
            String number = dataSource.getString("number");
            this.initFilterByDataSource("filtergrid", number);
            this.initFilterByDataSource("filtergrfixid", number);
        } else {
            this.initFilterByDataSource("filtergrid", null);
            this.initFilterByDataSource("filtergrfixid", null);
        }
    }

    private void initFilterByDataSource(String filterProp, String dataSourceNumber) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(filterProp);
        filterGrid.setEntityNumber(dataSourceNumber);
        filterGrid.SetValue(new FilterCondition());
        this.getView().updateView(filterProp);
    }

    private void checkTplscen() {
        DynamicObject tplscenObj;
        Object msgentityPk;
        Object dataSource = this.getModel().getValue("datasource");
        if (EmptyUtil.isEmpty((Object)dataSource)) {
            this.getModel().setValue("tplscen", null);
            return;
        }
        Object tplscen = this.getModel().getValue("tplscen");
        if (EmptyUtil.isNoEmpty((Object)tplscen) && !(msgentityPk = (tplscenObj = (DynamicObject)tplscen).getDynamicObject("entitynumber").getPkValue()).equals(((DynamicObject)dataSource).getPkValue())) {
            this.getModel().setValue("tplscen", null);
        }
    }

    private void loadCondition() {
        DynamicObject dataSource = (DynamicObject)this.getModel().getValue("datasource");
        if (EmptyUtil.isNoEmpty((DynamicObject)dataSource)) {
            this.loadConditionByFilter("filter_tag", "filtergrid");
            this.loadConditionByFilter("fixfilter_tag", "filtergrfixid");
        }
    }

    private void loadConditionByFilter(String filterCon, String filterGrid) {
        FilterCondition filterCondition;
        String filter = (String)this.getModel().getValue(filterCon);
        if (EmptyUtil.isNoEmpty((String)filter) && (filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class)) != null) {
            FilterGrid filterControl = (FilterGrid)this.getView().getControl(filterGrid);
            filterControl.SetValue(filterCondition);
        }
    }

    private FilterCondition getCondition(String filtergrid) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(filtergrid);
        return filterGrid.getFilterGridState().getFilterCondition();
    }

    public void setOperateItems() {
        DynamicObject dataSource = (DynamicObject)this.getModel().getValue("datasource");
        if (EmptyUtil.isEmpty((DynamicObject)dataSource)) {
            return;
        }
        List items = SubscribeHelper.getOperateItems((String)dataSource.getString("number"));
        ComboEdit subscribeOps = (ComboEdit)this.getView().getControl("subscribeop");
        subscribeOps.setComboItems(items);
    }
}

