/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.surety;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RevDetailCardPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (customParams.containsKey("intdetail_tag")) {
            this.loanIntDetailInfo(customParams);
        } else {
            this.loanIntRevenueDetailInfo(customParams);
        }
    }

    private void loanIntDetailInfo(Map<String, Object> customParams) {
        Object currency = customParams.get("currency");
        String callIntStr = (String)customParams.get("intdetail_tag");
        if (EmptyUtil.isEmpty((String)callIntStr)) {
            return;
        }
        IntBillInfo intBillInfo = (IntBillInfo)SerializationUtils.fromJsonString((String)callIntStr, IntBillInfo.class);
        List details = intBillInfo.getDetails();
        details.sort((arg0, arg1) -> arg0.getBeginDate().compareTo(arg1.getBeginDate()));
        ArrayList dataMap = new ArrayList(details.size());
        for (IntBillDetailInfo intDetail : details) {
            if (EmptyUtil.isEmpty((BigDecimal)intDetail.getPrinciple())) continue;
            HashMap<String, Object> data = new HashMap<String, Object>(16);
            data.put("startdate", intDetail.getBeginDate());
            data.put("enddate", intDetail.getEndDate());
            data.put("days", intDetail.getDays());
            data.put("finamount", intDetail.getPrinciple());
            data.put("eplanrevenue", intDetail.getRate());
            data.put("currency", currency);
            data.put("convertdays", intDetail.getBasisDay());
            data.put("erevenueamount", intDetail.getAmount());
            dataMap.add(data);
        }
        TmcViewInputHelper.batchFillEntity((String)"entryentity", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), dataMap);
        this.getView().updateView("entryentity");
    }

    private void loanIntRevenueDetailInfo(Map<String, Object> customParams) {
        Object pkId = customParams.get("suretyBillId");
        Object revenueEntryId = customParams.get("revenueEntryId");
        DynamicObject suretyBillDO = TmcDataServiceHelper.loadSingle((Object)pkId, (String)"fbd_suretybill");
        Object currencyId = suretyBillDO.getDynamicObject("currency").getPkValue();
        DynamicObjectCollection revenueEntrys = suretyBillDO.getDynamicObjectCollection("revenue_entry");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("startdate", new Object[0]);
        vs.addField("enddate", new Object[0]);
        vs.addField("days", new Object[0]);
        vs.addField("finamount", new Object[0]);
        vs.addField("eplanrevenue", new Object[0]);
        vs.addField("convertdays", new Object[0]);
        vs.addField("erevenueamount", new Object[0]);
        vs.addField("currency", new Object[0]);
        for (DynamicObject revenueEntry : revenueEntrys) {
            if (!StringUtils.equals((CharSequence)revenueEntry.getPkValue().toString(), (CharSequence)revenueEntryId.toString())) continue;
            DynamicObjectCollection revenueSubentrys = revenueEntry.getDynamicObjectCollection("revenue_subentry");
            for (DynamicObject revenueSubentry : revenueSubentrys) {
                vs.addRow(new Object[]{revenueSubentry.get("startdate"), revenueSubentry.get("enddate"), revenueSubentry.get("days"), revenueSubentry.get("finamount"), revenueSubentry.get("eplanrevenue"), revenueSubentry.get("convertdays"), revenueSubentry.get("erevenueamount"), currencyId});
            }
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
        if (vs.getCount() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u76ca\u6d4b\u7b97\u6570\u636e\u6709\u53d8\u5316\uff0c\u8bf7\u5728\u4fdd\u8bc1\u91d1\u5b58\u5165\u5355\u4e0a\u8fdb\u884c\u5237\u65b0\u540e\u67e5\u770b\u3002", (String)"RevDetailCardPlugin_1", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
        }
    }
}

