/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.surety;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.TextEdit;
import kd.tmc.fbd.common.helper.SuretyHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyAppendBillEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        EntryGrid entryCredit;
        super.registerListener(e);
        TextEdit suretyBillNo = (TextEdit)this.getControl("suretybillno");
        suretyBillNo.addClickListener((ClickListener)this);
        EntryGrid entry = (EntryGrid)this.getControl("entry");
        if (entry != null) {
            entry.addHyperClickListener((HyperLinkClickListener)this);
        }
        if ((entryCredit = (EntryGrid)this.getControl("entry_credit")) != null) {
            entryCredit.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "suretybillno": {
                this.getView().invokeOperation("drawsurty", OperateOption.create());
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        SuretyHelper.showEntry((IFormView)this.getView(), (IDataModel)this.getModel());
        this.getView().setEnable(Boolean.valueOf((Boolean)this.getModel().getValue("isfromdebt") == false), new String[]{"appendflag"});
        this.appendFlagChgEvt();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        switch (propertyName = e.getProperty().getName()) {
            case "appendintdate": {
                Date appendIntDate = (Date)this.getModel().getValue("appendintdate");
                DynamicObject suretyBill = (DynamicObject)this.getModel().getValue("suretybill");
                if (EmptyUtil.isEmpty((Object)this.getModel().getValue("suretybill"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4fdd\u8bc1\u91d1\u5b58\u5165\u5355\u636e\u201d\u3002", (String)"SuretyAppendBillEdit_2", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (appendIntDate.before(suretyBill.getDate("intdate"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ffd\u52a0\u8d77\u606f\u65e5\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u4fdd\u8bc1\u91d1\u5b58\u5165\u5355\u7684\u8d77\u606f\u65e5\u3002", (String)"SuretyAppendBillEdit_3", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!EmptyUtil.isNoEmpty((Object)suretyBill.getDate("expiredate")) || !appendIntDate.after(suretyBill.getDate("expiredate"))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ffd\u52a0\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u4fdd\u8bc1\u91d1\u5b58\u5165\u5355\u7684\u5230\u671f\u65e5\u3002", (String)"SuretyAppendBillEdit_4", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                return;
            }
            case "appendamt": {
                this.releaseAmtChgEvt((BigDecimal)e.getChangeSet()[0].getNewValue(), e.getChangeSet()[0].getRowIndex());
                break;
            }
            case "appendflag": {
                this.appendFlagChgEvt();
                break;
            }
        }
    }

    private void releaseAmtChgEvt(BigDecimal appendAmt, int rowIdx) {
        DynamicObject creditCurrency = (DynamicObject)this.getModel().getValue("creditcurrency", rowIdx);
        DynamicObject appendOrg = (DynamicObject)this.getModel().getValue("org");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"releasecreditamt", (Object)this.exchangeAmt(currency, creditCurrency, appendOrg, appendAmt), (int)rowIdx);
    }

    private void appendFlagChgEvt() {
        Boolean appendFlag = (Boolean)this.getModel().getValue("appendflag");
        appendFlag = appendFlag == null ? Boolean.FALSE : appendFlag;
        for (int rowIdx = 0; rowIdx < this.getModel().getEntryRowCount("entry"); ++rowIdx) {
            if (appendFlag.booleanValue()) {
                TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (int)rowIdx, (String[])new String[]{"appendamt", "releasecreditamt"});
            }
            this.getView().setEnable(Boolean.valueOf(appendFlag == false), rowIdx, new String[]{"appendamt", "releasecreditamt"});
        }
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (appendFlag == false ? 1 : 0) != 0, (String[])new String[]{"appendamt", "releasecreditamt"});
    }

    private BigDecimal exchangeAmt(DynamicObject sourceCurrency, DynamicObject targetCurrency, DynamicObject org, BigDecimal debitAmt) {
        if (EmptyUtil.isEmpty((DynamicObject)sourceCurrency) || EmptyUtil.isEmpty((DynamicObject)targetCurrency)) {
            return BigDecimal.ZERO;
        }
        if (targetCurrency.getLong("id") != sourceCurrency.getLong("id")) {
            BigDecimal debit2AppendExchangeRate = TmcBusinessBaseHelper.getExchangeRateNew((long)sourceCurrency.getLong("id"), (long)targetCurrency.getLong("id"), (long)org.getLong("id"), (Date)DateUtils.getCurrentDate());
            return debitAmt.multiply(debit2AppendExchangeRate);
        }
        return debitAmt;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName;
        switch (fieldName = evt.getFieldName()) {
            case "debtbillno": {
                int rowIndex = evt.getRowIndex();
                if (rowIndex <= -1) break;
                DynamicObject entry = this.getModel().getEntryRowEntity("entry", rowIndex);
                Long srcBillId = entry.getLong("debtbillid");
                if (EmptyUtil.isNoEmpty((Long)srcBillId)) {
                    BillShowParameter parameter = new BillShowParameter();
                    parameter.setFormId(entry.getString("debttype"));
                    parameter.setPkId((Object)srcBillId);
                    parameter.setStatus(OperationStatus.VIEW);
                    parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)parameter);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"SuretyAppendBillEdit_0", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                break;
            }
            case "creditbillid": {
                this.openCreditLayout(evt);
                break;
            }
        }
    }

    private void openCreditLayout(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        if (rowIndex > -1) {
            DynamicObject creditEntry = this.getModel().getEntryRowEntity("entry_credit", rowIndex);
            Long srcBillId = creditEntry.getDynamicObject("creditbillid").getLong("id");
            if (EmptyUtil.isNoEmpty((Long)srcBillId)) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId("cfm_creditlimit");
                parameter.setPkId((Object)srcBillId);
                parameter.setStatus(OperationStatus.VIEW);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)parameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"SuretyAppendBillEdit_5", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

