/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.surety;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbd.common.enums.ConfirmStatusEnum;
import kd.tmc.fbd.common.enums.DebtBillTypeEnum;
import kd.tmc.fbd.common.enums.LoanContractStatusEnum;
import kd.tmc.fbd.common.enums.PartyTypeEnum;
import kd.tmc.fbd.common.enums.RateAdjustStyleEnum;
import kd.tmc.fbd.common.enums.RevenueWayEnum;
import kd.tmc.fbd.common.helper.SuretyBillHelper;
import kd.tmc.fbd.common.helper.SuretyHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillSourceEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.GuaranteeWayEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.OppUnitTypeEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.ListConstructorHelper;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyBillEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static Log logger = LogFactory.getLog(SuretyBillEdit.class);
    private static final String SELECT_PAYEEACCTNO_CLOSECALLBACK = "select_payeeacctno_closecallback";
    private static final String SELECTBILLNO_CLOSECALLBACK = "selectBillNo_closeCallBack";
    private static final String SELECT_PAYEEBANKNAME_CLOSECALLBACK = "select_payeebankname_closecallback";
    private static final String BANK_INFO_PROP = "id,entry_bank,entry_bank.bankaccount,entry_bank.bank";
    private static List<String> UNEDIT_DEBIT_AMT_BILL_LIST = new ArrayList<String>(2);

    public void registerListener(EventObject e) {
        EntryGrid entryCredit;
        super.registerListener(e);
        TextEdit srcBillNo = (TextEdit)this.getControl("debtbillno");
        srcBillNo.addClickListener((ClickListener)this);
        BasedataEdit settAccount = (BasedataEdit)this.getControl("settleaccount");
        settAccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit currency = (BasedataEdit)this.getControl("currency");
        currency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit finAccount = (BasedataEdit)this.getControl("finaccount");
        finAccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit prdFactory = (BasedataEdit)this.getControl("productfactory");
        prdFactory.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit referRate = (BasedataEdit)this.getControl("referencerate");
        referRate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit payeeBankNo = (TextEdit)this.getView().getControl("payeeacctno");
        payeeBankNo.addButtonClickListener((ClickListener)this);
        TextEdit payeeBankName = (TextEdit)this.getView().getControl("payeebankname");
        payeeBankName.addButtonClickListener((ClickListener)this);
        EntryGrid entry = (EntryGrid)this.getControl("entry");
        if (entry != null) {
            entry.addHyperClickListener((HyperLinkClickListener)this);
        }
        if ((entryCredit = (EntryGrid)this.getControl("entry_credit")) != null) {
            entryCredit.addHyperClickListener((HyperLinkClickListener)this);
        }
        BasedataEdit investVarieties = (BasedataEdit)this.getControl("investvarieties");
        investVarieties.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit creditBillId = (BasedataEdit)this.getControl("creditbillid");
        creditBillId.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "debtbillno": {
                this.showBillF7();
                break;
            }
            case "payeeacctno": {
                this.dealAndShowBankInfo();
                break;
            }
            case "payeebankname": {
                this.payeeBankBaseData();
                break;
            }
        }
    }

    private void payeeBankBaseData() {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"bd_bebank", (boolean)false);
        QFilter qFilter = new QFilter("enable", "=", (Object)"1").and("status", "=", (Object)"C");
        showParameter.getListFilterParameter().getQFilters().add(qFilter);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SELECT_PAYEEBANKNAME_CLOSECALLBACK));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void setDefaultAcctBankVal() {
        DynamicObject oppUnit = (DynamicObject)this.getModel().getValue("finorginfo");
        if (EmptyUtil.isNoEmpty((DynamicObject)oppUnit)) {
            String oppUnitEntityType = oppUnit.getDataEntityType().getName();
            if (OppUnitTypeEnum.SUPPLIER.getValue().equals(oppUnitEntityType) || OppUnitTypeEnum.CUSTOMER.getValue().equals(oppUnitEntityType)) {
                QFilter qFilter = new QFilter("id", "=", oppUnit.getPkValue());
                qFilter.and("entry_bank.isdefault_bank", "=", (Object)"1");
                DynamicObject entryBankDO = TmcDataServiceHelper.loadSingle((String)oppUnitEntityType, (String)BANK_INFO_PROP, (QFilter[])qFilter.toArray());
                if (EmptyUtil.isNoEmpty((DynamicObject)entryBankDO)) {
                    DynamicObjectCollection entries = entryBankDO.getDynamicObjectCollection("entry_bank");
                    DynamicObject entry = (DynamicObject)entries.get(0);
                    this.getModel().setValue("payeeacctno", (Object)entry.getString("bankaccount"));
                    this.getModel().setValue("payeebankname", EmptyUtil.isEmpty((DynamicObject)entry.getDynamicObject("bank")) ? null : entry.getDynamicObject("bank").get("name"));
                }
            }
        }
    }

    private void clearOppInfo(String ... fields) {
        for (String field : fields) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)field, null);
        }
    }

    private void dealAndShowBankInfo() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String investOrgType = dataEntity.getString("investorgtype");
        if (OppUnitTypeEnum.FINORGINFO.getValue().equals(investOrgType) || OppUnitTypeEnum.OTHER.getValue().equals(investOrgType)) {
            return;
        }
        DynamicObject oppUnit = dataEntity.getDynamicObject("finorginfo");
        if (EmptyUtil.isNoEmpty((DynamicObject)oppUnit)) {
            String oppUnitEntityType = oppUnit.getDataEntityType().getName();
            Object oppUnitId = oppUnit.getPkValue();
            Object innerOrgId = null;
            if (StringUtils.equals((CharSequence)oppUnitEntityType, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)oppUnitEntityType, (CharSequence)"bd_customer")) {
                DynamicObject innerOrg = TmcBusinessBaseHelper.getInternalOrg((DynamicObject)oppUnit);
                if (EmptyUtil.isEmpty((DynamicObject)innerOrg)) {
                    String qFilter = new QFilter("id", "=", oppUnitId);
                    DynamicObject entryBankDO = TmcDataServiceHelper.loadSingle((String)oppUnitEntityType, (String)"entry_bank", (QFilter[])qFilter.toArray());
                    if (EmptyUtil.isEmpty((DynamicObjectCollection)entryBankDO.getDynamicObjectCollection("entry_bank"))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5bf9\u5e94\u5ba2\u5546\u7684\u94f6\u884c\u4fe1\u606f\u3002", (String)"SuretyBillEdit_14", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                        return;
                    }
                } else {
                    innerOrgId = innerOrg.getPkValue();
                }
            }
            ListShowParameter lsp = new ListShowParameter();
            switch (oppUnitEntityType) {
                case "bd_supplier": {
                    if (EmptyUtil.isNoEmpty((Object)innerOrgId)) {
                        lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)innerOrgId);
                        break;
                    }
                    lsp = ListConstructorHelper.getSupplierBankInfoShowParameter((Object)oppUnitId);
                    break;
                }
                case "bd_customer": {
                    if (EmptyUtil.isNoEmpty((Object)innerOrgId)) {
                        lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)innerOrgId);
                        break;
                    }
                    lsp = ListConstructorHelper.getCustomerBankInfoShowParameter((Object)oppUnitId);
                    break;
                }
                case "bos_org": {
                    lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)oppUnitId);
                    break;
                }
            }
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, SELECT_PAYEEACCTNO_CLOSECALLBACK);
            lsp.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    private void payeeAcctNoCloseCallBack(ListSelectedRow row) {
        Object entryKey = row.getEntryPrimaryKeyValue();
        DynamicObject oppUnit = this.getModel().getDataEntity().getDynamicObject("finorginfo");
        String entityName = oppUnit.getDataEntityType().getName();
        DynamicObject innerOrg = null;
        if ("bd_supplier".equals(entityName) || "bd_customer".equals(entityName)) {
            innerOrg = TmcBusinessBaseHelper.getInternalOrg((DynamicObject)oppUnit);
        }
        if ((StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_customer")) && innerOrg == null) {
            DynamicObject oppUnitDetail = TmcDataServiceHelper.loadSingle((String)oppUnit.getDataEntityType().getName(), (String)"id,bankaccount,bank", (QFilter[])new QFilter[]{new QFilter("entry_bank.id", "=", entryKey)});
            if (EmptyUtil.isEmpty((DynamicObject)oppUnitDetail)) {
                return;
            }
            DynamicObjectCollection entryBank = oppUnitDetail.getDynamicObjectCollection("entry_bank");
            for (DynamicObject entry : entryBank) {
                if (!entry.getPkValue().equals(entryKey)) continue;
                this.getModel().setValue("payeeacctno", (Object)entry.getString("bankaccount"));
                this.getModel().setValue("payeebankname", EmptyUtil.isEmpty((DynamicObject)entry.getDynamicObject("bank")) ? null : entry.getDynamicObject("bank").get("name"));
                break;
            }
        } else if ("bos_org".equals(entityName) || EmptyUtil.isNoEmpty((DynamicObject)innerOrg)) {
            DynamicObject accountBanksDO = TmcDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,bank,number", (QFilter[])new QFilter("id", "=", row.getPrimaryKeyValue()).toArray());
            if (EmptyUtil.isEmpty((DynamicObject)accountBanksDO)) {
                return;
            }
            this.getModel().setValue("payeeacctno", (Object)accountBanksDO.getString("bankaccountnumber"));
            DynamicObject bankDO = accountBanksDO.getDynamicObject("bank");
            if (!EmptyUtil.isEmpty((DynamicObject)bankDO)) {
                this.getModel().setValue("payeebankname", bankDO.get("name"));
            }
        }
    }

    private void payeeBankNameCloseCallBack(ListSelectedRow row) {
        this.getModel().setValue("payeebankname", (Object)row.getName());
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String fieldName = source.getKey();
        Object value = e.getValue();
        if (EmptyUtil.isEmpty((Object)value)) {
            return;
        }
        switch (fieldName) {
            case "expiredate": {
                this.validateExpireDate(e, value, fieldName);
                break;
            }
            case "term": {
                boolean rightFormat = TermHelper.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)value.toString());
                if (rightFormat) break;
                e.setCancel(true);
                this.getView().updateView(fieldName);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (!EmptyUtil.isEmpty((Object)returnData)) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            switch (actionId) {
                case "selectBillNo_closeCallBack": {
                    this.selectBillNoCloseCallBack(selectedRows.get(0));
                    break;
                }
                case "select_payeeacctno_closecallback": {
                    this.payeeAcctNoCloseCallBack(selectedRows.get(0));
                    break;
                }
                case "select_payeebankname_closecallback": {
                    this.payeeBankNameCloseCallBack(selectedRows.get(0));
                    break;
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldName;
        switch (fieldName = evt.getProperty().getName()) {
            case "finaccount": {
                this.finAccountF7Filter(evt);
                break;
            }
            case "settleaccount": {
                this.setSettAccountF7Filter(evt);
                break;
            }
            case "productfactory": {
                this.setPrdFactoryF7Filter(evt);
                break;
            }
            case "currency": {
                this.currencyF7Filter(evt);
                break;
            }
            case "referencerate": {
                this.rateF7Filter(evt);
                break;
            }
            case "investvarieties": {
                this.investVarietiesF7Filter(evt);
                break;
            }
            case "creditbillid": {
                this.creditBillIdF7Filter(evt);
                break;
            }
        }
    }

    private void rateF7Filter(BeforeF7SelectEvent evt) {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (EmptyUtil.isEmpty((DynamicObject)currency)) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e01\u79cd\u3002", (String)"SuretyBillEdit_01", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        QFilter currQFilter = new QFilter("currency", "=", currency.getPkValue());
        Date bizDate = (Date)this.getModel().getValue("intdate");
        if (EmptyUtil.isNoEmpty((Object)bizDate)) {
            sp.setCustomParam("PARAM_BIZDATEVAL", (Object)DateUtils.formatString((Date)bizDate, (String)"yyyy-MM-dd"));
        }
        sp.getListFilterParameter().setFilter(currQFilter);
    }

    private void investVarietiesF7Filter(BeforeF7SelectEvent evt) {
        DynamicObjectCollection creditEntry = this.getModel().getEntryEntity("entry_credit");
        DynamicObjectCollection debitEntry = this.getModel().getEntryEntity("entry");
        QFilter filter = null;
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)creditEntry)) {
            filter = new QFilter("islimitsurety", "=", (Object)true);
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)debitEntry)) {
            filter = new QFilter("islimitsurety", "=", (Object)false);
        }
        if (EmptyUtil.isNoEmpty(filter)) {
            ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters().add(filter);
        }
    }

    private void creditBillIdF7Filter(BeforeF7SelectEvent evt) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u6b3e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SuretyBillEdit_2", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObject investVarieties = (DynamicObject)this.getModel().getValue("investvarieties");
        if (EmptyUtil.isEmpty((DynamicObject)investVarieties)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4fdd\u8bc1\u91d1\u54c1\u79cd\u201d\u3002", (String)"SuretyBillEdit_4", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (!investVarieties.getBoolean("islimitsurety")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u989d\u5ea6\u4fdd\u8bc1\u91d1\u4e0d\u80fd\u9009\u62e9\u6388\u4fe1\u5355\u3002", (String)"SuretyBillEdit_15", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        QFilter creditFilter = new QFilter("org", "=", org.getPkValue());
        logger.info("\u6388\u4fe1\u989d\u5ea6\u5355\u7684\u8fc7\u6ee4\u6761\u4ef6\u662f:" + ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters().toString());
        evt.getFormShowParameter().setCustomParam("selectF7", (Object)"surety");
        ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters().add(creditFilter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName = e.getProperty().getName();
        Object newVal = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (fieldName) {
            case "intdate": 
            case "term": {
                this.calExpireDate();
                break;
            }
            case "expiredate": {
                this.calTerm();
                String intType = (String)this.getModel().getValue("interesttype");
                String revenueWay = (String)this.getModel().getValue("revenueway");
                this.setInterestRateMustInput(intType, revenueWay);
                break;
            }
            case "investvarieties": {
                this.getModel().setValue("productfactory", null);
                SuretyHelper.showEntry((IFormView)this.getView(), (IDataModel)this.getModel());
                break;
            }
            case "productfactory": {
                Optional.ofNullable((DynamicObject)this.getModel().getValue("productfactory")).ifPresent(factory -> {
                    this.getModel().setValue("basis", (Object)factory.getString("basis"));
                    this.getModel().setValue("interesttype", (Object)factory.getString("ratetype"));
                });
                break;
            }
            case "interesttype": {
                this.setMustInputByInterestType();
                break;
            }
            case "revenueway": {
                this.setMustInputByRevenueWay();
                break;
            }
            case "amount": {
                this.getModel().setValue("surplusamount", newVal);
                break;
            }
            case "settleaccount": {
                Object settleAccount = this.getModel().getValue("settleaccount");
                if (EmptyUtil.isNoEmpty((Object)settleAccount)) {
                    DynamicObject account = (DynamicObject)settleAccount;
                    this.getModel().setValue("currency", account.getDynamicObject("defaultcurrency").getPkValue());
                    this.getView().setEnable(Boolean.valueOf(account.getBoolean("ismulcurrency")), new String[]{"currency"});
                    break;
                }
                this.getModel().setValue("currency", null);
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"currency"});
                break;
            }
            case "finorginfo": {
                this.clearOppInfo("payeeacctno", "payeebankname", "settleaccount", "currency");
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"currency"});
                this.setDefaultAcctBankVal();
                this.setFinOther();
                break;
            }
            case "investorgtype": {
                this.clearOppInfo("payeeacctno", "payeebankname", "settleaccount", "finorginfo", "finorgother");
                this.setInvestOrgMustInput();
                break;
            }
            case "debttype": {
                TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (int)rowIndex, (String[])new String[]{"debtbillno", "debtbillid", "counterparty", "debtcurrency", "debtamt", "suretyamount", "bizno", "debtstartdate", "debtenddate", "credit", "creditcurrency", "creditamount"});
                this.getView().setEnable(Boolean.valueOf(!"lc_lettercredit".equals(newVal)), rowIndex, new String[]{"suretyamount"});
                break;
            }
            case "debtbillno": {
                if (!EmptyUtil.isEmpty((Object)newVal)) break;
                TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (int)rowIndex, (String[])new String[]{"debtbillid", "counterparty", "debtcurrency", "debtamt", "bizno", "debtstartdate", "debtenddate", "credit", "creditcurrency", "creditamount"});
                break;
            }
        }
    }

    private void setInvestOrgMustInput() {
        Object investOrg = this.getModel().getValue("investorgtype");
        if (EmptyUtil.isEmpty((Object)investOrg)) {
            return;
        }
        if (StringUtils.equals((CharSequence)((String)investOrg), (CharSequence)PartyTypeEnum.fbd_other.getValue())) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"finorginfo"});
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"finorginfo"});
        }
    }

    private void setFinOther() {
        DynamicObject finOrgInfo = (DynamicObject)this.getModel().getValue("finorginfo");
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"finorgother", EmptyUtil.isNoEmpty((DynamicObject)finOrgInfo) ? finOrgInfo.getString("name") : null);
    }

    private boolean haveSelect(Long id, int rowIndex) {
        DynamicObjectCollection entryCol = this.getModel().getEntryEntity("entry");
        for (int i = 0; i < entryCol.size(); ++i) {
            DynamicObject entry;
            Long existSuretyBillId;
            if (i == rowIndex || !EmptyUtil.isNoEmpty((Long)(existSuretyBillId = Long.valueOf((entry = (DynamicObject)entryCol.get(i)).getLong("debtbillid")))) || !id.equals(existSuretyBillId)) continue;
            return true;
        }
        return false;
    }

    private void selectBillNoCloseCallBack(ListSelectedRow listSelectedRow) {
        int currRow = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject entry = this.getModel().getEntryRowEntity("entry", currRow);
        Object pkId = listSelectedRow.getPrimaryKeyValue();
        if (this.haveSelect((Long)pkId, currRow)) {
            this.getModel().setValue("debtbillno", null, currRow);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u8fc7\u8be5\u503a\u52a1\u5355\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SuretyBillEdit_11", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return;
        }
        String entityName = entry.getString("debttype");
        ProductTypeEnum enumByFormId = ProductTypeEnum.getEnumByFormId((String)entityName);
        DynamicObject bizBill = TmcDataServiceHelper.loadSingle((Object)pkId, (String)enumByFormId.getEntity());
        this.fillDebtEntryInfo(bizBill, entityName, currRow);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        super.beforeDoOperation(event);
        AbstractOperate operate = (AbstractOperate)event.getSource();
        if (StringUtils.equals((CharSequence)"newcreditentry", (CharSequence)operate.getOperateKey()) && EmptyUtil.isNoEmpty((Integer)this.getModel().getEntryEntity("entry_credit").size())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u7b14\u4fdd\u8bc1\u91d1\u5b58\u5165\u5355\u53ea\u80fd\u5173\u8054\u4e00\u7b14\u672a\u5173\u95ed\u7684\u6388\u4fe1\u989d\u5ea6\u5355\u3002", (String)"SuretyBillEdit_16", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
        }
    }

    private void fillDebtEntryInfo(DynamicObject bizBill, String entityName, int currRow) {
        HashMap<String, Object> paras = new HashMap<String, Object>(16);
        paras.put("bizInfoNo", " ");
        paras.put("counterParty", 0);
        paras.put("debtCurrency", 0);
        paras.put("debtAmt", BigDecimal.ZERO);
        paras.put("startdate", null);
        paras.put("enddate", null);
        if (DebtBillTypeEnum.LC_LETTERCREDIT.getValue().equals(entityName)) {
            this.handleLcLetterCredit(bizBill, paras);
        } else if (DebtBillTypeEnum.CDM_PAYABLEBILL.getValue().equals(entityName)) {
            this.handleCdmPayableBill(bizBill, paras);
        } else if (DebtBillTypeEnum.CDM_PAYABLEBILL_AP_MANUAL.getValue().equals(entityName)) {
            this.handleCdmPayableBillApManual(bizBill, paras);
        } else if (DebtBillTypeEnum.GM_LETTEROFGUARANTEE.getValue().equals(entityName)) {
            this.handleGmLetterOfGuarantee(bizBill, paras);
        } else if (DebtBillTypeEnum.CFM_LOANCONTRACT_BL_L.getValue().equals(entityName) || DebtBillTypeEnum.FL_LEASECONTRACTBILL.getValue().equals(entityName)) {
            this.handleCfmFlContract(bizBill, paras);
        }
        this.fillInfo(bizBill, paras, currRow, entityName);
    }

    public void fillInfo(DynamicObject bizBill, Map<String, Object> para, int currRow, String entityName) {
        this.getModel().setValue("debtbillno", (Object)bizBill.getString("billno"), currRow);
        this.getModel().setValue("debtbillid", (Object)bizBill.getLong("id"), currRow);
        this.getModel().setValue("bizno", para.get("bizInfoNo"), currRow);
        this.getModel().setValue("counterparty", para.get("counterParty"), currRow);
        this.getModel().setValue("debtcurrency", para.get("debtCurrency"), currRow);
        this.getModel().setValue("suretyamount", para.get("suretyamount"), currRow);
        this.getModel().setValue("debtamt", para.get("debtAmt"), currRow);
        this.getModel().setValue("debtstartdate", para.get("startdate"), currRow);
        this.getModel().setValue("debtenddate", para.get("enddate"), currRow);
        this.getModel().setValue("credit", para.get("credit"), currRow);
        if (EmptyUtil.isNoEmpty((Object)para.get("credit"))) {
            QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            qFilter.and(new QFilter("creditlimit", "=", para.get("credit"))).and(new QFilter("sourcebillno", "=", (Object)bizBill.getString("billno")));
            qFilter.and(new QFilter("isrelease", "=", (Object)"0"));
            DynamicObject creditUse = QueryServiceHelper.queryOne((String)"cfm_credituse", (String)"currency,realamt", (QFilter[])qFilter.toArray());
            if (EmptyUtil.isNoEmpty((DynamicObject)creditUse)) {
                this.getModel().setValue("creditcurrency", (Object)creditUse.getLong("currency"), currRow);
                this.getModel().setValue("creditamount", (Object)creditUse.getBigDecimal("realamt"), currRow);
            }
        }
        this.getModel().setValue("suretystatus", (Object)SuretyBillHelper.getActDebtBizStatus((DynamicObject)bizBill, (String)entityName), currRow);
    }

    public void handleLcLetterCredit(DynamicObject bizBill, Map<String, Object> para) {
        para.put("bizInfoNo", bizBill.getString("creditno"));
        DynamicObject bank = bizBill.getDynamicObject("bank");
        if (EmptyUtil.isNoEmpty((DynamicObject)bank)) {
            para.put("counterParty", bank.getLong("id"));
        }
        para.put("debtCurrency", bizBill.getDynamicObject("currency").getLong("id"));
        para.put("debtAmt", bizBill.getBigDecimal("amount").multiply(BigDecimal.ONE.add(bizBill.getBigDecimal("amountscaleupper").divide(Constants.ONE_HUNDRED, 6, RoundingMode.HALF_UP))));
        para.put("suretyamount", bizBill.getBigDecimal("totalsuretymoney"));
        para.put("startdate", bizBill.getDate("bizdate"));
        para.put("enddate", bizBill.getDate("validdate"));
        DynamicObject creditLimit = bizBill.getDynamicObject("creditlimit");
        para.put("credit", EmptyUtil.isNoEmpty((DynamicObject)creditLimit) ? creditLimit.getLong("id") : 0L);
    }

    public void handleCdmPayableBill(DynamicObject bizBill, Map<String, Object> para) {
        para.put("bizInfoNo", bizBill.getString("draftbillno"));
        DynamicObject accepterFinOrg = bizBill.getDynamicObject("accepterfinorg");
        if (EmptyUtil.isNoEmpty((DynamicObject)accepterFinOrg)) {
            para.put("counterParty", accepterFinOrg.getLong("id"));
        }
        para.put("debtCurrency", bizBill.getDynamicObject("currency").getLong("id"));
        para.put("debtAmt", bizBill.getBigDecimal("amount"));
        para.put("suretyamount", bizBill.getBigDecimal("suretymoney"));
        para.put("startdate", bizBill.getDate("issuedate"));
        para.put("enddate", bizBill.getDate("draftbillexpiredate"));
        DynamicObject creditLimit = bizBill.getDynamicObject("creditlimit");
        para.put("credit", EmptyUtil.isNoEmpty((DynamicObject)creditLimit) ? creditLimit.getLong("id") : 0L);
    }

    public void handleCdmPayableBillApManual(DynamicObject bizBill, Map<String, Object> para) {
        DynamicObject accepterFinOrg = bizBill.getDynamicObject("accepterfinorg");
        if (EmptyUtil.isNoEmpty((DynamicObject)accepterFinOrg)) {
            para.put("counterParty", accepterFinOrg.getLong("id"));
        }
        para.put("debtCurrency", bizBill.getDynamicObject("currency").getLong("id"));
        para.put("debtAmt", bizBill.getBigDecimal("amounttotal"));
        para.put("startdate", this.getEarliestOrLatestEntryDate(bizBill, "issuedate", false));
        para.put("enddate", this.getEarliestOrLatestEntryDate(bizBill, "draftbillexpiredate", true));
        DynamicObject creditLimit = bizBill.getDynamicObject("creditlimit");
        para.put("credit", EmptyUtil.isNoEmpty((DynamicObject)creditLimit) ? creditLimit.getLong("id") : 0L);
    }

    public void handleGmLetterOfGuarantee(DynamicObject bizBill, Map<String, Object> para) {
        para.put("bizInfoNo", bizBill.getString("billno"));
        DynamicObject finOrgInfo = bizBill.getDynamicObject("finorginfo");
        if (EmptyUtil.isNoEmpty((DynamicObject)finOrgInfo)) {
            para.put("counterParty", finOrgInfo.getLong("id"));
        }
        para.put("debtCurrency", bizBill.getDynamicObject("currency").getLong("id"));
        para.put("debtAmt", bizBill.getBigDecimal("amount"));
        para.put("startdate", bizBill.getDate("startdate"));
        para.put("enddate", bizBill.getDate("expiredate"));
        DynamicObject creditLimit = bizBill.getDynamicObject("creditlimit");
        para.put("credit", EmptyUtil.isNoEmpty((DynamicObject)creditLimit) ? creditLimit.getLong("id") : 0L);
    }

    public void handleCfmFlContract(DynamicObject bizBill, Map<String, Object> para) {
        para.put("bizInfoNo", bizBill.getString("contractno"));
        para.put("counterParty", bizBill.getLong("creditor"));
        para.put("debtCurrency", bizBill.getDynamicObject("currency").getLong("id"));
        para.put("debtAmt", bizBill.getBigDecimal("amount"));
        para.put("startdate", bizBill.getDate("startdate"));
        para.put("enddate", bizBill.getDate("enddate"));
        DynamicObject creditLimit = bizBill.getDynamicObject("creditlimit");
        para.put("credit", EmptyUtil.isNoEmpty((DynamicObject)creditLimit) ? creditLimit.getLong("id") : 0L);
    }

    private Date getEarliestOrLatestEntryDate(DynamicObject bizBill, String propertyName, boolean max) {
        DynamicObjectCollection dynamicObjects = bizBill.getDynamicObjectCollection("entryentity");
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)dynamicObjects)) {
            if (dynamicObjects.size() == 1) {
                return ((DynamicObject)dynamicObjects.get(0)).getDate(propertyName);
            }
            Date[] issueDateArr = dynamicObjects.stream().map(e -> e.getDate(propertyName)).collect(Collectors.toList()).toArray(new Date[0]);
            for (int j = 0; j < issueDateArr.length - 1; ++j) {
                Date first = issueDateArr[j];
                Date second = issueDateArr[j + 1];
                if ((!max || !first.after(second)) && (max || !first.before(second))) continue;
                issueDateArr[j] = second;
                issueDateArr[j + 1] = first;
            }
            return issueDateArr[issueDateArr.length - 1];
        }
        return null;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName;
        switch (fieldName = evt.getFieldName()) {
            case "debtbillno": {
                this.openDebitLayout(evt);
                break;
            }
            case "creditbillid": {
                this.openCreditLayout(evt);
                break;
            }
        }
    }

    private void openDebitLayout(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        if (rowIndex > -1) {
            DynamicObject entry = this.getModel().getEntryRowEntity("entry", rowIndex);
            Long srcBillId = entry.getLong("debtbillid");
            if (EmptyUtil.isNoEmpty((Long)srcBillId)) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId(entry.getString("debttype"));
                parameter.setPkId((Object)srcBillId);
                parameter.setStatus(OperationStatus.VIEW);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)parameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"SuretyBillEdit_1", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void openCreditLayout(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        if (rowIndex > -1) {
            DynamicObject creditEntry = this.getModel().getEntryRowEntity("entry_credit", rowIndex);
            Long srcBillId = creditEntry.getDynamicObject("creditbillid").getLong("id");
            if (EmptyUtil.isNoEmpty((Long)srcBillId)) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId("cfm_creditlimit");
                parameter.setPkId((Object)srcBillId);
                parameter.setStatus(OperationStatus.VIEW);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)parameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"SuretyBillEdit_1", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setMustInputByInterestType();
        this.setMustInputByRevenueWay();
        this.setCurrencyEnable();
        SuretyHelper.showEntry((IFormView)this.getView(), (IDataModel)this.getModel());
        this.setIsEnableCreditEntry();
        this.setInvestOrgMustInput();
        this.setEnable();
        this.getModel().setDataChanged(false);
    }

    private void setEnable() {
        this.setEntrySuretyAmtEnable();
        this.setEntryCreditEnable();
    }

    private void setEntryCreditEnable() {
        DynamicObjectCollection creditEntries = this.getModel().getEntryEntity("entry_credit");
        boolean isCreditHandFlag = true;
        for (int i = 0; i < creditEntries.size(); ++i) {
            DynamicObject debitEntry = (DynamicObject)creditEntries.get(i);
            String suretySource = debitEntry.getString("creditsource");
            if (!suretySource.equals(BillSourceEnum.HAND.getValue())) continue;
            isCreditHandFlag = false;
        }
        this.getView().setEnable(Boolean.valueOf(isCreditHandFlag), new String[]{"bar_newcreditentry", "bar_deletelimitentry"});
    }

    private void setEntrySuretyAmtEnable() {
        DynamicObjectCollection debitEntries = this.getModel().getEntryEntity("entry");
        boolean isCdmHandDebitFlag = true;
        for (int i = 0; i < debitEntries.size(); ++i) {
            DynamicObject debitEntry = (DynamicObject)debitEntries.get(i);
            String suretySource = debitEntry.getString("suretysource");
            String debitType = debitEntry.getString("debttype");
            if (suretySource.equals(BillSourceEnum.HAND.getValue()) && UNEDIT_DEBIT_AMT_BILL_LIST.contains(debitType)) {
                isCdmHandDebitFlag = false;
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"suretyamount"});
            }
            if (!suretySource.equals(BillSourceEnum.HAND.getValue()) || !"cdm_payablebill_ap_manual".equals(debitType)) continue;
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"debttype"});
        }
        this.getView().setEnable(Boolean.valueOf(isCdmHandDebitFlag), new String[]{"bar_newentry", "bar_deleteentry", "bar_insertentry"});
    }

    private void setIsEnableCreditEntry() {
        int creditEntry = this.getModel().getEntryRowCount("entry_credit");
        for (int i = 0; i < creditEntry; ++i) {
            String creditSource = (String)this.getModel().getValue("creditsource", i);
            if (EmptyUtil.isEmpty((String)creditSource) || !StringUtils.equals((CharSequence)BillSourceEnum.HAND.getValue(), (CharSequence)creditSource)) continue;
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"creditbillid"});
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().deleteEntryData("revenue_entry");
        this.getModel().deleteEntryData("rateadjust_entry");
        this.getModel().deleteEntryData("entry");
        this.getModel().deleteEntryData("entry_credit");
        this.calExpireDate();
    }

    private void showBillF7() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u6b3e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SuretyBillEdit_2", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject entry = this.getModel().getEntryRowEntity("entry", this.getModel().getEntryCurrentRowIndex("entry"));
        String formId = entry.getString("debttype");
        if (EmptyUtil.isEmpty((String)formId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u503a\u52a1\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SuretyBillEdit_3", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)formId, (boolean)false, (int)2);
        lsp.setCustomParam("ismergerows", (Object)Boolean.FALSE);
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        if (DebtBillTypeEnum.GM_LETTEROFGUARANTEE.getValue().equals(formId)) {
            qFilter.and("applyorg", "=", org.getPkValue());
        } else if (DebtBillTypeEnum.CDM_PAYABLEBILL.getValue().equals(formId)) {
            qFilter.and("company", "=", org.getPkValue());
        } else if (DebtBillTypeEnum.CDM_PAYABLEBILL_AP_MANUAL.getValue().equals(formId)) {
            qFilter.and(QFilter.of((String)"1=2", (Object[])new Object[0]));
        } else if (DebtBillTypeEnum.LC_LETTERCREDIT.getValue().equals(formId)) {
            qFilter.and("org", "=", org.getPkValue());
            qFilter.and("guarantee", "like", (Object)("%" + GuaranteeWayEnum.ENSUAMT.getNumberValue() + "%"));
            qFilter.and("promisrate", ">", (Object)Constants.ZERO);
        } else {
            qFilter.and("org", "=", org.getPkValue());
        }
        qFilter.and(this.getRelatedSuretyFilter(formId));
        this.addStatusFilter(formId, qFilter);
        lsp.getListFilterParameter().getQFilters().add(qFilter);
        logger.info("show\u7684\u5355\u636e\u5e03\u5c40\u662f" + formId + "\u8fc7\u6ee4\u6761\u4ef6\u662f:" + lsp.getListFilterParameter().getQFilters());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, SELECTBILLNO_CLOSECALLBACK);
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private QFilter getRelatedSuretyFilter(String formId) {
        QFilter relateSuretyFilter = new QFilter("entry", "is not null", null).and("entry.debttype", "=", (Object)formId);
        DynamicObjectCollection relatedSureties = QueryServiceHelper.query((String)"fbd_suretybill", (String)"entry.debtbillid", (QFilter[])new QFilter[]{relateSuretyFilter});
        List relatedSuretyIds = relatedSureties.stream().map(d -> d.getLong("entry.debtbillid")).distinct().collect(Collectors.toList());
        return new QFilter("id", "not in", relatedSuretyIds);
    }

    private void addStatusFilter(String formId, QFilter qFilter) {
        if (DebtBillTypeEnum.LC_LETTERCREDIT.getValue().equals(formId)) {
            qFilter.and("creditstatus", "=", (Object)"done_register");
        } else if (DebtBillTypeEnum.GM_LETTEROFGUARANTEE.getValue().equals(formId)) {
            qFilter.and("bizstatus", "=", (Object)"registered");
        } else if (!DebtBillTypeEnum.CDM_PAYABLEBILL_AP_MANUAL.getValue().equals(formId)) {
            if (DebtBillTypeEnum.CFM_LOANCONTRACT_BL_L.getValue().equals(formId)) {
                qFilter.and("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue()).and("contractstatus", "!=", (Object)LoanContractStatusEnum.CLOSED.getValue()).and("creditortype", "!=", (Object)CreditorTypeEnum.SETTLECENTER.getValue()).and(new QFilter("loantype", "=", (Object)"loan").or("loantype", "=", (Object)"sl"));
            } else if (DebtBillTypeEnum.FL_LEASECONTRACTBILL.getValue().equals(formId)) {
                qFilter.and("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue()).and("loanType", "=", (Object)"finlease").and("contractstatus", "!=", (Object)LoanContractStatusEnum.CLOSED.getValue());
            } else {
                qFilter.and(new QFilter("draftbillstatus", "=", (Object)"registered"));
                qFilter.and("draftbilltranstatus", "=", (Object)"success");
            }
        }
    }

    private void setPrdFactoryF7Filter(BeforeF7SelectEvent e) {
        DynamicObject investVar = (DynamicObject)this.getModel().getValue("investvarieties");
        if (EmptyUtil.isEmpty((DynamicObject)investVar)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4fdd\u8bc1\u91d1\u54c1\u79cd\u201d\u3002", (String)"SuretyBillEdit_4", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        QFilter qFilter = new QFilter("investvarieties", "=", investVar.getPkValue());
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter);
    }

    private void setSettAccountF7Filter(BeforeF7SelectEvent e) {
        QFilter qFilter = this.getOrgFilter(e);
        if (qFilter == null) {
            return;
        }
        DynamicObject finOrg = (DynamicObject)this.getModel().getValue("finorginfo");
        if (EmptyUtil.isEmpty((DynamicObject)finOrg)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5b58\u6b3e\u673a\u6784\u201d\u3002", (String)"SuretyBillEdit_5", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        qFilter.and("bank", "=", finOrg.getPkValue());
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter);
    }

    private void currencyF7Filter(BeforeF7SelectEvent e) {
        DynamicObject acctBank = (DynamicObject)this.getModel().getValue("settleaccount");
        if (EmptyUtil.isNoEmpty((DynamicObject)acctBank)) {
            DynamicObjectCollection currencys = acctBank.getDynamicObjectCollection("currency");
            List currencyIds = currencys.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "in", currencyIds);
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    private void finAccountF7Filter(BeforeF7SelectEvent e) {
        QFilter qFilter = this.getOrgFilter(e);
        if (qFilter == null) {
            return;
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter);
    }

    private QFilter getOrgFilter(BeforeF7SelectEvent e) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5b58\u6b3e\u7ec4\u7ec7\u201d\u3002", (String)"SuretyBillEdit_7", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return null;
        }
        return TmcAccountHelper.getAccountBankFilterByOrg((Long)org.getLong("id"));
    }

    private void setMustInputByInterestType() {
        String intType = (String)this.getModel().getValue("interesttype");
        String revenueWay = (String)this.getModel().getValue("revenueway");
        this.setInterestRateMustInput(intType, revenueWay);
        if (StringUtils.equals((CharSequence)InterestTypeEnum.FLOAT.getValue(), (CharSequence)intType)) {
            TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"interestrate"});
        } else {
            TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"referencerate", "ratesign", "ratefloatpoint"});
        }
    }

    private void setInterestRateMustInput(String intType, String revenueWay) {
        Date expireDate = (Date)this.getModel().getValue("expiredate");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (StringUtils.equals((CharSequence)InterestTypeEnum.FIXED.getValue(), (CharSequence)intType) && EmptyUtil.isNoEmpty((Object)expireDate) && RevenueWayEnum.STAGE.getValue().equals(revenueWay) ? 1 : 0) != 0, (String[])new String[]{"interestrate"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (EmptyUtil.isEmpty((Object)expireDate) && RevenueWayEnum.STAGE.getValue().equals(revenueWay) ? 1 : 0) != 0, (String[])new String[]{"demandrate"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (StringUtils.equals((CharSequence)InterestTypeEnum.FLOAT.getValue(), (CharSequence)intType) && EmptyUtil.isNoEmpty((Object)expireDate) && RevenueWayEnum.STAGE.getValue().equals(revenueWay) ? 1 : 0) != 0, (String[])new String[]{"referencerate"});
    }

    private void setMustInputByRevenueWay() {
        String revenueWay = (String)this.getModel().getValue("revenueway");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)RevenueWayEnum.STAGE.getValue().equals(revenueWay), (String[])new String[]{"revenueplan", "interesttype", "demandrate", "basis"});
        String intType = (String)this.getModel().getValue("interesttype");
        this.setInterestRateMustInput(intType, revenueWay);
        if (RevenueWayEnum.NOREVENUE.getValue().equals(revenueWay)) {
            TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"revenueplan", "interesttype", "interestrate", "referencerate", "demandrate", "ratesign", "ratefloatpoint", "basis", "rateadjuststyle"});
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"rateadjuststyle", (Object)RateAdjustStyleEnum.DEADLINE.getValue());
        }
    }

    private void calExpireDate() {
        String term = (String)this.getModel().getValue("term");
        Date intDate = (Date)this.getModel().getValue("intdate");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{term, intDate})) {
            this.getModel().setValue("expiredate", null);
            return;
        }
        Date expireDate = TermHelper.getDateByBaseDate4ymd((String)term, (Date)intDate);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"expiredate", (Object)expireDate);
        String intType = (String)this.getModel().getValue("interesttype");
        String revenueWay = (String)this.getModel().getValue("revenueway");
        this.setInterestRateMustInput(intType, revenueWay);
    }

    private void calTerm() {
        Date expireDate = (Date)this.getModel().getValue("expiredate");
        Date intDate = (Date)this.getModel().getValue("intdate");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{intDate, expireDate})) {
            this.getModel().setValue("term", null);
            return;
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", (Object)TermHelper.callTermLargeEqualZore((Date)intDate, (Date)expireDate));
    }

    private void validateExpireDate(BeforeFieldPostBackEvent e, Object value, String fieldName) {
        Date expireDate = DateUtils.stringToDate((String)value.toString(), (String)"yyyy-MM-dd");
        Date intDate = (Date)this.getModel().getValue("intdate");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{intDate, expireDate})) {
            return;
        }
        if (expireDate.compareTo(intDate) <= 0) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5230\u671f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u4fdd\u8bc1\u91d1\u8d77\u606f\u65e5\u3002", (String)"SuretyBillEdit_9", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            this.getView().updateView(fieldName);
        }
    }

    private void setCurrencyEnable() {
        Boolean enable = Boolean.FALSE;
        if (!OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            Object settleAccount = this.getModel().getValue("settleaccount");
            enable = EmptyUtil.isNoEmpty((Object)settleAccount) ? Boolean.valueOf(((DynamicObject)settleAccount).getBoolean("ismulcurrency")) : Boolean.TRUE;
        }
        this.getView().setEnable(enable, new String[]{"currency"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if ("submit".equals(operateKey) && opResult.isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        this.setMustInputByRevenueWay();
        this.calTerm();
    }

    static {
        UNEDIT_DEBIT_AMT_BILL_LIST.add("cdm_payablebill_ap_manual");
        UNEDIT_DEBIT_AMT_BILL_LIST.add("cdm_payablebill");
        UNEDIT_DEBIT_AMT_BILL_LIST.add("lc_lettercredit");
    }
}

