/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.surety;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.tmc.fbd.common.enums.RevenueTypeEnum;
import kd.tmc.fbd.common.enums.RevenueWayEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.SuretyBizStatusEnum;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;

public class SuretyBillList
extends AbstractTmcListPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"debtbillno", "debtbillid", "creditbillid"});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumns = args.getCommonFilterColumns();
        String dataSource = (String)this.getView().getFormShowParameter().getCustomParam("dataSource");
        for (FilterColumn filterColumn : filterColumns) {
            String fieldName = filterColumn.getFieldName();
            if (!StringUtils.equals((CharSequence)"org.name", (CharSequence)fieldName) && (!"bizBill".equals(dataSource) || !StringUtils.equals((CharSequence)"bizdate", (CharSequence)fieldName))) continue;
            filterColumn.setDefaultValue("");
        }
    }

    public void setFilter(SetFilterEvent e) {
        QFilter qFilter = new QFilter("enable", "=", (Object)true);
        e.getQFilters().add(qFilter);
        super.setFilter(e);
    }

    protected List<QFilter> addCustomFilterForFilterCol(String fieldName) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
        if (StringUtils.equals((CharSequence)"investvarieties.name", (CharSequence)fieldName)) {
            filters.add(new QFilter("investtype", "=", (Object)"surety"));
        }
        return filters;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "pushrelease": {
                if (this.checkCanPushReleaseBill()) break;
                args.setCancel(true);
                break;
            }
            case "push": {
                if (this.checkCanPushAppendBill()) break;
                args.setCancel(true);
                break;
            }
            case "pushrevenue": {
                if (this.checkCanPushRevenueBill()) break;
                args.setCancel(true);
                break;
            }
            case "trackbizbill": {
                args.setCancel(true);
                this.trackBizBill();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "pushrevenue": {
                this.openIntBatchEdit();
                break;
            }
        }
    }

    private void trackBizBill() {
        Long id = super.getSelectedId();
        if (EmptyUtil.isEmpty((Long)id)) {
            return;
        }
        DynamicObject suretyBill = TmcDataServiceHelper.loadSingle((Object)id, (String)"fbd_suretybill", (String)"entry,entry.debttype,entry.debtbillid");
        DynamicObjectCollection entrys = suretyBill.getDynamicObjectCollection("entry");
        Map<String, List<DynamicObject>> map = entrys.stream().collect(Collectors.groupingBy(o -> o.getString("debttype")));
        if (map.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5173\u8054\u6570\u636e\u3002", (String)"SuretyBillList_4", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return;
        }
        map.forEach((debtType, entryList) -> {
            List<Long> debtBillIds = entryList.stream().map(o -> o.getLong("debtbillid")).collect(Collectors.toList());
            this.showTrackView(debtBillIds, (String)debtType);
        });
    }

    protected void showTrackView(List<Long> pkIds, String trackViewFormId) {
        IFormView view = this.getView();
        if (pkIds.size() == 1) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId((Object)pkIds.get(0));
            showParameter.setFormId(trackViewFormId);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            view.showForm((FormShowParameter)showParameter);
        } else {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setIsolationOrg(false);
            showParameter.setBillFormId(trackViewFormId);
            showParameter.getListFilterParameter().setQFilters(Collections.singletonList(new QFilter("id", "in", pkIds)));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            view.showForm((FormShowParameter)showParameter);
        }
    }

    private boolean checkCanPushAppendBill() {
        Long id = super.getSelectedId();
        if (EmptyUtil.isEmpty((Long)id)) {
            return false;
        }
        DynamicObject suretyBill = QueryServiceHelper.queryOne((String)"fbd_suretybill", (String)"billstatus,bizstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (!BillStatusEnum.AUDIT.getValue().equals(suretyBill.getString("billstatus")) || SuretyBizStatusEnum.SURETY_END.getValue().equals(suretyBill.getString("bizstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u4e3a\u201c\u5b58\u5165\u4e2d\u201d\uff0c\u201c\u5df2\u5b58\u51fa\u201d\u4e0d\u80fd\u8fdb\u884c\u8ffd\u52a0\u3002", (String)"SuretyBillList_7", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkCanPushReleaseBill() {
        Long id = super.getSelectedId();
        if (EmptyUtil.isEmpty((Long)id)) {
            return false;
        }
        DynamicObject suretyBill = TmcDataServiceHelper.loadSingle((Object)id, (String)"fbd_suretybill", (String)"billstatus,bizstatus,entry_credit.creditbillid");
        if (!BillStatusEnum.AUDIT.getValue().equals(suretyBill.getString("billstatus")) || SuretyBizStatusEnum.SURETY_END.getValue().equals(suretyBill.getString("bizstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u4e3a\u201c\u5b58\u5165\u4e2d\u201d\uff0c\u201c\u5df2\u5b58\u51fa\u201d\u4e0d\u80fd\u8fdb\u884c\u5b58\u51fa\u3002", (String)"SuretyBillList_0", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection creditEntry = suretyBill.getDynamicObjectCollection("entry_credit");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)creditEntry) && !((DynamicObject)creditEntry.get(0)).getDynamicObject("creditbillid").getBoolean("isclose")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6\u5355\u5fc5\u987b\u4e3a\u5df2\u5173\u95ed\uff0c\u624d\u5141\u8bb8\u5b58\u51fa\u3002", (String)"SuretyBillList_6", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return false;
        }
        QFilter qFilter = new QFilter("suretybill", "=", (Object)super.getSelectedId()).and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        boolean existsRelease = TmcDataServiceHelper.exists((String)"fbd_suretyreleasebill", (QFilter[])qFilter.toArray());
        if (existsRelease) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5b58\u51fa\u5355\uff0c\u8bf7\u5148\u64cd\u4f5c\u524d\u5e8f\u5355\u636e\u3002", (String)"SuretyBillList_2", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkCanPushRevenueBill() {
        Long id = super.getSelectedId();
        if (EmptyUtil.isEmpty((Long)id)) {
            return false;
        }
        DynamicObject suretyBill = QueryServiceHelper.queryOne((String)"fbd_suretybill", (String)"billstatus,bizstatus,revenueway", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (!BillStatusEnum.AUDIT.getValue().equals(suretyBill.getString("billstatus")) || SuretyBizStatusEnum.SURETY_END.getValue().equals(suretyBill.getString("bizstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u4e3a\u201c\u5b58\u5165\u4e2d\u201d\uff0c\u201c\u5df2\u5b58\u51fa\u201d\u4e0d\u80fd\u8fdb\u884c\u6536\u76ca\u3002", (String)"SuretyBillList_1", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (RevenueWayEnum.NOREVENUE.getValue().equals(suretyBill.getString("revenueway"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6536\u76ca\u4fdd\u8bc1\u91d1\u65e0\u6cd5\u83b7\u53d6\u6536\u76ca\u3002", (String)"SuretyBillList_3", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected void openIntBatchEdit() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setFormId("fbd_surety_stlint_navadd");
        Object[] suretyBills = this.getSuretyBills();
        String dJson = DynamicObjectSerializeUtil.serialize((Object[])suretyBills, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fbd_suretybill"));
        parameter.setCustomParam("loanbill", (Object)dJson);
        parameter.setCustomParam("formid", (Object)"fbd_surety_stlint_batch");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close_bake_key_filter"));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    protected DynamicObject[] getSuretyBills() {
        QFilter filter = new QFilter("id", "=", (Object)this.getSelectedId());
        filter = filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        DynamicObject[] loanBills = TmcDataServiceHelper.load((String)"fbd_suretybill", (String)"id,currency,org,billno", (QFilter[])(filter = filter.and(new QFilter("bizstatus", "!=", (Object)SuretyBizStatusEnum.SURETY_END.getValue()))).toArray());
        if (loanBills.length <= 0) {
            String message = ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u4e3a\u201c\u5b58\u5165\u4e2d\u201d\uff0c\u201c\u5df2\u5b58\u51fa\u201d\u4e0d\u80fd\u8fdb\u884c\u6536\u76ca\u3002", (String)"SuretyBillList_1", (String)"tmc-fbd-formplugin", (Object[])new Object[0]);
            throw new TmcBizException(TmcErrorCode.COMMON, new Object[]{message});
        }
        return loanBills;
    }

    protected DynamicObject[] getSuretyBillsForAppend() {
        QFilter filter = new QFilter("id", "=", (Object)this.getSelectedId());
        filter = filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        DynamicObject[] loanBills = TmcDataServiceHelper.load((String)"fbd_suretybill", (String)"id,currency,org,billno", (QFilter[])(filter = filter.and(new QFilter("bizstatus", "!=", (Object)SuretyBizStatusEnum.SURETY_END.getValue()))).toArray());
        if (loanBills.length <= 0) {
            String message = ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u975e\u201c\u5ba1\u6838\u201d\u548c\u4e1a\u52a1\u72b6\u6001\u201c\u5df2\u5b58\u51fa\u201d\u4e0d\u80fd\u8fdb\u884c\u8ffd\u52a0\u3002", (String)"SuretyBillList_5", (String)"tmc-fbd-formplugin", (Object[])new Object[0]);
            throw new TmcBizException(TmcErrorCode.COMMON, new Object[]{message});
        }
        return loanBills;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (StringUtils.equals((CharSequence)"close_bake_key_filter", (CharSequence)evt.getActionId()) && null != evt.getReturnData()) {
            BillShowParameter parameter = new BillShowParameter();
            parameter.setStatus(OperationStatus.ADDNEW);
            parameter.setFormId("fbd_surety_stlint_batch");
            parameter.setCustomParam("formid", (Object)"fbd_surety_stlint_batch");
            parameter.setCustomParam("revenuetype", (Object)RevenueTypeEnum.REVENUE.getValue());
            parameter.setCustomParam("navparam", evt.getReturnData());
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CLOSE_BAKE_KEY_EXIST"));
            this.getView().showForm((FormShowParameter)parameter);
        } else if (StringUtils.equals((CharSequence)"CLOSE_BAKE_KEY_EXIST", (CharSequence)evt.getActionId())) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName;
        switch (fieldName = event.getFieldName()) {
            case "debtbillno": 
            case "creditbillid_number": {
                this.showForm((BillListHyperLinkClickEvent)event);
                break;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName;
        switch (fieldName = args.getFieldName()) {
            case "debtbillno": 
            case "creditbillid_number": {
                args.setCancel(true);
                break;
            }
        }
    }

    private void showForm(BillListHyperLinkClickEvent event) {
        long pkId;
        String formId;
        Object entryId = event.getCurrentRow().getEntryPrimaryKeyValue();
        Object rowId = event.getCurrentRow().getPrimaryKeyValue();
        QFilter qFilter = new QFilter("id", "=", rowId);
        BillShowParameter showParameter = new BillShowParameter();
        if (StringUtils.equals((CharSequence)event.getFieldName(), (CharSequence)"debtbillno")) {
            DynamicObject surety = TmcDataServiceHelper.loadSingle((String)"fbd_suretybill", (String)(String.join((CharSequence)".", "entry", "debtbillid") + "," + String.join((CharSequence)".", "entry", "debttype")), (QFilter[])new QFilter[]{qFilter});
            DynamicObjectCollection debitEntry = surety.getDynamicObjectCollection("entry");
            List currentEntry = debitEntry.stream().filter(d -> d.get("id").equals(entryId)).collect(Collectors.toList());
            formId = ((DynamicObject)currentEntry.get(0)).getString("debttype");
            pkId = ((DynamicObject)currentEntry.get(0)).getLong("debtbillid");
        } else {
            DynamicObject surety = TmcDataServiceHelper.loadSingle((String)"fbd_suretybill", (String)String.join((CharSequence)".", "entry_credit", "creditbillid"), (QFilter[])new QFilter[]{qFilter});
            DynamicObjectCollection creditEntry = surety.getDynamicObjectCollection("entry_credit");
            List currentEntry = creditEntry.stream().filter(d -> d.get("id").equals(entryId)).collect(Collectors.toList());
            formId = "cfm_creditlimit";
            pkId = ((DynamicObject)currentEntry.get(0)).getDynamicObject("creditbillid").getLong("id");
        }
        showParameter.setFormId(formId);
        showParameter.setPkId((Object)pkId);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

