/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.suretypreint;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class IntbillDetailEdit
extends AbstractFormPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loanIntDetailInfo();
    }

    private void loanIntDetailInfo() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object currency = customParams.get("currency");
        String callIntStr = (String)customParams.get("intdetail_tag");
        if (EmptyUtil.isEmpty((String)callIntStr)) {
            return;
        }
        IntBillInfo intBillInfo = (IntBillInfo)SerializationUtils.fromJsonString((String)callIntStr, IntBillInfo.class);
        List details = intBillInfo.getDetails();
        details.sort(new Comparator<IntBillDetailInfo>(){

            @Override
            public int compare(IntBillDetailInfo arg0, IntBillDetailInfo arg1) {
                return arg0.getBeginDate().compareTo(arg1.getBeginDate());
            }
        });
        ArrayList dataMap = new ArrayList(details.size());
        for (IntBillDetailInfo intDetail : details) {
            if (EmptyUtil.isEmpty((BigDecimal)intDetail.getPrinciple())) continue;
            HashMap<String, Object> data = new HashMap<String, Object>(16);
            data.put("startdate", intDetail.getBeginDate());
            data.put("enddate", intDetail.getEndDate());
            data.put("intdays", intDetail.getDays());
            data.put("principle", intDetail.getPrinciple());
            data.put("rate", intDetail.getRate());
            data.put("intdate", intDetail.getBeginDate());
            data.put("currency", currency);
            data.put("interestamt", intDetail.getAmount());
            data.put("basis", intDetail.getBasisDay());
            data.put("intcategory", intDetail.getIntType().getValue());
            dataMap.add(data);
        }
        TmcViewInputHelper.batchFillEntity((String)"entry", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), dataMap);
        this.getView().updateView("entry");
    }
}

