/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.suretystlint;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbd.common.enums.BillTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.preint.AbstractTmcIntBillBatchList;
import kd.tmc.fbp.formplugin.list.preint.TmcIntBillListParam;

public class SuretyBillSettleIntBatchList
extends AbstractTmcIntBillBatchList {
    protected TmcIntBillListParam getIntBillListParam() {
        TmcIntBillListParam param = new TmcIntBillListParam();
        param.setNavAddNewFormId("fbd_surety_stlint_navadd").setTrackUpEntityName("fbd_suretybill").setTrackDownEntityName("fbd_surety_settleint");
        return param;
    }

    protected void customAddNewNavForm(FormShowParameter showParameter) {
        super.customAddNewNavForm(showParameter);
        showParameter.getCustomParams().put("entity", this.getEntityId());
    }

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(new QFilter("biztype", "=", (Object)BillTypeEnum.SETTLEINT.getValue()));
        e.getQFilters().add(new QFilter("id", "not in", this.getIntIds()));
    }

    protected List<Long> getTrackUpEntityIds(DynamicObject[] dynamicObjects) {
        ArrayList<Long> list = new ArrayList<Long>(16);
        for (DynamicObject batchBill : dynamicObjects) {
            DynamicObjectCollection entrys = batchBill.getDynamicObjectCollection("entry");
            List trackObjIds = entrys.stream().map(v -> v.getLong("loanbillid")).collect(Collectors.toList());
            list.addAll(trackObjIds);
        }
        return list;
    }

    protected List<Long> getTrackDownEntityIds(DynamicObject[] dynamicObjects) {
        ArrayList<Long> list = new ArrayList<Long>(16);
        for (DynamicObject batchBill : dynamicObjects) {
            DynamicObjectCollection entrys = batchBill.getDynamicObjectCollection("entry");
            List trackObjIds = entrys.stream().map(v -> v.getLong("intbillid")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toList());
            list.addAll(trackObjIds);
        }
        return list;
    }

    private Set<Long> getIntIds() {
        DynamicObjectCollection intbillentries = QueryServiceHelper.query((String)"fbd_surety_stlint_batch", (String)"entry.intbillid", (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)"B"), new QFilter("entry.intbillid", "!=", (Object)0L)});
        DynamicObjectCollection intbills = QueryServiceHelper.query((String)"fbd_surety_settleint", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)intbillentries.stream().map(o -> o.get("entry.intbillid")).toArray()), new QFilter("billstatus", "=", (Object)"B")});
        HashSet<Long> intIds = new HashSet<Long>();
        intbills.stream().forEach(item -> intIds.add(item.getLong("id")));
        intIds.remove(0L);
        return intIds;
    }
}

