/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.usergroup;

import java.text.Collator;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IListModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class UserGroupCardListPlugin
extends AbstractListPlugin
implements ClickListener,
ItemClickListener,
RowClickEventListener,
IConfirmCallBack {
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"imageap1"});
    }

    public void click(EventObject e) {
        super.click(e);
        String key = ((Control)e.getSource()).getKey();
        if (key.equalsIgnoreCase("imageap1")) {
            this.deleteRightSingeleCrad();
        }
    }

    private void deleteRightSingeleCrad() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("callBackId", (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u8ba4\u8981\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u5417\uff1f", (String)"UserGroupCardListPlugin_0", (String)"tmc-fbp-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
    }

    public void beforeBindData(EventObject e) {
        BillList entryentity = (BillList)this.getControl("billlistap");
        entryentity.setPageRow(100);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BillList entryentity = (BillList)this.getControl("billlistap");
        entryentity.clearSelection();
        entryentity.selectRows(0);
        if (e.getSource() instanceof BillList) {
            BillList listView = (BillList)e.getSource();
            IListModel listModel = listView.getListModel();
            SplitContainer splitContainer = (SplitContainer)this.getView().getControl("splitcontainerap");
            if (listModel.getDataCount() <= 0) {
                splitContainer.setCollapse("splitpanelap1", true);
            } else {
                splitContainer.setCollapse("splitpanelap1", false);
            }
        }
    }

    public void listRowClick(ListRowClickEvent e) {
        super.listRowClick(e);
        String key = ((Control)e.getSource()).getKey();
        if ("billlistap".equals(key)) {
            this.initRightPage();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getSource().getClass().getName().equals("kd.bos.entity.operate.Delete") && afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            BillList entryentity = (BillList)this.getControl("billlistap");
            entryentity.selectRows(0);
            entryentity.entryRowClick(Integer.valueOf(0));
        }
        this.initRightPage();
    }

    private void initRightPage() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
        if (listSelectedRows.size() < 1) {
            this.getModel().deleteEntryData("entryentity");
            return;
        }
        if (listSelectedRows.size() > 1) {
            return;
        }
        Long primaryKey = (Long)listSelectedRows.get(0).getPrimaryKeyValue();
        DynamicObjectCollection userInfos = this.getUserGroupInfo(primaryKey);
        this.getModel().deleteEntryData("entryentity");
        if (userInfos.size() > 0) {
            this.initRightRowPage(userInfos);
        }
    }

    private void initRightRowPage(DynamicObjectCollection userInfos) {
        List<Map<String, Object>> userInfo = this.sortAllUserInfo(userInfos);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("userfield", new Object[0]);
        vs.addField("dpt", new Object[0]);
        vs.addField("phone", new Object[0]);
        for (int i = 0; i < userInfo.size(); ++i) {
            Map<String, Object> singeleUserInfo = userInfo.get(i);
            vs.addRow(new Object[]{singeleUserInfo.get("userfield"), singeleUserInfo.get("dpt"), singeleUserInfo.get("phone")});
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private List<Map<String, Object>> sortAllUserInfo(DynamicObjectCollection userInfos) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (DynamicObject userDynamic : userInfos) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("userfield", userDynamic.getLong("userfield"));
            map.put("dpt", userDynamic.getLong("dpt"));
            map.put("phone", userDynamic.getString("phone"));
            map.put("name", userDynamic.getString("name"));
            list.add(map);
        }
        UserGroupCardListPlugin.listSort(list);
        return list;
    }

    private DynamicObjectCollection getUserGroupInfo(Long primaryKey) {
        QFilter g = new QFilter("id", "=", (Object)primaryKey);
        String selectFields = "id,entryentity.id entryid,entryentity.userfield userfield,entryentity.dptname dpt,entryentity.userfield.phone phone,entryentity.userfield.name name";
        DynamicObjectCollection cc = QueryServiceHelper.query((String)"fbd.UserGroupCardListPlugin.getUserGroupInfo", (String)"fbd_usergroup", (String)selectFields, (QFilter[])new QFilter[]{g}, null);
        Iterator it = cc.iterator();
        while (it.hasNext()) {
            DynamicObject dn = (DynamicObject)it.next();
            long entryId = dn.getLong("entryid");
            if (entryId != 0L) continue;
            it.remove();
        }
        return cc;
    }

    private DynamicObjectCollection getUserGroupInfo(Long primaryKey, DynamicObject userFieldId) {
        Long userId = userFieldId.getLong("userfield.id");
        QFilter g = new QFilter("entryentity.userfield", "=", (Object)userId);
        QFilter h = new QFilter("id", "=", (Object)primaryKey);
        String selectFields = "id,entryentity.id entryid,entryentity.userfield userfield,entryentity.dptname dpt,entryentity.userfield.phone phone";
        DynamicObjectCollection cc = QueryServiceHelper.query((String)"fbd.UserGroupCardListPlugin.getUserGroupInfo", (String)"fbd_usergroup", (String)selectFields, (QFilter[])new QFilter[]{g, h}, null);
        return cc;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        int result;
        super.confirmCallBack(e);
        if (e.getCallBackId().equals("callBackId") && (result = e.getResult().getValue()) == MessageBoxResult.Yes.getValue()) {
            this.delRightPageCard();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"UserGroupCardListPlugin_2", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
        }
    }

    private void delRightPageCard() {
        EntryGrid billList2 = (EntryGrid)this.getControl("entryentity");
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
        int[] selectRows = billList2.getEntryState().getSelectedRows();
        if (selectRows.length != 1) {
            return;
        }
        this.getModel().getEntryEntity("entryentity");
        this.getModel().getValue("entryentity", selectRows[0]);
        DynamicObject userEntryInfo = this.getModel().getEntryRowEntity("entryentity", selectRows[0]);
        Long primaryKey = (Long)listSelectedRows.getPrimaryKeyValues()[0];
        DynamicObjectCollection userInfo = this.getUserGroupInfo(primaryKey, userEntryInfo);
        if (userInfo == null || userInfo.size() < 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"UserGroupCardListPlugin_1", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return;
        }
        Long id = ((DynamicObject)userInfo.get(0)).getLong("id");
        Long entryId = ((DynamicObject)userInfo.get(0)).getLong("entryid");
        DynamicObject userInfoNew = BusinessDataServiceHelper.loadSingle((Object)id, (String)"fbd_usergroup");
        DynamicObjectCollection userInfoEntry = userInfoNew.getDynamicObjectCollection("entryentity");
        Iterator it = userInfoEntry.iterator();
        while (it.hasNext()) {
            DynamicObject userInfoQuery = (DynamicObject)it.next();
            Long entryIdQuery = userInfoQuery.getLong("id");
            if (!entryIdQuery.equals(entryId)) continue;
            it.remove();
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userInfoNew});
        billList.selectRows(listSelectedRows.get(0).getRowKey());
        this.initRightPage();
    }

    public static void listSort(List<Map<String, Object>> resultList) {
        resultList.sort((o1, o2) -> {
            String name1 = (String)o1.get("name");
            String name2 = (String)o2.get("name");
            if (name1 == null || name2 == null) {
                return 0;
            }
            Collator instance = Collator.getInstance(Locale.CHINA);
            return instance.compare(name1, name2);
        });
    }
}

