/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.usergroup;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbd.common.PermissionHelper;

public class UserGroupFormPlugin
extends AbstractBillPlugIn
implements ClickListener {
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if ("bar_save".equals(itemKey)) {
            HashSet<Long> orgSet = new HashSet<Long>();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity1");
            for (DynamicObject entry : entryEntity) {
                DynamicObject org = entry.getDynamicObject("applyorgid");
                Long pkValue = org == null ? null : (Long)org.getPkValue();
                if (pkValue == null || orgSet.add(pkValue)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u9002\u7528\u7684\u8d44\u91d1\u7ec4\u7ec7:%s\u3002", (String)"UserGroupFormPlugin_0", (String)"tmc-fbp-formplugin", (Object[])new Object[]{org.get("name").toString()}));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.valueOf(!OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus())), new String[]{"grouptype"});
        this.getView().setEnable(Boolean.valueOf(!OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus())), new String[]{"number"});
        Object grouptype = this.getModel().getValue("grouptype");
        if (grouptype != null && !"".equals(grouptype)) {
            String oldgrouptype = grouptype.toString();
            String newgrouptype = oldgrouptype.replace("%", "");
            this.getModel().setValue("grouptype", (Object)newgrouptype);
        }
        this.setVisableFromPermission();
    }

    private void setVisableFromPermission() {
        long orgId = RequestContext.get().getOrgId();
        String appId = this.getView().getFormShowParameter().getAppId();
        boolean hasEditRight = PermissionHelper.hasEditRight((long)orgId, (String)"fbd_usergroup", (String)appId);
        if ((OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus()) || OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus())) && !hasEditRight) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconbaritemap", "advconbaritemap1", "bar_save", "cardentryfixrowap"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"name", "description"});
        }
    }

    public void initialize() {
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addClickListeners(new String[]{"imageap"});
        this.addClickListeners(new String[]{"usercard_add"});
        this.addClickListeners(new String[]{"cardentryflexpanelap51"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("imageap".equalsIgnoreCase(key) || "usercard_add".equalsIgnoreCase(key)) {
            this.userCardAdd();
        }
    }

    private void userCardAdd() {
        ListShowParameter para = new ListShowParameter();
        para.setHasRight(true);
        para.setLookUp(true);
        para.setBillFormId("bos_user");
        para.setFormId("bos_listf7");
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        para.getOpenStyle().setInlineStyleCss(css);
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setMultiSelect(true);
        para.setShowUsed(true);
        para.setShowTitle(false);
        para.setStatus(OperationStatus.ADDNEW);
        para.setShowQuickFilter(true);
        ListFilterParameter filterParam = new ListFilterParameter();
        filterParam.getQFilters().add(new QFilter("enable", "=", (Object)"1"));
        para.setListFilterParameter(filterParam);
        para.setIsolationOrg(true);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "usercard_add"));
        this.getView().showForm((FormShowParameter)para);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (e.getReturnData() == null) {
            return;
        }
        if (e.getActionId().equals("usercard_add")) {
            List<Map<String, Object>> userInfo;
            Object[] pk = this.getSelectedEntryPK(e);
            List<Map<String, Object>> mapObjects = this.getDptNameCollectionByUseridArr(pk);
            List<Map<String, Object>> userExitInfo = this.getUserMap();
            boolean isUserMapNull = userExitInfo == null || userExitInfo.size() == 0;
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            ArrayList<Long> idArr = new ArrayList<Long>();
            for (Map<String, Object> entry : mapObjects) {
                HashMap<String, Object> cacheMap = new HashMap<String, Object>();
                cacheMap.put("id", entry.get("id"));
                cacheMap.put("name", entry.get("name"));
                cacheMap.put("dpt", entry.get("dpt"));
                boolean isExits = false;
                if (!isUserMapNull) {
                    isExits = userExitInfo.contains(cacheMap);
                }
                if (isExits) continue;
                idArr.add((Long)entry.get("id"));
            }
            if (idArr.size() > 0 && (userInfo = this.getDptNameCollectionByUseridArr(idArr)) != null) {
                List<Map<String, Object>> userAllInfo = this.sortAllUserInfo(userExitInfo, userInfo);
                model.deleteEntryData("entryentity");
                model.beginInit();
                TableValueSetter vs = new TableValueSetter(new String[0]);
                vs.addField("userfield", new Object[0]);
                vs.addField("dptname", new Object[0]);
                for (Map<String, Object> userMap : userAllInfo) {
                    vs.addRow(new Object[]{userMap.get("id"), userMap.get("dpt")});
                }
                model.batchCreateNewEntryRow("entryentity", vs);
                model.endInit();
                this.getView().updateView("entryentity");
            }
        }
    }

    private List<Map<String, Object>> sortAllUserInfo(List<Map<String, Object>> userExitInfo, List<Map<String, Object>> userInfo) {
        if (userExitInfo != null) {
            for (Map<String, Object> map : userExitInfo) {
                userInfo.add(map);
            }
        }
        UserGroupFormPlugin.listSort(userInfo);
        return userInfo;
    }

    private List<Map<String, Object>> getDptNameCollectionByUseridArr(Object[] idArrs) {
        int size = idArrs.length;
        ArrayList<Long> idArr = new ArrayList<Long>(size);
        for (int i = 0; i < size; ++i) {
            idArr.add((Long)idArrs[i]);
        }
        return this.getDptNameCollectionByUseridArr(idArr);
    }

    private List<Map<String, Object>> getDptNameCollectionByUseridArr(List<Long> idArr) {
        ArrayList<Long> idArrDis = new ArrayList<Long>();
        ArrayList<Map<String, Object>> userInfo = new ArrayList<Map<String, Object>>();
        for (Long i : idArr) {
            if (idArrDis.contains(i)) continue;
            idArrDis.add(i);
        }
        String selectField = "id,entryentity.dpt,entryentity.ispartjob,name";
        QFilter idFilter = new QFilter("id", "in", idArrDis);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"fbd.UserGroupFormPlugin.getDptNameByUserid", (String)"bos_user", (String)selectField, (QFilter[])new QFilter[]{idFilter}, (String)"");
        if (collection.size() == 0) {
            return null;
        }
        for (DynamicObject userObj : collection) {
            HashMap<String, Object> userDpt = new HashMap<String, Object>();
            boolean ispartjob = userObj.getBoolean("entryentity.ispartjob");
            String name = userObj.getString("name");
            Long dpt = 0L;
            if (ispartjob) continue;
            dpt = (Long)userObj.get("entryentity.dpt");
            userDpt.put("id", userObj.get("id"));
            userDpt.put("dpt", dpt);
            userDpt.put("name", name);
            userInfo.add(userDpt);
        }
        return userInfo;
    }

    private Object[] getSelectedEntryPK(ClosedCallBackEvent e) {
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)e.getReturnData();
        Object[] pk = new Object[returnData.size()];
        for (int i = 0; i < returnData.size(); ++i) {
            ListSelectedRow listSelectedRow = returnData.get(i);
            if (StringUtils.isBlank((Object)listSelectedRow.getPrimaryKeyValue())) continue;
            pk[i] = listSelectedRow.getPrimaryKeyValue();
        }
        return pk;
    }

    private List<Map<String, Object>> getUserMap() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
        if (collection.size() == 0) {
            return null;
        }
        ArrayList<Map<String, Object>> userExitInfo = new ArrayList<Map<String, Object>>();
        for (DynamicObject obj : collection) {
            HashMap<String, Object> userMap = new HashMap<String, Object>();
            DynamicObject dynamicObject = (DynamicObject)obj.get("userfield");
            Long dptId = obj.getLong("dptname_id");
            Long id = dynamicObject.getLong("id");
            String name = dynamicObject.getString("name");
            userMap.put("id", id);
            userMap.put("dpt", dptId);
            userMap.put("name", name);
            userExitInfo.add(userMap);
        }
        return userExitInfo;
    }

    public static void listSort(List<Map<String, Object>> resultList) {
        Collections.sort(resultList, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                String name1 = (String)o1.get("name");
                String name2 = (String)o2.get("name");
                Collator instance = Collator.getInstance(Locale.CHINA);
                return instance.compare(name1, name2);
            }
        });
    }
}

