/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.workcalendar;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.WorkCalendar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class WorkCalendarEdit
extends AbstractFormPlugin
implements IConfirmCallBack {
    private static final Log LOGGER = LogFactory.getLog(WorkCalendarEdit.class);
    private int year;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"setworkcalendar", "preyear", "nextyear"});
        WorkCalendar workCalendar = (WorkCalendar)this.getView().getControl("workcalendarap");
        workCalendar.addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.year = Calendar.getInstance().get(1);
        this.setCurYear(this.year);
        this.loadWorkCalendar(this.year);
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        this.year = Integer.parseInt(this.getPageCache().get("year"));
        if (c.getKey().toLowerCase().startsWith("setworkcalendar")) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("year", this.getModel().getValue("year"));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "reload");
            this.showForm("tbd_workcalendar_set", params, closeCallBack, ShowType.Modal);
        } else if (c.getKey().toLowerCase().startsWith("preyear")) {
            --this.year;
            this.loadWorkCalendar(this.year);
        } else if (c.getKey().toLowerCase().startsWith("nextyear")) {
            ++this.year;
            this.loadWorkCalendar(this.year);
        }
        this.setCurYear(this.year);
        WorkCalendar workCalendar = (WorkCalendar)this.getControl("workcalendarap");
        this.markWorkCalendar(workCalendar);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        DynamicObject data = (DynamicObject)event.getReturnData();
        if (EmptyUtil.isNoEmpty((DynamicObject)data)) {
            this.generateDate(data);
            this.addSetToData(data);
            this.year = Integer.parseInt(this.getPageCache().get("year"));
            this.loadWorkCalendar(this.year);
            this.getModel().setDataChanged(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("save".equals(op.getOperateKey())) {
            String expireyearfrom = (String)this.getModel().getValue("expireyearfrom");
            String expireyearto = (String)this.getModel().getValue("expireyearto");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{expireyearfrom, expireyearto})) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u70b9\u51fb\u201c\u8bbe\u7f6e\u201d\u6309\u94ae\u8fdb\u884c\u76f8\u5173\u8bbe\u7f6e\u3002", (String)"WorkCalendarEdit_1", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    private void generateDate(DynamicObject obj) {
        int yearFrom = obj.getInt("expireyearfrom");
        int monthFrom = obj.getInt("expiremonthfrom");
        int yearTo = obj.getInt("expireyearto");
        int monthTo = obj.getInt("expiremonthto");
        Calendar curDate = Calendar.getInstance();
        curDate.set(curDate.get(1), curDate.get(2), curDate.get(5), 0, 0, 0);
        Calendar fromDate = Calendar.getInstance();
        fromDate.set(yearFrom, monthFrom - 1, 1, 0, 0, 0);
        Calendar toDate = Calendar.getInstance();
        toDate.set(yearTo, monthTo - 1, 1, 0, 0, 0);
        toDate.set(yearTo, monthTo - 1, toDate.getActualMaximum(5), 0, 0, 0);
        boolean[] isRestDay = WorkCalendarEdit.getRestDays(obj);
        boolean[] isHalfWorkDay = WorkCalendarEdit.getHalfWorkDays(obj);
        int days = DateUtils.getDiffDays((Date)fromDate.getTime(), (Date)toDate.getTime()) - 1;
        for (int i = 0; i < days; ++i) {
            DynamicObjectCollection colls = this.getModel().getEntryEntity("entitys");
            DynamicObject entry = colls.addNew();
            String year = fromDate.get(1) + "";
            entry.set("year", (Object)year);
            entry.set("workdate", (Object)DateUtils.truncateDate((Date)fromDate.getTime()));
            int index = this.getModel().createNewEntryRow("entitys");
            this.getModel().setValue("year", (Object)year, index);
            this.getModel().setValue("workdate", (Object)new SimpleDateFormat("yyy-MM-dd").format(fromDate.getTime()), index);
            int dateType = 1;
            dateType = isRestDay[fromDate.get(7) - 1] ? 4 : (isHalfWorkDay[fromDate.get(7) - 1] ? 2 : 1);
            this.getModel().setValue("datetype", (Object)dateType, index);
            entry.set("datetype", (Object)dateType);
            fromDate.add(5, 1);
        }
    }

    private void addSetToData(DynamicObject set) {
        this.getModel().setValue("issunrest", set.get("issunrest"));
        this.getModel().setValue("ismonrest", set.get("ismonrest"));
        this.getModel().setValue("istuerest", set.get("istuerest"));
        this.getModel().setValue("iswedrest", set.get("iswedrest"));
        this.getModel().setValue("isthurest", set.get("isthurest"));
        this.getModel().setValue("isfrirest", set.get("isfrirest"));
        this.getModel().setValue("issatrest", set.get("issatrest"));
        this.getModel().setValue("ishalfsunrest", set.get("ishalfsunrest"));
        this.getModel().setValue("ishalfmonrest", set.get("ishalfmonrest"));
        this.getModel().setValue("ishalftuerest", set.get("ishalftuerest"));
        this.getModel().setValue("ishalfwedrest", set.get("ishalfwedrest"));
        this.getModel().setValue("ishalfthurest", set.get("ishalfthurest"));
        this.getModel().setValue("ishalffrirest", set.get("ishalffrirest"));
        this.getModel().setValue("ishalfsatrest", set.get("ishalfsatrest"));
        this.getModel().setValue("hourofbegintimeam", set.get("hourofbegintimeam"));
        this.getModel().setValue("minofbegintimeam", set.get("minofbegintimeam"));
        this.getModel().setValue("hourofendtimeam", set.get("hourofendtimeam"));
        this.getModel().setValue("minofendtimeam", set.get("minofendtimeam"));
        this.getModel().setValue("hourofbegintimepm", set.get("hourofbegintimepm"));
        this.getModel().setValue("minofbegintimepm", set.get("minofbegintimepm"));
        this.getModel().setValue("hourofendtimepm", set.get("hourofendtimepm"));
        this.getModel().setValue("minofendtimepm", set.get("minofendtimepm"));
        this.getModel().setValue("expireyearfrom", set.get("expireyearfrom"));
        this.getModel().setValue("expiremonthfrom", set.get("expiremonthfrom"));
        this.getModel().setValue("expireyearto", set.get("expireyearto"));
        this.getModel().setValue("expiremonthto", set.get("expiremonthto"));
    }

    private void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType) {
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        param.setBillStatus(BillOperationStatus.EDIT);
        param.setCustomParams(params);
        Long id = (Long)this.getModel().getValue("id");
        if (id != null && id != 0L) {
            param.setPkId((Object)id);
        }
        param.getCustomParams().put("set", SerializationUtils.toJsonString((Object)this.getModel().getDataEntity()));
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm((FormShowParameter)param);
    }

    private void setCurYear(int year) {
        this.getPageCache().put("year", String.valueOf(year));
        Label label = (Label)this.getControl("yearshow");
        label.setText(String.valueOf(year));
    }

    private void markWorkCalendar(WorkCalendar workCalendar) {
        ArrayList dateList = workCalendar.getDateList();
        if (EmptyUtil.isNoEmpty((Object)dateList)) {
            String dateType = workCalendar.getDateType();
            DynamicObjectCollection colls = this.getModel().getEntryEntity("entitys");
            DynamicObject entry = colls.addNew();
            this.year = Integer.parseInt(this.getPageCache().get("year"));
            entry.set("year", (Object)this.year);
            Date workDate = null;
            try {
                workDate = new SimpleDateFormat("yyy-MM-dd").parse((String)dateList.get(0));
                entry.set("workdate", (Object)workDate);
            }
            catch (ParseException e) {
                LOGGER.error((Throwable)e);
            }
            entry.set("datetype", (Object)dateType);
            int index = this.getModel().createNewEntryRow("entitys");
            this.getModel().setValue("year", (Object)this.year, index);
            this.getModel().setValue("workdate", (Object)workDate, index);
            this.getModel().setValue("datetype", (Object)dateType, index);
            workCalendar.setDateTypeCallBack((List)dateList, dateType);
            this.getModel().setDataChanged(true);
        }
    }

    private void loadWorkCalendar(int year) {
        WorkCalendar workCalendar = (WorkCalendar)this.getControl("workcalendarap");
        DynamicObjectCollection colls = this.getModel().getEntryEntity("entitys");
        ArrayList workDataList = new ArrayList();
        for (DynamicObject dynamicObject : colls) {
            if (dynamicObject.getInt("year") != year) continue;
            HashMap<String, String> date = new HashMap<String, String>();
            date.put("workdate", new SimpleDateFormat("yyy-MM-dd").format(dynamicObject.getDate("workDate")));
            date.put("datetype", dynamicObject.getString("datetype"));
            workDataList.add(date);
        }
        workCalendar.setYear(year);
        workCalendar.setWorkDataList(workDataList);
        workCalendar.setData();
        for (Map map : workDataList) {
            ArrayList dateList = new ArrayList();
            dateList.add(map.get("workdate"));
            workCalendar.setDateTypeCallBack(dateList, (String)map.get("datetype"));
        }
    }

    public static boolean[] getRestDays(DynamicObject workCalendar) {
        return new boolean[]{workCalendar.getBoolean("issunrest"), workCalendar.getBoolean("ismonrest"), workCalendar.getBoolean("istuerest"), workCalendar.getBoolean("iswedrest"), workCalendar.getBoolean("isthurest"), workCalendar.getBoolean("isfrirest"), workCalendar.getBoolean("issatrest")};
    }

    public static boolean[] getHalfWorkDays(DynamicObject workCalendar) {
        return new boolean[]{workCalendar.getBoolean("ishalfsunrest"), workCalendar.getBoolean("ishalfmonrest"), workCalendar.getBoolean("ishalftuerest"), workCalendar.getBoolean("ishalfwedrest"), workCalendar.getBoolean("ishalfthurest"), workCalendar.getBoolean("ishalffrirest"), workCalendar.getBoolean("ishalfsatrest")};
    }
}

